/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.writer;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterParams;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;

public final class ImageWriterUtil {
    private ImageWriterUtil() {
    }

    public static void saveAsPNG(RenderedImage renderedImage, File file) throws IOException {
        ImageWriterUtil.saveAsPNG(renderedImage, 96, file);
    }

    public static void saveAsPNG(RenderedImage renderedImage, int n, File file) throws IOException {
        ImageWriterUtil.saveAsFile(renderedImage, n, file, "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsFile(RenderedImage renderedImage, int n, File file, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor(string);
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setResolution(n);
            imageWriter.writeImage(renderedImage, fileOutputStream, imageWriterParams);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
        }
    }
}

