/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamAdapter
extends InputStream {
    private ImageInputStream iin;
    private long lastMarkPosition;

    public ImageInputStreamAdapter(ImageInputStream imageInputStream) {
        assert (imageInputStream != null) : "InputStream is null";
        this.iin = imageInputStream;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.iin.read(byArray, n, n2);
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.iin.read(byArray);
    }

    @Override
    public int read() throws IOException {
        return this.iin.read();
    }

    @Override
    public long skip(long l) throws IOException {
        return this.iin.skipBytes(l);
    }

    @Override
    public void close() throws IOException {
        this.iin.close();
        this.iin = null;
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.lastMarkPosition = this.iin.getStreamPosition();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unexpected IOException in ImageInputStream.getStreamPosition()", iOException);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.iin.seek(this.lastMarkPosition);
    }

    @Override
    public int available() throws IOException {
        return 0;
    }
}

