/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageProcessingHints;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.cache.ImageCache;
import org.apache.xmlgraphics.image.loader.pipeline.ImageProviderPipeline;
import org.apache.xmlgraphics.image.loader.pipeline.PipelineFactory;
import org.apache.xmlgraphics.image.loader.spi.ImageImplRegistry;
import org.apache.xmlgraphics.image.loader.spi.ImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.Penalty;
import org.apache.xmlgraphics.io.XmlSourceUtil;

public class ImageManager {
    protected static final Log log = LogFactory.getLog(ImageManager.class);
    private ImageImplRegistry registry;
    private ImageContext imageContext;
    private ImageCache cache = new ImageCache();
    private PipelineFactory pipelineFactory = new PipelineFactory(this);

    public ImageManager(ImageContext imageContext) {
        this(ImageImplRegistry.getDefaultInstance(), imageContext);
    }

    public ImageManager(ImageImplRegistry imageImplRegistry, ImageContext imageContext) {
        this.registry = imageImplRegistry;
        this.imageContext = imageContext;
    }

    public ImageImplRegistry getRegistry() {
        return this.registry;
    }

    public ImageContext getImageContext() {
        return this.imageContext;
    }

    public ImageCache getCache() {
        return this.cache;
    }

    public PipelineFactory getPipelineFactory() {
        return this.pipelineFactory;
    }

    public ImageInfo getImageInfo(String string, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        if (this.getCache() != null) {
            return this.getCache().needImageInfo(string, imageSessionContext, this);
        }
        return this.preloadImage(string, imageSessionContext);
    }

    public ImageInfo preloadImage(String string, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        Source source = imageSessionContext.needSource(string);
        ImageInfo imageInfo = this.preloadImage(string, source);
        imageSessionContext.returnSource(string, source);
        return imageInfo;
    }

    public ImageInfo preloadImage(String string, Source source) throws ImageException, IOException {
        Iterator iterator = this.registry.getPreloaderIterator();
        while (iterator.hasNext()) {
            ImagePreloader imagePreloader = (ImagePreloader)iterator.next();
            ImageInfo imageInfo = imagePreloader.preloadImage(string, source, this.imageContext);
            if (imageInfo == null) continue;
            return imageInfo;
        }
        throw new ImageException("The file format is not supported. No ImagePreloader found for " + string);
    }

    private Map prepareHints(Map map, ImageSessionContext imageSessionContext) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (map != null) {
            hashMap.putAll(map);
        }
        if (!hashMap.containsKey(ImageProcessingHints.IMAGE_SESSION_CONTEXT) && imageSessionContext != null) {
            hashMap.put(ImageProcessingHints.IMAGE_SESSION_CONTEXT, imageSessionContext);
        }
        if (!hashMap.containsKey(ImageProcessingHints.IMAGE_MANAGER)) {
            hashMap.put(ImageProcessingHints.IMAGE_MANAGER, this);
        }
        return hashMap;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor imageFlavor, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        map = this.prepareHints(map, imageSessionContext);
        Image image = null;
        ImageProviderPipeline imageProviderPipeline = this.getPipelineFactory().newImageConverterPipeline(imageInfo, imageFlavor);
        if (imageProviderPipeline != null) {
            image = imageProviderPipeline.execute(imageInfo, map, imageSessionContext);
        }
        if (image == null) {
            throw new ImageException("Cannot load image (no suitable loader/converter combination available) for " + imageInfo);
        }
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(imageInfo.getOriginalURI()));
        return image;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor[] imageFlavorArray, Map map, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        map = this.prepareHints(map, imageSessionContext);
        Image image = null;
        ImageProviderPipeline[] imageProviderPipelineArray = this.getPipelineFactory().determineCandidatePipelines(imageInfo, imageFlavorArray);
        ImageProviderPipeline imageProviderPipeline = this.choosePipeline(imageProviderPipelineArray);
        if (imageProviderPipeline != null) {
            image = imageProviderPipeline.execute(imageInfo, map, imageSessionContext);
        }
        if (image == null) {
            throw new ImageException("Cannot load image (no suitable loader/converter combination available) for " + imageInfo);
        }
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(imageInfo.getOriginalURI()));
        return image;
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor imageFlavor, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        return this.getImage(imageInfo, imageFlavor, ImageUtil.getDefaultHints(imageSessionContext), imageSessionContext);
    }

    public Image getImage(ImageInfo imageInfo, ImageFlavor[] imageFlavorArray, ImageSessionContext imageSessionContext) throws ImageException, IOException {
        return this.getImage(imageInfo, imageFlavorArray, ImageUtil.getDefaultHints(imageSessionContext), imageSessionContext);
    }

    public void closeImage(String string, ImageSessionContext imageSessionContext) {
        XmlSourceUtil.closeQuietly(imageSessionContext.getSource(string));
    }

    public Image convertImage(Image image, ImageFlavor[] imageFlavorArray, Map map) throws ImageException, IOException {
        map = this.prepareHints(map, null);
        ImageInfo imageInfo = image.getInfo();
        Image image2 = null;
        int n = imageFlavorArray.length;
        for (int i = 0; i < n; ++i) {
            if (!image.getFlavor().equals(imageFlavorArray[i])) continue;
            return image;
        }
        ImageProviderPipeline[] imageProviderPipelineArray = this.getPipelineFactory().determineCandidatePipelines(image, imageFlavorArray);
        ImageProviderPipeline imageProviderPipeline = this.choosePipeline(imageProviderPipelineArray);
        if (imageProviderPipeline != null) {
            image2 = imageProviderPipeline.execute(imageInfo, image, map, null);
        }
        if (image2 == null) {
            throw new ImageException("Cannot convert image " + image + " (no suitable converter combination available)");
        }
        return image2;
    }

    public Image convertImage(Image image, ImageFlavor[] imageFlavorArray) throws ImageException, IOException {
        return this.convertImage(image, imageFlavorArray, null);
    }

    public ImageProviderPipeline choosePipeline(ImageProviderPipeline[] imageProviderPipelineArray) {
        int n;
        ImageProviderPipeline imageProviderPipeline = null;
        int n2 = Integer.MAX_VALUE;
        int n3 = imageProviderPipelineArray.length;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Candidate Pipelines:");
            for (n = 0; n < n3; ++n) {
                if (imageProviderPipelineArray[n] == null) continue;
                log.trace((Object)("  " + n + ": " + imageProviderPipelineArray[n].getConversionPenalty(this.getRegistry()) + " for " + imageProviderPipelineArray[n]));
            }
        }
        for (n = n3 - 1; n >= 0; --n) {
            Penalty penalty;
            if (imageProviderPipelineArray[n] == null || (penalty = imageProviderPipelineArray[n].getConversionPenalty(this.getRegistry())).isInfinitePenalty() || penalty.getValue() > n2) continue;
            imageProviderPipeline = imageProviderPipelineArray[n];
            n2 = penalty.getValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Chosen pipeline: " + imageProviderPipeline));
        }
        return imageProviderPipeline;
    }
}

