/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public final class Glyphs {
    public static final String NOTDEF = ".notdef";
    @Deprecated
    public static final String[] MAC_GLYPH_NAMES = new String[]{".notdef", ".null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "Sigma", "Pi", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "applelogo", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dmacron"};
    public static final String[] TEX8R_GLYPH_NAMES = new String[]{".notdef", "dotaccent", "fi", "fl", "fraction", "hungarumlaut", "Lslash", "lslash", "ogonek", "ring", ".notdef", "breve", "minus", ".notdef", "Zcaron", "zcaron", "caron", "dotlessi", "dotlessj", "ff", "ffi", "ffl", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "grave", "quotesingle", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", ".notdef", "Euro", ".notdef", "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", ".notdef", "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", ".notdef", ".notdef", "Ydieresis", ".notdef", "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
    public static final char[] WINANSI_ENCODING = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '\u2018', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2022', '\u20ac', '\u2022', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u2022', '\u017d', '\u2022', '\u2022', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '~', '\u2122', '\u0161', '\u203a', '\u0153', '\u2022', '\u017e', '\u0178', ' ', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
    public static final char[] ADOBECYRILLIC_ENCODING = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u0000', '\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u0000', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};
    private static final String[] UNICODE_GLYPHS;
    private static final String[] DINGBATS_GLYPHS;
    private static final Map CHARNAME_ALTERNATIVES;
    private static final Map CHARNAMES_TO_UNICODE;

    private Glyphs() {
    }

    private static void addAlternatives(Map map, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray2 = new String[n - 1];
            int n2 = 0;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                stringArray2[n2] = stringArray[j];
                ++n2;
            }
            map.put(stringArray[i], stringArray2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] loadGlyphList(String string, Map map) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = Glyphs.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new RuntimeException("Cannot load " + string + ". The Glyphs class cannot properly be initialized!");
        }
        try {
            stringArray = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
            try {
                String string2;
                while ((string2 = stringArray.readLine()) != null) {
                    if (string2.startsWith("#")) continue;
                    arrayList.add(string2);
                }
            }
            finally {
                stringArray.close();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Incompatible JVM! US-ASCII encoding is not supported. The Glyphs class cannot properly be initialized!");
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O error while loading " + string + ". The Glyphs class cannot properly be initialized!");
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        stringArray = new String[arrayList.size() * 2];
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            String string3;
            String string4 = (String)arrayList.get(i);
            int n3 = string4.indexOf(59);
            if (n3 <= 0) continue;
            String string5 = string4.substring(0, n3);
            String string6 = string4.substring(n3 + 1);
            stringBuffer.setLength(0);
            StringTokenizer stringTokenizer = new StringTokenizer(string6, " ", false);
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                assert (string3.length() == 4);
                stringBuffer.append(Glyphs.hexToChar(string3));
            }
            stringArray[n] = string3 = stringBuffer.toString();
            stringArray[++n] = string5;
            ++n;
            assert (!map.containsKey(string5));
            map.put(string5, string3);
        }
        return stringArray;
    }

    private static char hexToChar(String string) {
        return (char)Integer.parseInt(string, 16);
    }

    public static String charToGlyphName(char c) {
        return Glyphs.stringToGlyph(Character.toString(c));
    }

    public static String getUnicodeSequenceForGlyphName(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = (String)CHARNAMES_TO_UNICODE.get(string2);
            if (string3 == null) {
                if (string2.startsWith("uni")) {
                    int n2 = string2.length();
                    int n3 = 3;
                    while (n3 + 4 <= n2) {
                        try {
                            stringBuffer.append(Glyphs.hexToChar(string2.substring(n3, n3 + 4)));
                        }
                        catch (NumberFormatException numberFormatException) {
                            return null;
                        }
                        n3 += 4;
                    }
                    continue;
                }
                if (!string2.startsWith("u")) continue;
                if (string2.length() > 5) {
                    return null;
                }
                if (string2.length() < 5) {
                    return null;
                }
                try {
                    stringBuffer.append(Glyphs.hexToChar(string2.substring(1, 5)));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            stringBuffer.append(string3);
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    @Deprecated
    public static String glyphToString(String string) {
        for (int i = 0; i < UNICODE_GLYPHS.length; i += 2) {
            if (!UNICODE_GLYPHS[i + 1].equals(string)) continue;
            return UNICODE_GLYPHS[i];
        }
        return "";
    }

    public static String stringToGlyph(String string) {
        int n;
        for (n = 0; n < UNICODE_GLYPHS.length; n += 2) {
            if (!UNICODE_GLYPHS[n].equals(string)) continue;
            return UNICODE_GLYPHS[n + 1];
        }
        for (n = 0; n < DINGBATS_GLYPHS.length; n += 2) {
            if (!DINGBATS_GLYPHS[n].equals(string)) continue;
            return DINGBATS_GLYPHS[n + 1];
        }
        return "";
    }

    public static String[] getCharNameAlternativesFor(String string) {
        return (String[])CHARNAME_ALTERNATIVES.get(string);
    }

    static {
        TreeMap treeMap = new TreeMap();
        UNICODE_GLYPHS = Glyphs.loadGlyphList("glyphlist.txt", treeMap);
        DINGBATS_GLYPHS = Glyphs.loadGlyphList("zapfdingbats.txt", treeMap);
        CHARNAMES_TO_UNICODE = Collections.unmodifiableMap(treeMap);
        treeMap = new TreeMap();
        Glyphs.addAlternatives(treeMap, new String[]{"Omega", "Omegagreek"});
        Glyphs.addAlternatives(treeMap, new String[]{"Delta", "Deltagreek"});
        Glyphs.addAlternatives(treeMap, new String[]{"fraction", "divisionslash"});
        Glyphs.addAlternatives(treeMap, new String[]{"hyphen", "sfthyphen", "softhyphen", "minus"});
        Glyphs.addAlternatives(treeMap, new String[]{"macron", "overscore"});
        Glyphs.addAlternatives(treeMap, new String[]{"mu", "mu1", "mugreek"});
        Glyphs.addAlternatives(treeMap, new String[]{"periodcentered", "middot", "bulletoperator", "anoteleia"});
        Glyphs.addAlternatives(treeMap, new String[]{"space", "nonbreakingspace", "nbspace"});
        Glyphs.addAlternatives(treeMap, new String[]{"zero", "zerooldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"one", "oneoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"two", "twooldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"three", "threeoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"four", "fouroldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"five", "fiveoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"six", "sixoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"seven", "sevenoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"eight", "eightoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"nine", "nineoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"cent", "centoldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"dollar", "dollaroldstyle"});
        Glyphs.addAlternatives(treeMap, new String[]{"Acyrillic", "afii10017"});
        Glyphs.addAlternatives(treeMap, new String[]{"Becyrillic", "afii10018"});
        Glyphs.addAlternatives(treeMap, new String[]{"Vecyrillic", "afii10019"});
        Glyphs.addAlternatives(treeMap, new String[]{"Gecyrillic", "afii10020"});
        Glyphs.addAlternatives(treeMap, new String[]{"Decyrillic", "afii10021"});
        Glyphs.addAlternatives(treeMap, new String[]{"Iecyrillic", "afii10022"});
        Glyphs.addAlternatives(treeMap, new String[]{"Iocyrillic", "afii10023"});
        Glyphs.addAlternatives(treeMap, new String[]{"Zhecyrillic", "afii10024"});
        Glyphs.addAlternatives(treeMap, new String[]{"Zecyrillic", "afii10025"});
        Glyphs.addAlternatives(treeMap, new String[]{"Iicyrillic", "afii10026"});
        Glyphs.addAlternatives(treeMap, new String[]{"Iishortcyrillic", "afii10027"});
        Glyphs.addAlternatives(treeMap, new String[]{"Kacyrillic", "afii10028"});
        Glyphs.addAlternatives(treeMap, new String[]{"Elcyrillic", "afii10029"});
        Glyphs.addAlternatives(treeMap, new String[]{"Emcyrillic", "afii10030"});
        Glyphs.addAlternatives(treeMap, new String[]{"Encyrillic", "afii10031"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ocyrillic", "afii10032"});
        Glyphs.addAlternatives(treeMap, new String[]{"Pecyrillic", "afii10033"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ercyrillic", "afii10034"});
        Glyphs.addAlternatives(treeMap, new String[]{"Escyrillic", "afii10035"});
        Glyphs.addAlternatives(treeMap, new String[]{"Tecyrillic", "afii10036"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ucyrillic", "afii10037"});
        Glyphs.addAlternatives(treeMap, new String[]{"Efcyrillic", "afii10038"});
        Glyphs.addAlternatives(treeMap, new String[]{"Khacyrillic", "afii10039"});
        Glyphs.addAlternatives(treeMap, new String[]{"Tsecyrillic", "afii10040"});
        Glyphs.addAlternatives(treeMap, new String[]{"Checyrillic", "afii10041"});
        Glyphs.addAlternatives(treeMap, new String[]{"Shacyrillic", "afii10042"});
        Glyphs.addAlternatives(treeMap, new String[]{"Shchacyrillic", "afii10043"});
        Glyphs.addAlternatives(treeMap, new String[]{"Hardsigncyrillic", "afii10044"});
        Glyphs.addAlternatives(treeMap, new String[]{"Yericyrillic", "afii10045"});
        Glyphs.addAlternatives(treeMap, new String[]{"Softsigncyrillic", "afii10046"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ereversedcyrillic", "afii10047"});
        Glyphs.addAlternatives(treeMap, new String[]{"IUcyrillic", "afii10048"});
        Glyphs.addAlternatives(treeMap, new String[]{"IAcyrillic", "afii10049"});
        Glyphs.addAlternatives(treeMap, new String[]{"acyrillic", "afii10065"});
        Glyphs.addAlternatives(treeMap, new String[]{"becyrillic", "afii10066"});
        Glyphs.addAlternatives(treeMap, new String[]{"vecyrillic", "afii10067"});
        Glyphs.addAlternatives(treeMap, new String[]{"gecyrillic", "afii10068"});
        Glyphs.addAlternatives(treeMap, new String[]{"decyrillic", "afii10069"});
        Glyphs.addAlternatives(treeMap, new String[]{"iecyrillic", "afii10070"});
        Glyphs.addAlternatives(treeMap, new String[]{"iocyrillic", "afii10071"});
        Glyphs.addAlternatives(treeMap, new String[]{"zhecyrillic", "afii10072"});
        Glyphs.addAlternatives(treeMap, new String[]{"zecyrillic", "afii10073"});
        Glyphs.addAlternatives(treeMap, new String[]{"iicyrillic", "afii10074"});
        Glyphs.addAlternatives(treeMap, new String[]{"iishortcyrillic", "afii10075"});
        Glyphs.addAlternatives(treeMap, new String[]{"kacyrillic", "afii10076"});
        Glyphs.addAlternatives(treeMap, new String[]{"elcyrillic", "afii10077"});
        Glyphs.addAlternatives(treeMap, new String[]{"emcyrillic", "afii10078"});
        Glyphs.addAlternatives(treeMap, new String[]{"encyrillic", "afii10079"});
        Glyphs.addAlternatives(treeMap, new String[]{"ocyrillic", "afii10080"});
        Glyphs.addAlternatives(treeMap, new String[]{"pecyrillic", "afii10081"});
        Glyphs.addAlternatives(treeMap, new String[]{"ercyrillic", "afii10082"});
        Glyphs.addAlternatives(treeMap, new String[]{"escyrillic", "afii10083"});
        Glyphs.addAlternatives(treeMap, new String[]{"tecyrillic", "afii10084"});
        Glyphs.addAlternatives(treeMap, new String[]{"ucyrillic", "afii10085"});
        Glyphs.addAlternatives(treeMap, new String[]{"efcyrillic", "afii10086"});
        Glyphs.addAlternatives(treeMap, new String[]{"khacyrillic", "afii10087"});
        Glyphs.addAlternatives(treeMap, new String[]{"tsecyrillic", "afii10088"});
        Glyphs.addAlternatives(treeMap, new String[]{"checyrillic", "afii10089"});
        Glyphs.addAlternatives(treeMap, new String[]{"shacyrillic", "afii10090"});
        Glyphs.addAlternatives(treeMap, new String[]{"shchacyrillic", "afii10091"});
        Glyphs.addAlternatives(treeMap, new String[]{"hardsigncyrillic", "afii10092"});
        Glyphs.addAlternatives(treeMap, new String[]{"yericyrillic", "afii10093"});
        Glyphs.addAlternatives(treeMap, new String[]{"softsigncyrillic", "afii10094"});
        Glyphs.addAlternatives(treeMap, new String[]{"ereversedcyrillic", "afii10095"});
        Glyphs.addAlternatives(treeMap, new String[]{"iucyrillic", "afii10096"});
        Glyphs.addAlternatives(treeMap, new String[]{"iacyrillic", "afii10097"});
        Glyphs.addAlternatives(treeMap, new String[]{"Gheupturncyrillic", "afii10050"});
        Glyphs.addAlternatives(treeMap, new String[]{"Djecyrillic", "afii10051"});
        Glyphs.addAlternatives(treeMap, new String[]{"Gjecyrillic", "afii10052"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ecyrillic", "afii10053"});
        Glyphs.addAlternatives(treeMap, new String[]{"Dzecyrillic", "afii10054"});
        Glyphs.addAlternatives(treeMap, new String[]{"Icyrillic", "afii10055"});
        Glyphs.addAlternatives(treeMap, new String[]{"Yicyrillic", "afii10056"});
        Glyphs.addAlternatives(treeMap, new String[]{"Jecyrillic", "afii10057"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ljecyrillic", "afii10058"});
        Glyphs.addAlternatives(treeMap, new String[]{"Njecyrillic", "afii10059"});
        Glyphs.addAlternatives(treeMap, new String[]{"Tshecyrillic", "afii10060"});
        Glyphs.addAlternatives(treeMap, new String[]{"Kjecyrillic", "afii10061"});
        Glyphs.addAlternatives(treeMap, new String[]{"Ushortcyrillic", "afii10062"});
        Glyphs.addAlternatives(treeMap, new String[]{"Dzhecyrillic", "afii10145"});
        Glyphs.addAlternatives(treeMap, new String[]{"Yatcyrillic", "afii10146"});
        Glyphs.addAlternatives(treeMap, new String[]{"Fitacyrillic", "afii10147"});
        Glyphs.addAlternatives(treeMap, new String[]{"Izhitsacyrillic", "afii10148"});
        Glyphs.addAlternatives(treeMap, new String[]{"gheupturncyrillic", "afii10098"});
        Glyphs.addAlternatives(treeMap, new String[]{"djecyrillic", "afii10099"});
        Glyphs.addAlternatives(treeMap, new String[]{"gjecyrillic", "afii10100"});
        Glyphs.addAlternatives(treeMap, new String[]{"ecyrillic", "afii10101"});
        Glyphs.addAlternatives(treeMap, new String[]{"dzecyrillic", "afii10102"});
        Glyphs.addAlternatives(treeMap, new String[]{"icyrillic", "afii10103"});
        Glyphs.addAlternatives(treeMap, new String[]{"yicyrillic", "afii10104"});
        Glyphs.addAlternatives(treeMap, new String[]{"jecyrillic", "afii10105"});
        Glyphs.addAlternatives(treeMap, new String[]{"ljecyrillic", "afii10106"});
        Glyphs.addAlternatives(treeMap, new String[]{"njecyrillic", "afii10107"});
        Glyphs.addAlternatives(treeMap, new String[]{"tshecyrillic", "afii10108"});
        Glyphs.addAlternatives(treeMap, new String[]{"kjecyrillic", "afii10109"});
        Glyphs.addAlternatives(treeMap, new String[]{"ushortcyrillic", "afii10110"});
        Glyphs.addAlternatives(treeMap, new String[]{"dzhecyrillic", "afii10193"});
        Glyphs.addAlternatives(treeMap, new String[]{"yatcyrillic", "afii10194"});
        Glyphs.addAlternatives(treeMap, new String[]{"fitacyrillic", "afii10195"});
        Glyphs.addAlternatives(treeMap, new String[]{"izhitsacyrillic", "afii10196"});
        CHARNAME_ALTERNATIVES = Collections.unmodifiableMap(treeMap);
    }
}

