/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespacedSAXConfigurationHandler
extends SAXConfigurationHandler {
    private static final int EXPECTED_DEPTH = 5;
    private final ArrayList m_elements = new ArrayList(5);
    private final ArrayList m_prefixes = new ArrayList(5);
    private final ArrayList m_values = new ArrayList(5);
    private final BitSet m_preserveSpace = new BitSet();
    private Configuration m_configuration;
    private Locator m_locator;
    private NamespaceSupport m_namespaceSupport = new NamespaceSupport();

    @Override
    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public void clear() {
        this.m_elements.clear();
        Iterator iterator = this.m_prefixes.iterator();
        while (iterator.hasNext()) {
            ((ArrayList)iterator.next()).clear();
        }
        this.m_prefixes.clear();
        this.m_values.clear();
        this.m_locator = null;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_namespaceSupport.reset();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        this.m_namespaceSupport.reset();
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.m_values.size() - 1;
        StringBuffer stringBuffer = (StringBuffer)this.m_values.get(n3);
        stringBuffer.append(cArray, n, n2);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        int n = this.m_elements.size() - 1;
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)this.m_elements.remove(n);
        String string4 = ((StringBuffer)this.m_values.remove(n)).toString();
        ArrayList arrayList = (ArrayList)this.m_prefixes.remove(n);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.endPrefixMapping((String)iterator.next());
        }
        arrayList.clear();
        if (defaultConfiguration.getChildren().length == 0) {
            Object object = this.m_preserveSpace.get(n) ? string4 : (0 == string4.length() ? null : string4.trim());
            defaultConfiguration.setValue((String)object);
        } else {
            String string5 = string4.trim();
            if (string5.length() > 0) {
                throw new SAXException("Not allowed to define mixed content in the element " + defaultConfiguration.getName() + " at " + defaultConfiguration.getLocation());
            }
        }
        if (0 == n) {
            this.m_configuration = defaultConfiguration;
        }
        this.m_namespaceSupport.popContext();
    }

    protected DefaultConfiguration createConfiguration(String string, String string2, String string3) {
        String string4 = this.m_namespaceSupport.getPrefix(string2);
        if (string4 == null) {
            string4 = "";
        }
        return new DefaultConfiguration(string, string3, string2, string4);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        Serializable serializable;
        this.m_namespaceSupport.pushContext();
        DefaultConfiguration defaultConfiguration = this.createConfiguration(string2, string, this.getLocationString());
        int n2 = this.m_elements.size();
        boolean bl = false;
        if (n2 > 0) {
            serializable = (DefaultConfiguration)this.m_elements.get(n2 - 1);
            ((DefaultConfiguration)serializable).addChild(defaultConfiguration);
            bl = this.m_preserveSpace.get(n2 - 1);
        }
        this.m_elements.add(defaultConfiguration);
        this.m_values.add(new StringBuffer());
        serializable = new ArrayList();
        AttributesImpl attributesImpl = new AttributesImpl();
        for (n = 0; n < attributes.getLength(); ++n) {
            if (attributes.getQName(n).startsWith("xmlns")) {
                ((ArrayList)serializable).add(attributes.getLocalName(n));
                this.startPrefixMapping(attributes.getLocalName(n), attributes.getValue(n));
                continue;
            }
            if (attributes.getQName(n).equals("xml:space")) {
                bl = attributes.getValue(n).equals("preserve");
                continue;
            }
            attributesImpl.addAttribute(attributes.getURI(n), attributes.getLocalName(n), attributes.getQName(n), attributes.getType(n), attributes.getValue(n));
        }
        if (bl) {
            this.m_preserveSpace.set(n2);
        } else {
            this.m_preserveSpace.clear(n2);
        }
        this.m_prefixes.add(serializable);
        n = attributesImpl.getLength();
        for (int i = 0; i < n; ++i) {
            String string4 = attributesImpl.getQName(i);
            String string5 = attributesImpl.getValue(i);
            defaultConfiguration.setAttribute(string4, string5);
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    @Override
    protected String getLocationString() {
        if (null == this.m_locator) {
            return "Unknown";
        }
        int n = this.m_locator.getColumnNumber();
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + (n >= 0 ? ":" + n : "");
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.m_namespaceSupport.declarePrefix(string, string2);
        super.startPrefixMapping(string, string2);
    }
}

