
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in TopoShapeEdgePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of TopoShapeEdgePy
PyTypeObject TopoShapeEdgePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.TopoShape",     /*tp_name*/
    sizeof(TopoShapeEdgePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "TopoShapeEdge is the OpenCasCade topological edge wrapper",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::TopoShapeEdgePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::TopoShapeEdgePy::GetterSetter,                     /*tp_getset */
    &Part::TopoShapePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::TopoShapeEdgePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of TopoShapeEdgePy
PyMethodDef TopoShapeEdgePy::Methods[] = {
    {"getParameterByLength",
        reinterpret_cast<PyCFunction>( staticCallback_getParameterByLength ),
        METH_VARARGS,
        "Get the value of the primary parameter at the given distance along the cartesian length of the edge.\ngetParameterByLength(pos, [tolerance = 1e-7]) -> Float\n--\nArgs:\n    pos (float or int): The distance along the length of the edge at which to\n        determine the primary parameter value. See help for the FirstParameter or\n        LastParameter properties for more information on the primary parameter.\n        If the given value is positive, the distance from edge start is used.\n        If the given value is negative, the distance from edge end is used.\n    tol (float): Computing tolerance. Optional, defaults to 1e-7.\n\nReturns:\n    paramval (float): the value of the primary parameter defining the edge at the\n        given position along its cartesian length.\n        "
    },
    {"tangentAt",
        reinterpret_cast<PyCFunction>( staticCallback_tangentAt ),
        METH_VARARGS,
        "Get the tangent direction at the given primary parameter value along the Edge if it is defined\ntangentAt(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the tangent direction e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.tangentAt(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is the Vector (-0.7071067811865475, 0.7071067811865476, 0.0)\n\n        Values with magnitude greater than the Edge length return\n        values of the tangent on the curve extrapolated beyond its\n        length. This may not be valid for all Edges. Negative values\n        similarly return a tangent on the curve extrapolated backwards\n        (before the start point of the Edge). For example, using the\n        same shape as above:\n\n        >>> x.tangentAt(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865477, 0.7071067811865474, 0.0)\n\n        Which gives the same result as\n\n        >>> x.tangentAt(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865475, 0.7071067811865476, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the tangent to the Edge at the given\n       location along its length (or extrapolated length)\n        "
    },
    {"valueAt",
        reinterpret_cast<PyCFunction>( staticCallback_valueAt ),
        METH_VARARGS,
        "Get the value of the cartesian parameter value at the given parameter value along the Edge\nvalueAt(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the value in terms of the main parameter defining\n        the edge, what the parameter value is depends on the type of\n        edge. See  e.g:\n\n        For a circle value\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.valueAt(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is theVector (0.7071067811865476, 0.7071067811865475, 0.0)\n\n        Values with magnitude greater than the Edge length return\n        values on the curve extrapolated beyond its length. This may\n        not be valid for all Edges. Negative values similarly return\n        a parameter value on the curve extrapolated backwards (before the\n        start point of the Edge). For example, using the same shape\n        as above:\n\n        >>> x.valueAt(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865474, -0.7071067811865477, 0.0)\n\n        Which gives the same result as\n\n        >>> x.valueAt(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865476, -0.7071067811865475, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the cartesian location on the Edge at the given\n       distance along its length (or extrapolated length)\n          "
    },
    {"parameters",
        reinterpret_cast<PyCFunction>( staticCallback_parameters ),
        METH_VARARGS,
        "Get the list of parameters of the tessellation of an edge.\nparameters([face]) -> list\n--\nIf the edge is part of a face then this face is required as argument.\nAn exception is raised if the edge has no polygon.\n          "
    },
    {"parameterAt",
        reinterpret_cast<PyCFunction>( staticCallback_parameterAt ),
        METH_VARARGS,
        "Get the parameter at the given vertex if lying on the edge\nparameterAt(Vertex) -> Float\n            "
    },
    {"normalAt",
        reinterpret_cast<PyCFunction>( staticCallback_normalAt ),
        METH_VARARGS,
        "Get the normal direction at the given parameter value along the Edge if it is defined\nnormalAt(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the normal direction e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.normalAt(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is the Vector (-0.7071067811865476, -0.7071067811865475, 0.0)\n\n        Values with magnitude greater than the Edge length return\n        values of the normal on the curve extrapolated beyond its\n        length. This may not be valid for all Edges. Negative values\n        similarly return a normal on the curve extrapolated backwards\n        (before the start point of the Edge). For example, using the\n        same shape as above:\n\n        >>> x.normalAt(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865474, 0.7071067811865477, 0.0)\n\n        Which gives the same result as\n\n        >>> x.normalAt(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865476, 0.7071067811865475, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the normal to the Edge at the given\n       location along its length (or extrapolated length)\n          "
    },
    {"derivative1At",
        reinterpret_cast<PyCFunction>( staticCallback_derivative1At ),
        METH_VARARGS,
        "Get the first derivative at the given parameter value along the Edge if it is defined\nderivative1At(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the first derivative e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.derivative1At(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is the Vector (-0.7071067811865475, 0.7071067811865476, 0.0)\n\n        Values with magnitude greater than the Edge length return\n        values of the first derivative on the curve extrapolated\n        beyond its length. This may not be valid for all Edges.\n        Negative values similarly return a first derivative on the\n        curve extrapolated backwards (before the start point of the\n        Edge). For example, using the same shape as above:\n\n        >>> x.derivative1At(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865477, 0.7071067811865474, 0.0)\n\n        Which gives the same result as\n\n        >>> x.derivative1At(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (0.7071067811865475, 0.7071067811865476, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the first derivative to the Edge at the\n       given location along its length (or extrapolated length)\n          "
    },
    {"derivative2At",
        reinterpret_cast<PyCFunction>( staticCallback_derivative2At ),
        METH_VARARGS,
        "Get the second derivative at the given parameter value along the Edge if it is defined\nderivative2At(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the second derivative e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.derivative2At(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is the Vector (-0.7071067811865476, -0.7071067811865475, 0.0)\n\n        Values with magnitude greater than the Edge length return\n        values of the second derivative on the curve extrapolated\n        beyond its length. This may not be valid for all Edges.\n        Negative values similarly return a second derivative on the\n        curve extrapolated backwards (before the start point of the\n        Edge). For example, using the same shape as above:\n\n        >>> x.derivative2At(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865474, 0.7071067811865477, 0.0)\n\n        Which gives the same result as\n\n        >>> x.derivative2At(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865476, 0.7071067811865475, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the second derivative to the Edge at the\n       given location along its length (or extrapolated length)\n          "
    },
    {"derivative3At",
        reinterpret_cast<PyCFunction>( staticCallback_derivative3At ),
        METH_VARARGS,
        "Get the third derivative at the given parameter value along the Edge if it is defined\nderivative3At(paramval) -> Vector\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        determine the third derivative e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.derivative3At(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\n        y is the Vector (0.7071067811865475, -0.7071067811865476, -0.0)\n\n        Values with magnitude greater than the Edge length return\n        values of the third derivative on the curve extrapolated\n        beyond its length. This may not be valid for all Edges.\n        Negative values similarly return a third derivative on the\n        curve extrapolated backwards (before the start point of the\n        Edge). For example, using the same shape as above:\n\n        >>> x.derivative3At(x.FirstParameter + 3.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865477, -0.7071067811865474, 0.0)\n\n        Which gives the same result as\n\n        >>> x.derivative3At(x.FirstParameter -0.5*(x.LastParameter - x.FirstParameter))\n        Vector (-0.7071067811865475, -0.7071067811865476, 0.0)\n\n        Since it is a circle\n\nReturns:\n    Vector: representing the third derivative to the Edge at the\n       given location along its length (or extrapolated length)\n          "
    },
    {"curvatureAt",
        reinterpret_cast<PyCFunction>( staticCallback_curvatureAt ),
        METH_VARARGS,
        "Get the curvature at the given parameter [First|Last] if defined\ncurvatureAt(paramval) -> Float\n          "
    },
    {"centerOfCurvatureAt",
        reinterpret_cast<PyCFunction>( staticCallback_centerOfCurvatureAt ),
        METH_VARARGS,
        "Get the center of curvature at the given parameter [First|Last] if defined\ncenterOfCurvatureAt(paramval) -> Vector\n          "
    },
    {"firstVertex",
        reinterpret_cast<PyCFunction>( staticCallback_firstVertex ),
        METH_VARARGS,
        "Returns the Vertex of orientation FORWARD in this edge.\nfirstVertex([Orientation=False]) -> Vertex\n--\nIf there is none a Null shape is returned.\nOrientation = True : taking into account the edge orientation\n          "
    },
    {"lastVertex",
        reinterpret_cast<PyCFunction>( staticCallback_lastVertex ),
        METH_VARARGS,
        "Returns the Vertex of orientation REVERSED in this edge.\nlastVertex([Orientation=False]) -> Vertex\n--\nIf there is none a Null shape is returned.\nOrientation = True : taking into account the edge orientation\n          "
    },
    {"discretize",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_discretize )),
        METH_VARARGS|METH_KEYWORDS,
        "Discretizes the edge and returns a list of points.\ndiscretize(kwargs) -> list\n--\nThe function accepts keywords as argument:\ndiscretize(Number=n) => gives a list of 'n' equidistant points\ndiscretize(QuasiNumber=n) => gives a list of 'n' quasi equidistant points (is faster than the method above)\ndiscretize(Distance=d) => gives a list of equidistant points with distance 'd'\ndiscretize(Deflection=d) => gives a list of points with a maximum deflection 'd' to the edge\ndiscretize(QuasiDeflection=d) => gives a list of points with a maximum deflection 'd' to the edge (faster)\ndiscretize(Angular=a,Curvature=c,[Minimum=m]) => gives a list of points with an angular deflection of 'a'\n                                    and a curvature deflection of 'c'. Optionally a minimum number of points\n                                    can be set which by default is set to 2.\n\nOptionally you can set the keywords 'First' and 'Last' to define a sub-range of the parameter range\nof the edge.\n\nIf no keyword is given then it depends on whether the argument is an int or float.\nIf it's an int then the behaviour is as if using the keyword 'Number', if it's float\nthen the behaviour is as if using the keyword 'Distance'.\n\nExample:\n\nimport Part\ne=Part.makeCircle(5)\np=e.discretize(Number=50,First=3.14)\ns=Part.Compound([Part.Vertex(i) for i in p])\nPart.show(s)\n\n\np=e.discretize(Angular=0.09,Curvature=0.01,Last=3.14,Minimum=100)\ns=Part.Compound([Part.Vertex(i) for i in p])\nPart.show(s)\n          "
    },
    {"countNodes",
        reinterpret_cast<PyCFunction>( staticCallback_countNodes ),
        METH_VARARGS,
        "Returns the number of nodes of the 3D polygon of the edge."
    },
    {"split",
        reinterpret_cast<PyCFunction>( staticCallback_split ),
        METH_VARARGS,
        "Splits the edge at the given parameter values and builds a wire out of it\nsplit(paramval) -> Wire\n--\nArgs:\n    paramval (float or int): The parameter value along the Edge at which to\n        split it e.g:\n\n        x = Part.makeCircle(1, FreeCAD.Vector(0,0,0), FreeCAD.Vector(0,0,1), 0, 90)\n        y = x.derivative3At(x.FirstParameter + 0.5 * (x.LastParameter - x.FirstParameter))\n\nReturns:\n    Wire: wire made up of two Edges\n          "
    },
    {"isSeam",
        reinterpret_cast<PyCFunction>( staticCallback_isSeam ),
        METH_VARARGS,
        "Checks whether the edge is a seam edge.\nisSeam(Face)\n          "
    },
    {"curveOnSurface",
        reinterpret_cast<PyCFunction>( staticCallback_curveOnSurface ),
        METH_VARARGS,
        "Returns the 2D curve, the surface, the placement and the parameter range of index idx.\ncurveOnSurface(idx) -> None or tuple\n--\nReturns None if index idx is out of range.\nReturns a 5-items tuple of a curve, a surface, a placement, first parameter and last parameter.\n          "
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of TopoShapeEdgePy
PyGetSetDef TopoShapeEdgePy::GetterSetter[] = {
    {"Tolerance",
        (getter) staticCallback_getTolerance,
        (setter) staticCallback_setTolerance,
        "Set or get the tolerance of the vertex",
        nullptr
    },
    {"Length",
        (getter) staticCallback_getLength,
        (setter) staticCallback_setLength,
        "Returns the cartesian length of the curve",
        nullptr
    },
    {"ParameterRange",
        (getter) staticCallback_getParameterRange,
        (setter) staticCallback_setParameterRange,
        "\nReturns a 2 tuple with the range of the primary parameter\ndefining the curve. This is the same as would be returned by\nthe FirstParameter and LastParameter properties, i.e.\n\n(LastParameter,FirstParameter)\n\nWhat the parameter is depends on what type of edge it is. For a\nLine the parameter is simply its cartesian length. Some other\nexamples are shown below:\n\nType                 Parameter\n---------------------------------------------------------------\nCircle               Angle swept by circle (or arc) in radians\nBezierCurve          Unitless number in the range 0.0 to 1.0\nHelix                Angle swept by helical turns in radians\n          ",
        nullptr
    },
    {"FirstParameter",
        (getter) staticCallback_getFirstParameter,
        (setter) staticCallback_setFirstParameter,
        "\nReturns the start value of the range of the primary parameter\ndefining the curve.\n\nWhat the parameter is depends on what type of edge it is. For a\nLine the parameter is simply its cartesian length. Some other\nexamples are shown below:\n\nType                 Parameter\n-----------------------------------------------------------\nCircle               Angle swept by circle (or arc) in radians\nBezierCurve          Unitless number in the range 0.0 to 1.0\nHelix                Angle swept by helical turns in radians\n          ",
        nullptr
    },
    {"LastParameter",
        (getter) staticCallback_getLastParameter,
        (setter) staticCallback_setLastParameter,
        "\nReturns the end value of the range of the primary parameter\ndefining the curve.\n\nWhat the parameter is depends on what type of edge it is. For a\nLine the parameter is simply its cartesian length. Some other\nexamples are shown below:\n\nType                 Parameter\n-----------------------------------------------------------\nCircle               Angle swept by circle (or arc) in radians\nBezierCurve          Unitless number in the range 0.0 to 1.0\nHelix                Angle swept by helical turns in radians\n          ",
        nullptr
    },
    {"Curve",
        (getter) staticCallback_getCurve,
        (setter) staticCallback_setCurve,
        "Returns the 3D curve of the edge",
        nullptr
    },
    {"Closed",
        (getter) staticCallback_getClosed,
        (setter) staticCallback_setClosed,
        "Returns true if the edge is closed",
        nullptr
    },
    {"Degenerated",
        (getter) staticCallback_getDegenerated,
        (setter) staticCallback_setDegenerated,
        "Returns true if the edge is degenerated",
        nullptr
    },
    {"Mass",
        (getter) staticCallback_getMass,
        (setter) staticCallback_setMass,
        "Returns the mass of the current system.",
        nullptr
    },
    {"CenterOfMass",
        (getter) staticCallback_getCenterOfMass,
        (setter) staticCallback_setCenterOfMass,
        "Returns the center of mass of the current system.\nIf the gravitational field is uniform, it is the center of gravity.\nThe coordinates returned for the center of mass are expressed in the\nabsolute Cartesian coordinate system.",
        nullptr
    },
    {"MatrixOfInertia",
        (getter) staticCallback_getMatrixOfInertia,
        (setter) staticCallback_setMatrixOfInertia,
        "Returns the matrix of inertia. It is a symmetrical matrix.\nThe coefficients of the matrix are the quadratic moments of\ninertia.\n\n | Ixx Ixy Ixz 0 |\n | Ixy Iyy Iyz 0 |\n | Ixz Iyz Izz 0 |\n | 0   0   0   1 |\n\nThe moments of inertia are denoted by Ixx, Iyy, Izz.\nThe products of inertia are denoted by Ixy, Ixz, Iyz.\nThe matrix of inertia is returned in the central coordinate\nsystem (G, Gx, Gy, Gz) where G is the centre of mass of the\nsystem and Gx, Gy, Gz the directions parallel to the X(1,0,0)\nY(0,1,0) Z(0,0,1) directions of the absolute cartesian\ncoordinate system.",
        nullptr
    },
    {"StaticMoments",
        (getter) staticCallback_getStaticMoments,
        (setter) staticCallback_setStaticMoments,
        "Returns Ix, Iy, Iz, the static moments of inertia of the\n current system; i.e. the moments of inertia about the\n three axes of the Cartesian coordinate system.",
        nullptr
    },
    {"PrincipalProperties",
        (getter) staticCallback_getPrincipalProperties,
        (setter) staticCallback_setPrincipalProperties,
        "Computes the principal properties of inertia of the current system.\n There is always a set of axes for which the products\n of inertia of a geometric system are equal to 0; i.e. the\n matrix of inertia of the system is diagonal. These axes\n are the principal axes of inertia. Their origin is\n coincident with the center of mass of the system. The\n associated moments are called the principal moments of inertia.\n This function computes the eigen values and the\n eigen vectors of the matrix of inertia of the system.",
        nullptr
    },
    {"Continuity",
        (getter) staticCallback_getContinuity,
        (setter) staticCallback_setContinuity,
        "Returns the continuity",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// getParameterByLength() callback and implementer
// PyObject*  TopoShapeEdgePy::getParameterByLength(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getParameterByLength (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getParameterByLength' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->getParameterByLength(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// tangentAt() callback and implementer
// PyObject*  TopoShapeEdgePy::tangentAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_tangentAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'tangentAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->tangentAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// valueAt() callback and implementer
// PyObject*  TopoShapeEdgePy::valueAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_valueAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'valueAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->valueAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// parameters() callback and implementer
// PyObject*  TopoShapeEdgePy::parameters(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_parameters (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'parameters' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->parameters(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// parameterAt() callback and implementer
// PyObject*  TopoShapeEdgePy::parameterAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_parameterAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'parameterAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->parameterAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// normalAt() callback and implementer
// PyObject*  TopoShapeEdgePy::normalAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_normalAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'normalAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->normalAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// derivative1At() callback and implementer
// PyObject*  TopoShapeEdgePy::derivative1At(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_derivative1At (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'derivative1At' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->derivative1At(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// derivative2At() callback and implementer
// PyObject*  TopoShapeEdgePy::derivative2At(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_derivative2At (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'derivative2At' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->derivative2At(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// derivative3At() callback and implementer
// PyObject*  TopoShapeEdgePy::derivative3At(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_derivative3At (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'derivative3At' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->derivative3At(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curvatureAt() callback and implementer
// PyObject*  TopoShapeEdgePy::curvatureAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_curvatureAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curvatureAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->curvatureAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// centerOfCurvatureAt() callback and implementer
// PyObject*  TopoShapeEdgePy::centerOfCurvatureAt(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_centerOfCurvatureAt (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'centerOfCurvatureAt' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->centerOfCurvatureAt(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// firstVertex() callback and implementer
// PyObject*  TopoShapeEdgePy::firstVertex(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_firstVertex (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'firstVertex' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->firstVertex(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// lastVertex() callback and implementer
// PyObject*  TopoShapeEdgePy::lastVertex(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_lastVertex (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'lastVertex' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->lastVertex(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// discretize() callback and implementer
// PyObject*  TopoShapeEdgePy::discretize(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_discretize (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'discretize' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->discretize(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// countNodes() callback and implementer
// PyObject*  TopoShapeEdgePy::countNodes(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_countNodes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'countNodes' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->countNodes(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// split() callback and implementer
// PyObject*  TopoShapeEdgePy::split(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_split (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'split' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->split(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSeam() callback and implementer
// PyObject*  TopoShapeEdgePy::isSeam(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_isSeam (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSeam' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->isSeam(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curveOnSurface() callback and implementer
// PyObject*  TopoShapeEdgePy::curveOnSurface(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_curveOnSurface (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curveOnSurface' of 'Part.TopoShape' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<TopoShapeEdgePy*>(self)->curveOnSurface(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Tolerance() callback and implementer
// PyObject*  TopoShapeEdgePy::Tolerance(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getTolerance (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getTolerance());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Tolerance' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setTolerance (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<TopoShapeEdgePy*>(self)->setTolerance(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Tolerance' of object 'TopoShape'");
        return -1;
    }
}

// Length() callback and implementer
// PyObject*  TopoShapeEdgePy::Length(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Length' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Length' of object 'TopoShape' is read-only");
    return -1;
}

// ParameterRange() callback and implementer
// PyObject*  TopoShapeEdgePy::ParameterRange(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getParameterRange (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getParameterRange());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ParameterRange' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setParameterRange (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ParameterRange' of object 'TopoShape' is read-only");
    return -1;
}

// FirstParameter() callback and implementer
// PyObject*  TopoShapeEdgePy::FirstParameter(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getFirstParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getFirstParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FirstParameter' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setFirstParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FirstParameter' of object 'TopoShape' is read-only");
    return -1;
}

// LastParameter() callback and implementer
// PyObject*  TopoShapeEdgePy::LastParameter(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getLastParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getLastParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LastParameter' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setLastParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LastParameter' of object 'TopoShape' is read-only");
    return -1;
}

// Curve() callback and implementer
// PyObject*  TopoShapeEdgePy::Curve(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getCurve (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getCurve());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Curve' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setCurve (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Curve' of object 'TopoShape' is read-only");
    return -1;
}

// Closed() callback and implementer
// PyObject*  TopoShapeEdgePy::Closed(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getClosed (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getClosed());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Closed' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setClosed (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Closed' of object 'TopoShape' is read-only");
    return -1;
}

// Degenerated() callback and implementer
// PyObject*  TopoShapeEdgePy::Degenerated(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getDegenerated (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getDegenerated());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Degenerated' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setDegenerated (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Degenerated' of object 'TopoShape' is read-only");
    return -1;
}

// Mass() callback and implementer
// PyObject*  TopoShapeEdgePy::Mass(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Mass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Mass' of object 'TopoShape' is read-only");
    return -1;
}

// CenterOfMass() callback and implementer
// PyObject*  TopoShapeEdgePy::CenterOfMass(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getCenterOfMass (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getCenterOfMass());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CenterOfMass' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setCenterOfMass (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CenterOfMass' of object 'TopoShape' is read-only");
    return -1;
}

// MatrixOfInertia() callback and implementer
// PyObject*  TopoShapeEdgePy::MatrixOfInertia(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getMatrixOfInertia (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getMatrixOfInertia());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MatrixOfInertia' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setMatrixOfInertia (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MatrixOfInertia' of object 'TopoShape' is read-only");
    return -1;
}

// StaticMoments() callback and implementer
// PyObject*  TopoShapeEdgePy::StaticMoments(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getStaticMoments (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getStaticMoments());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'StaticMoments' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setStaticMoments (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'StaticMoments' of object 'TopoShape' is read-only");
    return -1;
}

// PrincipalProperties() callback and implementer
// PyObject*  TopoShapeEdgePy::PrincipalProperties(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getPrincipalProperties (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getPrincipalProperties());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PrincipalProperties' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setPrincipalProperties (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PrincipalProperties' of object 'TopoShape' is read-only");
    return -1;
}

// Continuity() callback and implementer
// PyObject*  TopoShapeEdgePy::Continuity(PyObject *args){};
// has to be implemented in TopoShapeEdgePyImp.cpp
PyObject * TopoShapeEdgePy::staticCallback_getContinuity (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<TopoShapeEdgePy*>(self)->getContinuity());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Continuity' of object 'TopoShape'");
        return nullptr;
    }
}

int TopoShapeEdgePy::staticCallback_setContinuity (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Continuity' of object 'TopoShape' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
TopoShapeEdgePy::TopoShapeEdgePy(TopoShape *pcObject, PyTypeObject *T)
    : TopoShapePy(static_cast<TopoShapePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
TopoShapeEdgePy::~TopoShapeEdgePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// TopoShapeEdgePy representation
//--------------------------------------------------------------------------
PyObject *TopoShapeEdgePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// TopoShapeEdgePy Attributes
//--------------------------------------------------------------------------
PyObject *TopoShapeEdgePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return TopoShapePy::_getattr(attr);
}

int TopoShapeEdgePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return TopoShapePy::_setattr(attr, value);
}

TopoShape *TopoShapeEdgePy::getTopoShapePtr() const
{
    return static_cast<TopoShape *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in TopoShapeEdgePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *TopoShapeEdgePy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of TopoShapeEdgePy and the Twin object
    return new TopoShapeEdgePy(new TopoShape);
}

// constructor method
int TopoShapeEdgePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string TopoShapeEdgePy::representation() const
{
    return std::string("<TopoShape object>");
}

PyObject* TopoShapeEdgePy::getParameterByLength(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::tangentAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::valueAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::parameters(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::parameterAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::normalAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::derivative1At(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::derivative2At(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::derivative3At(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::curvatureAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::centerOfCurvatureAt(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::firstVertex(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::lastVertex(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::discretize(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::countNodes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::split(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::isSeam(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* TopoShapeEdgePy::curveOnSurface(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Float TopoShapeEdgePy::getTolerance() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  TopoShapeEdgePy::setTolerance(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapeEdgePy::getLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple TopoShapeEdgePy::getParameterRange() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapeEdgePy::getFirstParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float TopoShapeEdgePy::getLastParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeEdgePy::getCurve() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean TopoShapeEdgePy::getClosed() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean TopoShapeEdgePy::getDegenerated() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeEdgePy::getMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeEdgePy::getCenterOfMass() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeEdgePy::getMatrixOfInertia() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object TopoShapeEdgePy::getStaticMoments() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Dict TopoShapeEdgePy::getPrincipalProperties() const
{
    //return Py::Dict();
    throw Py::AttributeError("Not yet implemented");
}

Py::String TopoShapeEdgePy::getContinuity() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *TopoShapeEdgePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int TopoShapeEdgePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



