
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in Curve2dPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of Curve2dPy
PyTypeObject Curve2dPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.Geom2d.Curve2d",     /*tp_name*/
    sizeof(Curve2dPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "\n"
    "                The abstract class Geom2dCurve is the root class of all curve objects.\n"
    "			",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::Curve2dPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::Curve2dPy::GetterSetter,                     /*tp_getset */
    &Part::Geometry2dPy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::Curve2dPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of Curve2dPy
PyMethodDef Curve2dPy::Methods[] = {
    {"reverse",
        reinterpret_cast<PyCFunction>( staticCallback_reverse ),
        METH_VARARGS,
        "Changes the direction of parametrization of the curve."
    },
    {"toShape",
        reinterpret_cast<PyCFunction>( staticCallback_toShape ),
        METH_VARARGS,
        "Return the shape for the geometry."
    },
    {"discretize",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_discretize )),
        METH_VARARGS|METH_KEYWORDS,
        "Discretizes the curve and returns a list of points.\nThe function accepts keywords as argument:\ndiscretize(Number=n) => gives a list of 'n' equidistant points\ndiscretize(QuasiNumber=n) => gives a list of 'n' quasi equidistant points (is faster than the method above)\ndiscretize(Distance=d) => gives a list of equidistant points with distance 'd'\ndiscretize(Deflection=d) => gives a list of points with a maximum deflection 'd' to the curve\ndiscretize(QuasiDeflection=d) => gives a list of points with a maximum deflection 'd' to the curve (faster)\ndiscretize(Angular=a,Curvature=c,[Minimum=m]) => gives a list of points with an angular deflection of 'a'\n                                    and a curvature deflection of 'c'. Optionally a minimum number of points\n                                    can be set which by default is set to 2.\n\nOptionally you can set the keywords 'First' and 'Last' to define a sub-range of the parameter range\nof the curve.\n\nIf no keyword is given then it depends on whether the argument is an int or float.\nIf it's an int then the behaviour is as if using the keyword 'Number', if it's float\nthen the behaviour is as if using the keyword 'Distance'.\n\nExample:\n\nimport Part\nc=PartGeom2d.Circle2d()\nc.Radius=5\np=c.discretize(Number=50,First=3.14)\ns=Part.Compound([Part.Vertex(i) for i in p])\nPart.show(s)\n\n\np=c.discretize(Angular=0.09,Curvature=0.01,Last=3.14,Minimum=100)\ns=Part.Compound([Part.Vertex(i) for i in p])\nPart.show(s)\n"
    },
    {"length",
        reinterpret_cast<PyCFunction>( staticCallback_length ),
        METH_VARARGS,
        "Computes the length of a curve\nlength([uMin,uMax,Tol]) -> Float"
    },
    {"parameterAtDistance",
        reinterpret_cast<PyCFunction>( staticCallback_parameterAtDistance ),
        METH_VARARGS,
        "Returns the parameter on the curve of a point at the given distance from a starting parameter.\nparameterAtDistance([abscissa, startingParameter]) -> Float the"
    },
    {"value",
        reinterpret_cast<PyCFunction>( staticCallback_value ),
        METH_VARARGS,
        "Computes the point of parameter u on this curve"
    },
    {"tangent",
        reinterpret_cast<PyCFunction>( staticCallback_tangent ),
        METH_VARARGS,
        "Computes the tangent of parameter u on this curve"
    },
    {"parameter",
        reinterpret_cast<PyCFunction>( staticCallback_parameter ),
        METH_VARARGS,
        "Returns the parameter on the curve\nof the nearest orthogonal projection of the point."
    },
    {"normal",
        reinterpret_cast<PyCFunction>( staticCallback_normal ),
        METH_VARARGS,
        "Vector = normal(pos) - Get the normal vector at the given parameter [First|Last] if defined"
    },
    {"curvature",
        reinterpret_cast<PyCFunction>( staticCallback_curvature ),
        METH_VARARGS,
        "Float = curvature(pos) - Get the curvature at the given parameter [First|Last] if defined"
    },
    {"centerOfCurvature",
        reinterpret_cast<PyCFunction>( staticCallback_centerOfCurvature ),
        METH_VARARGS,
        "Vector = centerOfCurvature(float pos) - Get the center of curvature at the given parameter [First|Last] if defined"
    },
    {"intersectCC",
        reinterpret_cast<PyCFunction>( staticCallback_intersectCC ),
        METH_VARARGS,
        "\n                    Returns all intersection points between this curve and the given curve.\n                "
    },
    {"toBSpline",
        reinterpret_cast<PyCFunction>( staticCallback_toBSpline ),
        METH_VARARGS,
        "\n					Converts a curve of any type (only part from First to Last)\n					toBSpline([Float=First, Float=Last]) -> B-Spline curve\n				"
    },
    {"approximateBSpline",
        reinterpret_cast<PyCFunction>( staticCallback_approximateBSpline ),
        METH_VARARGS,
        "\n					Approximates a curve of any type to a B-Spline curve\n					approximateBSpline(Tolerance, MaxSegments, MaxDegree, [Order='C2']) -> B-Spline curve\n				"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of Curve2dPy
PyGetSetDef Curve2dPy::GetterSetter[] = {
    {"Continuity",
        (getter) staticCallback_getContinuity,
        (setter) staticCallback_setContinuity,
        "\n					Returns the global continuity of the curve.\n				",
        nullptr
    },
    {"Closed",
        (getter) staticCallback_getClosed,
        (setter) staticCallback_setClosed,
        "\n                    Returns true if the curve is closed.\n                ",
        nullptr
    },
    {"Periodic",
        (getter) staticCallback_getPeriodic,
        (setter) staticCallback_setPeriodic,
        "\n                    Returns true if the curve is periodic.\n                ",
        nullptr
    },
    {"FirstParameter",
        (getter) staticCallback_getFirstParameter,
        (setter) staticCallback_setFirstParameter,
        "\n					Returns the value of the first parameter.\n				",
        nullptr
    },
    {"LastParameter",
        (getter) staticCallback_getLastParameter,
        (setter) staticCallback_setLastParameter,
        "\n					Returns the value of the last parameter.\n				",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// reverse() callback and implementer
// PyObject*  Curve2dPy::reverse(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_reverse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'reverse' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->reverse(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toShape() callback and implementer
// PyObject*  Curve2dPy::toShape(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_toShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toShape' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->toShape(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// discretize() callback and implementer
// PyObject*  Curve2dPy::discretize(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_discretize (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'discretize' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->discretize(args, kwd);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// length() callback and implementer
// PyObject*  Curve2dPy::length(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_length (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'length' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->length(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// parameterAtDistance() callback and implementer
// PyObject*  Curve2dPy::parameterAtDistance(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_parameterAtDistance (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'parameterAtDistance' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->parameterAtDistance(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// value() callback and implementer
// PyObject*  Curve2dPy::value(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_value (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'value' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->value(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// tangent() callback and implementer
// PyObject*  Curve2dPy::tangent(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_tangent (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'tangent' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->tangent(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// parameter() callback and implementer
// PyObject*  Curve2dPy::parameter(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_parameter (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'parameter' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->parameter(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// normal() callback and implementer
// PyObject*  Curve2dPy::normal(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_normal (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'normal' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->normal(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// curvature() callback and implementer
// PyObject*  Curve2dPy::curvature(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_curvature (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'curvature' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->curvature(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// centerOfCurvature() callback and implementer
// PyObject*  Curve2dPy::centerOfCurvature(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_centerOfCurvature (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'centerOfCurvature' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->centerOfCurvature(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// intersectCC() callback and implementer
// PyObject*  Curve2dPy::intersectCC(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_intersectCC (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'intersectCC' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->intersectCC(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toBSpline() callback and implementer
// PyObject*  Curve2dPy::toBSpline(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_toBSpline (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toBSpline' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->toBSpline(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// approximateBSpline() callback and implementer
// PyObject*  Curve2dPy::approximateBSpline(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_approximateBSpline (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'approximateBSpline' of 'Part.Geom2dCurve' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<Curve2dPy*>(self)->approximateBSpline(args);
        if (ret != 0)
            static_cast<Curve2dPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Continuity() callback and implementer
// PyObject*  Curve2dPy::Continuity(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_getContinuity (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<Curve2dPy*>(self)->getContinuity());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Continuity' of object 'Geom2dCurve'");
        return nullptr;
    }
}

int Curve2dPy::staticCallback_setContinuity (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Continuity' of object 'Geom2dCurve' is read-only");
    return -1;
}

// Closed() callback and implementer
// PyObject*  Curve2dPy::Closed(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_getClosed (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<Curve2dPy*>(self)->getClosed());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Closed' of object 'Geom2dCurve'");
        return nullptr;
    }
}

int Curve2dPy::staticCallback_setClosed (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Closed' of object 'Geom2dCurve' is read-only");
    return -1;
}

// Periodic() callback and implementer
// PyObject*  Curve2dPy::Periodic(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_getPeriodic (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<Curve2dPy*>(self)->getPeriodic());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Periodic' of object 'Geom2dCurve'");
        return nullptr;
    }
}

int Curve2dPy::staticCallback_setPeriodic (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Periodic' of object 'Geom2dCurve' is read-only");
    return -1;
}

// FirstParameter() callback and implementer
// PyObject*  Curve2dPy::FirstParameter(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_getFirstParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<Curve2dPy*>(self)->getFirstParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FirstParameter' of object 'Geom2dCurve'");
        return nullptr;
    }
}

int Curve2dPy::staticCallback_setFirstParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FirstParameter' of object 'Geom2dCurve' is read-only");
    return -1;
}

// LastParameter() callback and implementer
// PyObject*  Curve2dPy::LastParameter(PyObject *args){};
// has to be implemented in Curve2dPyImp.cpp
PyObject * Curve2dPy::staticCallback_getLastParameter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<Curve2dPy*>(self)->getLastParameter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LastParameter' of object 'Geom2dCurve'");
        return nullptr;
    }
}

int Curve2dPy::staticCallback_setLastParameter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LastParameter' of object 'Geom2dCurve' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
Curve2dPy::Curve2dPy(Geom2dCurve *pcObject, PyTypeObject *T)
    : Geometry2dPy(static_cast<Geometry2dPy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
Curve2dPy::~Curve2dPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// Curve2dPy representation
//--------------------------------------------------------------------------
PyObject *Curve2dPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// Curve2dPy Attributes
//--------------------------------------------------------------------------
PyObject *Curve2dPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return Geometry2dPy::_getattr(attr);
}

int Curve2dPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return Geometry2dPy::_setattr(attr, value);
}

Geom2dCurve *Curve2dPy::getGeom2dCurvePtr() const
{
    return static_cast<Geom2dCurve *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in Curve2dPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *Curve2dPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of Curve2dPy and the Twin object
    return new Curve2dPy(new Geom2dCurve);
}

// constructor method
int Curve2dPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string Curve2dPy::representation() const
{
    return std::string("<Geom2dCurve object>");
}

PyObject* Curve2dPy::reverse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::toShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::discretize(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::length(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::parameterAtDistance(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::value(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::tangent(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::parameter(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::normal(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::curvature(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::centerOfCurvature(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::intersectCC(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::toBSpline(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* Curve2dPy::approximateBSpline(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::String Curve2dPy::getContinuity() const
{
    //return Py::String();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean Curve2dPy::getClosed() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean Curve2dPy::getPeriodic() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float Curve2dPy::getFirstParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float Curve2dPy::getLastParameter() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *Curve2dPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int Curve2dPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



