
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in BSplineSurfacePyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of BSplineSurfacePy
PyTypeObject BSplineSurfacePy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.BSplineSurface",     /*tp_name*/
    sizeof(BSplineSurfacePy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Describes a B-Spline surface in 3D space",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::BSplineSurfacePy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::BSplineSurfacePy::GetterSetter,                     /*tp_getset */
    &Part::GeometrySurfacePy::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::BSplineSurfacePy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of BSplineSurfacePy
PyMethodDef BSplineSurfacePy::Methods[] = {
    {"bounds",
        reinterpret_cast<PyCFunction>( staticCallback_bounds ),
        METH_VARARGS,
        "\n                    Returns the parametric bounds (U1, U2, V1, V2) of this B-Spline surface.\n                "
    },
    {"isURational",
        reinterpret_cast<PyCFunction>( staticCallback_isURational ),
        METH_VARARGS,
        "\n                    Returns false if the equation of this B-Spline surface is polynomial\n                    (e.g. non-rational) in the u or v parametric direction.\n                    In other words, returns false if for each row of poles, the associated\n                    weights are identical\n                "
    },
    {"isVRational",
        reinterpret_cast<PyCFunction>( staticCallback_isVRational ),
        METH_VARARGS,
        "\n                    Returns false if the equation of this B-Spline surface is polynomial\n                    (e.g. non-rational) in the u or v parametric direction.\n                    In other words, returns false if for each column of poles, the associated\n                    weights are identical\n                "
    },
    {"isUPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_isUPeriodic ),
        METH_VARARGS,
        "Returns true if this surface is periodic in the u parametric direction."
    },
    {"isVPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_isVPeriodic ),
        METH_VARARGS,
        "Returns true if this surface is periodic in the v parametric direction."
    },
    {"isUClosed",
        reinterpret_cast<PyCFunction>( staticCallback_isUClosed ),
        METH_VARARGS,
        "\n                    Checks if this surface is closed in the u parametric direction.\n                    Returns true if, in the table of poles the first row and the last\n                    row are identical.\n                "
    },
    {"isVClosed",
        reinterpret_cast<PyCFunction>( staticCallback_isVClosed ),
        METH_VARARGS,
        "\n                    Checks if this surface is closed in the v parametric direction.\n                    Returns true if, in the table of poles the first column and the\n                    last column are identical.\n                "
    },
    {"increaseDegree",
        reinterpret_cast<PyCFunction>( staticCallback_increaseDegree ),
        METH_VARARGS,
        "\n                    increase(Int=UDegree, int=VDegree)\n                    Increases the degrees of this B-Spline surface to UDegree and VDegree\n                    in the u and v parametric directions respectively.\n                    As a result, the tables of poles, weights and multiplicities are modified.\n                    The tables of knots is not changed.\n\n                    Note: Nothing is done if the given degree is less than or equal to the\n                    current degree in the corresponding parametric direction.\n                "
    },
    {"increaseUMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_increaseUMultiplicity ),
        METH_VARARGS,
        "Increases the multiplicity in the u direction."
    },
    {"increaseVMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_increaseVMultiplicity ),
        METH_VARARGS,
        "Increases the multiplicity in the v direction."
    },
    {"incrementUMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_incrementUMultiplicity ),
        METH_VARARGS,
        "Increment the multiplicity in the u direction"
    },
    {"incrementVMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_incrementVMultiplicity ),
        METH_VARARGS,
        "Increment the multiplicity in the v direction"
    },
    {"insertUKnot",
        reinterpret_cast<PyCFunction>( staticCallback_insertUKnot ),
        METH_VARARGS,
        "insertUKnote(float U, int Index, float Tolerance) - Insert or override a knot"
    },
    {"insertUKnots",
        reinterpret_cast<PyCFunction>( staticCallback_insertUKnots ),
        METH_VARARGS,
        "insertUKnote(List of float U, List of float Mult, float Tolerance) - Inserts knots."
    },
    {"insertVKnot",
        reinterpret_cast<PyCFunction>( staticCallback_insertVKnot ),
        METH_VARARGS,
        "insertUKnote(float V, int Index, float Tolerance) - Insert or override a knot."
    },
    {"insertVKnots",
        reinterpret_cast<PyCFunction>( staticCallback_insertVKnots ),
        METH_VARARGS,
        "insertUKnote(List of float V, List of float Mult, float Tolerance) - Inserts knots."
    },
    {"removeUKnot",
        reinterpret_cast<PyCFunction>( staticCallback_removeUKnot ),
        METH_VARARGS,
        "\n                Reduces to M the multiplicity of the knot of index Index in the given\n                parametric direction. If M is 0, the knot is removed.\n                With a modification of this type, the table of poles is also modified.\n                Two different algorithms are used systematically to compute the new\n                poles of the surface. For each pole, the distance between the pole\n                calculated using the first algorithm and the same pole calculated using\n                the second algorithm, is checked. If this distance is less than Tolerance\n                it ensures that the surface is not modified by more than Tolerance.\n                Under these conditions, the function returns true; otherwise, it returns\n                false.\n\n                A low tolerance prevents modification of the surface. A high tolerance\n                'smoothes' the surface.\n                "
    },
    {"removeVKnot",
        reinterpret_cast<PyCFunction>( staticCallback_removeVKnot ),
        METH_VARARGS,
        "\n                Reduces to M the multiplicity of the knot of index Index in the given\n                parametric direction. If M is 0, the knot is removed.\n                With a modification of this type, the table of poles is also modified.\n                Two different algorithms are used systematically to compute the new\n                poles of the surface. For each pole, the distance between the pole\n                calculated using the first algorithm and the same pole calculated using\n                the second algorithm, is checked. If this distance is less than Tolerance\n                it ensures that the surface is not modified by more than Tolerance.\n                Under these conditions, the function returns true; otherwise, it returns\n                false.\n\n                A low tolerance prevents modification of the surface. A high tolerance\n                'smoothes' the surface.\n                "
    },
    {"segment",
        reinterpret_cast<PyCFunction>( staticCallback_segment ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by segmenting it between U1 and U2 in the\n                    u parametric direction and between V1 and V2 in the v parametric direction.\n                    Any of these values can be outside the bounds of this surface, but U2 must\n                    be greater than U1 and V2 must be greater than V1.\n\n                    All the data structure tables of this B-Spline surface are modified but the\n                    knots located between U1 and U2 in the u parametric direction, and between\n                    V1 and V2 in the v parametric direction are retained.\n                    The degree of the surface in each parametric direction is not modified.\n                "
    },
    {"setUKnot",
        reinterpret_cast<PyCFunction>( staticCallback_setUKnot ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning the value K to the knot of index\n                    UIndex of the knots table corresponding to the u parametric direction.\n                    This modification remains relatively local, since K must lie between the values\n                    of the knots which frame the modified knot.\n\n                    You can also increase the multiplicity of the modified knot to M. Note however\n                    that it is not possible to decrease the multiplicity of a knot with this function.\n                "
    },
    {"setVKnot",
        reinterpret_cast<PyCFunction>( staticCallback_setVKnot ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning the value K to the knot of index\n                    VIndex of the knots table corresponding to the v parametric direction.\n                    This modification remains relatively local, since K must lie between the values\n                    of the knots which frame the modified knot.\n\n                    You can also increase the multiplicity of the modified knot to M. Note however\n                    that it is not possible to decrease the multiplicity of a knot with this function.\n                "
    },
    {"getUKnot",
        reinterpret_cast<PyCFunction>( staticCallback_getUKnot ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, in the u parametric direction\n                    the knot of index UIndex of the knots table.\n                "
    },
    {"getVKnot",
        reinterpret_cast<PyCFunction>( staticCallback_getVKnot ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, in the v parametric direction\n                    the knot of index VIndex of the knots table.\n                "
    },
    {"setUKnots",
        reinterpret_cast<PyCFunction>( staticCallback_setUKnots ),
        METH_VARARGS,
        "\n                    Changes all knots of this B-Spline surface in the u parametric\n                    direction. The multiplicity of the knots is not modified.\n                "
    },
    {"setVKnots",
        reinterpret_cast<PyCFunction>( staticCallback_setVKnots ),
        METH_VARARGS,
        "\n                    Changes all knots of this B-Spline surface in the v parametric\n                    direction. The multiplicity of the knots is not modified.\n                "
    },
    {"getUKnots",
        reinterpret_cast<PyCFunction>( staticCallback_getUKnots ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the knots table\n                    in the u parametric direction\n                "
    },
    {"getVKnots",
        reinterpret_cast<PyCFunction>( staticCallback_getVKnots ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the knots table\n                    in the v parametric direction\n                "
    },
    {"setPole",
        reinterpret_cast<PyCFunction>( staticCallback_setPole ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning P to the pole of\n                    index (UIndex, VIndex) in the poles table.\n                    The second syntax allows you also to change the weight of the\n                    modified pole. The weight is set to Weight. This syntax must\n                    only be used for rational surfaces.\n                    Modifies this B-Spline curve by assigning P to the pole of\n                    index Index in the poles table.\n                "
    },
    {"setPoleCol",
        reinterpret_cast<PyCFunction>( staticCallback_setPoleCol ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning values to all or part\n                    of the column of poles of index VIndex, of this B-Spline surface.\n                    You can also change the weights of the modified poles. The weights\n                    are set to the corresponding values of CPoleWeights.\n                    These syntaxes must only be used for rational surfaces.\n                "
    },
    {"setPoleRow",
        reinterpret_cast<PyCFunction>( staticCallback_setPoleRow ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning values to all or part\n                    of the row of poles of index VIndex, of this B-Spline surface.\n                    You can also change the weights of the modified poles. The weights\n                    are set to the corresponding values of CPoleWeights.\n                    These syntaxes must only be used for rational surfaces.\n                "
    },
    {"getPole",
        reinterpret_cast<PyCFunction>( staticCallback_getPole ),
        METH_VARARGS,
        "\n                    Returns the pole of index (UIndex,VIndex) of this B-Spline surface.\n                "
    },
    {"getPoles",
        reinterpret_cast<PyCFunction>( staticCallback_getPoles ),
        METH_VARARGS,
        "Returns the table of poles of this B-Spline surface."
    },
    {"setWeight",
        reinterpret_cast<PyCFunction>( staticCallback_setWeight ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning the value Weight to the weight\n                    of the pole of index (UIndex, VIndex) in the poles tables of this B-Spline\n                    surface.\n\n                    This function must only be used for rational surfaces.\n                "
    },
    {"setWeightCol",
        reinterpret_cast<PyCFunction>( staticCallback_setWeightCol ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning values to all or part of the\n                    weights of the column of poles of index VIndex of this B-Spline surface.\n\n                    The modified part of the column of weights is defined by the bounds\n                    of the array CPoleWeights.\n\n                    This function must only be used for rational surfaces.\n                "
    },
    {"setWeightRow",
        reinterpret_cast<PyCFunction>( staticCallback_setWeightRow ),
        METH_VARARGS,
        "\n                    Modifies this B-Spline surface by assigning values to all or part of the\n                    weights of the row of poles of index UIndex of this B-Spline surface.\n\n                    The modified part of the row of weights is defined by the bounds of the\n                    array CPoleWeights.\n\n                    This function must only be used for rational surfaces.\n                "
    },
    {"getWeight",
        reinterpret_cast<PyCFunction>( staticCallback_getWeight ),
        METH_VARARGS,
        "\n                    Return the weight of the pole of index (UIndex,VIndex)\n                    in the poles table for this B-Spline surface.\n                "
    },
    {"getWeights",
        reinterpret_cast<PyCFunction>( staticCallback_getWeights ),
        METH_VARARGS,
        "Returns the table of weights of the poles for this B-Spline surface."
    },
    {"getPolesAndWeights",
        reinterpret_cast<PyCFunction>( staticCallback_getPolesAndWeights ),
        METH_VARARGS,
        "Returns the table of poles and weights in homogeneous coordinates."
    },
    {"getResolution",
        reinterpret_cast<PyCFunction>( staticCallback_getResolution ),
        METH_VARARGS,
        "\n                    Computes two tolerance values for this B-Spline surface, based on the\n                    given tolerance in 3D space Tolerance3D. The tolerances computed are:\n                    -- UTolerance in the u parametric direction and\n                    -- VTolerance in the v parametric direction.\n\n                    If f(u,v) is the equation of this B-Spline surface, UTolerance and\n                    VTolerance guarantee that:\n                    |u1 - u0| < UTolerance\n                    |v1 - v0| < VTolerance\n                    ====> ||f(u1, v1) - f(u2, v2)|| < Tolerance3D\n                "
    },
    {"movePoint",
        reinterpret_cast<PyCFunction>( staticCallback_movePoint ),
        METH_VARARGS,
        "\n                    Moves the point of parameters (U, V) of this B-Spline surface to P.\n                    UIndex1, UIndex2, VIndex1 and VIndex2 are the indexes in the poles\n                    table of this B-Spline surface, of the first and last poles which\n                    can be moved in each parametric direction.\n                    The returned indexes UFirstIndex, ULastIndex, VFirstIndex and\n                    VLastIndex are the indexes of the first and last poles effectively\n                    modified in each parametric direction.\n                    In the event of incompatibility between UIndex1, UIndex2, VIndex1,\n                    VIndex2 and the values U and V:\n                    -- no change is made to this B-Spline surface, and\n                    -- UFirstIndex, ULastIndex, VFirstIndex and VLastIndex are set to\n                       null.\n                "
    },
    {"setUNotPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_setUNotPeriodic ),
        METH_VARARGS,
        "\n                    Changes this B-Spline surface into a non-periodic one in the u parametric direction.\n                    If this B-Spline surface is already non-periodic in the given parametric direction,\n                    it is not modified.\n                    If this B-Spline surface is periodic in the given parametric direction, the boundaries\n                    of the surface are not given by the first and last rows (or columns) of poles (because\n                    the multiplicity of the first knot and of the last knot in the given parametric direction\n                    are not modified, nor are they equal to Degree+1, where Degree is the degree of this\n                    B-Spline surface in the given parametric direction). Only the function Segment ensures\n                    this property.\n\n                    Note: the poles and knots tables are modified.\n                "
    },
    {"setVNotPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_setVNotPeriodic ),
        METH_VARARGS,
        "\n                    Changes this B-Spline surface into a non-periodic one in the v parametric direction.\n                    If this B-Spline surface is already non-periodic in the given parametric direction,\n                    it is not modified.\n                    If this B-Spline surface is periodic in the given parametric direction, the boundaries\n                    of the surface are not given by the first and last rows (or columns) of poles (because\n                    the multiplicity of the first knot and of the last knot in the given parametric direction\n                    are not modified, nor are they equal to Degree+1, where Degree is the degree of this\n                    B-Spline surface in the given parametric direction). Only the function Segment ensures\n                    this property.\n\n                    Note: the poles and knots tables are modified.\n                "
    },
    {"setUPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_setUPeriodic ),
        METH_VARARGS,
        "\n                    Modifies this surface to be periodic in the u parametric direction.\n                    To become periodic in a given parametric direction a surface must\n                    be closed in that parametric direction, and the knot sequence relative\n                    to that direction must be periodic.\n                    To generate this periodic sequence of knots, the functions FirstUKnotIndex\n                    and LastUKnotIndex are used to compute I1 and I2. These are the indexes,\n                    in the knot array associated with the given parametric direction, of the\n                    knots that correspond to the first and last parameters of this B-Spline\n                    surface in the given parametric direction. Hence the period is:\n\n                    Knots(I1) - Knots(I2)\n\n                    As a result, the knots and poles tables are modified.\n                "
    },
    {"setVPeriodic",
        reinterpret_cast<PyCFunction>( staticCallback_setVPeriodic ),
        METH_VARARGS,
        "\n                    Modifies this surface to be periodic in the v parametric direction.\n                    To become periodic in a given parametric direction a surface must\n                    be closed in that parametric direction, and the knot sequence relative\n                    to that direction must be periodic.\n                    To generate this periodic sequence of knots, the functions FirstUKnotIndex\n                    and LastUKnotIndex are used to compute I1 and I2. These are the indexes,\n                    in the knot array associated with the given parametric direction, of the\n                    knots that correspond to the first and last parameters of this B-Spline\n                    surface in the given parametric direction. Hence the period is:\n\n                    Knots(I1) - Knots(I2)\n\n                    As a result, the knots and poles tables are modified.\n                "
    },
    {"setUOrigin",
        reinterpret_cast<PyCFunction>( staticCallback_setUOrigin ),
        METH_VARARGS,
        "\n                    Assigns the knot of index Index in the knots table\n                    in the u parametric direction to be the origin of\n                    this periodic B-Spline surface. As a consequence,\n                    the knots and poles tables are modified.\n                "
    },
    {"setVOrigin",
        reinterpret_cast<PyCFunction>( staticCallback_setVOrigin ),
        METH_VARARGS,
        "\n                    Assigns the knot of index Index in the knots table\n                    in the v parametric direction to be the origin of\n                    this periodic B-Spline surface. As a consequence,\n                    the knots and poles tables are modified.\n                "
    },
    {"getUMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_getUMultiplicity ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the multiplicity of\n                    the knot of index UIndex in the u parametric direction.\n                "
    },
    {"getVMultiplicity",
        reinterpret_cast<PyCFunction>( staticCallback_getVMultiplicity ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the multiplicity of\n                    the knot of index VIndex in the v parametric direction.\n                "
    },
    {"getUMultiplicities",
        reinterpret_cast<PyCFunction>( staticCallback_getUMultiplicities ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the table of\n                    multiplicities in the u parametric direction\n                "
    },
    {"getVMultiplicities",
        reinterpret_cast<PyCFunction>( staticCallback_getVMultiplicities ),
        METH_VARARGS,
        "\n                    Returns, for this B-Spline surface, the table of\n                    multiplicities in the v parametric direction\n                "
    },
    {"exchangeUV",
        reinterpret_cast<PyCFunction>( staticCallback_exchangeUV ),
        METH_VARARGS,
        "\n                    Exchanges the u and v parametric directions on this B-Spline surface.\n                    As a consequence:\n                    -- the poles and weights tables are transposed,\n                    -- the knots and multiplicities tables are exchanged,\n                    -- degrees of continuity and rational, periodic and uniform\n                       characteristics are exchanged and\n                    -- the orientation of the surface is reversed.\n                "
    },
    {"reparametrize",
        reinterpret_cast<PyCFunction>( staticCallback_reparametrize ),
        METH_VARARGS,
        "Returns a reparametrized copy of this surface"
    },
    {"approximate",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_approximate )),
        METH_VARARGS|METH_KEYWORDS,
        "\n                    Replaces this B-Spline surface by approximating a set of points.\n                    This method uses keywords :\n                    - Points = 2Darray of points (or floats, in combination with X0, dX, Y0, dY)\n                    - DegMin (int), DegMax (int)\n                    - Continuity = 0,1 or 2 (for C0, C1, C2)\n                    - Tolerance (float)\n                    - X0, dX, Y0, dY (floats) with Points = 2Darray of floats\n                    - ParamType = 'Uniform','Centripetal' or 'ChordLength'\n                    - LengthWeight, CurvatureWeight, TorsionWeight (floats)\n                    (with this smoothing algorithm, continuity C1 requires DegMax >= 3 and C2, DegMax >=5)\n\n                    Possible combinations :\n                    - approximate(Points, DegMin, DegMax, Continuity, Tolerance)\n                    - approximate(Points, DegMin, DegMax, Continuity, Tolerance, X0, dX, Y0, dY)\n                    With explicit keywords :\n                    - approximate(Points, DegMin, DegMax, Continuity, Tolerance, ParamType)\n                    - approximate(Points, DegMax, Continuity, Tolerance, LengthWeight, CurvatureWeight, TorsionWeight)\n                "
    },
    {"interpolate",
        reinterpret_cast<PyCFunction>( staticCallback_interpolate ),
        METH_VARARGS,
        "\n                    interpolate(points)\n                    interpolate(zpoints, X0, dX, Y0, dY)\n\n                    Replaces this B-Spline surface by interpolating a set of points.\n                    The resulting surface is of degree 3 and continuity C2.\n                    Arguments:\n                    a 2 dimensional array of vectors, that the surface passes through\n                    or\n                    a 2 dimensional array of floats with the z values,\n                    the x starting point X0 (float),\n                    the x increment dX (float),\n                    the y starting point Y0 and increment dY\n                "
    },
    {"buildFromPolesMultsKnots",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_buildFromPolesMultsKnots )),
        METH_VARARGS|METH_KEYWORDS,
        "\n                    Builds a B-Spline by a lists of Poles, Mults and Knots\n                    arguments: poles (sequence of sequence of Base.Vector), umults, vmults, [uknots, vknots, uperiodic, vperiodic, udegree, vdegree, weights (sequence of sequence of float)]\n                "
    },
    {"buildFromNSections",
        reinterpret_cast<PyCFunction>( staticCallback_buildFromNSections ),
        METH_VARARGS,
        "\n                    Builds a B-Spline from a list of control curves\n                "
    },
    {"scaleKnotsToBounds",
        reinterpret_cast<PyCFunction>( staticCallback_scaleKnotsToBounds ),
        METH_VARARGS,
        "\n                    Scales the U and V knots lists to fit the specified bounds.\n                    The shape of the surface is not modified.\n                    bspline_surf.scaleKnotsToBounds(u0, u1, v0, v1)\n                    Default arguments are 0.0, 1.0, 0.0, 1.0\n                "
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of BSplineSurfacePy
PyGetSetDef BSplineSurfacePy::GetterSetter[] = {
    {"UDegree",
        (getter) staticCallback_getUDegree,
        (setter) staticCallback_setUDegree,
        "\n                    Returns the degree of this B-Spline surface in the u parametric direction.\n                ",
        nullptr
    },
    {"VDegree",
        (getter) staticCallback_getVDegree,
        (setter) staticCallback_setVDegree,
        "\n                    Returns the degree of this B-Spline surface in the v parametric direction.\n                ",
        nullptr
    },
    {"MaxDegree",
        (getter) staticCallback_getMaxDegree,
        (setter) staticCallback_setMaxDegree,
        "\n                    Returns the value of the maximum polynomial degree of any\n                    B-Spline surface surface in either parametric directions.\n                    This value is 25.\n                ",
        nullptr
    },
    {"NbUPoles",
        (getter) staticCallback_getNbUPoles,
        (setter) staticCallback_setNbUPoles,
        "\n                    Returns the number of poles of this B-Spline surface in the u parametric direction.\n                ",
        nullptr
    },
    {"NbVPoles",
        (getter) staticCallback_getNbVPoles,
        (setter) staticCallback_setNbVPoles,
        "\n                    Returns the number of poles of this B-Spline surface in the v parametric direction.\n                ",
        nullptr
    },
    {"NbUKnots",
        (getter) staticCallback_getNbUKnots,
        (setter) staticCallback_setNbUKnots,
        "\n                    Returns the number of knots of this B-Spline surface in the u parametric direction.\n                ",
        nullptr
    },
    {"NbVKnots",
        (getter) staticCallback_getNbVKnots,
        (setter) staticCallback_setNbVKnots,
        "\n                    Returns the number of knots of this B-Spline surface in the v parametric direction.\n                ",
        nullptr
    },
    {"FirstUKnotIndex",
        (getter) staticCallback_getFirstUKnotIndex,
        (setter) staticCallback_setFirstUKnotIndex,
        "\n                    Returns the index in the knot array associated with the u parametric direction,\n                    which corresponds to the first parameter of this B-Spline surface in the specified\n                    parametric direction.\n\n                    The isoparametric curves corresponding to these values are the boundary curves of\n                    this surface.\n\n                    Note: The index does not correspond to the first knot of the surface in the specified\n                    parametric direction unless the multiplicity of the first knot is equal to Degree + 1,\n                    where Degree is the degree of this surface in the corresponding parametric direction.\n                ",
        nullptr
    },
    {"LastUKnotIndex",
        (getter) staticCallback_getLastUKnotIndex,
        (setter) staticCallback_setLastUKnotIndex,
        "\n                    Returns the index in the knot array associated with the u parametric direction,\n                    which corresponds to the last parameter of this B-Spline surface in the specified\n                    parametric direction.\n\n                    The isoparametric curves corresponding to these values are the boundary curves of\n                    this surface.\n\n                    Note: The index does not correspond to the first knot of the surface in the specified\n                    parametric direction unless the multiplicity of the last knot is equal to Degree + 1,\n                    where Degree is the degree of this surface in the corresponding parametric direction.\n                ",
        nullptr
    },
    {"FirstVKnotIndex",
        (getter) staticCallback_getFirstVKnotIndex,
        (setter) staticCallback_setFirstVKnotIndex,
        "\n                    Returns the index in the knot array associated with the v parametric direction,\n                    which corresponds to the first parameter of this B-Spline surface in the specified\n                    parametric direction.\n\n                    The isoparametric curves corresponding to these values are the boundary curves of\n                    this surface.\n\n                    Note: The index does not correspond to the first knot of the surface in the specified\n                    parametric direction unless the multiplicity of the first knot is equal to Degree + 1,\n                    where Degree is the degree of this surface in the corresponding parametric direction.\n                ",
        nullptr
    },
    {"LastVKnotIndex",
        (getter) staticCallback_getLastVKnotIndex,
        (setter) staticCallback_setLastVKnotIndex,
        "\n                    Returns the index in the knot array associated with the v parametric direction,\n                    which corresponds to the last parameter of this B-Spline surface in the specified\n                    parametric direction.\n\n                    The isoparametric curves corresponding to these values are the boundary curves of\n                    this surface.\n\n                    Note: The index does not correspond to the first knot of the surface in the specified\n                    parametric direction unless the multiplicity of the last knot is equal to Degree + 1,\n                    where Degree is the degree of this surface in the corresponding parametric direction.\n                ",
        nullptr
    },
    {"UKnotSequence",
        (getter) staticCallback_getUKnotSequence,
        (setter) staticCallback_setUKnotSequence,
        "\n                        Returns the knots sequence of this B-Spline surface in\n                        the u direction.\n                ",
        nullptr
    },
    {"VKnotSequence",
        (getter) staticCallback_getVKnotSequence,
        (setter) staticCallback_setVKnotSequence,
        "\n                    Returns the knots sequence of this B-Spline surface in\n                    the v direction.\n                ",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// bounds() callback and implementer
// PyObject*  BSplineSurfacePy::bounds(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_bounds (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'bounds' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->bounds(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isURational() callback and implementer
// PyObject*  BSplineSurfacePy::isURational(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isURational (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isURational' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isURational(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVRational() callback and implementer
// PyObject*  BSplineSurfacePy::isVRational(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isVRational (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVRational' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isVRational(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isUPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::isUPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isUPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isUPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isUPeriodic(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::isVPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isVPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isVPeriodic(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isUClosed() callback and implementer
// PyObject*  BSplineSurfacePy::isUClosed(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isUClosed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isUClosed' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isUClosed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isVClosed() callback and implementer
// PyObject*  BSplineSurfacePy::isVClosed(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_isVClosed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isVClosed' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->isVClosed(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// increaseDegree() callback and implementer
// PyObject*  BSplineSurfacePy::increaseDegree(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_increaseDegree (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'increaseDegree' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->increaseDegree(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// increaseUMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::increaseUMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_increaseUMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'increaseUMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->increaseUMultiplicity(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// increaseVMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::increaseVMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_increaseVMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'increaseVMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->increaseVMultiplicity(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// incrementUMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::incrementUMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_incrementUMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'incrementUMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->incrementUMultiplicity(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// incrementVMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::incrementVMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_incrementVMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'incrementVMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->incrementVMultiplicity(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertUKnot() callback and implementer
// PyObject*  BSplineSurfacePy::insertUKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_insertUKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertUKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->insertUKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertUKnots() callback and implementer
// PyObject*  BSplineSurfacePy::insertUKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_insertUKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertUKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->insertUKnots(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertVKnot() callback and implementer
// PyObject*  BSplineSurfacePy::insertVKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_insertVKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertVKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->insertVKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// insertVKnots() callback and implementer
// PyObject*  BSplineSurfacePy::insertVKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_insertVKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'insertVKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->insertVKnots(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeUKnot() callback and implementer
// PyObject*  BSplineSurfacePy::removeUKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_removeUKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeUKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->removeUKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// removeVKnot() callback and implementer
// PyObject*  BSplineSurfacePy::removeVKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_removeVKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'removeVKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->removeVKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// segment() callback and implementer
// PyObject*  BSplineSurfacePy::segment(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_segment (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'segment' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->segment(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setUKnot() callback and implementer
// PyObject*  BSplineSurfacePy::setUKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setUKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setUKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setUKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVKnot() callback and implementer
// PyObject*  BSplineSurfacePy::setVKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setVKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setVKnot(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getUKnot() callback and implementer
// PyObject*  BSplineSurfacePy::getUKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getUKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getUKnot(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getVKnot() callback and implementer
// PyObject*  BSplineSurfacePy::getVKnot(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVKnot (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getVKnot' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getVKnot(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setUKnots() callback and implementer
// PyObject*  BSplineSurfacePy::setUKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setUKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setUKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setUKnots(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVKnots() callback and implementer
// PyObject*  BSplineSurfacePy::setVKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setVKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setVKnots(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getUKnots() callback and implementer
// PyObject*  BSplineSurfacePy::getUKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getUKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getUKnots(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getVKnots() callback and implementer
// PyObject*  BSplineSurfacePy::getVKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVKnots (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getVKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getVKnots(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPole() callback and implementer
// PyObject*  BSplineSurfacePy::setPole(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setPole (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPole' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setPole(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPoleCol() callback and implementer
// PyObject*  BSplineSurfacePy::setPoleCol(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setPoleCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPoleCol' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setPoleCol(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setPoleRow() callback and implementer
// PyObject*  BSplineSurfacePy::setPoleRow(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setPoleRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setPoleRow' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setPoleRow(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPole() callback and implementer
// PyObject*  BSplineSurfacePy::getPole(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getPole (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPole' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getPole(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPoles() callback and implementer
// PyObject*  BSplineSurfacePy::getPoles(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getPoles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPoles' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getPoles(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeight() callback and implementer
// PyObject*  BSplineSurfacePy::setWeight(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setWeight (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeight' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setWeight(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeightCol() callback and implementer
// PyObject*  BSplineSurfacePy::setWeightCol(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setWeightCol (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeightCol' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setWeightCol(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setWeightRow() callback and implementer
// PyObject*  BSplineSurfacePy::setWeightRow(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setWeightRow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setWeightRow' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setWeightRow(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getWeight() callback and implementer
// PyObject*  BSplineSurfacePy::getWeight(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getWeight (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getWeight' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getWeight(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getWeights() callback and implementer
// PyObject*  BSplineSurfacePy::getWeights(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getWeights (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getWeights' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getWeights(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPolesAndWeights() callback and implementer
// PyObject*  BSplineSurfacePy::getPolesAndWeights(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getPolesAndWeights (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPolesAndWeights' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getPolesAndWeights(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getResolution() callback and implementer
// PyObject*  BSplineSurfacePy::getResolution(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getResolution (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getResolution' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getResolution(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// movePoint() callback and implementer
// PyObject*  BSplineSurfacePy::movePoint(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_movePoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'movePoint' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->movePoint(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setUNotPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::setUNotPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setUNotPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setUNotPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setUNotPeriodic(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVNotPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::setVNotPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setVNotPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVNotPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setVNotPeriodic(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setUPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::setUPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setUPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setUPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setUPeriodic(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVPeriodic() callback and implementer
// PyObject*  BSplineSurfacePy::setVPeriodic(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setVPeriodic (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVPeriodic' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setVPeriodic(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setUOrigin() callback and implementer
// PyObject*  BSplineSurfacePy::setUOrigin(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setUOrigin (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setUOrigin' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setUOrigin(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setVOrigin() callback and implementer
// PyObject*  BSplineSurfacePy::setVOrigin(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_setVOrigin (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVOrigin' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->setVOrigin(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getUMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::getUMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getUMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getUMultiplicity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getVMultiplicity() callback and implementer
// PyObject*  BSplineSurfacePy::getVMultiplicity(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVMultiplicity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getVMultiplicity' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getVMultiplicity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getUMultiplicities() callback and implementer
// PyObject*  BSplineSurfacePy::getUMultiplicities(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUMultiplicities (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getUMultiplicities' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getUMultiplicities(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getVMultiplicities() callback and implementer
// PyObject*  BSplineSurfacePy::getVMultiplicities(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVMultiplicities (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getVMultiplicities' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->getVMultiplicities(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// exchangeUV() callback and implementer
// PyObject*  BSplineSurfacePy::exchangeUV(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_exchangeUV (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'exchangeUV' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->exchangeUV(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// reparametrize() callback and implementer
// PyObject*  BSplineSurfacePy::reparametrize(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_reparametrize (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'reparametrize' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->reparametrize(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// approximate() callback and implementer
// PyObject*  BSplineSurfacePy::approximate(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_approximate (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'approximate' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->approximate(args, kwd);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// interpolate() callback and implementer
// PyObject*  BSplineSurfacePy::interpolate(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_interpolate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'interpolate' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->interpolate(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// buildFromPolesMultsKnots() callback and implementer
// PyObject*  BSplineSurfacePy::buildFromPolesMultsKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_buildFromPolesMultsKnots (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'buildFromPolesMultsKnots' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->buildFromPolesMultsKnots(args, kwd);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// buildFromNSections() callback and implementer
// PyObject*  BSplineSurfacePy::buildFromNSections(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_buildFromNSections (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'buildFromNSections' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->buildFromNSections(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// scaleKnotsToBounds() callback and implementer
// PyObject*  BSplineSurfacePy::scaleKnotsToBounds(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_scaleKnotsToBounds (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'scaleKnotsToBounds' of 'Part.GeomBSplineSurface' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BSplineSurfacePy*>(self)->scaleKnotsToBounds(args);
        if (ret != 0)
            static_cast<BSplineSurfacePy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// UDegree() callback and implementer
// PyObject*  BSplineSurfacePy::UDegree(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getUDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UDegree' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setUDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UDegree' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// VDegree() callback and implementer
// PyObject*  BSplineSurfacePy::VDegree(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getVDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'VDegree' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setVDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'VDegree' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// MaxDegree() callback and implementer
// PyObject*  BSplineSurfacePy::MaxDegree(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getMaxDegree (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getMaxDegree());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'MaxDegree' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setMaxDegree (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'MaxDegree' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// NbUPoles() callback and implementer
// PyObject*  BSplineSurfacePy::NbUPoles(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getNbUPoles (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getNbUPoles());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbUPoles' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setNbUPoles (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbUPoles' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// NbVPoles() callback and implementer
// PyObject*  BSplineSurfacePy::NbVPoles(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getNbVPoles (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getNbVPoles());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbVPoles' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setNbVPoles (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbVPoles' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// NbUKnots() callback and implementer
// PyObject*  BSplineSurfacePy::NbUKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getNbUKnots (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getNbUKnots());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbUKnots' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setNbUKnots (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbUKnots' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// NbVKnots() callback and implementer
// PyObject*  BSplineSurfacePy::NbVKnots(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getNbVKnots (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getNbVKnots());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NbVKnots' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setNbVKnots (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NbVKnots' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// FirstUKnotIndex() callback and implementer
// PyObject*  BSplineSurfacePy::FirstUKnotIndex(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getFirstUKnotIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getFirstUKnotIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FirstUKnotIndex' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setFirstUKnotIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FirstUKnotIndex' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// LastUKnotIndex() callback and implementer
// PyObject*  BSplineSurfacePy::LastUKnotIndex(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getLastUKnotIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getLastUKnotIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LastUKnotIndex' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setLastUKnotIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LastUKnotIndex' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// FirstVKnotIndex() callback and implementer
// PyObject*  BSplineSurfacePy::FirstVKnotIndex(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getFirstVKnotIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getFirstVKnotIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'FirstVKnotIndex' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setFirstVKnotIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'FirstVKnotIndex' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// LastVKnotIndex() callback and implementer
// PyObject*  BSplineSurfacePy::LastVKnotIndex(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getLastVKnotIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getLastVKnotIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'LastVKnotIndex' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setLastVKnotIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'LastVKnotIndex' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// UKnotSequence() callback and implementer
// PyObject*  BSplineSurfacePy::UKnotSequence(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getUKnotSequence (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getUKnotSequence());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'UKnotSequence' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setUKnotSequence (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'UKnotSequence' of object 'GeomBSplineSurface' is read-only");
    return -1;
}

// VKnotSequence() callback and implementer
// PyObject*  BSplineSurfacePy::VKnotSequence(PyObject *args){};
// has to be implemented in BSplineSurfacePyImp.cpp
PyObject * BSplineSurfacePy::staticCallback_getVKnotSequence (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BSplineSurfacePy*>(self)->getVKnotSequence());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'VKnotSequence' of object 'GeomBSplineSurface'");
        return nullptr;
    }
}

int BSplineSurfacePy::staticCallback_setVKnotSequence (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'VKnotSequence' of object 'GeomBSplineSurface' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
BSplineSurfacePy::BSplineSurfacePy(GeomBSplineSurface *pcObject, PyTypeObject *T)
    : GeometrySurfacePy(static_cast<GeometrySurfacePy::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
BSplineSurfacePy::~BSplineSurfacePy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// BSplineSurfacePy representation
//--------------------------------------------------------------------------
PyObject *BSplineSurfacePy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// BSplineSurfacePy Attributes
//--------------------------------------------------------------------------
PyObject *BSplineSurfacePy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return GeometrySurfacePy::_getattr(attr);
}

int BSplineSurfacePy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return GeometrySurfacePy::_setattr(attr, value);
}

GeomBSplineSurface *BSplineSurfacePy::getGeomBSplineSurfacePtr() const
{
    return static_cast<GeomBSplineSurface *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in BSplineSurfacePyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *BSplineSurfacePy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of BSplineSurfacePy and the Twin object
    return new BSplineSurfacePy(new GeomBSplineSurface);
}

// constructor method
int BSplineSurfacePy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string BSplineSurfacePy::representation() const
{
    return std::string("<GeomBSplineSurface object>");
}

PyObject* BSplineSurfacePy::bounds(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isURational(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isVRational(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isUPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isVPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isUClosed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::isVClosed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::increaseDegree(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::increaseUMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::increaseVMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::incrementUMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::incrementVMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::insertUKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::insertUKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::insertVKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::insertVKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::removeUKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::removeVKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::segment(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setUKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setVKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getUKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getVKnot(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setUKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setVKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getUKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getVKnots(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setPole(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setPoleCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setPoleRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getPole(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getPoles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setWeight(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setWeightCol(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setWeightRow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getWeight(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getWeights(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getPolesAndWeights(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getResolution(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::movePoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setUNotPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setVNotPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setUPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setVPeriodic(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setUOrigin(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::setVOrigin(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getUMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getVMultiplicity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getUMultiplicities(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::getVMultiplicities(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::exchangeUV(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::reparametrize(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::approximate(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::interpolate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::buildFromPolesMultsKnots(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::buildFromNSections(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BSplineSurfacePy::scaleKnotsToBounds(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Long BSplineSurfacePy::getUDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getVDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getMaxDegree() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getNbUPoles() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getNbVPoles() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getNbUKnots() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Long BSplineSurfacePy::getNbVKnots() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object BSplineSurfacePy::getFirstUKnotIndex() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object BSplineSurfacePy::getLastUKnotIndex() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object BSplineSurfacePy::getFirstVKnotIndex() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object BSplineSurfacePy::getLastVKnotIndex() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::List BSplineSurfacePy::getUKnotSequence() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::List BSplineSurfacePy::getVKnotSequence() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *BSplineSurfacePy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int BSplineSurfacePy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



