
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in RotationPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Base;

/// Type structure of RotationPy
PyTypeObject RotationPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Base.Rotation",     /*tp_name*/
    sizeof(RotationPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    Base::RotationPy::Number,      /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Base.Rotation class.\n\n"
    "A Rotation using a quaternion.\n\n"
    "The following constructors are supported:\n\n"
    "Rotation()\n"
    "Empty constructor.\n\n"
    "Rotation(rotation)\n"
    "Copy constructor.\n\n"
    "Rotation(Axis, Radian)\n"
    "Rotation(Axis, Degree)\n"
    "Define from an axis and an angle (in radians or degrees according to the keyword).\n"
    "Axis : Base.Vector\n"
    "Radian : float\n"
    "Degree : float\n\n"
    "Rotation(vector_start, vector_end)\n"
    "Define from two vectors (rotation from/to vector).\n"
    "vector_start : Base.Vector\n"
    "vector_end : Base.Vector\n\n"
    "Rotation(angle1, angle2, angle3)\n"
    "Define from three floats (Euler angles) as yaw-pitch-roll in XY'Z'' convention.\n"
    "angle1 : float\n"
    "angle2 : float\n"
    "angle3 : float\n\n"
    "Rotation(seq, angle1, angle2, angle3)\n"
    "Define from one string and three floats (Euler angles) as Euler rotation\n"
    "of a given type. Call toEulerAngles() for supported sequence types.\n"
    "seq : str\n"
    "angle1 : float\n"
    "angle2 : float\n"
    "angle3 : float\n\n"
    "Rotation(x, y, z, w)\n"
    "Define from four floats (quaternion) where the quaternion is specified as:\n"
    "q = xi+yj+zk+w, i.e. the last parameter is the real part.\n"
    "x : float\n"
    "y : float\n"
    "z : float\n"
    "w : float\n\n"
    "Rotation(dir1, dir2, dir3, seq)\n"
    "Define from three vectors that define rotated axes directions plus an optional\n"
    "3-characher string of capital letters 'X', 'Y', 'Z' that sets the order of\n"
    "importance of the axes (e.g., 'ZXY' means z direction is followed strictly,\n"
    "x is used but corrected if necessary, y is ignored).\n"
    "dir1 : Base.Vector\n"
    "dir2 : Base.Vector\n"
    "dir3 : Base.Vector\n"
    "seq : str\n\n"
    "Rotation(matrix)\n"
    "Define from a matrix rotation in the 4D representation.\n"
    "matrix : Base.Matrix\n\n"
    "Rotation(*coef)\n"
    "Define from 16 or 9 elements which represent the rotation in the 4D matrix\n"
    "representation or in the 3D matrix representation, respectively.\n"
    "coef : sequence of float",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    Base::RotationPy::richCompare,      /*tp_richcompare*/
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Base::RotationPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Base::RotationPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Base::RotationPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of RotationPy
PyMethodDef RotationPy::Methods[] = {
    {"invert",
        reinterpret_cast<PyCFunction>( staticCallback_invert ),
        METH_VARARGS,
        "invert() -> None\n\nSets the rotation to its inverse."
    },
    {"inverted",
        reinterpret_cast<PyCFunction>( staticCallback_inverted ),
        METH_VARARGS,
        "inverted() -> Base.Rotation\n\nReturns the inverse of the rotation."
    },
    {"isSame",
        reinterpret_cast<PyCFunction>( staticCallback_isSame ),
        METH_VARARGS,
        "isSame(rotation, tol=0) -> bool\n\nChecks if `rotation` perform the same transformation as this rotation.\n\nrotation : Base.Rotation\ntol : float\n    Tolerance used to compare both rotations.\n    If tol is negative or zero, no tolerance is used."
    },
    {"multiply",
        reinterpret_cast<PyCFunction>( staticCallback_multiply ),
        METH_VARARGS,
        "multiply(rotation) -> Base.Rotation\n\nRight multiply this rotation with another rotation.\n\nrotation : Base.Rotation\n    Rotation by which to multiply this rotation."
    },
    {"multVec",
        reinterpret_cast<PyCFunction>( staticCallback_multVec ),
        METH_VARARGS,
        "multVec(vector) -> Base.Vector\n\nCompute the transformed vector using the rotation.\n\nvector : Base.Vector\n    Vector to be transformed."
    },
    {"slerp",
        reinterpret_cast<PyCFunction>( staticCallback_slerp ),
        METH_VARARGS,
        "slerp(rotation2, t) -> Base.Rotation\n\nSpherical Linear Interpolation (SLERP) of this rotation and `rotation2`.\n\nt : float\n    Parameter of the path. t=0 returns this rotation, t=1 returns `rotation2`."
    },
    {"setYawPitchRoll",
        reinterpret_cast<PyCFunction>( staticCallback_setYawPitchRoll ),
        METH_VARARGS,
        "setYawPitchRoll(angle1, angle2, angle3) -> None\n\nSet the Euler angles of this rotation as yaw-pitch-roll in XY'Z'' convention.\n\nangle1 : float\n    Angle around yaw axis in degrees.\nangle2 : float\n    Angle around pitch axis in degrees.\nangle3 : float\n    Angle around roll axis in degrees."
    },
    {"getYawPitchRoll",
        reinterpret_cast<PyCFunction>( staticCallback_getYawPitchRoll ),
        METH_VARARGS,
        "getYawPitchRoll() -> tuple\n\nGet the Euler angles of this rotation as yaw-pitch-roll in XY'Z'' convention.\nThe angles are given in degrees."
    },
    {"setEulerAngles",
        reinterpret_cast<PyCFunction>( staticCallback_setEulerAngles ),
        METH_VARARGS,
        "setEulerAngles(seq, angle1, angle2, angle3) -> None\n\nSet the Euler angles in a given sequence for this rotation.\nThe angles must be given in degrees.\n\nseq : str\n    Euler sequence name. All possible values given by toEulerAngles().\nangle1 : float\nangle2 : float\nangle3 : float "
    },
    {"toEulerAngles",
        reinterpret_cast<PyCFunction>( staticCallback_toEulerAngles ),
        METH_VARARGS,
        "toEulerAngles(seq) -> list\n\nGet the Euler angles in a given sequence for this rotation.\n\nseq : str\n    Euler sequence name. If not given, the function returns\n    all possible values of `seq`. Optional."
    },
    {"toMatrix",
        reinterpret_cast<PyCFunction>( staticCallback_toMatrix ),
        METH_VARARGS,
        "toMatrix() -> Base.Matrix\n\nConvert the rotation to a 4D matrix representation."
    },
    {"isNull",
        reinterpret_cast<PyCFunction>( staticCallback_isNull ),
        METH_VARARGS,
        "isNull() -> bool\n\nReturns True if all values in the quaternion representation are zero."
    },
    {"isIdentity",
        reinterpret_cast<PyCFunction>( staticCallback_isIdentity ),
        METH_VARARGS,
        "isIdentity(tol=0) -> bool\n\nReturns True if the rotation equals the 4D identity matrix.\ntol : float\n    Tolerance used to check for identity.\n    If tol is negative or zero, no tolerance is used."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};

PyNumberMethods RotationPy::Number[] = { {
    number_add_handler,
    number_subtract_handler,
    number_multiply_handler,
    number_remainder_handler,
    number_divmod_handler,
    number_power_handler,
    number_negative_handler,
    number_positive_handler,
    number_absolute_handler,
    number_nonzero_handler,
    number_invert_handler,
    number_lshift_handler,
    number_rshift_handler,
    number_and_handler,
    number_xor_handler,
    number_or_handler,
    number_int_handler,
    nullptr,
    number_float_handler,
    nullptr,    /*nb_inplace_add*/
    nullptr,    /*nb_inplace_subtract*/
    nullptr,    /*nb_inplace_multiply*/
    nullptr,    /*nb_inplace_remainder*/
    nullptr,    /*nb_inplace_power*/
    nullptr,    /*nb_inplace_lshift*/
    nullptr,    /*nb_inplace_rshift*/
    nullptr,    /*nb_inplace_and*/
    nullptr,    /*nb_inplace_xor*/
    nullptr,    /*nb_inplace_or*/
    nullptr,    /*nb_floor_divide*/
    number_divide_handler,    /*nb_true_divide*/
    nullptr,    /*nb_inplace_floor_divide*/
    nullptr,    /*nb_inplace_true_divide*/
    nullptr     /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
   ,nullptr     /*nb_matrix_multiply*/
   ,nullptr     /*nb_inplace_matrix_multiply*/
#endif
} };


/// Attribute structure of RotationPy
PyGetSetDef RotationPy::GetterSetter[] = {
    {"Q",
        (getter) staticCallback_getQ,
        (setter) staticCallback_setQ,
        "The rotation elements (as quaternion).",
        nullptr
    },
    {"Axis",
        (getter) staticCallback_getAxis,
        (setter) staticCallback_setAxis,
        "The rotation axis of the quaternion.",
        nullptr
    },
    {"RawAxis",
        (getter) staticCallback_getRawAxis,
        (setter) staticCallback_setRawAxis,
        "The rotation axis without normalization.",
        nullptr
    },
    {"Angle",
        (getter) staticCallback_getAngle,
        (setter) staticCallback_setAngle,
        "The rotation angle of the quaternion.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// invert() callback and implementer
// PyObject*  RotationPy::invert(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_invert (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'invert' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->invert(args);
        if (ret != 0)
            static_cast<RotationPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// inverted() callback and implementer
// PyObject*  RotationPy::inverted(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_inverted (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'inverted' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->inverted(args);
        if (ret != 0)
            static_cast<RotationPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSame() callback and implementer
// PyObject*  RotationPy::isSame(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_isSame (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSame' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->isSame(args);
        if (ret != 0)
            static_cast<RotationPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multiply() callback and implementer
// PyObject*  RotationPy::multiply(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_multiply (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multiply' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->multiply(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multVec() callback and implementer
// PyObject*  RotationPy::multVec(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_multVec (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multVec' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->multVec(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// slerp() callback and implementer
// PyObject*  RotationPy::slerp(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_slerp (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'slerp' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->slerp(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setYawPitchRoll() callback and implementer
// PyObject*  RotationPy::setYawPitchRoll(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_setYawPitchRoll (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setYawPitchRoll' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->setYawPitchRoll(args);
        if (ret != 0)
            static_cast<RotationPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getYawPitchRoll() callback and implementer
// PyObject*  RotationPy::getYawPitchRoll(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_getYawPitchRoll (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getYawPitchRoll' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->getYawPitchRoll(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setEulerAngles() callback and implementer
// PyObject*  RotationPy::setEulerAngles(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_setEulerAngles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setEulerAngles' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->setEulerAngles(args);
        if (ret != 0)
            static_cast<RotationPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toEulerAngles() callback and implementer
// PyObject*  RotationPy::toEulerAngles(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_toEulerAngles (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toEulerAngles' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->toEulerAngles(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toMatrix() callback and implementer
// PyObject*  RotationPy::toMatrix(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_toMatrix (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toMatrix' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->toMatrix(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isNull() callback and implementer
// PyObject*  RotationPy::isNull(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_isNull (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isNull' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->isNull(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isIdentity() callback and implementer
// PyObject*  RotationPy::isIdentity(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_isIdentity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isIdentity' of 'Base.Rotation' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<RotationPy*>(self)->isIdentity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Q() callback and implementer
// PyObject*  RotationPy::Q(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_getQ (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<RotationPy*>(self)->getQ());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Q' of object 'Rotation'");
        return nullptr;
    }
}

int RotationPy::staticCallback_setQ (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<RotationPy*>(self)->setQ(Py::Tuple(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Q' of object 'Rotation'");
        return -1;
    }
}

// Axis() callback and implementer
// PyObject*  RotationPy::Axis(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_getAxis (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<RotationPy*>(self)->getAxis());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Axis' of object 'Rotation'");
        return nullptr;
    }
}

int RotationPy::staticCallback_setAxis (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<RotationPy*>(self)->setAxis(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Axis' of object 'Rotation'");
        return -1;
    }
}

// RawAxis() callback and implementer
// PyObject*  RotationPy::RawAxis(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_getRawAxis (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<RotationPy*>(self)->getRawAxis());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'RawAxis' of object 'Rotation'");
        return nullptr;
    }
}

int RotationPy::staticCallback_setRawAxis (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'RawAxis' of object 'Rotation' is read-only");
    return -1;
}

// Angle() callback and implementer
// PyObject*  RotationPy::Angle(PyObject *args){};
// has to be implemented in RotationPyImp.cpp
PyObject * RotationPy::staticCallback_getAngle (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<RotationPy*>(self)->getAngle());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Angle' of object 'Rotation'");
        return nullptr;
    }
}

int RotationPy::staticCallback_setAngle (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<RotationPy*>(self)->setAngle(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Angle' of object 'Rotation'");
        return -1;
    }
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
RotationPy::RotationPy(Rotation *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
RotationPy::~RotationPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    RotationPy::PointerType ptr = static_cast<RotationPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// RotationPy representation
//--------------------------------------------------------------------------
PyObject *RotationPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// RotationPy Attributes
//--------------------------------------------------------------------------
PyObject *RotationPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int RotationPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

Rotation *RotationPy::getRotationPtr() const
{
    return static_cast<Rotation *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in RotationPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *RotationPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of RotationPy and the Twin object
    return new RotationPy(new Rotation);
}

// constructor method
int RotationPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string RotationPy::representation() const
{
    return std::string("<Rotation object>");
}

PyObject* RotationPy::invert(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::inverted(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::isSame(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::multiply(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::multVec(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::slerp(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::setYawPitchRoll(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::getYawPitchRoll(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::setEulerAngles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::toEulerAngles(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::toMatrix(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::isNull(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::isIdentity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* RotationPy::number_add_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* RotationPy::number_subtract_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* RotationPy::number_multiply_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_divide_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_remainder_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_divmod_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_power_handler (PyObject* /*self*/, PyObject* /*other*/, PyObject* /*modulo*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_negative_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_positive_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_absolute_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int RotationPy::number_nonzero_handler (PyObject* /*self*/)
{
    return 1;
}

PyObject * RotationPy::number_invert_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_lshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_rshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_and_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_xor_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_or_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int RotationPy::number_coerce_handler (PyObject** /*self*/, PyObject** /*other*/)
{
    return 1;
}

PyObject * RotationPy::number_int_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_long_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_float_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_oct_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * RotationPy::number_hex_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* RotationPy::richCompare(PyObject *v, PyObject *w, int op)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

Py::Tuple RotationPy::getQ() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

void  RotationPy::setQ(Py::Tuple arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object RotationPy::getAxis() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  RotationPy::setAxis(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object RotationPy::getRawAxis() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float RotationPy::getAngle() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  RotationPy::setAngle(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

PyObject *RotationPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int RotationPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



