
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in PlacementPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Base;

/// Type structure of PlacementPy
PyTypeObject PlacementPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Base.Placement",     /*tp_name*/
    sizeof(PlacementPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    Base::PlacementPy::Number,      /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Base.Placement class.\n\n"
    "A Placement defines an orientation (rotation) and a position (base) in 3D space.\n"
    "It is used when no scaling or other distortion is needed.\n\n"
    "The following constructors are supported:\n\n"
    "Placement()\n"
    "Empty constructor.\n\n"
    "Placement(placement)\n"
    "Copy constructor.\n"
    "placement : Base.Placement\n\n"
    "Placement(matrix)\n"
    "Define from a 4D matrix consisting of rotation and translation.\n"
    "matrix : Base.Matrix\n\n"
    "Placement(base, rotation)\n"
    "Define from position and rotation.\n"
    "base : Base.Vector\n"
    "rotation : Base.Rotation\n\n"
    "Placement(base, rotation, center)\n"
    "Define from position and rotation with center.\n"
    "base : Base.Vector\n"
    "rotation : Base.Rotation\n"
    "center : Base.Vector\n\n"
    "Placement(base, axis, angle)\n"
    "define position and rotation.\n"
    "base : Base.Vector\n"
    "axis : Base.Vector\n"
    "angle : float",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    Base::PlacementPy::richCompare,      /*tp_richcompare*/
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Base::PlacementPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Base::PlacementPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Base::PlacementPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of PlacementPy
PyMethodDef PlacementPy::Methods[] = {
    {"copy",
        reinterpret_cast<PyCFunction>( staticCallback_copy ),
        METH_VARARGS,
        "copy() -> Base.Placement\n\nReturns a copy of this placement."
    },
    {"move",
        reinterpret_cast<PyCFunction>( staticCallback_move ),
        METH_VARARGS,
        "move(vector) -> None\n\nMove the placement along a vector.\n\nvector : Base.Vector\n    Vector by which to move the placement."
    },
    {"translate",
        reinterpret_cast<PyCFunction>( staticCallback_translate ),
        METH_VARARGS,
        "translate(vector) -> None\n\nAlias to move(), to be compatible with TopoShape.translate().\n\nvector : Base.Vector\n    Vector by which to move the placement."
    },
    {"rotate",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) (void)>( staticCallback_rotate )),
        METH_VARARGS|METH_KEYWORDS,
        "rotate(center, axis, angle, comp) -> None\n\nRotate the current placement around center and axis with the given angle.\nThis method is compatible with TopoShape.rotate() if the (optional) keyword\nargument comp is True (default=False).\n\ncenter : Base.Vector, sequence of float\n    Rotation center.\naxis : Base.Vector, sequence of float\n    Rotation axis.\nangle : float\n    Rotation angle in degrees.\ncomp : bool\n    optional keyword only argument, if True (default=False),\nbehave like TopoShape.rotate() (i.e. the resulting placements are interchangeable).\n"
    },
    {"multiply",
        reinterpret_cast<PyCFunction>( staticCallback_multiply ),
        METH_VARARGS,
        "multiply(placement) -> Base.Placement\n\nRight multiply this placement with another placement.\nAlso available as `*` operator.\n\nplacement : Base.Placement\n    Placement by which to multiply this placement."
    },
    {"multVec",
        reinterpret_cast<PyCFunction>( staticCallback_multVec ),
        METH_VARARGS,
        "multVec(vector) -> Base.Vector\n\nCompute the transformed vector using the placement.\n\nvector : Base.Vector\n    Vector to be transformed."
    },
    {"toMatrix",
        reinterpret_cast<PyCFunction>( staticCallback_toMatrix ),
        METH_VARARGS,
        "toMatrix() -> Base.Matrix\n\nCompute the matrix representation of the placement."
    },
    {"inverse",
        reinterpret_cast<PyCFunction>( staticCallback_inverse ),
        METH_VARARGS,
        "inverse() -> Base.Placement\n\nCompute the inverse placement."
    },
    {"pow",
        reinterpret_cast<PyCFunction>( staticCallback_pow ),
        METH_VARARGS,
        "pow(t, shorten=True) -> Base.Placement\n\nRaise this placement to real power using ScLERP interpolation.\nAlso available as `**` operator.\n\nt : float\n    Real power.\nshorten : bool\n    If True, ensures rotation quaternion is net positive to make\n    the path shorter."
    },
    {"sclerp",
        reinterpret_cast<PyCFunction>( staticCallback_sclerp ),
        METH_VARARGS,
        "sclerp(placement2, t, shorten=True) -> Base.Placement\n\nScrew Linear Interpolation (ScLERP) between this placement and `placement2`.\nInterpolation is a continuous motion along a helical path parametrized by `t`\nmade of equal transforms if discretized.\nIf quaternions of rotations of the two placements differ in sign, the interpolation\nwill take a long path.\n\nplacement2 : Base.Placement\nt : float\n    Parameter of helical path. t=0 returns this placement, t=1 returns\n    `placement2`. t can also be outside of [0, 1] range for extrapolation.\nshorten : bool\n    If True, the signs are harmonized before interpolation and the interpolation\n    takes the shorter path."
    },
    {"slerp",
        reinterpret_cast<PyCFunction>( staticCallback_slerp ),
        METH_VARARGS,
        "slerp(placement2, t) -> Base.Placement\n\nSpherical Linear Interpolation (SLERP) between this placement and `placement2`.\nThis function performs independent interpolation of rotation and movement.\nResult of such interpolation might be not what application expects, thus this tool\nmight be considered for simple cases or for interpolating between small intervals.\nFor more complex cases you better use the advanced sclerp() function.\n\nplacement2 : Base.Placement\nt : float\n    Parameter of the path. t=0 returns this placement, t=1 returns `placement2`."
    },
    {"isIdentity",
        reinterpret_cast<PyCFunction>( staticCallback_isIdentity ),
        METH_VARARGS,
        "isIdentity([tol=0.0]) -> bool\n\nReturns True if the placement has no displacement and no rotation.\nMatrix representation is the 4D identity matrix.\ntol : float\n    Tolerance used to check for identity.\n    If tol is negative or zero, no tolerance is used."
    },
    {"isSame",
        reinterpret_cast<PyCFunction>( staticCallback_isSame ),
        METH_VARARGS,
        "isSame(Base.Placement, [tol=0.0]) -> bool\n\nChecks whether this and the given placement are the same.\nThe default tolerance is set to 0.0"
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};

PyNumberMethods PlacementPy::Number[] = { {
    number_add_handler,
    number_subtract_handler,
    number_multiply_handler,
    number_remainder_handler,
    number_divmod_handler,
    number_power_handler,
    number_negative_handler,
    number_positive_handler,
    number_absolute_handler,
    number_nonzero_handler,
    number_invert_handler,
    number_lshift_handler,
    number_rshift_handler,
    number_and_handler,
    number_xor_handler,
    number_or_handler,
    number_int_handler,
    nullptr,
    number_float_handler,
    nullptr,    /*nb_inplace_add*/
    nullptr,    /*nb_inplace_subtract*/
    nullptr,    /*nb_inplace_multiply*/
    nullptr,    /*nb_inplace_remainder*/
    nullptr,    /*nb_inplace_power*/
    nullptr,    /*nb_inplace_lshift*/
    nullptr,    /*nb_inplace_rshift*/
    nullptr,    /*nb_inplace_and*/
    nullptr,    /*nb_inplace_xor*/
    nullptr,    /*nb_inplace_or*/
    nullptr,    /*nb_floor_divide*/
    number_divide_handler,    /*nb_true_divide*/
    nullptr,    /*nb_inplace_floor_divide*/
    nullptr,    /*nb_inplace_true_divide*/
    nullptr     /*nb_index*/
#if PY_VERSION_HEX >= 0x03050000
   ,nullptr     /*nb_matrix_multiply*/
   ,nullptr     /*nb_inplace_matrix_multiply*/
#endif
} };


/// Attribute structure of PlacementPy
PyGetSetDef PlacementPy::GetterSetter[] = {
    {"Base",
        (getter) staticCallback_getBase,
        (setter) staticCallback_setBase,
        "Vector to the Base Position of the Placement.",
        nullptr
    },
    {"Rotation",
        (getter) staticCallback_getRotation,
        (setter) staticCallback_setRotation,
        "Orientation of the placement expressed as rotation.",
        nullptr
    },
    {"Matrix",
        (getter) staticCallback_getMatrix,
        (setter) staticCallback_setMatrix,
        "Set/get matrix representation of the placement.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// copy() callback and implementer
// PyObject*  PlacementPy::copy(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_copy (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'copy' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->copy(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// move() callback and implementer
// PyObject*  PlacementPy::move(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_move (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'move' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->move(args);
        if (ret != 0)
            static_cast<PlacementPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// translate() callback and implementer
// PyObject*  PlacementPy::translate(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_translate (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'translate' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->translate(args);
        if (ret != 0)
            static_cast<PlacementPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// rotate() callback and implementer
// PyObject*  PlacementPy::rotate(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_rotate (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'rotate' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->rotate(args, kwd);
        if (ret != 0)
            static_cast<PlacementPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multiply() callback and implementer
// PyObject*  PlacementPy::multiply(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_multiply (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multiply' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->multiply(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// multVec() callback and implementer
// PyObject*  PlacementPy::multVec(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_multVec (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'multVec' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->multVec(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// toMatrix() callback and implementer
// PyObject*  PlacementPy::toMatrix(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_toMatrix (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'toMatrix' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->toMatrix(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// inverse() callback and implementer
// PyObject*  PlacementPy::inverse(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_inverse (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'inverse' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->inverse(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// pow() callback and implementer
// PyObject*  PlacementPy::pow(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_pow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'pow' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->pow(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// sclerp() callback and implementer
// PyObject*  PlacementPy::sclerp(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_sclerp (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'sclerp' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->sclerp(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// slerp() callback and implementer
// PyObject*  PlacementPy::slerp(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_slerp (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'slerp' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->slerp(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isIdentity() callback and implementer
// PyObject*  PlacementPy::isIdentity(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_isIdentity (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isIdentity' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->isIdentity(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isSame() callback and implementer
// PyObject*  PlacementPy::isSame(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_isSame (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isSame' of 'Base.Placement' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }


    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<PlacementPy*>(self)->isSame(args);
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Base() callback and implementer
// PyObject*  PlacementPy::Base(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_getBase (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<PlacementPy*>(self)->getBase());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Base' of object 'Placement'");
        return nullptr;
    }
}

int PlacementPy::staticCallback_setBase (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<PlacementPy*>(self)->setBase(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Base' of object 'Placement'");
        return -1;
    }
}

// Rotation() callback and implementer
// PyObject*  PlacementPy::Rotation(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_getRotation (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<PlacementPy*>(self)->getRotation());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Rotation' of object 'Placement'");
        return nullptr;
    }
}

int PlacementPy::staticCallback_setRotation (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<PlacementPy*>(self)->setRotation(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Rotation' of object 'Placement'");
        return -1;
    }
}

// Matrix() callback and implementer
// PyObject*  PlacementPy::Matrix(PyObject *args){};
// has to be implemented in PlacementPyImp.cpp
PyObject * PlacementPy::staticCallback_getMatrix (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<PlacementPy*>(self)->getMatrix());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Matrix' of object 'Placement'");
        return nullptr;
    }
}

int PlacementPy::staticCallback_setMatrix (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<PlacementPy*>(self)->setMatrix(Py::Object(value,false));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Matrix' of object 'Placement'");
        return -1;
    }
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
PlacementPy::PlacementPy(Placement *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
PlacementPy::~PlacementPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    PlacementPy::PointerType ptr = static_cast<PlacementPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// PlacementPy representation
//--------------------------------------------------------------------------
PyObject *PlacementPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// PlacementPy Attributes
//--------------------------------------------------------------------------
PyObject *PlacementPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int PlacementPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

Placement *PlacementPy::getPlacementPtr() const
{
    return static_cast<Placement *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in PlacementPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *PlacementPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of PlacementPy and the Twin object
    return new PlacementPy(new Placement);
}

// constructor method
int PlacementPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string PlacementPy::representation() const
{
    return std::string("<Placement object>");
}

PyObject* PlacementPy::copy(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::move(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::translate(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::rotate(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::multiply(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::multVec(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::toMatrix(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::inverse(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::pow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::sclerp(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::slerp(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::isIdentity(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::isSame(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* PlacementPy::number_add_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* PlacementPy::number_subtract_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* PlacementPy::number_multiply_handler(PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_divide_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_remainder_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_divmod_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_power_handler (PyObject* /*self*/, PyObject* /*other*/, PyObject* /*modulo*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_negative_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_positive_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_absolute_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int PlacementPy::number_nonzero_handler (PyObject* /*self*/)
{
    return 1;
}

PyObject * PlacementPy::number_invert_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_lshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_rshift_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_and_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_xor_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_or_handler (PyObject* /*self*/, PyObject* /*other*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

int PlacementPy::number_coerce_handler (PyObject** /*self*/, PyObject** /*other*/)
{
    return 1;
}

PyObject * PlacementPy::number_int_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_long_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_float_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_oct_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject * PlacementPy::number_hex_handler (PyObject* /*self*/)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not implemented");
    return nullptr;
}

PyObject* PlacementPy::richCompare(PyObject *v, PyObject *w, int op)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

Py::Object PlacementPy::getBase() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  PlacementPy::setBase(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object PlacementPy::getRotation() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  PlacementPy::setRotation(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Object PlacementPy::getMatrix() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

void  PlacementPy::setMatrix(Py::Object arg)
{
    throw Py::AttributeError("Not yet implemented");
}

PyObject *PlacementPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int PlacementPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



