
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in BoundBoxPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Base;

/// Type structure of BoundBoxPy
PyTypeObject BoundBoxPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Base.BoundBox",     /*tp_name*/
    sizeof(BoundBoxPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Base.BoundBox class.\n\n"
    "This class represents a bounding box.\n"
    "A bounding box is a rectangular cuboid which is a way to describe outer\n"
    "boundaries and is obtained from a lot of 3D types.\n"
    "It is often used to check if a 3D entity lies in the range of another object.\n"
    "Checking for bounding interference first can save a lot of computing time!\n"
    "An invalid BoundBox is represented by inconsistent values at each direction:\n"
    "The maximum float value of the system at the minimum coordinates, and the\n"
    "opposite value at the maximum coordinates.\n\n"
    "The following constructors are supported:\n\n"
    "BoundBox()\n"
    "Empty constructor. Returns an invalid BoundBox.\n\n"
    "BoundBox(boundBox)\n"
    "Copy constructor.\n"
    "boundBox : Base.BoundBox\n\n"
    "BoundBox(xMin, yMin=0, zMin=0, xMax=0, yMax=0, zMax=0)\n"
    "Define from the minimum and maximum values at each direction.\n"
    "xMin : float\n    Minimum value at x-coordinate.\n"
    "yMin : float\n    Minimum value at y-coordinate.\n"
    "zMin : float\n    Minimum value at z-coordinate.\n"
    "xMax : float\n    Maximum value at x-coordinate.\n"
    "yMax : float\n    Maximum value at y-coordinate.\n"
    "zMax : float\n    Maximum value at z-coordinate.\n\n"
    "App.BoundBox(min, max)\n"
    "Define from two containers representing the minimum and maximum values of the\n"
    "coordinates in each direction.\n"
    "min : Base.Vector, tuple\n    Minimum values of the coordinates.\n"
    "max : Base.Vector, tuple\n    Maximum values of the coordinates.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Base::BoundBoxPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Base::BoundBoxPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Base::BoundBoxPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of BoundBoxPy
PyMethodDef BoundBoxPy::Methods[] = {
    {"setVoid",
        reinterpret_cast<PyCFunction>( staticCallback_setVoid ),
        METH_VARARGS,
        "setVoid() -> None\n\nInvalidate the bounding box."
    },
    {"isValid",
        reinterpret_cast<PyCFunction>( staticCallback_isValid ),
        METH_VARARGS,
        "isValid() -> bool\n\nChecks if the bounding box is valid."
    },
    {"add",
        reinterpret_cast<PyCFunction>( staticCallback_add ),
        METH_VARARGS,
        "add(minMax) -> None\nadd(x, y, z) -> None\n\nIncrease the maximum values or decrease the minimum values of this BoundBox by\nreplacing the current values with the given values, so the bounding box can grow\nbut not shrink.\n\nminMax : Base.Vector, tuple\n    Values to enlarge at each direction.\nx : float\n    Value to enlarge at x-direction.\ny : float\n    Value to enlarge at y-direction.\nz : float\n    Value to enlarge at z-direction."
    },
    {"getPoint",
        reinterpret_cast<PyCFunction>( staticCallback_getPoint ),
        METH_VARARGS,
        "getPoint(index) ->Base.Vector\n\nGet the point of the given index.\nThe index must be in the range of [0, 7].\n\nindex : int"
    },
    {"getEdge",
        reinterpret_cast<PyCFunction>( staticCallback_getEdge ),
        METH_VARARGS,
        "getEdge(index) -> tuple of Base.Vector\n\nGet the edge points of the given index.\nThe index must be in the range of [0, 11].\n\nindex : int"
    },
    {"closestPoint",
        reinterpret_cast<PyCFunction>( staticCallback_closestPoint ),
        METH_VARARGS,
        "closestPoint(point) -> Base.Vector\nclosestPoint(x, y, z) -> Base.Vector\n\nGet the closest point of the bounding box to the given point.\n\npoint : Base.Vector, tuple\n    Coordinates of the given point.\nx : float\n    X-coordinate of the given point.\ny : float\n    Y-coordinate of the given point.\nz : float\n    Z-coordinate of the given point."
    },
    {"intersect",
        reinterpret_cast<PyCFunction>( staticCallback_intersect ),
        METH_VARARGS,
        "intersect(boundBox2) -> bool\nintersect(base, dir) -> bool\n\nChecks if the given object intersects with this bounding box. That can be\nanother bounding box or a line specified by base and direction.\n\nboundBox2 : Base.BoundBox\nbase : Base.Vector, tuple\ndir : Base.Vector, tuple"
    },
    {"intersected",
        reinterpret_cast<PyCFunction>( staticCallback_intersected ),
        METH_VARARGS,
        "intersected(boundBox2) -> Base.BoundBox\n\nReturns the intersection of this and the given bounding box.\n\nboundBox2 : Base.BoundBox"
    },
    {"united",
        reinterpret_cast<PyCFunction>( staticCallback_united ),
        METH_VARARGS,
        "united(boundBox2) -> Base.BoundBox\n\nReturns the union of this and the given bounding box.\n\nboundBox2 : Base.BoundBox"
    },
    {"enlarge",
        reinterpret_cast<PyCFunction>( staticCallback_enlarge ),
        METH_VARARGS,
        "enlarge(variation) -> None\n\nDecrease the minimum values and increase the maximum values by the given value.\nA negative value shrinks the bounding box.\n\nvariation : float"
    },
    {"getIntersectionPoint",
        reinterpret_cast<PyCFunction>( staticCallback_getIntersectionPoint ),
        METH_VARARGS,
        "getIntersectionPoint(base, dir, epsilon=0.0001) -> Base.Vector\n\nCalculate the intersection point of a line with the bounding box.\nThe base point must lie inside the bounding box, if not an exception is thrown.\n\nbase : Base.Vector\n    Base point of the line.\ndir : Base.Vector\n    Direction of the line.\nepsilon : float\n    Bounding box size tolerance."
    },
    {"move",
        reinterpret_cast<PyCFunction>( staticCallback_move ),
        METH_VARARGS,
        "move(displacement) -> None\nmove(x, y, z) -> None\n\nMove the bounding box by the given values.\n\ndisplacement : Base.Vector, tuple\n    Displacement at each direction.\nx : float\n    Displacement at x-direction.\ny : float\n    Displacement at y-direction.\nz : float\n    Displacement at z-direction."
    },
    {"scale",
        reinterpret_cast<PyCFunction>( staticCallback_scale ),
        METH_VARARGS,
        "scale(factor) -> None\nscale(x, y, z) -> None\n\nScale the bounding box by the given values.\n\nfactor : Base.Vector, tuple\n    Factor scale at each direction.\nx : float\n    Scale at x-direction.\ny : float\n    Scale at y-direction.\nz : float\n    Scale at z-direction."
    },
    {"transformed",
        reinterpret_cast<PyCFunction>( staticCallback_transformed ),
        METH_VARARGS,
        "transformed(matrix) -> Base.BoundBox\n\nReturns a new BoundBox containing the transformed rectangular cuboid\nrepresented by this BoundBox.\n\nmatrix : Base.Matrix\n    Transformation matrix."
    },
    {"isCutPlane",
        reinterpret_cast<PyCFunction>( staticCallback_isCutPlane ),
        METH_VARARGS,
        "isCutPlane(base, normal) -> bool\n\nCheck if the plane specified by base and normal intersects (cuts) this bounding\nbox.\n\nbase : Base.Vector\nnormal : Base.Vector"
    },
    {"isInside",
        reinterpret_cast<PyCFunction>( staticCallback_isInside ),
        METH_VARARGS,
        "isInside(object) -> bool\nisInside(x, y, z) -> bool\n\nCheck if a point or a bounding box is inside this bounding box.\n\nobject : Base.Vector, Base.BoundBox\n    Object to check if it is inside this bounding box.\nx : float\n    X-coordinate of the point to check.\ny : float\n    Y-coordinate of the point to check.\nz : float\n    Z-coordinate of the point to check."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of BoundBoxPy
PyGetSetDef BoundBoxPy::GetterSetter[] = {
    {"Center",
        (getter) staticCallback_getCenter,
        (setter) staticCallback_setCenter,
        "Center point of the bounding box.",
        nullptr
    },
    {"XMax",
        (getter) staticCallback_getXMax,
        (setter) staticCallback_setXMax,
        "The maximum x boundary position.",
        nullptr
    },
    {"YMax",
        (getter) staticCallback_getYMax,
        (setter) staticCallback_setYMax,
        "The maximum y boundary position.",
        nullptr
    },
    {"ZMax",
        (getter) staticCallback_getZMax,
        (setter) staticCallback_setZMax,
        "The maximum z boundary position.",
        nullptr
    },
    {"XMin",
        (getter) staticCallback_getXMin,
        (setter) staticCallback_setXMin,
        "The minimum x boundary position.",
        nullptr
    },
    {"YMin",
        (getter) staticCallback_getYMin,
        (setter) staticCallback_setYMin,
        "The minimum y boundary position.",
        nullptr
    },
    {"ZMin",
        (getter) staticCallback_getZMin,
        (setter) staticCallback_setZMin,
        "The minimum z boundary position.",
        nullptr
    },
    {"XLength",
        (getter) staticCallback_getXLength,
        (setter) staticCallback_setXLength,
        "Length of the bounding box in x direction.",
        nullptr
    },
    {"YLength",
        (getter) staticCallback_getYLength,
        (setter) staticCallback_setYLength,
        "Length of the bounding box in y direction.",
        nullptr
    },
    {"ZLength",
        (getter) staticCallback_getZLength,
        (setter) staticCallback_setZLength,
        "Length of the bounding box in z direction.",
        nullptr
    },
    {"DiagonalLength",
        (getter) staticCallback_getDiagonalLength,
        (setter) staticCallback_setDiagonalLength,
        "Diagonal length of the bounding box.",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// setVoid() callback and implementer
// PyObject*  BoundBoxPy::setVoid(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_setVoid (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setVoid' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->setVoid(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isValid() callback and implementer
// PyObject*  BoundBoxPy::isValid(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_isValid (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isValid' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->isValid(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// add() callback and implementer
// PyObject*  BoundBoxPy::add(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_add (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'add' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->add(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getPoint() callback and implementer
// PyObject*  BoundBoxPy::getPoint(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getPoint' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->getPoint(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getEdge() callback and implementer
// PyObject*  BoundBoxPy::getEdge(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getEdge (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getEdge' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->getEdge(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// closestPoint() callback and implementer
// PyObject*  BoundBoxPy::closestPoint(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_closestPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'closestPoint' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->closestPoint(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// intersect() callback and implementer
// PyObject*  BoundBoxPy::intersect(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_intersect (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'intersect' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->intersect(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// intersected() callback and implementer
// PyObject*  BoundBoxPy::intersected(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_intersected (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'intersected' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->intersected(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// united() callback and implementer
// PyObject*  BoundBoxPy::united(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_united (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'united' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->united(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// enlarge() callback and implementer
// PyObject*  BoundBoxPy::enlarge(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_enlarge (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'enlarge' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->enlarge(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getIntersectionPoint() callback and implementer
// PyObject*  BoundBoxPy::getIntersectionPoint(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getIntersectionPoint (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getIntersectionPoint' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->getIntersectionPoint(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// move() callback and implementer
// PyObject*  BoundBoxPy::move(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_move (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'move' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->move(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// scale() callback and implementer
// PyObject*  BoundBoxPy::scale(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_scale (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'scale' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->scale(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// transformed() callback and implementer
// PyObject*  BoundBoxPy::transformed(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_transformed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'transformed' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->transformed(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isCutPlane() callback and implementer
// PyObject*  BoundBoxPy::isCutPlane(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_isCutPlane (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isCutPlane' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->isCutPlane(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isInside() callback and implementer
// PyObject*  BoundBoxPy::isInside(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_isInside (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isInside' of 'Base.BoundBox' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<BoundBoxPy*>(self)->isInside(args);
        if (ret != 0)
            static_cast<BoundBoxPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Center() callback and implementer
// PyObject*  BoundBoxPy::Center(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getCenter (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getCenter());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Center' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setCenter (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Center' of object 'BoundBox' is read-only");
    return -1;
}

// XMax() callback and implementer
// PyObject*  BoundBoxPy::XMax(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getXMax (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getXMax());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'XMax' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setXMax (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setXMax(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'XMax' of object 'BoundBox'");
        return -1;
    }
}

// YMax() callback and implementer
// PyObject*  BoundBoxPy::YMax(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getYMax (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getYMax());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'YMax' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setYMax (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setYMax(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'YMax' of object 'BoundBox'");
        return -1;
    }
}

// ZMax() callback and implementer
// PyObject*  BoundBoxPy::ZMax(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getZMax (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getZMax());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ZMax' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setZMax (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setZMax(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'ZMax' of object 'BoundBox'");
        return -1;
    }
}

// XMin() callback and implementer
// PyObject*  BoundBoxPy::XMin(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getXMin (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getXMin());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'XMin' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setXMin (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setXMin(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'XMin' of object 'BoundBox'");
        return -1;
    }
}

// YMin() callback and implementer
// PyObject*  BoundBoxPy::YMin(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getYMin (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getYMin());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'YMin' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setYMin (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setYMin(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'YMin' of object 'BoundBox'");
        return -1;
    }
}

// ZMin() callback and implementer
// PyObject*  BoundBoxPy::ZMin(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getZMin (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getZMin());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ZMin' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setZMin (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<BoundBoxPy*>(self)->setZMin(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'ZMin' of object 'BoundBox'");
        return -1;
    }
}

// XLength() callback and implementer
// PyObject*  BoundBoxPy::XLength(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getXLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getXLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'XLength' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setXLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'XLength' of object 'BoundBox' is read-only");
    return -1;
}

// YLength() callback and implementer
// PyObject*  BoundBoxPy::YLength(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getYLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getYLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'YLength' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setYLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'YLength' of object 'BoundBox' is read-only");
    return -1;
}

// ZLength() callback and implementer
// PyObject*  BoundBoxPy::ZLength(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getZLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getZLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'ZLength' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setZLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'ZLength' of object 'BoundBox' is read-only");
    return -1;
}

// DiagonalLength() callback and implementer
// PyObject*  BoundBoxPy::DiagonalLength(PyObject *args){};
// has to be implemented in BoundBoxPyImp.cpp
PyObject * BoundBoxPy::staticCallback_getDiagonalLength (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<BoundBoxPy*>(self)->getDiagonalLength());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'DiagonalLength' of object 'BoundBox'");
        return nullptr;
    }
}

int BoundBoxPy::staticCallback_setDiagonalLength (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'DiagonalLength' of object 'BoundBox' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
BoundBoxPy::BoundBoxPy(BoundBox3d *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
BoundBoxPy::~BoundBoxPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    BoundBoxPy::PointerType ptr = static_cast<BoundBoxPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// BoundBoxPy representation
//--------------------------------------------------------------------------
PyObject *BoundBoxPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// BoundBoxPy Attributes
//--------------------------------------------------------------------------
PyObject *BoundBoxPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int BoundBoxPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

BoundBox3d *BoundBoxPy::getBoundBoxPtr() const
{
    return static_cast<BoundBox3d *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in BoundBoxPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *BoundBoxPy::PyMake(struct _typeobject *, PyObject *, PyObject *)  // Python wrapper
{
    // create a new instance of BoundBoxPy and the Twin object
    return new BoundBoxPy(new BoundBox3d);
}

// constructor method
int BoundBoxPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string BoundBoxPy::representation() const
{
    return std::string("<BoundBox object>");
}

PyObject* BoundBoxPy::setVoid(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::isValid(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::add(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::getPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::getEdge(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::closestPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::intersect(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::intersected(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::united(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::enlarge(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::getIntersectionPoint(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::move(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::scale(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::transformed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::isCutPlane(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* BoundBoxPy::isInside(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Object BoundBoxPy::getCenter() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getXMax() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setXMax(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getYMax() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setYMax(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getZMax() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setZMax(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getXMin() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setXMin(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getYMin() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setYMin(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getZMin() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  BoundBoxPy::setZMin(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getXLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getYLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getZLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float BoundBoxPy::getDiagonalLength() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *BoundBoxPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int BoundBoxPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



