const char FreeCADInit[] ="#***************************************************************************\n"
"#*   Copyright (c) 2001,2002 Jürgen Riegel <juergen.riegel@web.de>         *\n"
"#*                                                                         *\n"
"#*   This file is part of the FreeCAD CAx development system.              *\n"
"#*                                                                         *\n"
"#*   This program is free software  you can redistribute it and/or modify  *\n"
"#*   it under the terms of the GNU Lesser General Public License (LGPL)    *\n"
"#*   as published by the Free Software Foundation  either version 2 of     *\n"
"#*   the License, or (at your option) any later version.                   *\n"
"#*   for detail see the LICENCE text file.                                 *\n"
"#*                                                                         *\n"
"#*   FreeCAD is distributed in the hope that it will be useful,            *\n"
"#*   but WITHOUT ANY WARRANTY  without even the implied warranty of        *\n"
"#*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
"#*   GNU Lesser General Public License for more details.                   *\n"
"#*                                                                         *\n"
"#*   You should have received a copy of the GNU Library General Public     *\n"
"#*   License along with FreeCAD  if not, write to the Free Software        *\n"
"#*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *\n"
"#*   USA                                                                   *\n"
"#*                                                                         *\n"
"#***************************************************************************/\n"
"\n"
"# FreeCAD init module\n"
"#\n"
"# Gathering all the information to start FreeCAD.\n"
"# This is the second of three init scripts.\n"
"# The third one runs when the gui is up,\n"
"\n"
"# imports the one and only\n"
"import FreeCAD\n"
"\n"
"def removeFromPath(module_name):\n"
"    \"\"\"removes the module from the sys.path. The entry point for imports\n"
"        will therefore always be FreeCAD.\n"
"        eg.: from FreeCAD.Module.submodule import function\"\"\"\n"
"    import sys\n"
"    paths = sys.path\n"
"    for path in paths:\n"
"        if module_name in path:\n"
"            sys.path.remove(path)\n"
"            return\n"
"    Wrn(module_name + \" not found in sys.path\\n\")\n"
"\n"
"def setupSearchPaths(PathExtension):\n"
"    # DLL resolution in Python 3.8 on Windows has changed\n"
"    import sys\n"
"    if sys.platform == \'win32\' and hasattr(os, \"add_dll_directory\"):\n"
"        if \"FREECAD_LIBPACK_BIN\" in os.environ:\n"
"            os.add_dll_directory(os.environ[\"FREECAD_LIBPACK_BIN\"])\n"
"        if \"WINDIR\" in os.environ:\n"
"            os.add_dll_directory(os.environ[\"WINDIR\"] + os.sep + \"system32\")\n"
"        for path in PathExtension:\n"
"            os.add_dll_directory(path)\n"
"\n"
"    PathEnvironment = PathExtension.pop(0) + os.pathsep\n"
"    for path in PathExtension:\n"
"        try:\n"
"            PathEnvironment += path + os.pathsep\n"
"        except UnicodeDecodeError:\n"
"            Wrn(\'Filter invalid module path: u{}\\n\'.format(repr(path)))\n"
"\n"
"    # new paths must be prepended to avoid to load a wrong version of a library\n"
"    try:\n"
"        os.environ[\"PATH\"] = PathEnvironment + os.environ[\"PATH\"]\n"
"    except UnicodeEncodeError:\n"
"        Log(\'UnicodeEncodeError was raised when concatenating unicode string with PATH. Try to replace non-ascii chars...\\n\')\n"
"        os.environ[\"PATH\"] = PathEnvironment.encode(errors=\'replace\') + os.environ[\"PATH\"]\n"
"        Log(\'done\\n\')\n"
"    except KeyError:\n"
"        os.environ[\"PATH\"] = PathEnvironment\n"
"\n"
"FreeCAD._importFromFreeCAD = removeFromPath\n"
"\n"
"\n"
"def InitApplications():\n"
"    # Checking on FreeCAD module path ++++++++++++++++++++++++++++++++++++++++++\n"
"    ModDir = FreeCAD.getHomePath()+\'Mod\'\n"
"    ModDir = os.path.realpath(ModDir)\n"
"    ExtDir = FreeCAD.getHomePath()+\'Ext\'\n"
"    ExtDir = os.path.realpath(ExtDir)\n"
"    BinDir = FreeCAD.getHomePath()+\'bin\'\n"
"    BinDir = os.path.realpath(BinDir)\n"
"    libpaths = []\n"
"    LibDir = FreeCAD.getHomePath()+\'lib\'\n"
"    LibDir = os.path.realpath(LibDir)\n"
"    if os.path.exists(LibDir):\n"
"        libpaths.append(LibDir)\n"
"    Lib64Dir = FreeCAD.getHomePath()+\'lib64\'\n"
"    Lib64Dir = os.path.realpath(Lib64Dir)\n"
"    if os.path.exists(Lib64Dir):\n"
"        libpaths.append(Lib64Dir)\n"
"    LibPyDir = FreeCAD.getHomePath()+\'lib-py3\'\n"
"    LibPyDir = os.path.realpath(LibPyDir)\n"
"    if (os.path.exists(LibPyDir)):\n"
"        libpaths.append(LibPyDir)\n"
"    LibFcDir = FreeCAD.getLibraryDir()\n"
"    LibFcDir = os.path.realpath(LibFcDir)\n"
"    if (os.path.exists(LibFcDir) and not LibFcDir in libpaths):\n"
"        libpaths.append(LibFcDir)\n"
"    AddPath = FreeCAD.ConfigGet(\"AdditionalModulePaths\").split(\";\")\n"
"    HomeMod = FreeCAD.getUserAppDataDir()+\"Mod\"\n"
"    HomeMod = os.path.realpath(HomeMod)\n"
"    MacroStd = App.getUserMacroDir(False)\n"
"    MacroDir = App.getUserMacroDir(True)\n"
"    MacroMod = os.path.realpath(MacroDir+\"/Mod\")\n"
"    SystemWideMacroDir = FreeCAD.getHomePath()+\'Macro\'\n"
"    SystemWideMacroDir = os.path.realpath(SystemWideMacroDir)\n"
"\n"
"    #print FreeCAD.getHomePath()\n"
"    if os.path.isdir(FreeCAD.getHomePath()+\'src\\\\Tools\'):\n"
"        sys.path.append(FreeCAD.getHomePath()+\'src\\\\Tools\')\n"
"\n"
"\n"
"\n"
"    # Searching for module dirs +++++++++++++++++++++++++++++++++++++++++++++++++++\n"
"    # Use dict to handle duplicated module names\n"
"    ModDict = {}\n"
"    if os.path.isdir(ModDir):\n"
"        ModDirs = os.listdir(ModDir)\n"
"        for i in ModDirs: ModDict[i.lower()] = os.path.join(ModDir,i)\n"
"    else:\n"
"        Wrn (\"No modules found in \" + ModDir + \"\\n\")\n"
"    # Search for additional modules in the home directory\n"
"    if os.path.isdir(HomeMod):\n"
"        HomeMods = os.listdir(HomeMod)\n"
"        for i in HomeMods: ModDict[i.lower()] = os.path.join(HomeMod,i)\n"
"    elif os.path.isdir(os.path.join(os.path.expanduser(\"~\"),\".FreeCAD\",\"Mod\")):\n"
"        # Check if old location exists\n"
"        Wrn (\"User path has changed to \" + FreeCAD.getUserAppDataDir() + \". Please move user modules and macros\\n\")\n"
"    # Search for additional modules in the macro directory\n"
"    if os.path.isdir(MacroMod):\n"
"        MacroMods = os.listdir(MacroMod)\n"
"        for i in MacroMods:\n"
"            key = i.lower()\n"
"            if key not in ModDict: ModDict[key] = os.path.join(MacroMod,i)\n"
"    # Search for additional modules in command line\n"
"    for i in AddPath:\n"
"        if os.path.isdir(i): ModDict[i] = i\n"
"    #AddModPaths = App.ParamGet(\"System parameter:AdditionalModulePaths\")\n"
"    #Err( AddModPaths)\n"
"    # add also this path so that all modules search for libraries\n"
"    # they depend on first here\n"
"    PathExtension = []\n"
"    PathExtension.append(BinDir)\n"
"\n"
"    # prepend all module paths to Python search path\n"
"    Log(\'Init:   Searching for modules...\\n\')\n"
"\n"
"\n"
"    # to have all the module-paths available in FreeCADGuiInit.py:\n"
"    FreeCAD.__ModDirs__ = list(ModDict.values())\n"
"\n"
"    # this allows importing with:\n"
"    # from FreeCAD.Module import package\n"
"    FreeCAD.__path__ = [ModDir] + libpaths + [HomeMod]\n"
"\n"
"    # also add these directories to the sys.path to\n"
"    # not change the old behaviour. once we have moved to\n"
"    # proper python modules this can eventually be removed.\n"
"    sys.path = [ModDir] + libpaths + [ExtDir] + sys.path\n"
"\n"
"    # The AddonManager may install additional Python packages in\n"
"    # these paths:\n"
"    import platform\n"
"    major,minor,_ = platform.python_version_tuple()\n"
"    vendor_path = os.path.join(\n"
"        FreeCAD.getUserAppDataDir(), \"AdditionalPythonPackages\",f\"py{major}{minor}\"\n"
"    )\n"
"    if os.path.isdir(vendor_path):\n"
"        sys.path.append(vendor_path)\n"
"\n"
"    additional_packages_path = os.path.join(FreeCAD.getUserAppDataDir(),\"AdditionalPythonPackages\")\n"
"    if os.path.isdir(additional_packages_path):\n"
"        sys.path.append(additional_packages_path)\n"
"\n"
"    def RunInitPy(Dir):\n"
"        InstallFile = os.path.join(Dir,\"Init.py\")\n"
"        if (os.path.exists(InstallFile)):\n"
"            try:\n"
"                with open(file=InstallFile, encoding=\"utf-8\") as f:\n"
"                    exec(f.read())\n"
"            except Exception as inst:\n"
"                Log(\'Init:      Initializing \' + Dir + \'... failed\\n\')\n"
"                Log(\'-\'*100+\'\\n\')\n"
"                Log(traceback.format_exc())\n"
"                Log(\'-\'*100+\'\\n\')\n"
"                Err(\'During initialization the error \"\' + str(inst) + \'\" occurred in \' + InstallFile + \'\\n\')\n"
"                Err(\'Please look into the log file for further information\\n\')\n"
"            else:\n"
"                Log(\'Init:      Initializing \' + Dir + \'... done\\n\')\n"
"        else:\n"
"            Log(\'Init:      Initializing \' + Dir + \'(Init.py not found)... ignore\\n\')\n"
"\n"
"    def processMetadataFile(MetadataFile):\n"
"        meta = FreeCAD.Metadata(MetadataFile)\n"
"        if not meta.supportsCurrentFreeCAD():\n"
"            Msg(f\'NOTICE: {meta.Name} does not support this version of FreeCAD, so is being skipped\\n\')\n"
"            return None\n"
"        content = meta.Content\n"
"        if \"workbench\" in content:\n"
"            workbenches = content[\"workbench\"]\n"
"            for workbench in workbenches:\n"
"                if not workbench.supportsCurrentFreeCAD():\n"
"                    Msg(f\'NOTICE: {meta.Name} content item {workbench.Name} does not support this version of FreeCAD, so is being skipped\\n\')\n"
"                    return None\n"
"                subdirectory = workbench.Name if not workbench.Subdirectory else workbench.Subdirectory\n"
"                subdirectory = subdirectory.replace(\"/\",os.path.sep)\n"
"                subdirectory = os.path.join(Dir, subdirectory)\n"
"                #classname = workbench.Classname\n"
"                sys.path.insert(0,subdirectory)\n"
"                PathExtension.append(subdirectory)\n"
"                RunInitPy(subdirectory)\n"
"\n"
"    def tryProcessMetadataFile(MetadataFile):\n"
"        try:\n"
"            processMetadataFile(MetadataFile)\n"
"        except Exception as exc:\n"
"            Err(str(exc))\n"
"\n"
"    for Dir in ModDict.values():\n"
"        if ((Dir != \'\') & (Dir != \'CVS\') & (Dir != \'__init__.py\')):\n"
"            stopFile = os.path.join(Dir, \"ADDON_DISABLED\")\n"
"            if os.path.exists(stopFile):\n"
"                Msg(f\'NOTICE: Addon \"{Dir}\" disabled by presence of ADDON_DISABLED stopfile\\n\')\n"
"                continue\n"
"            sys.path.insert(0,Dir)\n"
"            PathExtension.append(Dir)\n"
"            MetadataFile = os.path.join(Dir, \"package.xml\")\n"
"            if os.path.exists(MetadataFile):\n"
"                tryProcessMetadataFile(MetadataFile)\n"
"            else:\n"
"                RunInitPy(Dir)\n"
"\n"
"    extension_modules = []\n"
"\n"
"    try:\n"
"        import pkgutil\n"
"        import importlib\n"
"        import freecad\n"
"        for _, freecad_module_name, freecad_module_ispkg in pkgutil.iter_modules(freecad.__path__, \"freecad.\"):\n"
"            if freecad_module_ispkg:\n"
"                Log(\'Init: Initializing \' + freecad_module_name + \'\\n\')\n"
"                try:\n"
"                    # Check for a stopfile\n"
"                    stopFile = os.path.join(FreeCAD.getUserAppDataDir(), \"Mod\", freecad_module_name[8:], \"ADDON_DISABLED\")\n"
"                    if os.path.exists(stopFile):\n"
"                        Msg(f\'NOTICE: Addon \"{freecad_module_name}\" disabled by presence of ADDON_DISABLED stopfile\\n\')\n"
"                        continue\n"
"\n"
"                    # Make sure that package.xml (if present) does not exclude this version of FreeCAD\n"
"                    MetadataFile = os.path.join(FreeCAD.getUserAppDataDir(), \"Mod\", freecad_module_name[8:], \"package.xml\")\n"
"                    if os.path.exists(MetadataFile):\n"
"                        meta = FreeCAD.Metadata(MetadataFile)\n"
"                        if not meta.supportsCurrentFreeCAD():\n"
"                            Msg(f\'NOTICE: Addon \"{freecad_module_name}\" does not support this version of FreeCAD, so is being skipped\\n\')\n"
"                            continue\n"
"\n"
"                    freecad_module = importlib.import_module(freecad_module_name)\n"
"                    extension_modules += [freecad_module_name]\n"
"                    if any (module_name == \'init\' for _, module_name, ispkg in pkgutil.iter_modules(freecad_module.__path__)):\n"
"                        importlib.import_module(freecad_module_name + \'.init\')\n"
"                        Log(\'Init: Initializing \' + freecad_module_name + \'... done\\n\')\n"
"                    else:\n"
"                        Log(\'Init: No init module found in \' + freecad_module_name + \', skipping\\n\')\n"
"                except Exception as inst:\n"
"                    Err(\'During initialization the error \"\' + str(inst) + \'\" occurred in \' + freecad_module_name + \'\\n\')\n"
"                    Err(\'-\'*80+\'\\n\')\n"
"                    Err(traceback.format_exc())\n"
"                    Err(\'-\'*80+\'\\n\')\n"
"                    Log(\'Init:      Initializing \' + freecad_module_name + \'... failed\\n\')\n"
"                    Log(\'-\'*80+\'\\n\')\n"
"                    Log(traceback.format_exc())\n"
"                    Log(\'-\'*80+\'\\n\')\n"
"    except ImportError as inst:\n"
"        Err(\'During initialization the error \"\' + str(inst) + \'\" occurred\\n\')\n"
"\n"
"    Log(\"Using \"+ModDir+\" as module path!\\n\")\n"
"    # In certain cases the PathExtension list can contain invalid strings. We concatenate them to a single string\n"
"    # but check that the output is a valid string\n"
"    setupSearchPaths(PathExtension)\n"
"    path = os.environ[\"PATH\"].split(os.pathsep)\n"
"    Log(\"System path after init:\\n\")\n"
"    for i in path:\n"
"        Log(\"   \" + i + \"\\n\")\n"
"    # add MacroDir to path (RFE #0000504)\n"
"    sys.path.append(MacroStd)\n"
"    sys.path.append(MacroDir)\n"
"    # add SystemWideMacroDir to path\n"
"    sys.path.append(SystemWideMacroDir)\n"
"    # add special path for MacOSX (bug #0000307)\n"
"    import platform\n"
"    if len(platform.mac_ver()[0]) > 0:\n"
"        sys.path.append(os.path.expanduser(\'~/Library/Application Support/FreeCAD/Mod\'))\n"
"\n"
"# some often used shortcuts (for lazy people like me  ;-)\n"
"App = FreeCAD\n"
"Log = FreeCAD.Console.PrintLog\n"
"Msg = FreeCAD.Console.PrintMessage\n"
"Err = FreeCAD.Console.PrintError\n"
"Wrn = FreeCAD.Console.PrintWarning\n"
"Crt = FreeCAD.Console.PrintCritical\n"
"Ntf = FreeCAD.Console.PrintNotification\n"
"Tnf = FreeCAD.Console.PrintTranslatedNotification\n"
"\n"
"#store the cmake variales\n"
"App.__cmake__ = cmake;\n"
"\n"
"#store unit test names\n"
"App.__unit_test__ = []\n"
"\n"
"Log (\'Init: starting App::FreeCADInit.py\\n\')\n"
"\n"
"try:\n"
"    import sys,os,traceback,inspect\n"
"    from datetime import datetime\n"
"except ImportError:\n"
"    FreeCAD.Console.PrintError(\"\\n\\nSeems the python standard libs are not installed, bailing out!\\n\\n\")\n"
"    raise\n"
"\n"
"class FCADLogger(object):\n"
"    \'\'\'Convenient class for tagged logging.\n"
"\n"
"       Example usage:\n"
"           >>> logger = FreeCAD.Logger(\'MyModule\')\n"
"           >>> logger.info(\'log test {}\',1)\n"
"           24.36053 <MyModule> <input>(1): test log 1\n"
"\n"
"       The default output format is:\n"
"           <timestamp> <tag> <source file>(line number): message\n"
"\n"
"       The message is formatted using new style Python string formatting, e.g.\n"
"       \'test {}\'.format(1). It is strongly recommended to not directly use\n"
"       Python string formatting, but pass additional argument indirectly through\n"
"       various logger print function, because the logger can skip string\n"
"       evaluation in case the logging level is disabled. For more options,\n"
"       please consult the docstring of __init__(), catch() and report().\n"
"\n"
"       To set/get logger level:\n"
"           >>> FreeCAD.setLogLevel(\'MyModule\',\'Trace\')\n"
"           >>> FreeCAD.getLogLevel(\'MyModule\')\n"
"           4\n"
"\n"
"        There are five predefined logger level, each corresponding to an integer\n"
"        value, as shown below together with the corresponding logger print\n"
"        method,\n"
"            0: Error, Logger.error()\n"
"            1: Warning, Logger.warn()\n"
"            2: Message, Logger.msg() or info()\n"
"            3: Log, Logger.log() or debug()\n"
"            4: Trace, Logger.trace()\n"
"\n"
"        FreeCAD.setLogLevel() supports both text and integer value, which allows\n"
"        you to define your own levels. The level set is persisted to user\n"
"        configuration file.\n"
"\n"
"        By default any tag has a log level of 2 for release, and 3 for debug\n"
"        build.\n"
"    \'\'\'\n"
"\n"
"    _levels = { \'Error\':0, \'error\':0,\n"
"                \'Warning\':1, \'warn\':1,\n"
"                \'Message\':2, \'msg\':2, \'info\':2,\n"
"                \'Log\':3, \'log\':3, \'debug\':3,\n"
"                \'Trace\':4, \'trace\':4,}\n"
"    _printer = [\n"
"            FreeCAD.Console.PrintError,\n"
"            FreeCAD.Console.PrintWarning,\n"
"            FreeCAD.Console.PrintMessage,\n"
"            FreeCAD.Console.PrintLog,\n"
"            FreeCAD.Console.PrintLog ]\n"
"\n"
"    def __init__(self, tag, **kargs):\n"
"        \'\'\'Construct a logger instance.\n"
"\n"
"        Supported arguments are their default values are,\n"
"\n"
"        * tag: a string tag for this logger. The log level of this logger can be\n"
"               accessed using FreeCAD.getLogLevel(tag)/setLogLevel(tag,level).\n"
"               All logger instance with the same tag shares the same level\n"
"               setting.\n"
"\n"
"        * printTag (True): whether to print tag\n"
"\n"
"        * noUpdateUI (True): whether to update GUI when printing. This is useful\n"
"                             to show log output on lengthy operations. Be\n"
"                             careful though, this may allow unexpected user\n"
"                             interaction when the application is busy, which may\n"
"                             lead to crash\n"
"\n"
"        * timing (True): whether to print time stamp\n"
"\n"
"        * lineno (True): whether to print source file and line number\n"
"\n"
"        * parent (None): provide a parent logger, so that the log printing will\n"
"                         check for parent\'s log level in addition of its own\n"
"\n"
"        * title (\'FreeCAD\'): message box title used by report()\n"
"        \'\'\'\n"
"        self.tag = tag\n"
"        self.laststamp = datetime.now()\n"
"        for key,default in ((\'printTag\',True),(\'noUpdateUI\',True),\n"
"                (\'timing\',True),(\'lineno\',True),(\'parent\',None),\n"
"                (\'title\',\'FreeCAD\')) :\n"
"            setattr(self,key,kargs.get(key,default))\n"
"\n"
"    def _isEnabledFor(self,level):\n"
"        \'\'\'Internal function to check for an integer log level.\n"
"\n"
"            * level: integer log level\n"
"        \'\'\'\n"
"\n"
"        if self.parent and not self.parent._isEnabledFor(level):\n"
"            return False\n"
"        return FreeCAD.getLogLevel(self.tag) >= level\n"
"\n"
"    def isEnabledFor(self,level):\n"
"        \'\'\'To check for an integer or text log level.\n"
"\n"
"            * level: integer or text log level\n"
"        \'\'\'\n"
"        if not isinstance(level,int):\n"
"            level = self.__class__._levels[level]\n"
"        return self._isEnabledFor(level)\n"
"\n"
"    def error(self,msg,*args,**kargs):\n"
"        \'\'\'\"Error\" level log printer\n"
"\n"
"            * msg: message string. May contain new style Python string formatter.\n"
"\n"
"            This function accepts additional positional and keyword arguments,\n"
"            which are forward to string.format() to generate the logging\n"
"            message. It is strongly recommended to not directly use Python\n"
"            string formatting, but pass additional arguments here, because the\n"
"            printer can skip string evaluation in case the logging level is\n"
"            disabled.\n"
"        \'\'\'\n"
"        if self._isEnabledFor(0):\n"
"            frame = kargs.pop(\'frame\',0)+1\n"
"            self._log(0,msg,frame,args,kargs)\n"
"\n"
"    def warn(self,msg,*args,**kargs):\n"
"        \'\'\'\"Warning\" level log printer\n"
"\n"
"            * msg: message string. May contain new style Python string formatter.\n"
"\n"
"            This function accepts additional positional and keyword arguments,\n"
"            which are forward to string.format() to generate the logging\n"
"            message. It is strongly recommended to not directly use Python\n"
"            string formatting, but pass additional arguments here, because the\n"
"            printer can skip string evaluation in case the logging level is\n"
"            disabled.\n"
"        \'\'\'\n"
"        if self._isEnabledFor(1):\n"
"            frame = kargs.pop(\'frame\',0)+1\n"
"            self._log(1,msg,frame,args,kargs)\n"
"\n"
"    def msg(self,msg,*args,**kargs):\n"
"        \'\'\'\"Message\" level log printer\n"
"\n"
"            * msg: message string. May contain new style Python string formatter.\n"
"\n"
"            This function accepts additional positional and keyword arguments,\n"
"            which are forward to string.format() to generate the logging\n"
"            message. It is strongly recommended to not directly use Python\n"
"            string formatting, but pass additional arguments here, because the\n"
"            printer can skip string evaluation in case the logging level is\n"
"            disabled.\n"
"        \'\'\'\n"
"        if self._isEnabledFor(2):\n"
"            frame = kargs.pop(\'frame\',0)+1\n"
"            self._log(2,msg,frame,args,kargs)\n"
"\n"
"    info = msg\n"
"\n"
"    def log(self,msg,*args,**kargs):\n"
"        \'\'\'\"Log\" level log printer\n"
"\n"
"            * msg: message string. May contain new style Python string formatter.\n"
"\n"
"            This function accepts additional positional and keyword arguments,\n"
"            which are forward to string.format() to generate the logging\n"
"            message. It is strongly recommended to not directly use Python\n"
"            string formatting, but pass additional arguments here, because the\n"
"            printer can skip string evaluation in case the logging level is\n"
"            disabled.\n"
"        \'\'\'\n"
"        if self._isEnabledFor(3):\n"
"            frame = kargs.pop(\'frame\',0)+1\n"
"            self._log(3,msg,frame,args,kargs)\n"
"\n"
"    debug = log\n"
"\n"
"    def trace(self,msg,*args,**kargs):\n"
"        \'\'\'\"Trace\" level log printer\n"
"\n"
"            * msg: message string. May contain new style Python string formatter.\n"
"\n"
"            This function accepts additional positional and keyword arguments,\n"
"            which are forward to string.format() to generate the logging\n"
"            message. It is strongly recommended to not directly use Python\n"
"            string formatting, but pass additional arguments here, because the\n"
"            printer can skip string evaluation in case the logging level is\n"
"            disabled.\n"
"        \'\'\'\n"
"        if self._isEnabledFor(4):\n"
"            frame = kargs.pop(\'frame\',0)+1\n"
"            self._log(4,msg,frame,args,kargs)\n"
"\n"
"    def _log(self,level,msg,frame=0,args=(),kargs=None):\n"
"        \'\'\'Internal log printing function.\n"
"\n"
"            * level: integer log level\n"
"\n"
"            * msg: message, may contain new style string format specifier\n"
"\n"
"            * frame (0): the calling frame for printing source file and line\n"
"                         number.  For example, in case you have your own logging\n"
"                         function, and you want to show the callers source\n"
"                         location, then set frame to one.\n"
"\n"
"            * args: tuple for positional arguments to be passed to\n"
"                    string.format()\n"
"\n"
"            * kargs: dictionary for keyword arguments to be passed to\n"
"                     string.format()\n"
"        \'\'\'\n"
"\n"
"        if (args or kargs) and isinstance(msg,str):\n"
"            if not kargs:\n"
"                msg = msg.format(*args)\n"
"            else:\n"
"                msg = msg.format(*args,**kargs)\n"
"\n"
"        prefix = \'\'\n"
"\n"
"        if self.timing:\n"
"            now = datetime.now()\n"
"            prefix += \'{} \'.format((now-self.laststamp).total_seconds())\n"
"            self.laststamp = now\n"
"\n"
"        if self.printTag:\n"
"            prefix += \'<{}> \'.format(self.tag)\n"
"\n"
"        if self.lineno:\n"
"            try:\n"
"                frame = sys._getframe(frame+1)\n"
"                prefix += \'{}({}): \'.format(os.path.basename(\n"
"                    frame.f_code.co_filename),frame.f_lineno)\n"
"            except Exception:\n"
"                frame = inspect.stack()[frame+1]\n"
"                prefix += \'{}({}): \'.format(os.path.basename(frame[1]),frame[2])\n"
"\n"
"        self.__class__._printer[level](\'{}{}\\n\'.format(prefix,msg))\n"
"\n"
"        if not self.noUpdateUI and FreeCAD.GuiUp:\n"
"            import FreeCADGui\n"
"            try:\n"
"                FreeCADGui.updateGui()\n"
"            except Exception:\n"
"                pass\n"
"\n"
"    def _catch(self,level,msg,func,args=None,kargs=None):\n"
"        \'\'\'Internal function to log exception of any callable.\n"
"\n"
"            * level: integer log level\n"
"\n"
"            * msg: message string. Unlike _log(), this argument must not contain\n"
"                   any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        try:\n"
"            if not args:\n"
"                args = []\n"
"            if not kargs:\n"
"                kargs = {}\n"
"            return func(*args,**kargs)\n"
"        except Exception:\n"
"            if self._isEnabledFor(level):\n"
"                self._log(level,msg+\'\\n\'+traceback.format_exc(),frame=2)\n"
"\n"
"    def catch(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception from a function and print as \"Error\".\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        return self._catch(0,msg,func,args,kargs)\n"
"\n"
"    def catchWarn(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception from a function and print as \"Warning\".\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        return self._catch(1,msg,func,args,kargs)\n"
"\n"
"    def catchMsg(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception from a function and print as \"Message\".\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        return self._catch(2,msg,func,args,kargs)\n"
"\n"
"    catchInfo = catchMsg\n"
"\n"
"    def catchLog(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception from a function and print as \"Log\".\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        return self._catch(3,msg,func,args,kargs)\n"
"\n"
"    catchDebug = catchLog\n"
"\n"
"    def catchTrace(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception from a function and print as \"Trace\".\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        return self._catch(4,msg,func,args,kargs)\n"
"\n"
"    def report(self,msg,func,*args,**kargs):\n"
"        \'\'\'Catch any exception report it with a message box.\n"
"\n"
"            * msg: message string. Unlike log printer, this argument must not\n"
"                   contain any string formatter.\n"
"\n"
"            * func: a callable object\n"
"\n"
"            * args: tuple of positional arguments to be passed to func.\n"
"\n"
"            * kargs: dictionary of keyword arguments to be passed to func.\n"
"        \'\'\'\n"
"        try:\n"
"            return func(*args,**kargs)\n"
"        except Exception as e:\n"
"            self.error(msg+\'\\n\'+traceback.format_exc(),frame=1)\n"
"            if FreeCAD.GuiUp:\n"
"                import FreeCADGui,PySide\n"
"                PySide.QtGui.QMessageBox.critical(\n"
"                        FreeCADGui.getMainWindow(),self.title,str(e))\n"
"\n"
"FreeCAD.Logger = FCADLogger\n"
"\n"
"# init every application by importing Init.py\n"
"try:\n"
"    InitApplications()\n"
"except Exception as e:\n"
"    Err(\'Error in InitApplications \' + str(e) + \'\\n\')\n"
"    Err(\'-\'*80+\'\\n\')\n"
"    Err(traceback.format_exc())\n"
"    Err(\'-\'*80+\'\\n\')\n"
"\n"
"FreeCAD.addImportType(\"FreeCAD document (*.FCStd)\",\"FreeCAD\")\n"
"\n"
"# set to no gui, is overwritten by InitGui\n"
"App.GuiUp = 0\n"
"\n"
"# fill up unit definitions\n"
"\n"
"App.Units.NanoMetre     = App.Units.Quantity(\'nm\')\n"
"App.Units.MicroMetre    = App.Units.Quantity(\'um\')\n"
"App.Units.MilliMetre    = App.Units.Quantity(\'mm\')\n"
"App.Units.CentiMetre    = App.Units.Quantity(\'cm\')\n"
"App.Units.DeciMetre     = App.Units.Quantity(\'dm\')\n"
"App.Units.Metre         = App.Units.Quantity(\'m\')\n"
"App.Units.KiloMetre     = App.Units.Quantity(\'km\')\n"
"\n"
"App.Units.MilliLiter    = App.Units.Quantity(\'ml\')\n"
"App.Units.Liter         = App.Units.Quantity(\'l\')\n"
"\n"
"App.Units.Hertz         = App.Units.Quantity(\'Hz\')\n"
"App.Units.KiloHertz     = App.Units.Quantity(\'kHz\')\n"
"App.Units.MegaHertz     = App.Units.Quantity(\'MHz\')\n"
"App.Units.GigaHertz     = App.Units.Quantity(\'GHz\')\n"
"App.Units.TeraHertz     = App.Units.Quantity(\'THz\')\n"
"\n"
"App.Units.MicroGram     = App.Units.Quantity(\'ug\')\n"
"App.Units.MilliGram     = App.Units.Quantity(\'mg\')\n"
"App.Units.Gram          = App.Units.Quantity(\'g\')\n"
"App.Units.KiloGram      = App.Units.Quantity(\'kg\')\n"
"App.Units.Ton           = App.Units.Quantity(\'t\')\n"
"\n"
"App.Units.Second        = App.Units.Quantity(\'s\')\n"
"App.Units.Minute        = App.Units.Quantity(\'min\')\n"
"App.Units.Hour          = App.Units.Quantity(\'h\')\n"
"\n"
"App.Units.Ampere        = App.Units.Quantity(\'A\')\n"
"App.Units.MilliAmpere   = App.Units.Quantity(\'mA\')\n"
"App.Units.KiloAmpere    = App.Units.Quantity(\'kA\')\n"
"App.Units.MegaAmpere    = App.Units.Quantity(\'MA\')\n"
"\n"
"App.Units.Kelvin        = App.Units.Quantity(\'K\')\n"
"App.Units.MilliKelvin   = App.Units.Quantity(\'mK\')\n"
"App.Units.MicroKelvin   = App.Units.Quantity(\'uK\')\n"
"\n"
"App.Units.MilliMole     = App.Units.Quantity(\'mmol\')\n"
"App.Units.Mole          = App.Units.Quantity(\'mol\')\n"
"\n"
"App.Units.Candela       = App.Units.Quantity(\'cd\')\n"
"\n"
"App.Units.Inch          = App.Units.Quantity(\'in\')\n"
"App.Units.Foot          = App.Units.Quantity(\'ft\')\n"
"App.Units.Thou          = App.Units.Quantity(\'thou\')\n"
"App.Units.Yard          = App.Units.Quantity(\'yd\')\n"
"App.Units.Mile          = App.Units.Quantity(\'mi\')\n"
"\n"
"App.Units.SquareFoot    = App.Units.Quantity(\'sqft\')\n"
"App.Units.CubicFoot     = App.Units.Quantity(\'cft\')\n"
"\n"
"App.Units.Pound         = App.Units.Quantity(\'lb\')\n"
"App.Units.Ounce         = App.Units.Quantity(\'oz\')\n"
"App.Units.Stone         = App.Units.Quantity(\'st\')\n"
"App.Units.Hundredweights= App.Units.Quantity(\'cwt\')\n"
"\n"
"App.Units.Newton        = App.Units.Quantity(\'N\')\n"
"App.Units.MilliNewton   = App.Units.Quantity(\'mN\')\n"
"App.Units.KiloNewton    = App.Units.Quantity(\'kN\')\n"
"App.Units.MegaNewton    = App.Units.Quantity(\'MN\')\n"
"\n"
"App.Units.NewtonPerMeter        = App.Units.Quantity(\'N/m\')\n"
"App.Units.MilliNewtonPerMeter   = App.Units.Quantity(\'mN/m\')\n"
"App.Units.KiloNewtonPerMeter    = App.Units.Quantity(\'kN/m\')\n"
"App.Units.MegaNewtonPerMeter    = App.Units.Quantity(\'MN/m\')\n"
"\n"
"App.Units.Pascal        = App.Units.Quantity(\'Pa\')\n"
"App.Units.KiloPascal    = App.Units.Quantity(\'kPa\')\n"
"App.Units.MegaPascal    = App.Units.Quantity(\'MPa\')\n"
"App.Units.GigaPascal    = App.Units.Quantity(\'GPa\')\n"
"\n"
"App.Units.MilliBar      = App.Units.Quantity(\'mbar\')\n"
"App.Units.Bar           = App.Units.Quantity(\'bar\')\n"
"\n"
"App.Units.PoundForce    = App.Units.Quantity(\'lbf\')\n"
"App.Units.Torr          = App.Units.Quantity(\'Torr\')\n"
"App.Units.mTorr         = App.Units.Quantity(\'mTorr\')\n"
"App.Units.yTorr         = App.Units.Quantity(\'uTorr\')\n"
"\n"
"App.Units.PSI           = App.Units.Quantity(\'psi\')\n"
"App.Units.KSI           = App.Units.Quantity(\'ksi\')\n"
"App.Units.MPSI          = App.Units.Quantity(\'Mpsi\')\n"
"\n"
"App.Units.Watt          = App.Units.Quantity(\'W\')\n"
"App.Units.MilliWatt     = App.Units.Quantity(\'mW\')\n"
"App.Units.KiloWatt      = App.Units.Quantity(\'kW\')\n"
"App.Units.VoltAmpere    = App.Units.Quantity(\'VA\')\n"
"\n"
"App.Units.Volt          = App.Units.Quantity(\'V\')\n"
"App.Units.MilliVolt     = App.Units.Quantity(\'mV\')\n"
"App.Units.KiloVolt      = App.Units.Quantity(\'kV\')\n"
"\n"
"App.Units.MegaSiemens   = App.Units.Quantity(\'MS\')\n"
"App.Units.KiloSiemens   = App.Units.Quantity(\'kS\')\n"
"App.Units.Siemens       = App.Units.Quantity(\'S\')\n"
"App.Units.MilliSiemens  = App.Units.Quantity(\'mS\')\n"
"App.Units.MicroSiemens  = App.Units.Quantity(\'uS\')\n"
"\n"
"App.Units.Ohm          = App.Units.Quantity(\'Ohm\')\n"
"App.Units.KiloOhm      = App.Units.Quantity(\'kOhm\')\n"
"App.Units.MegaOhm      = App.Units.Quantity(\'MOhm\')\n"
"\n"
"App.Units.Coulomb       = App.Units.Quantity(\'C\')\n"
"\n"
"App.Units.Tesla         = App.Units.Quantity(\'T\')\n"
"App.Units.Gauss         = App.Units.Quantity(\'G\')\n"
"\n"
"App.Units.Weber         = App.Units.Quantity(\'Wb\')\n"
"\n"
"# disable Oersted because people need to input e.g. a field strength of\n"
"# 1 ampere per meter -> 1 A/m and not get the recalculation to Oersted\n"
"# App.Units.Oersted       = App.Units.Quantity(\'Oe\')\n"
"\n"
"App.Units.PicoFarad     = App.Units.Quantity(\'pF\')\n"
"App.Units.NanoFarad     = App.Units.Quantity(\'nF\')\n"
"App.Units.MicroFarad    = App.Units.Quantity(\'uF\')\n"
"App.Units.MilliFarad    = App.Units.Quantity(\'mF\')\n"
"App.Units.Farad         = App.Units.Quantity(\'F\')\n"
"\n"
"App.Units.NanoHenry     = App.Units.Quantity(\'nH\')\n"
"App.Units.MicroHenry    = App.Units.Quantity(\'uH\')\n"
"App.Units.MilliHenry    = App.Units.Quantity(\'mH\')\n"
"App.Units.Henry         = App.Units.Quantity(\'H\')\n"
"\n"
"App.Units.Joule         = App.Units.Quantity(\'J\')\n"
"App.Units.MilliJoule    = App.Units.Quantity(\'mJ\')\n"
"App.Units.KiloJoule     = App.Units.Quantity(\'kJ\')\n"
"App.Units.NewtonMeter   = App.Units.Quantity(\'Nm\')\n"
"App.Units.VoltAmpereSecond   = App.Units.Quantity(\'VAs\')\n"
"App.Units.WattSecond    = App.Units.Quantity(\'Ws\')\n"
"App.Units.KiloWattHour  = App.Units.Quantity(\'kWh\')\n"
"App.Units.ElectronVolt  = App.Units.Quantity(\'eV\')\n"
"App.Units.KiloElectronVolt = App.Units.Quantity(\'keV\')\n"
"App.Units.MegaElectronVolt = App.Units.Quantity(\'MeV\')\n"
"App.Units.Calorie       = App.Units.Quantity(\'cal\')\n"
"App.Units.KiloCalorie   = App.Units.Quantity(\'kcal\')\n"
"\n"
"App.Units.MPH           = App.Units.Quantity(\'mi/h\')\n"
"App.Units.KMH           = App.Units.Quantity(\'km/h\')\n"
"\n"
"App.Units.Degree        = App.Units.Quantity(\'deg\')\n"
"App.Units.Radian        = App.Units.Quantity(\'rad\')\n"
"App.Units.Gon           = App.Units.Quantity(\'gon\')\n"
"App.Units.AngularMinute = App.Units.Quantity().AngularMinute\n"
"App.Units.AngularSecond = App.Units.Quantity().AngularSecond\n"
"\n"
"\n"
"# SI base units\n"
"# (length, weight, time, current, temperature, amount of substance, luminous intensity, angle)\n"
"App.Units.AmountOfSubstance           = App.Units.Unit(0,0,0,0,0,1)\n"
"App.Units.ElectricCurrent             = App.Units.Unit(0,0,0,1)\n"
"App.Units.Length                      = App.Units.Unit(1)\n"
"App.Units.LuminousIntensity           = App.Units.Unit(0,0,0,0,0,0,1)\n"
"App.Units.Mass                        = App.Units.Unit(0,1)\n"
"App.Units.Temperature                 = App.Units.Unit(0,0,0,0,1)\n"
"App.Units.TimeSpan                    = App.Units.Unit(0,0,1)\n"
"\n"
"# all other combined units\n"
"App.Units.Acceleration                = App.Units.Unit(1,0,-2)\n"
"App.Units.Angle                       = App.Units.Unit(0,0,0,0,0,0,0,1)\n"
"App.Units.AngleOfFriction             = App.Units.Unit(0,0,0,0,0,0,0,1)\n"
"App.Units.Area                        = App.Units.Unit(2)\n"
"App.Units.CompressiveStrength         = App.Units.Unit(-1,1,-2)\n"
"App.Units.CurrentDensity              = App.Units.Unit(-2,0,0,1)\n"
"App.Units.Density                     = App.Units.Unit(-3,1)\n"
"App.Units.DissipationRate             = App.Units.Unit(2,0,-3)\n"
"App.Units.DynamicViscosity            = App.Units.Unit(-1,1,-1)\n"
"App.Units.Frequency                   = App.Units.Unit(0,0,-1)\n"
"App.Units.MagneticFluxDensity         = App.Units.Unit(0,1,-2,-1)\n"
"App.Units.Magnetization               = App.Units.Unit(-1,0,0,1)\n"
"App.Units.ElectricalCapacitance       = App.Units.Unit(-2,-1,4,2)\n"
"App.Units.ElectricalConductance       = App.Units.Unit(-2,-1,3,2)\n"
"App.Units.ElectricalConductivity      = App.Units.Unit(-3,-1,3,2)\n"
"App.Units.ElectricalInductance        = App.Units.Unit(2,1,-2,-2)\n"
"App.Units.ElectricalResistance        = App.Units.Unit(2,1,-3,-2)\n"
"App.Units.ElectricCharge              = App.Units.Unit(0,0,1,1)\n"
"App.Units.ElectricPotential           = App.Units.Unit(2,1,-3,-1)\n"
"App.Units.Force                       = App.Units.Unit(1,1,-2)\n"
"App.Units.HeatFlux                    = App.Units.Unit(0,1,-3,0,0)\n"
"App.Units.InverseArea                 = App.Units.Unit(-2)\n"
"App.Units.InverseLength               = App.Units.Unit(-1)\n"
"App.Units.InverseVolume               = App.Units.Unit(-3)\n"
"App.Units.KinematicViscosity          = App.Units.Unit(2,0,-1)\n"
"App.Units.Pressure                    = App.Units.Unit(-1,1,-2)\n"
"App.Units.Power                       = App.Units.Unit(2,1,-3)\n"
"App.Units.ShearModulus                = App.Units.Unit(-1,1,-2)\n"
"App.Units.SpecificEnergy              = App.Units.Unit(2,0,-2)\n"
"App.Units.SpecificHeat                = App.Units.Unit(2,0,-2,0,-1)\n"
"App.Units.Stiffness                   = App.Units.Unit(0,1,-2)\n"
"App.Units.Stress                      = App.Units.Unit(-1,1,-2)\n"
"App.Units.ThermalConductivity         = App.Units.Unit(1,1,-3,0,-1)\n"
"App.Units.ThermalExpansionCoefficient = App.Units.Unit(0,0,0,0,-1)\n"
"App.Units.ThermalTransferCoefficient  = App.Units.Unit(0,1,-3,0,-1)\n"
"App.Units.UltimateTensileStrength     = App.Units.Unit(-1,1,-2)\n"
"App.Units.Velocity                    = App.Units.Unit(1,0,-1)\n"
"App.Units.VacuumPermittivity          = App.Units.Unit(-3,-1,4,2)\n"
"App.Units.Volume                      = App.Units.Unit(3)\n"
"App.Units.VolumeFlowRate              = App.Units.Unit(3,0,-1)\n"
"App.Units.VolumetricThermalExpansionCoefficient = App.Units.Unit(0,0,0,0,-1)\n"
"App.Units.Work                        = App.Units.Unit(2,1,-2)\n"
"App.Units.YieldStrength               = App.Units.Unit(-1,1,-2)\n"
"App.Units.YoungsModulus               = App.Units.Unit(-1,1,-2)\n"
"\n"
"\n"
"# Add an enum for the different unit schemes\n"
"from enum import IntEnum\n"
"\n"
"# The values must match with that of the\n"
"# C++ enum class UnitSystem\n"
"class Scheme(IntEnum):\n"
"    SI1 = 0\n"
"    SI2 = 1\n"
"    Imperial1 = 2\n"
"    ImperialDecimal = 3\n"
"    Centimeters = 4\n"
"    ImperialBuilding = 5\n"
"    MmMin = 6\n"
"    ImperialCivil = 7\n"
"    FemMilliMeterNewton = 8\n"
"\n"
"App.Units.Scheme = Scheme\n"
"\n"
"class NumberFormat(IntEnum):\n"
"    Default = 0\n"
"    Fixed = 1\n"
"    Scientific = 2\n"
"\n"
"App.Units.NumberFormat = NumberFormat\n"
"\n"
"class ScaleType(IntEnum):\n"
"    Other = -1\n"
"    NoScaling = 0\n"
"    NonUniformRight = 1\n"
"    NonUniformLeft = 2\n"
"    Uniform = 3\n"
"\n"
"App.ScaleType = ScaleType\n"
"\n"
"class PropertyType(IntEnum):\n"
"    Prop_None = 0\n"
"    Prop_ReadOnly = 1\n"
"    Prop_Transient = 2\n"
"    Prop_Hidden = 4\n"
"    Prop_Output = 8\n"
"    Prop_NoRecompute = 16\n"
"    Prop_NoPersist = 32\n"
"\n"
"App.PropertyType = PropertyType\n"
"\n"
"class ReturnType(IntEnum):\n"
"    PyObject = 0\n"
"    DocObject = 1\n"
"    DocAndPyObject = 2\n"
"    Placement = 3\n"
"    Matrix = 4\n"
"    LinkAndPlacement = 5\n"
"    LinkAndMatrix = 6\n"
"\n"
"App.ReturnType = ReturnType\n"
"\n"
"# clean up namespace\n"
"del(InitApplications)\n"
"\n"
"Log (\'Init: App::FreeCADInit.py done\\n\')\n"
;


