/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.core;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.stathissideris.ascii2image.core.ConversionOptions;
import org.stathissideris.ascii2image.core.FileUtils;
import org.stathissideris.ascii2image.core.HTMLConverter;
import org.stathissideris.ascii2image.graphics.BitmapRenderer;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.text.TextGrid;

public class CommandLineConverter {
    private static String notice = "ditaa version 0.9, Copyright (C) 2004--2009  Efstathios (Stathis) Sideris";
    private static String[] markupModeAllowedValues = new String[]{"use", "ignore", "render"};

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        long l = System.currentTimeMillis();
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Prints usage help.");
        options.addOption(OptionBuilder.create());
        options.addOption("v", "verbose", false, "Makes ditaa more verbose.");
        options.addOption("o", "overwrite", false, "If the filename of the destination image already exists, an alternative name is chosen. If the overwrite option is selected, the image file is instead overwriten.");
        options.addOption("S", "no-shadows", false, "Turns off the drop-shadow effect.");
        options.addOption("A", "no-antialias", false, "Turns anti-aliasing off.");
        options.addOption("W", "fixed-slope", false, "Makes sides of parallelograms and trapezoids fixed slope instead of fixed width.");
        options.addOption("d", "debug", false, "Renders the debug grid over the resulting image.");
        options.addOption("r", "round-corners", false, "Causes all corners to be rendered as round corners.");
        options.addOption("E", "no-separation", false, "Prevents the separation of common edges of shapes.");
        options.addOption("h", "html", false, "In this case the input is an HTML file. The contents of the <pre class=\"textdiagram\"> tags are rendered as diagrams and saved in the images directory and a new HTML file is produced with the appropriate <img> tags.");
        options.addOption("T", "transparent", false, "Causes the diagram to be rendered on a transparent background. Overrides --background.");
        OptionBuilder.withLongOpt((String)"encoding");
        OptionBuilder.withDescription((String)"The encoding of the input file.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"ENCODING");
        options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.withLongOpt((String)"scale");
        OptionBuilder.withDescription((String)"A natural number that determines the size of the rendered image. The units are fractions of the default size (2.5 renders 1.5 times bigger than the default).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"SCALE");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"tabs");
        OptionBuilder.withDescription((String)"Tabs are normally interpreted as 8 spaces but it is possible to change that using this option. It is not advisable to use tabs in your diagrams.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"TABS");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"background");
        OptionBuilder.withDescription((String)"The background colour of the image. The format should be a six-digit hexadecimal number (as in HTML, FF0000 for red). Pass an eight-digit hex to define transparency. This is overridden by --transparent.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"BACKGROUND");
        options.addOption(OptionBuilder.create((char)'b'));
        CommandLine commandLine = null;
        try {
            object2 = new PosixParser();
            commandLine = object2.parse(options, stringArray);
            if (commandLine.hasOption("block-size")) {
                System.out.println(commandLine.getOptionValue("block-size"));
            }
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            new HelpFormatter().printHelp("ditaa <INPFILE> [OUTFILE]", options, true);
            System.exit(2);
        }
        if (commandLine.hasOption("help") || stringArray.length == 0) {
            new HelpFormatter().printHelp("ditaa <INPFILE> [OUTFILE]", options, true);
            System.exit(0);
        }
        object2 = null;
        try {
            object2 = new ConversionOptions(commandLine);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("Error: " + unsupportedEncodingException.getMessage());
            System.exit(2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Error: " + illegalArgumentException.getMessage());
            new HelpFormatter().printHelp("ditaa <INPFILE> [OUTFILE]", options, true);
            System.exit(2);
        }
        stringArray = commandLine.getArgs();
        if (stringArray.length == 0) {
            System.err.println("Error: Please provide the input file filename");
            new HelpFormatter().printHelp("ditaa <inpfile> [outfile]", options, true);
            System.exit(2);
        }
        if (commandLine.hasOption("html")) {
            CommandLineConverter.printRunInfo(commandLine);
            object = stringArray[0];
            boolean bl = false;
            if (object2.processingOptions.overwriteFiles()) {
                bl = true;
            }
            String string = stringArray.length == 1 ? FileUtils.makeTargetPathname((String)object, "html", "_processed", true) : stringArray[1];
            File file = new File(string);
            if (!bl && file.exists()) {
                System.out.println("Error: File " + string + " exists. If you would like to overwrite it, please use the --overwrite option.");
                System.exit(0);
            }
            new HTMLConverter().convertHTMLFile((String)object, string, "ditaa_diagram", "images", (ConversionOptions)object2);
            System.exit(0);
        } else {
            String string;
            boolean bl;
            object = new TextGrid();
            if (object2.processingOptions.getCustomShapes() != null) {
                ((TextGrid)object).addToMarkupTags(object2.processingOptions.getCustomShapes().keySet());
            }
            String string2 = stringArray[0];
            boolean bl2 = "-".equals(string2);
            boolean bl3 = false;
            if (object2.processingOptions.overwriteFiles()) {
                bl3 = true;
            }
            if (stringArray.length == 1) {
                if (bl2) {
                    bl = true;
                    string = "-";
                } else {
                    string = FileUtils.makeTargetPathname(string2, "png", bl3);
                    bl = false;
                }
            } else {
                string = stringArray[1];
                bl = "-".equals(string);
            }
            if (!bl) {
                CommandLineConverter.printRunInfo(commandLine);
                System.out.println("Reading " + (bl2 ? "standard input" : "file: " + string2));
            }
            try {
                if (!((TextGrid)object).loadFrom(string2, object2.processingOptions)) {
                    System.err.println("Cannot open file " + string2 + " for reading");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("Error: " + unsupportedEncodingException.getMessage());
                System.exit(1);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Error: File " + string2 + " does not exist");
                System.exit(1);
            }
            catch (IOException iOException) {
                System.err.println("Error: Cannot open file " + string2 + " for reading");
                System.exit(1);
            }
            if (object2.processingOptions.printDebugOutput()) {
                if (!bl) {
                    System.out.println("Using grid:");
                }
                ((TextGrid)object).printDebug();
            }
            Diagram diagram = new Diagram((TextGrid)object, (ConversionOptions)object2);
            if (!bl) {
                System.out.println("Rendering to file: " + string);
            }
            RenderedImage renderedImage = new BitmapRenderer().renderToImage(diagram, object2.renderingOptions);
            try {
                OutputStream outputStream = bl ? System.out : new FileOutputStream(string);
                ImageIO.write(renderedImage, "png", outputStream);
            }
            catch (IOException iOException) {
                System.err.println("Error: Cannot write to file " + string);
                System.exit(1);
            }
            long l2 = System.currentTimeMillis();
            long l3 = (l2 - l) / 1000L;
            if (!bl) {
                System.out.println("Done in " + l3 + "sec");
            }
        }
    }

    private static void printRunInfo(CommandLine commandLine) {
        Option[] optionArray;
        System.out.println("\n" + notice + "\n");
        System.out.println("Running with options:");
        for (Option option : optionArray = commandLine.getOptions()) {
            if (option.hasArgs()) {
                for (String string : option.getValues()) {
                    System.out.println(option.getLongOpt() + " = " + string);
                }
                continue;
            }
            if (option.hasArg()) {
                System.out.println(option.getLongOpt() + " = " + option.getValue());
                continue;
            }
            System.out.println(option.getLongOpt());
        }
    }
}

