# Requirements

Packages:

 - `base-devel` package group
 - `bash-bats` package
 - `kcov` package
 - `libretools` package
 - `qemu-user-static-binfmt` package

Other setup:

 - Arrange for `gpg` to sign files using a key that is trusted by the
   pacman keyring.  This is easy if you are already a Parabola
   packager--your PGP key is already trusted by the pacman keyring, as
   it is included in the `parabola-keyring` package.

# Running the tests

The command to run the test suite is

    [BUILDIR=/path/to/cache] [COVERAGE_DIR=/path/to/output] make check[-coverage]

 - The default `BUILDDIR` is `${TMPDIR:-/tmp}/dbscripts-build`;
   packages built as part of test setup are cached here.  This can be
   shared between test suite runs (as libremakepkg isn't the target of
   our tests).
 - Using the `check-coverage` target instead of the `check` target
   also generates a coverage report when running the tests; open
   `${COVERAGE_DIR}/index.html` in your web browser to view the
   results.  The default `COVERAGE_DIR` is `$PWD/coverage`.

# Other testing notes

 - The test suite will use `sudo` to run `unshare -m`, `librechroot`,
   and `libremakepkg`.  It should be safe, but if this makes you
   nervous, run the test suite in a VM or container.

Things outside of the dbscripts directory that are modified:

 - The test suite creates and uses the `librechroot` chroots
   `dbscripts@{any,armv7h,i686,x86_64}`.  It does not ever update
   these after creation or clean these up, and leaves them around to
   speed up future runs.
 - Built packages are cached in `BUILDDIR` (see above).  This
   directory is never cleaned up, and is left around to speed up
   future runs.

You may want to manually clean these up periodically.
