/* SPDX-License-Identifier: MIT */
/*
 * Copyright © 2024 Intel Corporation
 */

#ifndef __INTEL_VRR_REGS_H__
#define __INTEL_VRR_REGS_H__

#include "intel_display_reg_defs.h"

#define _TRANS_VRR_CTL_A			0x60420
#define _TRANS_VRR_CTL_B			0x61420
#define _TRANS_VRR_CTL_C			0x62420
#define _TRANS_VRR_CTL_D			0x63420
#define TRANS_VRR_CTL(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_VRR_CTL_A)
#define   VRR_CTL_VRR_ENABLE			REG_BIT(31)
#define   VRR_CTL_IGN_MAX_SHIFT			REG_BIT(30)
#define   VRR_CTL_FLIP_LINE_EN			REG_BIT(29)
#define   VRR_CTL_CMRR_ENABLE			REG_BIT(27)
#define   VRR_CTL_PIPELINE_FULL_MASK		REG_GENMASK(10, 3)
#define   VRR_CTL_PIPELINE_FULL(x)		REG_FIELD_PREP(VRR_CTL_PIPELINE_FULL_MASK, (x))
#define   VRR_CTL_PIPELINE_FULL_OVERRIDE	REG_BIT(0)
#define   XELPD_VRR_CTL_VRR_GUARDBAND_MASK	REG_GENMASK(15, 0)
#define   XELPD_VRR_CTL_VRR_GUARDBAND(x)	REG_FIELD_PREP(XELPD_VRR_CTL_VRR_GUARDBAND_MASK, (x))

#define _TRANS_VRR_VMAX_A			0x60424
#define _TRANS_VRR_VMAX_B			0x61424
#define _TRANS_VRR_VMAX_C			0x62424
#define _TRANS_VRR_VMAX_D			0x63424
#define TRANS_VRR_VMAX(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_VRR_VMAX_A)
#define   VRR_VMAX_MASK				REG_GENMASK(19, 0)

#define _TRANS_VRR_VMIN_A			0x60434
#define _TRANS_VRR_VMIN_B			0x61434
#define _TRANS_VRR_VMIN_C			0x62434
#define _TRANS_VRR_VMIN_D			0x63434
#define TRANS_VRR_VMIN(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_VRR_VMIN_A)
#define   VRR_VMIN_MASK				REG_GENMASK(15, 0)

#define _TRANS_VRR_VMAXSHIFT_A			0x60428
#define _TRANS_VRR_VMAXSHIFT_B			0x61428
#define _TRANS_VRR_VMAXSHIFT_C			0x62428
#define _TRANS_VRR_VMAXSHIFT_D			0x63428
#define TRANS_VRR_VMAXSHIFT(display, trans)	_MMIO_TRANS2((display), (trans), _TRANS_VRR_VMAXSHIFT_A)
#define   VRR_VMAXSHIFT_DEC_MASK		REG_GENMASK(29, 16)
#define   VRR_VMAXSHIFT_DEC			REG_BIT(16)
#define   VRR_VMAXSHIFT_INC_MASK		REG_GENMASK(12, 0)

#define _TRANS_VRR_STATUS_A			0x6042c
#define _TRANS_VRR_STATUS_B			0x6142c
#define _TRANS_VRR_STATUS_C			0x6242c
#define _TRANS_VRR_STATUS_D			0x6342c
#define TRANS_VRR_STATUS(display, trans)	_MMIO_TRANS2((display), (trans), _TRANS_VRR_STATUS_A)
#define   VRR_STATUS_VMAX_REACHED		REG_BIT(31)
#define   VRR_STATUS_NOFLIP_TILL_BNDR		REG_BIT(30)
#define   VRR_STATUS_FLIP_BEF_BNDR		REG_BIT(29)
#define   VRR_STATUS_NO_FLIP_FRAME		REG_BIT(28)
#define   VRR_STATUS_VRR_EN_LIVE		REG_BIT(27)
#define   VRR_STATUS_FLIPS_SERVICED		REG_BIT(26)
#define   VRR_STATUS_VBLANK_MASK		REG_GENMASK(22, 20)
#define   STATUS_FSM_IDLE			REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 0)
#define   STATUS_FSM_WAIT_TILL_FDB		REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 1)
#define   STATUS_FSM_WAIT_TILL_FS		REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 2)
#define   STATUS_FSM_WAIT_TILL_FLIP		REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 3)
#define   STATUS_FSM_PIPELINE_FILL		REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 4)
#define   STATUS_FSM_ACTIVE			REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 5)
#define   STATUS_FSM_LEGACY_VBLANK		REG_FIELD_PREP(VRR_STATUS_VBLANK_MASK, 6)

#define _TRANS_VRR_VTOTAL_PREV_A		0x60480
#define _TRANS_VRR_VTOTAL_PREV_B		0x61480
#define _TRANS_VRR_VTOTAL_PREV_C		0x62480
#define _TRANS_VRR_VTOTAL_PREV_D		0x63480
#define TRANS_VRR_VTOTAL_PREV(display, trans)	_MMIO_TRANS2((display), (trans), _TRANS_VRR_VTOTAL_PREV_A)
#define   VRR_VTOTAL_FLIP_BEFR_BNDR		REG_BIT(31)
#define   VRR_VTOTAL_FLIP_AFTER_BNDR		REG_BIT(30)
#define   VRR_VTOTAL_FLIP_AFTER_DBLBUF		REG_BIT(29)
#define   VRR_VTOTAL_PREV_FRAME_MASK		REG_GENMASK(19, 0)

#define _TRANS_VRR_FLIPLINE_A			0x60438
#define _TRANS_VRR_FLIPLINE_B			0x61438
#define _TRANS_VRR_FLIPLINE_C			0x62438
#define _TRANS_VRR_FLIPLINE_D			0x63438
#define TRANS_VRR_FLIPLINE(display, trans)	_MMIO_TRANS2((display), (trans), _TRANS_VRR_FLIPLINE_A)
#define   VRR_FLIPLINE_MASK			REG_GENMASK(19, 0)

#define _TRANS_VRR_STATUS2_A			0x6043c
#define _TRANS_VRR_STATUS2_B			0x6143c
#define _TRANS_VRR_STATUS2_C			0x6243c
#define _TRANS_VRR_STATUS2_D			0x6343c
#define TRANS_VRR_STATUS2(display, trans)	_MMIO_TRANS2((display), (trans), _TRANS_VRR_STATUS2_A)
#define   VRR_STATUS2_VERT_LN_CNT_MASK		REG_GENMASK(19, 0)

#define _TRANS_PUSH_A				0x60a70
#define _TRANS_PUSH_B				0x61a70
#define _TRANS_PUSH_C				0x62a70
#define _TRANS_PUSH_D				0x63a70
#define TRANS_PUSH(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_PUSH_A)
#define   TRANS_PUSH_EN				REG_BIT(31)
#define   TRANS_PUSH_SEND			REG_BIT(30)

#define _TRANS_VRR_VSYNC_A			0x60078
#define TRANS_VRR_VSYNC(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_VRR_VSYNC_A)
#define   VRR_VSYNC_END_MASK			REG_GENMASK(28, 16)
#define   VRR_VSYNC_END(vsync_end)		REG_FIELD_PREP(VRR_VSYNC_END_MASK, (vsync_end))
#define   VRR_VSYNC_START_MASK			REG_GENMASK(12, 0)
#define   VRR_VSYNC_START(vsync_start)		REG_FIELD_PREP(VRR_VSYNC_START_MASK, (vsync_start))

/* Common register for HDMI EMP and DP AS SDP */
#define _EMP_AS_SDP_TL_A			0x60204
#define EMP_AS_SDP_TL(display, trans)		_MMIO_TRANS2((display), (trans), _EMP_AS_SDP_TL_A)
#define   EMP_AS_SDP_DB_TL_MASK			REG_GENMASK(12, 0)
#define   EMP_AS_SDP_DB_TL(db_transmit_line)	REG_FIELD_PREP(EMP_AS_SDP_DB_TL_MASK, (db_transmit_line))

#define _TRANS_CMRR_M_LO_A			0x604F0
#define TRANS_CMRR_M_LO(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_CMRR_M_LO_A)

#define _TRANS_CMRR_M_HI_A			0x604F4
#define TRANS_CMRR_M_HI(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_CMRR_M_HI_A)

#define _TRANS_CMRR_N_LO_A			0x604F8
#define TRANS_CMRR_N_LO(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_CMRR_N_LO_A)

#define _TRANS_CMRR_N_HI_A			0x604FC
#define TRANS_CMRR_N_HI(display, trans)		_MMIO_TRANS2((display), (trans), _TRANS_CMRR_N_HI_A)

#endif /* __INTEL_VRR_REGS__ */
