/** @file

Copyright (c) 2019, Intel Corporation. All rights reserved.<BR>

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0020 - Si Config CSM Flag.
  Platform specific common policies that used by several silicon components. CSM status flag.
  $EN_DIS
**/
  UINT8                       SiCsmFlag;

/** Offset 0x0021
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x0024 - SVID SDID table Poniter.
  The address of the table of SVID SDID to customize each SVID SDID entry.
**/
  UINT32                      SiSsidTablePtr;

/** Offset 0x0028 - Number of ssid table.
  SiNumberOfSsidTableEntry should match the table entries created in SiSsidTablePtr.
**/
  UINT16                      SiNumberOfSsidTableEntry;

/** Offset 0x002A
**/
  UINT8                       SiPostMemRsvd[16];

/** Offset 0x003A
**/
  UINT8                       UnusedUpdSpace1[2];

/** Offset 0x003C - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x0040 - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0044 - Enable or Disable TXT
  Enable or Disable TXT; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       TxtEnable;

/** Offset 0x0045 - Advanced Encryption Standard (AES) feature
  Enable or Disable Advanced Encryption Standard (AES) feature; </b>0: Disable; <b>1: Enable
  $EN_DIS
**/
  UINT8                       AesEnable;

/** Offset 0x0046 - Deprecated Skip Multi-Processor Initialization
  {@deprecated SkipMpInit has been moved to FspmUpd as SkipMpInitPreMem. </b>0: Initialize;
  <b>1: Skip
  $EN_DIS
**/
  UINT8                       SkipMpInit;

/** Offset 0x0047 - PpinSupport to view Protected Processor Inventory Number
  Enable or Disable or Auto (Based on End of Manufacturing flag. Disabled if this
  flag is set) for PPIN Support
  0: Disable, 1: Enable, 2: Auto
**/
  UINT8                       PpinSupport;

/** Offset 0x0048 - Turbo Mode
  Enable/Disable Turbo mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0049 - Power State 3 enable/disable
  PCODE MMIO Mailbox: Power State 3 enable/disable; 0: Disable; <b>1: Enable</b>.
  For all VR Indexes
**/
  UINT8                       Psi3Enable;

/** Offset 0x004A - Power State 4 enable/disable
  PCODE MMIO Mailbox: Power State 4 enable/disable; 0: Disable; <b>1: Enable</b>.For
  all VR Indexes
**/
  UINT8                       Psi4Enable;

/** Offset 0x004B
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x004C - Imon slope correction
  PCODE MMIO Mailbox: Imon slope correction. Specified in 1/100 increment values.
  Range is 0-200. 125 = 1.25. <b>0: Auto</b>.For all VR Indexes
**/
  UINT16                      ImonSlope;

/** Offset 0x004E - Imon offset correction
  PCODE MMIO Mailbox: Imon offset correction. Value is a 2's complement signed integer.
  Units 1/1000, Range 0-63999. For an offset = 12.580, use 12580. <b>0: Auto</b>
**/
  UINT16                      ImonOffset;

/** Offset 0x0050 - Enable/Disable BIOS configuration of VR
  Enable/Disable BIOS configuration of VR; <b>0: Disable</b>; 1: Enable.For all VR Indexes
**/
  UINT8                       VrConfigEnable;

/** Offset 0x0051 - Thermal Design Current enable/disable
  PCODE MMIO Mailbox: Thermal Design Current enable/disable; <b>0: Disable</b>; 1:
  Enable.For all VR Indexes
**/
  UINT8                       TdcEnable;

/** Offset 0x0052 - HECI3 state
  PCODE MMIO Mailbox: Thermal Design Current time window. Defined in milli seconds.
  Valid Values 1 - 1ms , 2 - 2ms , 3 - 3ms , 4 - 4ms , 5 - 5ms , 6 - 6ms , 7 - 7ms
  , 8 - 8ms , 10 - 10ms.For all VR Indexe
**/
  UINT8                       TdcTimeWindow;

/** Offset 0x0053 - Thermal Design Current Lock
  PCODE MMIO Mailbox: Thermal Design Current Lock; <b>0: Disable</b>; 1: Enable.For
  all VR Indexes
**/
  UINT8                       TdcLock;

/** Offset 0x0054 - Thermal Design Current current limit
  PCODE MMIO Mailbox: Thermal Design Current current limit. Specified in 1/8A units.
  Range is 0-4095. 1000 = 125A. <b>0: Auto</b>. For all VR Indexes
**/
  UINT16                      TdcPowerLimit;

/** Offset 0x0056 - AcLoadline
  PCODE MMIO Mailbox: AcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249. <b>Intel Recommended Defaults vary by domain and SKU.
**/
  UINT16                      AcLoadline;

/** Offset 0x0058 - DcLoadline
  PCODE MMIO Mailbox: DcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249.<b>Intel Recommended Defaults vary by domain and SKU.</b>
**/
  UINT16                      DcLoadline;

/** Offset 0x005A - Power State 1 Threshold current
  PCODE MMIO Mailbox: Power State 1 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi1Threshold;

/** Offset 0x005C - Power State 2 Threshold current
  PCODE MMIO Mailbox: Power State 2 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi2Threshold;

/** Offset 0x005E - Power State 3 Threshold current
  PCODE MMIO Mailbox: Power State 3 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi3Threshold;

/** Offset 0x0060 - Icc Max limit
  PCODE MMIO Mailbox: VR Icc Max limit. 0-255A in 1/4 A units. 400 = 100A
**/
  UINT16                      IccMax;

/** Offset 0x0062 - VR Voltage Limit
  DEPRECATED
**/
  UINT16                      VrVoltageLimit;

/** Offset 0x0064 - Platform Psys slope correction
  PCODE MMIO Mailbox: Platform Psys slope correction. <b>0 - Auto</b> Specified in
  1/100 increment values. Range is 0-200. 125 = 1.25
**/
  UINT8                       PsysSlope;

/** Offset 0x0065 - Platform Psys offset correction
  PCODE MMIO Mailbox: Platform Psys offset correction. <b>0 - Auto</b> Units 1/4,
  Range 0-255. Value of 100 = 100/4 = 25 offset
**/
  UINT8                       PsysOffset;

/** Offset 0x0066 - Acoustic Noise Mitigation feature
  Enable or Disable Acoustic Noise Mitigation feature. This has to be enabled to program
  slew rate configuration for all VR domains, Pre Wake, Ramp Up and, Ramp Down times.<b>0:
  Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x0067 - Pre Wake Randomization time
  PCODE MMIO Mailbox: Acoustic Mitigation Range.Defines the maximum pre-wake randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMitigation is enabled.
  Range 0-255 <b>0</b>.
**/
  UINT8                       PreWake;

/** Offset 0x0068 - Ramp Up Randomization time
  PCODE MMIO Mailbox: Acoustic Mitigation Range.Defines the maximum Ramp Up randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMitigation is enabled.Range
  0-255 <b>0</b>.
**/
  UINT8                       RampUp;

/** Offset 0x0069 - Ramp Down Randomization time
  PCODE MMIO Mailbox: Acoustic Mitigation Range.Defines the maximum Ramp Down randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMitigation is enabled.Range
  0-255 <b>0</b>.
**/
  UINT8                       RampDown;

/** Offset 0x006A - Disable Fast Slew Rate for Deep Package C States for VR FIVR domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableFivr;

/** Offset 0x006B - Slew Rate configuration for Deep Package C States for VR FIVR domain
  Slew Rate configuration for Deep Package C States for VR FIVR domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForFivr;

/** Offset 0x006C - Enable VR specific mailbox command
  VR specific mailbox commands. <b>00b - no VR specific command sent.</b>  01b - A
  VR mailbox command specifically for the MPS IMPV8 VR will be sent. 10b - VR specific
  command sent for PS4 exit issue. 11b - Reserved.
  $EN_DIS
**/
  UINT8                       SendVrMbxCmd;

/** Offset 0x006D
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x006E - FIVR RFI Frequency
  PCODE MMIO Mailbox: Set the desired RFI frequency, in increments of 100KHz. <b>0:
  Auto</b>. Range varies based on XTAL clock: 0-1918 (Up to 191.8HMz) for 24MHz clock;
  0-1535 (Up to 153.5MHz) for 19MHz clock.
**/
  UINT16                      FivrRfiFrequency;

/** Offset 0x0070 - FIVR RFI Spread Spectrum
  PCODE MMIO Mailbox: FIVR RFI Spread Spectrum, in 0.1% increments. For a spread of
  5.0%, enter 50.<b>0: Disable FIVR Spread Spectrum</b>; Range: 0 to 100 (0.0% to 10.0%).
**/
  UINT8                       FivrSpreadSpectrum;

/** Offset 0x0071 - Enable or Disable Minimum Voltage Override
  Enable or disable Minimum Voltage overrides ; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       EnableMinVoltageOverride;

/** Offset 0x0072 - Min Voltage for C8
  PCODE MMIO Mailbox: Minimum voltage for C8. Valid if EnableMinVoltageOverride =
  1. Range 0 to 1999mV. <b> 0: 0mV </b>
**/
  UINT16                      MinVoltageC8;

/** Offset 0x0074 - Min Voltage for Runtime
  PCODE MMIO Mailbox: Minimum voltage for runtime. Valid if EnableMinVoltageOverride
  = 1. Range 0 to 1999mV. <b> 0: 0mV </b>
**/
  UINT16                      MinVoltageRuntime;

/** Offset 0x0076 - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x0077 - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x0078 - Enable or Disable Monitor /MWAIT instructions
  Enable or Disable Monitor /MWAIT instructions; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x0079 - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0: Single Range Output, 1: ToPA Output
**/
  UINT8                       ProcessorTraceOutputScheme;

/** Offset 0x007A - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcessorTraceEnable;

/** Offset 0x007B
**/
  UINT8                       UnusedUpdSpace4[5];

/** Offset 0x0080 - Base of memory region allocated for Processor Trace
  Base address of memory region allocated for Processor Trace. Processor Trace requires
  2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT64                      ProcessorTraceMemBase;

/** Offset 0x0088 - Memory region allocation for Processor Trace
  Length in bytes of memory region allocated for Processor Trace. Processor Trace
  requires 2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT32                      ProcessorTraceMemLength;

/** Offset 0x008C - Enable or Disable Voltage Optimization feature
  Enable or Disable Voltage Optimization feature 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       VoltageOptimization;

/** Offset 0x008D - Set Three Strike Counter Disable
  False (default): Three Strike counter will be incremented and True: Prevents Three
  Strike counter from incrementing; <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       ThreeStrikeCounterDisable;

/** Offset 0x008E - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x008F - AP Idle Manner of waiting for SIPI
  AP Idle Manner of waiting for SIPI; 1: HALT loop; <b>2: MWAIT loop</b>; 3: RUN loop.
  1: HALT loop, 2: MWAIT loop, 3: RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x0090 - 1-Core Ratio Limit
  1-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  1-Core Ratio Limit + OC Bins.This 1-Core Ratio Limit Must be greater than or equal
  to 2-Core Ratio Limit, 3-Core Ratio Limit, 4-Core Ratio Limit. Range is 0 to 83
**/
  UINT8                       OneCoreRatioLimit;

/** Offset 0x0091 - 2-Core Ratio Limit
  2-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  2-Core Ratio Limit + OC Bins.This 2-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       TwoCoreRatioLimit;

/** Offset 0x0092 - 3-Core Ratio Limit
  3-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  3-Core Ratio Limit + OC Bins.This 3-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       ThreeCoreRatioLimit;

/** Offset 0x0093 - 4-Core Ratio Limit
  4-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  4-Core Ratio Limit + OC Bins.This 4-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
**/
  UINT8                       FourCoreRatioLimit;

/** Offset 0x0094 - 5-Core Ratio Limit
  5-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  5-Core Ratio Limit + OC Bins.This 5-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       FiveCoreRatioLimit;

/** Offset 0x0095 - 6-Core Ratio Limit
  6-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  6-Core Ratio Limit + OC Bins.This 6-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       SixCoreRatioLimit;

/** Offset 0x0096 - 7-Core Ratio Limit
  7-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  7-Core Ratio Limit + OC Bins.This 7-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       SevenCoreRatioLimit;

/** Offset 0x0097 - 8-Core Ratio Limit
  8-Core Ratio Limit: For XE part: LFM to 255, For overclocking part: LFM to Fused
  8-Core Ratio Limit + OC Bins.This 8-Core Ratio Limit Must be Less than or equal
  to 1-Core Ratio Limit.Range is 0 to 83
  0x0:0xFF
**/
  UINT8                       EightCoreRatioLimit;

/** Offset 0x0098 - Enable or Disable HWP
  Enable or Disable HWP(Hardware P states) Support. 0: Disable; <b>1: Enable;</b>
  2-3:Reserved
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x0099 - Hardware Duty Cycle Control
  Hardware Duty Cycle Control configuration. 0: Disabled; <b>1: Enabled</b> 2-3:Reserved
  $EN_DIS
**/
  UINT8                       HdcControl;

/** Offset 0x009A - Package Long duration turbo mode time
  Package Long duration turbo mode time window in seconds. Valid values(Unit in seconds)
  0 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x009B - Short Duration Turbo Mode
  Enable or Disable short duration Turbo Mode. </b>0 : Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x009C - Turbo settings Lock
  Lock all Turbo settings Enable/Disable; <b>0: Disable , </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x009D - Package PL3 time window
  Package PL3 time window range for this policy from 0 to 64ms
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x009E - Package PL3 Duty Cycle
  Package PL3 Duty Cycle; Valid Range is 0 to 100
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x009F - Package PL3 Lock
  Package PL3 Lock Enable/Disable; <b>0: Disable ; <b> 1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x00A0 - Package PL4 Lock
  Package PL4 Lock Enable/Disable; <b>0: Disable ; <b>1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x00A1 - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts.For SKL Y SKU, the recommended default for this policy is
  <b>10</b>, For all other SKUs the recommended default are <b>0</b>
**/
  UINT8                       TccActivationOffset;

/** Offset 0x00A2 - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1.For SKL Y SKU, the recommended default for this policy is <b>1: Enabled</b>,
  For all other SKUs the recommended default are  <b>0: Disabled</b>.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x00A3 - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x00A4 - Package Long duration turbo mode power limit
  Package Long duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit1;

/** Offset 0x00A8 - Package Short duration turbo mode power limit
  Package Short duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x00AC - Package PL3 power limit
  Package PL3 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit3;

/** Offset 0x00B0 - Package PL4 power limit
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 1023875 in Step size of 125
**/
  UINT32                      PowerLimit4;

/** Offset 0x00B4 - Tcc Offset Time Window for RATL
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 1023875 in Step size of 125
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x00B8 - Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT
  Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       HwpInterruptControl;

/** Offset 0x00B9 - Intel Turbo Boost Max Technology 3.0
  Intel Turbo Boost Max Technology 3.0. 0: Disabled; <b>1: Enabled</b>
  $EN_DIS
**/
  UINT8                       EnableItbm;

/** Offset 0x00BA - Intel Turbo Boost Max Technology 3.0 Driver
  Intel Turbo Boost Max Technology 3.0 Driver <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       EnableItbmDriver;

/** Offset 0x00BB - Enable or Disable Per Core P State OS control
  Enable or Disable Per Core P State OS control. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnablePerCorePState;

/** Offset 0x00BC - Enable or Disable HwP Autonomous Per Core P State OS control
  Enable or Disable HwP Autonomous Per Core P State OS control. 0: Disable; <b>1:
  Enable</b>
  $EN_DIS
**/
  UINT8                       EnableHwpAutoPerCorePstate;

/** Offset 0x00BD - Enable or Disable HwP Autonomous EPP Grouping
  Enable or Disable HwP Autonomous EPP Grouping. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnableHwpAutoEppGrouping;

/** Offset 0x00BE - Enable or Disable EPB override over PECI
  Enable or Disable EPB override over PECI. <b>0: Disable;</b> 1: Enable
  $EN_DIS
**/
  UINT8                       EnableEpbPeciOverride;

/** Offset 0x00BF - Enable or Disable Fast MSR for IA32_HWP_REQUEST
  Enable or Disable Fast MSR for IA32_HWP_REQUEST. 0: Disable;<b>1: Enable</b>. For
  ICL CPU steppings below D0, set to 0.
  $EN_DIS
**/
  UINT8                       EnableFastMsrHwpReq;

/** Offset 0x00C0 - Minimum Ring ratio limit override
  Minimum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MinRingRatioLimit;

/** Offset 0x00C1 - Maximum Ring ratio limit override
  Maximum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MaxRingRatioLimit;

/** Offset 0x00C2 - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table.Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x00C3 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 1. Valid Range 0 to 128
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x00C4 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 2. Valid Range 0 to 128
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x00C5 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 3. Valid Range 0 to 128
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x00C6 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 1. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x00C7 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 2. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x00C8 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 3. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x00C9 - ConfigTdp mode settings Lock
  Lock the ConfigTdp mode settings from runtime changes; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x00CA - Load Configurable TDP SSDT
  Configure whether to load Configurable TDP SSDT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x00CB - Max P-State Ratio
  Max P-State Ratio, Valid Range 0 to 0x7F
**/
  UINT8                       MaxRatio;

/** Offset 0x00CC - P-state ratios for custom P-state table
  P-state ratios for custom P-state table. NumberOfEntries has valid range between
  0 to 40. For no. of P-States supported(NumberOfEntries) , StateRatio[NumberOfEntries]
  are configurable. Valid Range of each entry is 0 to 0x7F
**/
  UINT8                       StateRatio[40];

/** Offset 0x00F4 - Short term Power Limit value for custom cTDP level 1
  Short term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x00F8 - Long term Power Limit value for custom cTDP level 1
  Long term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x00FC - Short term Power Limit value for custom cTDP level 2
  Short term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x0100 - Long term Power Limit value for custom cTDP level 2
  Long term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x0104 - Short term Power Limit value for custom cTDP level 3
  Short term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x0108 - Long term Power Limit value for custom cTDP level 3
  Long term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x010C - PL1 Enable value
  PL1 Enable value to limit average platform power. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x010D - PL1 timewindow
  PL1 timewindow in seconds.Valid values(Unit in seconds) 0 to 8 , 10 , 12 ,14 , 16
  , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x010E - PL2 Enable Value
  PL2 Enable activates the PL2 value to limit average platform power.<b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x010F
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x0110 - Platform Power Pmax
  PCODE MMIO Mailbox: Platform Power Pmax. <b>0 - Auto</b> Specified in 1/8 Watt increments.
  Range 0-1024 Watts. Value of 800 = 100W
**/
  UINT16                      PsysPmax;

/** Offset 0x0112
**/
  UINT8                       UnusedUpdSpace6[2];

/** Offset 0x0114 - Platform PL1 power
  Platform PL1 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x0118 - Platform PL2 power
  Platform PL2 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x011C - Enable or Disable Intel SpeedStep Technology
  Enable or Disable Intel SpeedStep Technology. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x011D - Enable or Disable Energy Efficient P-state
  Enable or Disable Energy Efficient P-state will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x011E - Enable or Disable Energy Efficient Turbo
  Enable or Disable Energy Efficient Turbo, will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x011F - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x0120 - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x0121 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x0122 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x0123 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x0124 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       AutoThermalReporting;

/** Offset 0x0125 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x0126 - Enable or Disable CPU power states (C-states)
  Enable or Disable CPU power states (C-states). 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x0127 - Configure C-State Configuration Lock
  Configure C-State Configuration Lock; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x0128 - Enable or Disable Enhanced C-states
  Enable or Disable Enhanced C-states. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x0129 - Enable or Disable C1 Cstate Demotion
  Enable or Disable C1 Cstate Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateAutoDemotion;

/** Offset 0x012A - Enable or Disable C1 Cstate UnDemotion
  Enable or Disable C1 Cstate UnDemotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateUnDemotion;

/** Offset 0x012B - Enable or Disable Package Cstate Demotion
  Enable or Disable Package Cstate Demotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x012C - Enable or Disable Package Cstate UnDemotion
  Enable or Disable Package Cstate UnDemotion. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x012D - Enable or Disable CState-Pre wake
  Enable or Disable CState-Pre wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x012E - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x012F - Enable or Disable IO to MWAIT redirection
  Enable or Disable IO to MWAIT redirection; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x0130 - Set the Max Pkg Cstate
  Set the Max Pkg Cstate. Default set to Auto which limits the Max Pkg Cstate to deep
  C-state. Valid values 0 - C0/C1 , 1 - C2 , 2 - C3 , 3 - C6 , 4 - C7 , 5 - C7S ,
  6 - C8 , 7 - C9 , 8 - C10 , 254 - CPU Default , 255 - Auto
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x0131 - TimeUnit for C-State Latency Control1
  TimeUnit for C-State Latency Control1;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl1TimeUnit;

/** Offset 0x0132 - TimeUnit for C-State Latency Control2
  TimeUnit for C-State Latency Control2;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl2TimeUnit;

/** Offset 0x0133 - TimeUnit for C-State Latency Control3
  TimeUnit for C-State Latency Control3;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl3TimeUnit;

/** Offset 0x0134 - TimeUnit for C-State Latency Control4
  Time - 1ns , 1 - 32ns , 2 - 1024ns , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl4TimeUnit;

/** Offset 0x0135 - TimeUnit for C-State Latency Control5
  TimeUnit for C-State Latency Control5;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl5TimeUnit;

/** Offset 0x0136 - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select.0: Fixed priority; 1: Round robin;2: Hash vector;7:
  No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x0137 - Lock prochot configuration
  Lock prochot configuration Enable/Disable; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x0138 - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. (RTH is controlled
  through MSR 1FC bit 20)Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x0139 - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x013A - Interrupt Response Time Limit of C-State LatencyContol1
  Interrupt Response Time Limit of C-State LatencyContol1.Range of value 0 to 0x3FF.
  0 is Auto.
**/
  UINT16                      CstateLatencyControl1Irtl;

/** Offset 0x013C - Interrupt Response Time Limit of C-State LatencyContol2
  Interrupt Response Time Limit of C-State LatencyContol2.Range of value 0 to 0x3FF.
  0 is Auto.
**/
  UINT16                      CstateLatencyControl2Irtl;

/** Offset 0x013E - Interrupt Response Time Limit of C-State LatencyContol3
  Interrupt Response Time Limit of C-State LatencyContol3.Range of value 0 to 0x3FF.
  0 is Auto.
**/
  UINT16                      CstateLatencyControl3Irtl;

/** Offset 0x0140 - Interrupt Response Time Limit of C-State LatencyContol4
  Interrupt Response Time Limit of C-State LatencyContol4.Range of value 0 to 0x3FF.
  0 is Auto.
**/
  UINT16                      CstateLatencyControl4Irtl;

/** Offset 0x0142 - Interrupt Response Time Limit of C-State LatencyContol5. 0 is Auto.
  Interrupt Response Time Limit of C-State LatencyContol5.Range of value 0 to 0x3FF.
  0 is Auto.
**/
  UINT16                      CstateLatencyControl5Irtl;

/** Offset 0x0144 - P-state ratios for max 16 version of custom P-state table
  P-state ratios for max 16 version of custom P-state table. This table is used for
  OS versions limited to a max of 16 P-States. If the first entry of this table is
  0, or if Number of Entries is 16 or less, then this table will be ignored, and
  up to the top 16 values of the StateRatio table will be used instead. Valid Range
  of each entry is 0 to 0x7F
**/
  UINT8                       StateRatioMax16[16];

/** Offset 0x0154 - CpuBistData
  Pointer CPU BIST Data
**/
  UINT32                      CpuBistData;

/** Offset 0x0158 - CpuMpPpi
  Pointer for CpuMpPpi
**/
  UINT32                      CpuMpPpi;

/** Offset 0x015C - CpuMpHob
  Pointer for CpuMpHob. This is optional data buffer for CpuMpPpi usage.
**/
  UINT32                      CpuMpHob;

/** Offset 0x0160
**/
  UINT8                       CpuPostMemRsvd[16];

/** Offset 0x0170 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x0190 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x0194
**/
  UINT8                       UnusedUpdSpace7[4];

/** Offset 0x0198 - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x01A0 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x01A8 - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x01A9 - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x01AA
**/
  UINT8                       UnusedUpdSpace8[6];

/** Offset 0x01B0 - SgxEpoch0
  SgxEpoch0 default values
**/
  UINT64                      SgxEpoch0;

/** Offset 0x01B8 - SgxEpoch1
  SgxEpoch1 default values
**/
  UINT64                      SgxEpoch1;

/** Offset 0x01C0 - SgxSinitNvsData
  SgxSinitNvsData default values
**/
  UINT8                       SgxSinitNvsData;

/** Offset 0x01C1 - SgxSinitDataFromTpm
  SgxSinitDataFromTpm default values
**/
  UINT8                       SgxSinitDataFromTpm;

/** Offset 0x01C2
**/
  UINT8                       SecurityPostMemRsvd[16];

/** Offset 0x01D2 - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x01D3 - DEPRECATED SA CRID
  Deprecated, use FSPM_UPD.FspmConfig.CridEnable instead
  $EN_DIS
**/
  UINT8                       CridEnableDeprecated;

/** Offset 0x01D4 - Skip PAM register lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x01D5 - EDRAM Test Mode
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  0: EDRAM SW disable, 1: EDRAM SW Enable, 2: EDRAM HW mode
**/
  UINT8                       EdramTestMode;

/** Offset 0x01D6 - DMI ASPM
  0=Disable, 1:L0s, 2:L1, 3(Default)=L0sL1
  0:Disable, 1:L0s, 2:L1, 3:L0sL1
**/
  UINT8                       DmiAspm;

/** Offset 0x01D7 - PchDmiCwbEnable
  Central Write Buffer feature configurable and disabled by default. Enabled by default
  for ICP-N B-stepping onwards.
  $EN_DIS
**/
  UINT8                       PchDmiCwbEnable;

/** Offset 0x01D8 - DMI Extended Sync Control
  Enable: Enable DMI Extended Sync Control, Disable(Default): Disable DMI Extended
  Sync Control
  $EN_DIS
**/
  UINT8                       DmiExtSync;

/** Offset 0x01D9 - DMI IOT Control
  Enable: Enable DMI IOT Control, Disable(Default): Disable DMI IOT Control
  $EN_DIS
**/
  UINT8                       DmiIot;

/** Offset 0x01DA - PCIe DeEmphasis control per root port
  0: -6dB, 1(Default): -3.5dB
  0:-6dB, 1:-3.5dB
**/
  UINT8                       PegDeEmphasis[4];

/** Offset 0x01DE - PCIe Slot Power Limit value per root port
  Slot power limit value per root port
**/
  UINT8                       PegSlotPowerLimitValue[4];

/** Offset 0x01E2 - PCIe Slot Power Limit scale per root port
  Slot power limit scale per root port
  0:1.0x, 1:0.1x, 2:0.01x, 3:0x001x
**/
  UINT8                       PegSlotPowerLimitScale[4];

/** Offset 0x01E6 - PCIe Physical Slot Number per root port
  Physical Slot Number per root port
**/
  UINT16                      PegPhysicalSlotNumber[4];

/** Offset 0x01EE - PEG Max Payload size per root port
  0xFF(Default):Auto, 0x1: Force 128B, 0x2: Force 256B
  0xFF: Auto, 0x1: Force 128B, 0x2: Force 256B
**/
  UINT8                       PegMaxPayload[4];

/** Offset 0x01F2
**/
  UINT8                       UnusedUpdSpace9[2];

/** Offset 0x01F4 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x01F8 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT32                      LogoPtr;

/** Offset 0x01FC - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x0200 - Blt Buffer Address
  Address of Blt buffer
**/
  UINT32                      BltBufferAddress;

/** Offset 0x0204 - Blt Buffer Size
  Size of Blt Buffer, is equal to PixelWidth * PixelHeight * 4 bytes (the size of
  EFI_GRAPHICS_OUTPUT_BLT_PIXEL)
**/
  UINT32                      BltBufferSize;

/** Offset 0x0208 - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x0209 - CdClock Frequency selection
  0: (Default) Auto (Max based on reference clock frequency), 1: 172.8 Mhz, 2: 180
  Mhz, 3: 190 Mhz, 4: 307.2 Mhz, 5: 312 Mhz, 6: 552 Mhz, 7: 556.8 Mhz, 8: 648 Mhz,
  9: 652.8 Mhz
  0: Auto (Max based on reference clock frequency), 1: 172.8 Mhz, 2: 180 Mhz, 3: 190
  Mhz, 4: 307.2 Mhz, 5: 312 Mhz, 6: 552 Mhz, 7: 556.8 Mhz, 8: 648 Mhz, 9: 652.8 Mhz
**/
  UINT8                       CdClock;

/** Offset 0x020A - Enable/Disable PeiGraphicsPeimInit
  Enable: Enable PeiGraphicsPeimInit, Disable(Default): Disable PeiGraphicsPeimInit
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x020B - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x020C - Enable/Disable IGFX PmSupport
  Enable(Default): Enable IGFX PmSupport, Disable: Disable IGFX PmSupport
  $EN_DIS
**/
  UINT8                       PmSupport;

/** Offset 0x020D - Enable/Disable CdynmaxClamp
  Enable: Enable CdynmaxClamp, Disable(Default): Disable CdynmaxClamp
  $EN_DIS
**/
  UINT8                       CdynmaxClampEnable;

/** Offset 0x020E - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x020F - Disable Turbo GT
   0=Disable: GT frequency is not limited, 1=Enable: Disables Turbo GT frequency
  $EN_DIS
**/
  UINT8                       DisableTurboGt;

/** Offset 0x0210 - Enable/Disable CdClock Init
  Enable: Skip Full CD clock initializaton, Disable(Default): Initialize the full
  CD clock if not initialized by Gfx PEIM
  $EN_DIS
**/
  UINT8                       SkipCdClockInit;

/** Offset 0x0211 - Enable or disable HPD of DDI port-A device
  0=Disabled,1(Default)=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortAConfig;

/** Offset 0x0212 - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x0213 - Enable or disable HPD of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x0214 - Enable or disable HPD of DDI port 1
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Hpd;

/** Offset 0x0215 - Enable or disable HPD of DDI port 2
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Hpd;

/** Offset 0x0216 - Enable or disable HPD of DDI port 3
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Hpd;

/** Offset 0x0217 - Enable or disable HPD of DDI port 4
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Hpd;

/** Offset 0x0218 - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x0219 - Enable or disable DDC of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x021A - Enable DDC setting of DDI Port 1
  0=Disable, 1=DDC(Default)
  0: Disable, 1: DDC
**/
  UINT8                       DdiPort1Ddc;

/** Offset 0x021B - Enable DDC setting of DDI Port 2
  0=Disable, 1=DDC(Default)
  0: Disable, 1: DDC
**/
  UINT8                       DdiPort2Ddc;

/** Offset 0x021C - Enable DDC setting of DDI Port 3
  0=Disable, 1=DDC(Default)
  0: Disable, 1: DDC
**/
  UINT8                       DdiPort3Ddc;

/** Offset 0x021D - Enable DDC setting of DDI Port 4
  0=Disable, 1=DDC(Default)
  0: Disable, 1: DDC
**/
  UINT8                       DdiPort4Ddc;

/** Offset 0x021E - Enable or disable GNA device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GnaEnable;

/** Offset 0x021F - USB override in IOM
  This policy will enable/disable USB Connect override in IOM
  $EN_DIS
**/
  UINT8                       UsbOverride;

/** Offset 0x0220 - VCCST request for IOM
  This policy will enable/disable VCCST and also decides if message would be replayed in S4/S5
  $EN_DIS
**/
  UINT8                       VccSt;

/** Offset 0x0221 - Enable D3 Hot in TCSS
  This policy will enable/disable D3 hot support in IOM
  $EN_DIS
**/
  UINT8                       D3HotEnable;

/** Offset 0x0222 - Enable D3 Cold in TCSS
  This policy will enable/disable D3 cold support in IOM
  $EN_DIS
**/
  UINT8                       D3ColdEnable;

/** Offset 0x0223 - Enable/Disable PMC-PD Solution
  This policy will enable/disable PMC-PD Solution vs EC-TCPC Solution
  $EN_DIS
**/
  UINT8                       PmcPdEnable;

/** Offset 0x0224 - Enable/Disable PTM
  This policy will enable/disable Precision Time Measurement for TCSS PCIe Root Ports
  $EN_DIS
**/
  UINT8                       PtmEnabled[4];

/** Offset 0x0228 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       SaPcieItbtRpLtrEnable[4];

/** Offset 0x022C - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMode[4];

/** Offset 0x0230 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpSnoopLatencyOverrideMultiplier[4];

/** Offset 0x0234 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpSnoopLatencyOverrideValue[4];

/** Offset 0x023C - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMode[4];

/** Offset 0x0240 - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       SaPcieItbtRpNonSnoopLatencyOverrideMultiplier[4];

/** Offset 0x0244 - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      SaPcieItbtRpNonSnoopLatencyOverrideValue[4];

/** Offset 0x024C - Force LTR Override
  Force LTR Override.
**/
  UINT8                       SaPcieItbtRpForceLtrOverride[4];

/** Offset 0x0250 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       SaPcieItbtRpLtrConfigLock[4];

/** Offset 0x0254 - Enable VMD controller
  Enable/disable to VMD controller.
  $EN_DIS
**/
  UINT8                       VmdEnable;

/** Offset 0x0255 - Enable VMD portA Support
  Enable/disable to VMD portA Support.
  $EN_DIS
**/
  UINT8                       VmdPortA;

/** Offset 0x0256 - Enable VMD portB Support
  Enable/disable to VMD portB Support.
  $EN_DIS
**/
  UINT8                       VmdPortB;

/** Offset 0x0257 - Enable VMD portC Support
  Enable/disable to VMD portC Support.
  $EN_DIS
**/
  UINT8                       VmdPortC;

/** Offset 0x0258 - Enable VMD portD Support
  Enable/disable to VMD portD Support.
  $EN_DIS
**/
  UINT8                       VmdPortD;

/** Offset 0x0259 - VMD Config Bar size
  Set The VMD Config Bar Size.
**/
  UINT8                       VmdCfgBarSz;

/** Offset 0x025A - VMD Config Bar Attributes
  0: VMD_32BIT_NONPREFETCH, 1: VMD_64BIT_NONPREFETCH, 2: VMD_64BIT_PREFETCH(Default)
  0: VMD_32BIT_NONPREFETCH, 1: VMD_64BIT_NONPREFETCH, 2: VMD_64BIT_PREFETCH
**/
  UINT8                       VmdCfgBarAttr;

/** Offset 0x025B - VMD Mem Bar1 size
  Set The VMD Mem Bar1 Size.
**/
  UINT8                       VmdMemBarSz1;

/** Offset 0x025C - VMD Mem Bar1 Attributes
  0: VMD_32BIT_NONPREFETCH(Default), 1: VMD_64BIT_NONPREFETCH, 2: VMD_64BIT_PREFETCH
  0: VMD_32BIT_NONPREFETCH, 1: VMD_64BIT_NONPREFETCH, 2: VMD_64BIT_PREFETCH
**/
  UINT8                       VmdMemBar1Attr;

/** Offset 0x025D - VMD Mem Bar2 size
  Set The VMD Mem Bar2 Size.
**/
  UINT8                       VmdMemBarSz2;

/** Offset 0x025E - VMD Mem Bar2 Attributes
  0: VMD_32BIT_NONPREFETCH, 1: VMD_64BIT_NONPREFETCH(Default), 2: VMD_64BIT_PREFETCH
  0: VMD_32BIT_NONPREFETCH, 1: VMD_64BIT_NONPREFETCH, 2: VMD_64BIT_PREFETCH
**/
  UINT8                       VmdMemBar2Attr;

/** Offset 0x025F
**/
  UINT8                       UnusedUpdSpace10[1];

/** Offset 0x0260 - TypeC port GPIO setting
  GPIO Ping number for Type C Aux Oritation setting, use the GpioPad that is defined
  in GpioPinsXXXH.h and GpioPinsXXXLp.h as argument.(XXX is platform name, Ex: Icl
  = IceLake)
**/
  UINT32                      IomTypeCPortPadCfg[8];

/** Offset 0x0280 - TCSS Aux Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssAuxOri;

/** Offset 0x0282 - TCSS HSL Orientation Override Enable
  Bits 0, 2, ... 10 control override enables, bits 1, 3, ... 11 control overrides
**/
  UINT16                      TcssHslOri;

/** Offset 0x0284 - PCH USB OverCurrent mapping enable
  1: Will program USB OC pin mapping in xHCI controller memory, 0: Will clear OC pin
  mapping allow for NOA usage of OC pins
  $EN_DIS
**/
  UINT8                       PchUsbOverCurrentEnable;

/** Offset 0x0285 - CPU USB3 Port Over Current Pin
  Describe the specific over current pin number of USBC Port N.
**/
  UINT8                       CpuUsb3OverCurrentPin[8];

/** Offset 0x028D - TCSS USB Port Enable
  Bits 0, 1, ... max Type C port control enables
**/
  UINT8                       UsbTcPortEn;

/** Offset 0x028E
**/
  UINT8                       UnusedUpdSpace11[2];

/** Offset 0x0290 - ITBT DMA UUID
  TCSS DMA1, DMA2 UUID Number
**/
  UINT32                      IclAxITbtDmaUuid[2];

/** Offset 0x0298 - ITBT Root Port Enable
  ITBT Root Port Enable, 0:Disable, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       ITbtPcieRootPortEn[4];

/** Offset 0x029C - ITBTForcePowerOn Timeout value
  ITBTForcePowerOn value. Specified increment values in miliseconds. Range is 0-1000.
  100 = 100 ms.
**/
  UINT16                      ITbtForcePowerOnTimeoutInMs;

/** Offset 0x029E - ITbtConnectTopology Timeout value
  ITbtConnectTopologyTimeout value. Specified increment values in miliseconds. Range
  is 0-10000. 100 = 100 ms.
**/
  UINT16                      ITbtConnectTopologyTimeoutInMs;

/** Offset 0x02A0 - TcssXhciEnableComplianceMode
  Set Compliance Mode. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssXhciEnableComplianceMode;

/** Offset 0x02A1 - Enable/Disable PEG GEN3 Static EQ Phase1 programming
  Program Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static Presets
  Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       SaPcieGen3ProgramStaticEq;

/** Offset 0x02A2 - Enable/Disable GEN4 Static EQ Phase1 programming
  Program Gen4 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static Presets
  Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       SaPcieGen4ProgramStaticEq;

/** Offset 0x02A3 - TcssLoopbackModeBitMap
  Set Loopback Mode Bit Map. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssLoopbackModeBitMap;

/** Offset 0x02A4 - ITBT DMA UUID
  TCSS DMA1, DMA2 LTR value
**/
  UINT16                      ITbtDmaLtr[2];

/** Offset 0x02A8 - TypecRetimerTxComplianceModeEn
  Set type C retimer TX Compliance Mode. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TypecRetimerTxComplianceModeEn;

/** Offset 0x02A9
**/
  UINT8                       SaPostMemRsvd[2];

/** Offset 0x02AB - HECI3 state
  The HECI3 state from Mbp for reference in S3 path or when MbpHob is not installed.
  0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       Heci3Enabled;

/** Offset 0x02AC - ME Unconfig on RTC clear
  0: Disable ME Unconfig On Rtc Clear. <b>1: Enable ME Unconfig On Rtc Clear</b>.
  2: Cmos is clear, status unkonwn. 3: Reserved
  0: Disable ME Unconfig On Rtc Clear, 1: Enable ME Unconfig On Rtc Clear, 2: Cmos
  is clear, 3: Reserved
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x02AD - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Send in PEI(0x1):
  EOP send in PEI, Send in DXE(0x2)(Default): EOP send in DXE
  0:Disable, 1:Send in PEI, 2:Send in DXE, 3:Reserved
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x02AE - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x02AF - Mctp Broadcast Cycle
  Test, Determine if MCTP Broadcast is enabled <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       MctpBroadcastCycle;

/** Offset 0x02B0
**/
  UINT8                       MePostMemRsvd[10];

/** Offset 0x02BA - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x02BB - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer.
  $EN_DIS
**/
  UINT8                       WatchDog;

/** Offset 0x02BC - ASF Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable ASF functionality.
  $EN_DIS
**/
  UINT8                       AsfEnabled;

/** Offset 0x02BD - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x02BE - OS Timer
  16 bits Value, Set OS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x02C0 - BIOS Timer
  16 bits Value, Set BIOS watchdog timer.
  $EN_DIS
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x02C2 - Manageability Mode set by Mebx
  Enable/Disable. 0: Disable, 1: enable, Enable or disable  Manageability Mode.
  $EN_DIS
**/
  UINT8                       ManageabilityMode;

/** Offset 0x02C3 - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x02C4 - Remote Assistance Trigger Availablilty
  Enable/Disable. 0: Disable, 1: enable, Remote Assistance enable/disable state by Mebx
  $EN_DIS
**/
  UINT8                       RemoteAssistance;

/** Offset 0x02C5 - KVM Switch
  Enable/Disable. 0: Disable, 1: enable, KVM enable/disable state by Mebx
  $EN_DIS
**/
  UINT8                       AmtKvmEnabled;

/** Offset 0x02C6 - MEBX execution
  Enable/Disable. 0: Disable, 1: enable, Force MEBX execution
  $EN_DIS
**/
  UINT8                       ForcMebxSyncUp;

/** Offset 0x02C7
**/
  UINT8                       AmtPostMemRsvd[10];

/** Offset 0x02D1 - SPI0 Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:PchSerialIoCsActiveLow,
  1:PchSerialIoCsActiveHigh
**/
  UINT8                       SerialIoSpi0CsPolarity[2];

/** Offset 0x02D3 - SPI1 Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:PchSerialIoCsActiveLow,
  1:PchSerialIoCsActiveHigh
**/
  UINT8                       SerialIoSpi1CsPolarity[2];

/** Offset 0x02D5 - SPI2 Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:PchSerialIoCsActiveLow,
  1:PchSerialIoCsActiveHigh
**/
  UINT8                       SerialIoSpi2CsPolarity[2];

/** Offset 0x02D7 - SPI0 Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpi0CsEnable[2];

/** Offset 0x02D9 - SPI1 Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpi1CsEnable[2];

/** Offset 0x02DB - SPI2 Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpi2CsEnable[2];

/** Offset 0x02DD - SPIn Device Mode
  Selects SPI operation mode. N represents controller index: SPI0, SPI1, ... Available
  modes: 0:SerialIoSpiDisabled, 1:SerialIoSpiPci, 2:SerialIoSpiHidden
**/
  UINT8                       SerialIoSpiMode[3];

/** Offset 0x02E0 - SPIn Default Chip Select Output
  Sets Default CS as Output. N represents controller index: SPI0, SPI1, ... Available
  options: 0:CS0, 1:CS1
**/
  UINT8                       SerialIoSpiDefaultCsOutput[3];

/** Offset 0x02E3 - SPIn Default Chip Select Mode HW/SW
  Sets Default CS Mode Hardware or Software. N represents controller index: SPI0,
  SPI1, ... Available options: 0:HW, 1:SW
**/
  UINT8                       SerialIoSpiCsMode[3];

/** Offset 0x02E6 - SPIn Default Chip Select State Low/High
  Sets Default CS State Low or High. N represents controller index: SPI0, SPI1, ...
  Available options: 0:Low, 1:High
**/
  UINT8                       SerialIoSpiCsState[3];

/** Offset 0x02E9 - PCH SerialIo I2C Pads Termination
  0x0: Hardware default, 0x1: None, 0x13: 1kOhm weak pull-up, 0x15: 5kOhm weak pull-up,
  0x19: 20kOhm weak pull-up - Enable/disable SerialIo I2C0,I2C1,I2C2,I2C3,I2C4,I2C5
  pads termination respectively. One byte for each controller, byte0 for I2C0, byte1
  for I2C1, and so on.
**/
  UINT8                       PchSerialIoI2cPadsTermination[6];

/** Offset 0x02EF - I2Cn Device Mode
  Selects I2c operation mode. N represents controller index: I2c0, I2c1, ... Available
  modes: 0:SerialIoI2cDisabled, 1:SerialIoI2cPci, 2:SerialIoI2cHidden
**/
  UINT8                       SerialIoI2cMode[6];

/** Offset 0x02F5 - UARTn Device Mode
  Selects Uart operation mode. N represents controller index: Uart0, Uart1, ... Available
  modes: 0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartMode[3];

/** Offset 0x02F8 - Default BaudRate for each Serial IO UART
  Set default BaudRate Supported from 0 - default to 6000000
**/
  UINT32                      SerialIoUartBaudRate[3];

/** Offset 0x0304 - Default ParityType for each Serial IO UART
  Set default Parity. 0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartParity[3];

/** Offset 0x0307 - Default DataBits for each Serial IO UART
  Set default word length. 0: Default, 5,6,7,8
**/
  UINT8                       SerialIoUartDataBits[3];

/** Offset 0x030A - Default StopBits for each Serial IO UART
  Set default stop bits. 0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3:
  TwoStopBits
**/
  UINT8                       SerialIoUartStopBits[3];

/** Offset 0x030D - Power Gating mode for each Serial IO UART that works in COM mode
  Set Power Gating. 0: Disabled, 1: Enabled, 2: Auto
**/
  UINT8                       SerialIoUartPowerGating[3];

/** Offset 0x0310 - Enable Dma for each Serial IO UART that supports it
  Set DMA/PIO mode. 0: Disabled, 1: Enabled
**/
  UINT8                       SerialIoUartDmaEnable[3];

/** Offset 0x0313 - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS lines.
**/
  UINT8                       SerialIoUartAutoFlow[3];

/** Offset 0x0316
**/
  UINT8                       UnusedUpdSpace12[2];

/** Offset 0x0318 - SerialIoUartRxPinMux
  Select SerialIo Uart Rx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RX* for
  possible values.
**/
  UINT32                      SerialIoUartRxPinMux[3];

/** Offset 0x0324 - SerialIoUartTxPinMux
  Select SerialIo Uart Tx pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_TX* for
  possible values.
**/
  UINT32                      SerialIoUartTxPinMux[3];

/** Offset 0x0330 - SerialIoUartRtsPinMux
  Select SerialIo Uart Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartRtsPinMux[3];

/** Offset 0x033C - SerialIoUartCtsPinMux
  Select SerialIo Uart Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartCtsPinMux[3];

/** Offset 0x0348 - UART Number For Debug Purpose
  UART number for debug purpose. 0:UART0, 1: UART1, 2:UART2. Note: If UART0 is selected
  as CNVi BT Core interface, it cannot be used for debug purpose.
   0:UART0, 1:UART1, 2:UART2
**/
  UINT8                       SerialIoDebugUartNumber;

/** Offset 0x0349 - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x034A - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x034B - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x034C - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x034D - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x034E - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, 1: 12MHz, 2: 24MHz.
  0: 6MHz, 1: 12MHz, 2: 24MHz
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x034F - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x0350 - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 2: 4T, 3: 8T, 4: 16T
  0: 2T, 2: 4T, 3: 8T, 4: 16T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x0351 - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x0352 - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x0353 - PCH HDA Codec Sx Wake Capability
  Capability to detect wake initiated by a codec in Sx
**/
  UINT8                       PchHdaCodecSxWakeCapability;

/** Offset 0x0354 - HD Audio Reset Wait Timer
  The delay timer after Azalia reset, the value is number of microseconds. Default is 600.
**/
  UINT16                      PchHdaResetWaitTimer;

/** Offset 0x0356 - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x0357
**/
  UINT8                       UnusedUpdSpace13;

/** Offset 0x0358 - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT32                      PchHdaVerbTablePtr;

/** Offset 0x035C - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHda;

/** Offset 0x035D - Enable HD Audio DMIC0 Link
  Enable/disable HD Audio DMIC0 link. Muxed with SNDW4.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic0;

/** Offset 0x035E - Enable HD Audio DMIC1 Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic1;

/** Offset 0x035F - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP0/I2S link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp0;

/** Offset 0x0360 - Enable HD Audio SSP1 Link
  Enable/disable HD Audio SSP1/I2S link. Muxed with HDA/SNDW2.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp1;

/** Offset 0x0361 - Enable HD Audio SSP2 Link
  Enable/disable HD Audio SSP2/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp2;

/** Offset 0x0362 - Enable HD Audio SSP3 Link
  Enable/disable HD Audio SSP3/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp3;

/** Offset 0x0363 - Enable HD Audio SSP4 Link
  Enable/disable HD Audio SSP4/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp4;

/** Offset 0x0364 - Enable HD Audio SSP5 Link
  Enable/disable HD Audio SSP5/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp5;

/** Offset 0x0365 - Enable HD Audio SoundWire#1 Link
  Enable/disable HD Audio SNDW1 link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw1;

/** Offset 0x0366 - Enable HD Audio SoundWire#2 Link
  Enable/disable HD Audio SNDW2 link. Muxed with SSP1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw2;

/** Offset 0x0367 - Enable HD Audio SoundWire#3 Link
  Enable/disable HD Audio SNDW3 link. Muxed with DMIC1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw3;

/** Offset 0x0368 - Enable HD Audio SoundWire#4 Link
  Enable/disable HD Audio SNDW4 link. Muxed with DMIC0.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw4;

/** Offset 0x0369 - CNVi Configuration
  This option allows for automatic detection of Connectivity Solution. [Auto Detection]
  assumes that CNVi will be enabled when available, [Disable] allows for disabling CNVi.
  0:Disable, 1:Auto
**/
  UINT8                       CnviMode;

/** Offset 0x036A - CNVi BT Core
  Enable/Disable CNVi BT Core, Default is ENABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtCore;

/** Offset 0x036B - CNVi BT Audio Offload
  Enable/Disable BT Audio Offload, Default is DISABLE. 0: DISABLE, 1: ENABLE
  $EN_DIS
**/
  UINT8                       CnviBtAudioOffload;

/** Offset 0x036C - CNVi RF_RESET pin muxing
  Select CNVi RF_RESET# pin depending on board routing. ICP-LP: GPP_A8 = 0x2640E408(default)
  or GPP_F4 = 0x1645E404. ICP-H: 0. ICP-N: GPP_H12 = 0x2746E40C(default) or GPP_H1
  = 0x3746E401. Refer to GPIO_*_MUXING_CNVI_RF_RESET_* in GpioPins*.h.
**/
  UINT32                      CnviRfResetPinMux;

/** Offset 0x0370 - CNVi CLKREQ pin muxing
  Select CNVi CLKREQ pin depending on board routing. ICP-LP: GPP_A9 = 0x2640E609(default)
  or GPP_F5 = 0x2645E605. ICP-H: 0. ICP-N: GPP_H13 = 0x2746E60D(default) or GPP_H2
  = 0x3746E602. Refer to GPIO_*_MUXING_CNVI_MODEM_CLKREQ_* in GpioPins*.h.
**/
  UINT32                      CnviClkreqPinMux;

/** Offset 0x0374 - Espi Lgmr Memory Range decode
  This option enables or disables espi lgmr
  $EN_DIS
**/
  UINT8                       PchEspiLgmrEnable;

/** Offset 0x0375 - PCH eSPI Master and Slave BME enabled
  PCH eSPI Master and Slave BME enabled
  $EN_DIS
**/
  UINT8                       PchEspiBmeMasterSlaveEnabled;

/** Offset 0x0376 - Enable Host C10 reporting through eSPI
  Enable/disable Host C10 reporting to Slave via eSPI Virtual Wire.
  $EN_DIS
**/
  UINT8                       PchEspiHostC10ReportEnable;

/** Offset 0x0377 - Enable SdCard Controller
  Enable/disable SD Card Controller.
  $EN_DIS
**/
  UINT8                       ScsSdCardEnabled;

/** Offset 0x0378 - SdCard power enable polarity
  Choose SD_PWREN# polarity
  0: Active low, 1: Active high
**/
  UINT8                       SdCardPowerEnableActiveHigh;

/** Offset 0x0379 - Use tuned DLL values from policy
  Set if FSP should use HS400 DLL values from policy
  $EN_DIS
**/
  UINT8                       SdCardUseCustomDlls;

/** Offset 0x037A
**/
  UINT8                       UnusedUpdSpace14[2];

/** Offset 0x037C - SdCard Tx CMD Delay control register value
  Please see Tx CMD Delay Control register definition for help
**/
  UINT32                      SdCardTxCmdDelayRegValue;

/** Offset 0x0380 - SdCard Tx DATA Delay control 1 register value
  Please see Tx DATA Delay control 1 register definition for help
**/
  UINT32                      SdCardTxDataDelay1RegValue;

/** Offset 0x0384 - SdCard Tx DATA Delay control 2 register value
  Please see Tx DATA Delay control 2 register definition for help
**/
  UINT32                      SdCardTxDataDelay2RegValue;

/** Offset 0x0388 - SdCard Rx CMD + DATA Delay control 1 register value
  Please see Rx CMD + DATA Delay control 1 register definition for help
**/
  UINT32                      SdCardRxCmdDataDelay1RegValue;

/** Offset 0x038C - SdCard Rx CMD + DATA Delay control 2 register value
  Please see Rx CMD + DATA Delay control 2 register definition for help
**/
  UINT32                      SdCardRxCmdDataDelay2RegValue;

/** Offset 0x0390 - Enable eMMC Controller
  Enable/disable eMMC Controller.
  $EN_DIS
**/
  UINT8                       ScsEmmcEnabled;

/** Offset 0x0391 - Enable eMMC HS400 Mode
  Enable eMMC HS400 Mode.
  $EN_DIS
**/
  UINT8                       ScsEmmcHs400Enabled;

/** Offset 0x0392 - Use DLL values from policy
  Set if FSP should use HS400 DLL values from policy
  $EN_DIS
**/
  UINT8                       EmmcUseCustomDlls;

/** Offset 0x0393
**/
  UINT8                       UnusedUpdSpace15;

/** Offset 0x0394 - Emmc Tx CMD Delay control register value
  Please see Tx CMD Delay Control register definition for help
**/
  UINT32                      EmmcTxCmdDelayRegValue;

/** Offset 0x0398 - Emmc Tx DATA Delay control 1 register value
  Please see Tx DATA Delay control 1 register definition for help
**/
  UINT32                      EmmcTxDataDelay1RegValue;

/** Offset 0x039C - Emmc Tx DATA Delay control 2 register value
  Please see Tx DATA Delay control 2 register definition for help
**/
  UINT32                      EmmcTxDataDelay2RegValue;

/** Offset 0x03A0 - Emmc Rx CMD + DATA Delay control 1 register value
  Please see Rx CMD + DATA Delay control 1 register definition for help
**/
  UINT32                      EmmcRxCmdDataDelay1RegValue;

/** Offset 0x03A4 - Emmc Rx CMD + DATA Delay control 2 register value
  Please see Rx CMD + DATA Delay control 2 register definition for help
**/
  UINT32                      EmmcRxCmdDataDelay2RegValue;

/** Offset 0x03A8 - Emmc Rx Strobe Delay control register value
  Please see Rx Strobe Delay control register definition for help
**/
  UINT32                      EmmcRxStrobeDelayRegValue;

/** Offset 0x03AC - UFS enable/disable
  Please see Rx Strobe Delay control register definition for help
  $EN_DIS
**/
  UINT8                       UfsEnable[2];

/** Offset 0x03AE - Enable PCH ISH SPI GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshSpiGpioAssign;

/** Offset 0x03AF - Enable PCH ISH UART0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart0GpioAssign;

/** Offset 0x03B0 - Enable PCH ISH UART1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart1GpioAssign;

/** Offset 0x03B1 - Enable PCH ISH I2C0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c0GpioAssign;

/** Offset 0x03B2 - Enable PCH ISH I2C1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c1GpioAssign;

/** Offset 0x03B3 - Enable PCH ISH I2C2 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c2GpioAssign;

/** Offset 0x03B4 - Enable PCH ISH GP_0 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp0GpioAssign;

/** Offset 0x03B5 - Enable PCH ISH GP_1 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp1GpioAssign;

/** Offset 0x03B6 - Enable PCH ISH GP_2 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp2GpioAssign;

/** Offset 0x03B7 - Enable PCH ISH GP_3 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp3GpioAssign;

/** Offset 0x03B8 - Enable PCH ISH GP_4 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp4GpioAssign;

/** Offset 0x03B9 - Enable PCH ISH GP_5 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp5GpioAssign;

/** Offset 0x03BA - Enable PCH ISH GP_6 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp6GpioAssign;

/** Offset 0x03BB - Enable PCH ISH GP_7 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp7GpioAssign;

/** Offset 0x03BC - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x03BD - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x03BE - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x03BF - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x03C0 - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x03C1 - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x03C2 - SATA LED
  SATA LED indicating SATA controller activity. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       SataLedEnable;

/** Offset 0x03C3 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x03C4 - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x03C5 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x03CD - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x03D5 - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x03DD - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x03E5 - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x03ED - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x03F5 - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x03FD - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x0405 - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x040D
**/
  UINT8                       UnusedUpdSpace16[1];

/** Offset 0x040E - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x041E - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x0426 - PCH Sata Rst Raid Alternate Id
  Enable RAID Alternate ID.
  $EN_DIS
**/
  UINT8                       SataRstRaidDeviceId;

/** Offset 0x0427 - PCH Sata Rst Raid0
  RAID0.
  $EN_DIS
**/
  UINT8                       SataRstRaid0;

/** Offset 0x0428 - PCH Sata Rst Raid1
  RAID1.
  $EN_DIS
**/
  UINT8                       SataRstRaid1;

/** Offset 0x0429 - PCH Sata Rst Raid10
  RAID10.
  $EN_DIS
**/
  UINT8                       SataRstRaid10;

/** Offset 0x042A - PCH Sata Rst Raid5
  RAID5.
  $EN_DIS
**/
  UINT8                       SataRstRaid5;

/** Offset 0x042B - PCH Sata Rst Irrt
  Intel Rapid Recovery Technology.
  $EN_DIS
**/
  UINT8                       SataRstIrrt;

/** Offset 0x042C - PCH Sata Rst Orom Ui Banner
  OROM UI and BANNER.
  $EN_DIS
**/
  UINT8                       SataRstOromUiBanner;

/** Offset 0x042D - PCH Sata Rst Orom Ui Delay
  00b: 2 secs; 01b: 4 secs; 10b: 6 secs; 11: 8 secs (see: PCH_SATA_OROM_DELAY).
**/
  UINT8                       SataRstOromUiDelay;

/** Offset 0x042E - PCH Sata Rst Hdd Unlock
  Indicates that the HDD password unlock in the OS is enabled.
  $EN_DIS
**/
  UINT8                       SataRstHddUnlock;

/** Offset 0x042F - PCH Sata Rst Led Locate
  Indicates that the LED/SGPIO hardware is attached and ping to locate feature is
  enabled on the OS.
  $EN_DIS
**/
  UINT8                       SataRstLedLocate;

/** Offset 0x0430 - PCH Sata Rst Irrt Only
  Allow only IRRT drives to span internal and external ports.
  $EN_DIS
**/
  UINT8                       SataRstIrrtOnly;

/** Offset 0x0431 - PCH Sata Rst Smart Storage
  RST Smart Storage caching Bit.
  $EN_DIS
**/
  UINT8                       SataRstSmartStorage;

/** Offset 0x0432 - SATA RST Interrupt Mode
  Allowes to choose which interrupts will be implemented by SATA controller in RAID mode.
  0:Msix, 1:Msi, 2:Legacy
**/
  UINT8                       SataRstInterrupt;

/** Offset 0x0433 - PCH Sata Rst Optane Memory
  Optane Memory
  $EN_DIS
**/
  UINT8                       SataRstOptaneMemory;

/** Offset 0x0434 - PCH SATA use RST Legacy OROM
  Use PCH SATA RST Legacy OROM when CSM is Enabled
  $EN_DIS
**/
  UINT8                       SataRstLegacyOrom;

/** Offset 0x0435 - PCH Sata Rst CPU Attached Storage
  CPU Attached Storage
  $EN_DIS
**/
  UINT8                       SataRstCpuAttachedStorage;

/** Offset 0x0436 - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x0439 - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x043C - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x043F - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x0440 - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x0441 - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x0442 - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x0443 - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x0444 - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x0445 - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x0446 - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x0447 - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x0448 - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x0449 - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x044A - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x044B - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x044C - Enable xHCI Compliance Mode
  Compliance Mode can be enabled for testing through this option but this is disabled
  by default.
  $EN_DIS
**/
  UINT8                       PchEnableComplianceMode;

/** Offset 0x044D - USB PDO Programming
  Enable/disable PDO programming for USB in PEI phase. Disabling will allow for programming
  during later phase. 1: enable, 0: disable
  $EN_DIS
**/
  UINT8                       UsbPdoProgramming;

/** Offset 0x044E - USB Overcurrent Override for DbC
  This option overrides USB Over Current enablement state that USB OC will be disabled
  after enabling this option. Enable when DbC is used to avoid signaling conflicts.
  $EN_DIS
**/
  UINT8                       PchEnableDbcObs;

/** Offset 0x044F - PCH USB OverCurrent mapping lock enable
  If this policy option is enabled then BIOS will program OCCFDONE bit in xHCI meaning
  that OC mapping data will be consumed by xHCI and OC mapping registers will be locked.
  $EN_DIS
**/
  UINT8                       PchXhciOcLock;

/** Offset 0x0450 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x0460 - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x0470 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x047A - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x0484 - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x0485 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2PhyPetxiset[16];

/** Offset 0x0495 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2PhyTxiset[16];

/** Offset 0x04A5 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2PhyPredeemp[16];

/** Offset 0x04B5 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2PhyPehalfbit[16];

/** Offset 0x04C5 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x04CF - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x04D9 - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x04E3 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x04ED
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfgEnable[10];

/** Offset 0x04F7
**/
  UINT8                       PchUsb3HsioFilterSelNEnable[10];

/** Offset 0x0501
**/
  UINT8                       PchUsb3HsioFilterSelPEnable[10];

/** Offset 0x050B
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnResEnable[10];

/** Offset 0x0515
**/
  UINT8                       PchUsb3HsioCtrlAdaptOffsetCfg[10];

/** Offset 0x051F
**/
  UINT8                       PchUsb3HsioOlfpsCfgPullUpDwnRes[10];

/** Offset 0x0529
**/
  UINT8                       PchUsb3HsioFilterSelN[10];

/** Offset 0x0533
**/
  UINT8                       PchUsb3HsioFilterSelP[10];

/** Offset 0x053D - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[24];

/** Offset 0x0555 - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
**/
  UINT8                       PcieRpPmSci[24];

/** Offset 0x056D - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[24];

/** Offset 0x0585 - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[24];

/** Offset 0x059D - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[24];

/** Offset 0x05B5 - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[24];

/** Offset 0x05CD - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[24];

/** Offset 0x05E5 - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[24];

/** Offset 0x05FD - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[24];

/** Offset 0x0615 - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[24];

/** Offset 0x062D - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[24];

/** Offset 0x0645 - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[24];

/** Offset 0x065D - PCIE RP Max Payload
  Max Payload Size supported, Default 128B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[24];

/** Offset 0x0675
**/
  UINT8                       UnusedUpdSpace17[3];

/** Offset 0x0678 - DPC for PCIE RP Mask
  Enable/disable Downstream Port Containment for PCIE Root Ports. 0: disable, 1: enable.
  One bit for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpDpcMask;

/** Offset 0x067C - DPC Extensions PCIE RP Mask
  Enable/disable DPC Extensions for PCIE Root Ports. 0: disable, 1: enable. One bit
  for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpDpcExtensionsMask;

/** Offset 0x0680 - PTM for PCIE RP Mask
  Enable/disable Precision Time Measurement for PCIE Root Ports. 0: disable, 1: enable.
  One bit for each port, bit0 for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpPtmMask;

/** Offset 0x0684 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCH_PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[24];

/** Offset 0x069C - PCIE RP Gen3 Equalization Phase Method
  PCIe Gen3 Eq Ph3 Method (see PCH_PCIE_EQ_METHOD). 0: DEPRECATED, hardware equalization;
  1: hardware equalization; 4: Fixed Coeficients.
**/
  UINT8                       PcieRpGen3EqPh3Method[24];

/** Offset 0x06B4 - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[24];

/** Offset 0x06CC - PCH PCIe root port connection type
  0: built-in device, 1:slot
**/
  UINT8                       PcieRpSlotImplemented[24];

/** Offset 0x06E4 - PCIE RP Completion Timeout
  The root port completion timeout(see: PCH_PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[24];

/** Offset 0x06FC - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[24];

/** Offset 0x0714 - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[24];

/** Offset 0x072C - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[24];

/** Offset 0x0744 - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[24];

/** Offset 0x075C - PCIE RP Access Control Services Extended Capability
  Enable/Disable PCIE RP Access Control Services Extended Capability
**/
  UINT8                       PcieRpAcsEnabled[24];

/** Offset 0x0774 - PCIE RP Clock Power Management
  Enable/Disable PCIE RP Clock Power Management, even if disabled, CLKREQ# signal
  can still be controlled by L1 PM substates mechanism
**/
  UINT8                       PcieRpEnableCpm[24];

/** Offset 0x078C - PCIE RP Detect Timeout Ms
  The number of milliseconds within 0~65535 in reference code will wait for link to
  exit Detect state for enabled ports before assuming there is no device and potentially
  disabling the port.
**/
  UINT16                      PcieRpDetectTimeoutMs[24];

/** Offset 0x07BC - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[24];

/** Offset 0x07EC - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[24];

/** Offset 0x081C - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[24];

/** Offset 0x0834 - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[24];

/** Offset 0x084C - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[24];

/** Offset 0x087C - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[24];

/** Offset 0x0894 - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[24];

/** Offset 0x08AC - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[24];

/** Offset 0x08DC - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[24];

/** Offset 0x08F4 - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[24];

/** Offset 0x0924 - PCIE RP Upstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 5.
**/
  UINT8                       PcieRpUptp[24];

/** Offset 0x093C - PCIE RP Downstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 7.
**/
  UINT8                       PcieRpDptp[24];

/** Offset 0x0954 - Usage type for ClkSrc
  0-23: PCH rootport, 0x40-0x43: PEG port, 0x70:LAN, 0x80: unspecified but in use
  (free running), 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[16];

/** Offset 0x0964 - ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[16];

/** Offset 0x0974 - PCIE Eq Ph3 Lane Param Cm
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C-1.
**/
  UINT8                       PcieEqPh3LaneParamCm[24];

/** Offset 0x098C - PCIE Eq Ph3 Lane Param Cp
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C+1.
**/
  UINT8                       PcieEqPh3LaneParamCp[24];

/** Offset 0x09A4 - PCIE Sw Eq CoeffList Cm
  PCH_PCIE_EQ_PARAM. Coefficient C-1.The values depend on PcieNumOfCoefficients, the
  default value of PcieNumOfCoefficients is 3 hence only first 3 values are considered
**/
  UINT8                       PcieSwEqCoeffListCm[5];

/** Offset 0x09A9 - PCIE Sw Eq CoeffList Cp
  PCH_PCIE_EQ_PARAM. Coefficient C+1.The values depend on PcieNumOfCoefficients, the
  default value of PcieNumOfCoefficients is 3 hence only first 3 values are considered
**/
  UINT8                       PcieSwEqCoeffListCp[5];

/** Offset 0x09AE - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x09AF - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x09B0 - PCIE Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite;

/** Offset 0x09B1 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x09B2 - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x09B3 - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x09B4 - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x09B8 - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x09C0 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x09C1 - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x09C2 - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x09C3 - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x09C4 - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x09C5 - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x09C6 - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x09C7 - RTC CMOS MEMORY LOCK
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       PchLockDownRtcMemoryLock;

/** Offset 0x09C8 - Unlock all GPIO pads
  Force all GPIO pads to be unlocked for debug purpose.
  $EN_DIS
**/
  UINT8                       PchUnlockGpioPads;

/** Offset 0x09C9 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x09CA - Pch Dmi Aspm Ctrl
  ASPM configuration on the PCH side of the DMI/OPI Link. Default is <b>PchPcieAspmAutoConfig</b>
  0:Disabled, 1:L0s, 2:L1, 3:L0sL1, 4:Auto
**/
  UINT8                       PchDmiAspmCtrl;

/** Offset 0x09CB - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x09D0 - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x09D5
**/
  UINT8                       UnusedUpdSpace18[1];

/** Offset 0x09D6 - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x09E0 - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x09EA - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x09EB - Enable 8254 Static Clock Gating
  Set 8254CGE=1 is required for SLP_S0 support. However, set 8254CGE=1 in POST time
  might fail to boot legacy OS using 8254 timer. Make sure it is disabled to support
  legacy OS using 8254 timer. Also enable this while S0ix is enabled.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGating;

/** Offset 0x09EC - Enable 8254 Static Clock Gating On S3
  This is only applicable when Enable8254ClockGating is disabled. FSP will do the
  8254 CGE programming on S3 resume when Enable8254ClockGatingOnS3 is enabled. This
  avoids the SMI requirement for the programming.
  $EN_DIS
**/
  UINT8                       Enable8254ClockGatingOnS3;

/** Offset 0x09ED - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x09EE - PCH Unlock SideBand access
  The SideBand PortID mask for certain end point (e.g. PSFx) will be locked before
  3rd party code execution. 0: Lock SideBand access; 1: Unlock SideBand access.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x09EF - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x09F0 - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x09F1 - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x09F2 - PCH Pm Pcie Wake From DeepSx
  Determine if enable PCIe to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmPcieWakeFromDeepSx;

/** Offset 0x09F3 - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x09F4 - PCH Pm WoW lan DeepSx Enable
  Determine if WLAN wake from DeepSx, corresponds to the DSX_WLAN_PP_EN bit in the
  PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanDeepSxEnable;

/** Offset 0x09F5 - PCH Pm Lan Wake From DeepSx
  Determine if enable LAN to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmLanWakeFromDeepSx;

/** Offset 0x09F6 - PCH Pm Deep Sx Pol
  Deep Sx Policy.
  $EN_DIS
**/
  UINT8                       PchPmDeepSxPol;

/** Offset 0x09F7 - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x09F8 - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x09F9 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x09FA - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x09FB - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x09FC - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x09FD - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x09FE - PCH Energy Reporting
  Disable/Enable PCH to CPU energy report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x09FF - PCH Pm Disable Dsx Ac Present Pulldown
  When Disable, PCH will internal pull down AC_PRESENT in deep SX and during G3 exit.
  $EN_DIS
**/
  UINT8                       PchPmDisableDsxAcPresentPulldown;

/** Offset 0x0A00 - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x0A01
**/
  UINT8                       UnusedUpdSpace19[3];

/** Offset 0x0A04 - Power button debounce configuration
  Debounce time for PWRBTN in microseconds. For values not supported by HW, they will
  be rounded down to closest supported on. 0: disable, 250-1024000us: supported range
**/
  UINT32                      PmcPowerButtonDebounceTime;

/** Offset 0x0A08 - Disable Power Button debounce in PMC module
  Disable Power Button debounce for PWRBTN in PMC module. '0': The 16ms debounce period
  applies to all usages of the PWRBTN# pin (legacy behavior). '1': When a falling
  edge occurs on the PWRBTN# pin, an interrupt is generated and the 16ms debounce
  timer starts. Subsequent interrupts are masked while the debounce timer is running.
**/
  UINT8                       PmcDisablePowerButtonDebounce;

/** Offset 0x0A09 - PCH Pm Slp S0 Enable
  Indicates whether SLP_S0# is to be asserted when PCH reaches idle state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Enable;

/** Offset 0x0A0A - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x0A0B - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x0A0C - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x0A0D - VRAlert# Pin
  When VRAlert# feature pin is enabled and its state is '0', the PMC requests throttling
  to a T3 Tstate to the PCH throttling unit.. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchPmVrAlert;

/** Offset 0x0A0E - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x0A0F - PCH Pm Pcie Pll Ssc
  Specifies the Pcie Pll Spread Spectrum Percentage. The default is 0xFF: AUTO - No
  BIOS override.
**/
  UINT8                       PchPmPciePllSsc;

/** Offset 0x0A10 - S0i3 support
  S0i3 platform support. When enabled ASL code is used to determine if platform can
  go to S0i2 or S0i3 state. 0:Disable(S0i2 only), 1:Enable (Runtime in ASL)
  $EN_DIS
**/
  UINT8                       PchPmS0i3Support;

/** Offset 0x0A11 - SLP_S0# Override
  DEPRECATED
  0:Disabled, 1:Enabled
**/
  UINT8                       SlpS0Override;

/** Offset 0x0A12 - S0ix Override Settings
  DEPRECATED
  0:No Change, 1:DCI OOB, 2:USB2 DbC
**/
  UINT8                       SlpS0DisQForDebug;

/** Offset 0x0A13 - PMC Debug Message Enable
  When Enabled, PMC HW will send debug messages to trace hub; When Disabled, PMC HW
  will never send debug meesages to trace hub. Noted: When Enabled, may not enter S0ix
  $EN_DIS
**/
  UINT8                       PmcDbgMsgEn;

/** Offset 0x0A14 - Pointer of ChipsetInit format v2 Binary
  ChipsetInit Binary format v2 Pointer.
**/
  UINT32                      ChipsetInitBinPtr;

/** Offset 0x0A18 - Length of ChipsetInit format v2 Binary
  ChipsetInit Binary format v2 Length.
**/
  UINT32                      ChipsetInitBinLen;

/** Offset 0x0A1C - Enable PS_ON.
  PS_ON is a new C10 state from the CPU on desktop SKUs that enables a lower power
  target that will be required by the California Energy Commission (CEC). When FALSE,
  PS_ON is to be disabled.
  $EN_DIS
**/
  UINT8                       PsOnEnable;

/** Offset 0x0A1D - Pmc Cpu C10 Gate Pin Enable
  Enable/Disable platform support for CPU_C10_GATE# pin to control gating of CPU VccIO
  and VccSTG rails instead of SLP_S0# pin.
  $EN_DIS
**/
  UINT8                       PmcCpuC10GatePinEnable;

/** Offset 0x0A1E - ModPHY SUS Power Domain Dynamic Gating
  Enable/Disable ModPHY SUS Power Domain Dynamic Gating. Setting not supported on
  PCH-H. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PmcModPhySusPgEnable;

/** Offset 0x0A1F - PCH USB2 PHY Power Gating enable
  1: Will enable USB2 PHY SUS Well Power Gating, 0: Will not enable PG of USB2 PHY
  Sus Well PG
  $EN_DIS
**/
  UINT8                       PmcUsb2PhySusPgEnable;

/** Offset 0x0A20 - OS IDLE Mode Enable
  Enable/Disable OS Idle Mode (PCH-N and PCH-H only)
  $EN_DIS
**/
  UINT8                       PmcOsIdleEnable;

/** Offset 0x0A21 - Enable PMC CrashLog
  Enable or Disable PMC CrashLog; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmcCrashLogEnable;

/** Offset 0x0A22 - Enable CPPM Forced Alignment
  Enable or Disable CPPM Forced Alignment; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       ForcedAlignmentEnable;

/** Offset 0x0A23 - PCHHOT# pin
  Enable PCHHOT# pin assertion when temperature is higher than PchHotLevel. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       PchHotEnable;

/** Offset 0x0A24 - Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x0A26 - Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x0A28 - Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x0A2A - Enable The Thermal Throttle
  Enable the thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x0A2B - PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x0A2C - Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x0A2D - Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       TTSuggestedSetting;

/** Offset 0x0A2E - Enable PCH Cross Throttling
  Enable/Disable PCH Cross Throttling
  $EN_DIS
**/
  UINT8                       TTCrossThrottling;

/** Offset 0x0A2F - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x0A30 - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x0A31 - Thermal Sensor 0 Target Width
  Thermal Sensor 0 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS0TW;

/** Offset 0x0A32 - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS1TW;

/** Offset 0x0A33 - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS2TW;

/** Offset 0x0A34 - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
  0:x1, 1:x2, 2:x4, 3:x8, 4:x16
**/
  UINT8                       DmiTS3TW;

/** Offset 0x0A35 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
  $EN_DIS
**/
  UINT8                       PchMemoryThrottlingEnable;

/** Offset 0x0A36 - Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPmsyncEnable[2];

/** Offset 0x0A38 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryC0TransmitEnable[2];

/** Offset 0x0A3A - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPinSelection[2];

/** Offset 0x0A3C - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x0A3E - Mask to enable the usage of external V1p05 VR rail in specific S0ix or Sx states
  Enable External V1P05 Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5,
  Default is set to 0x1F for ICL-UN/YN and 0 for all other skus.
**/
  UINT8                       PchFivrExtV1p05RailEnabledStates;

/** Offset 0x0A3F
**/
  UINT8                       UnusedUpdSpace20;

/** Offset 0x0A40 - External V1P05 Voltage Value that will be used in S0i2/S0i3 states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtV1p05RailVoltage;

/** Offset 0x0A42 - External V1P05 Icc Max Value
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtV1p05RailIccMax;

/** Offset 0x0A43 - Mask to enable the usage of external Vnn VR rail in specific S0ix or Sx states
  Enable External Vnn Rail in: BIT0:S0i1/S0i2, BIT1:S0i3, BIT2:S3, BIT3:S4, BIT5:S5,
  Default is set to 0x1F for ICL-UN/YN and 0 for all other skus.
**/
  UINT8                       PchFivrExtVnnRailEnabledStates;

/** Offset 0x0A44 - External Vnn Voltage Value that will be used in S0ix/Sx states
  Value is given in 2.5mV increments (0=0mV, 1=2.5mV, 2=5mV...), Default is set to 420
**/
  UINT16                      PchFivrExtVnnRailVoltage;

/** Offset 0x0A46 - External Vnn Icc Max Value that will be used in S0ix/Sx states
  Granularity of this setting is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailIccMax;

/** Offset 0x0A47 - Mask to enable the usage of external Vnn VR rail in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Enable External Vnn Rail in
  Sx: BIT0-1:Reserved, BIT2:S3, BIT3:S4, BIT5:S5, Default is set to 0x1C for ICL-UN/YN
  and 0 for all other skus.
**/
  UINT8                       PchFivrExtVnnRailSxEnabledStates;

/** Offset 0x0A48 - External Vnn Voltage Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Value is given in 2.5mV increments
  (0=0mV, 1=2.5mV, 2=5mV...)
**/
  UINT16                      PchFivrExtVnnRailSxVoltage;

/** Offset 0x0A4A - External Vnn Icc Max Value that will be used in Sx states
  Use only if Ext Vnn Rail config is different in Sx. Granularity of this setting
  is 1mA and maximal possible value is 200mA
**/
  UINT8                       PchFivrExtVnnRailSxIccMax;

/** Offset 0x0A4B - Transition time in microseconds from Low Current Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to low current mode voltage
**/
  UINT8                       PchFivrVccinAuxLowToHighCurModeVolTranTime;

/** Offset 0x0A4C - Transition time in microseconds from Retention Mode Voltage to High Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage
**/
  UINT8                       PchFivrVccinAuxRetToHighCurModeVolTranTime;

/** Offset 0x0A4D - Transition time in microseconds from Retention Mode Voltage to Low Current Mode Voltage
  This field has 1us resolution. When value is 0 PCH will not transition VCCIN_AUX
  to retention mode voltage
**/
  UINT8                       PchFivrVccinAuxRetToLowCurModeVolTranTime;

/** Offset 0x0A4E - Transition time in microseconds from Off (0V) to High Current Mode Voltage
  This field has 1us resolution. When value is 0 Transition to 0V is disabled
**/
  UINT16                      PchFivrVccinAuxOffToHighCurModeVolTranTime;

/** Offset 0x0A50 - FIVR Dynamic Power Management
  Enable/Disable FIVR Dynamic Power Management.
  $EN_DIS
**/
  UINT8                       PchFivrDynPm;

/** Offset 0x0A51 - Serial IO UART DBG2 table
  Enable or disable Serial Io UART DBG2 table, default is Disable; <b>0: Disable;</b>
  1: Enable.
**/
  UINT8                       SerialIoUartDbg2[3];

/** Offset 0x0A54 - Trace Hub Memory Base
  If Trace Hub is enabled and trace to memory is desired, BootLoader needs to allocate
  trace hub memory as reserved and uncacheable, set the base to ensure Trace Hub
  memory is configured properly.
**/
  UINT32                      TraceHubMemBase;

/** Offset 0x0A58 - DEPRECATED ITSS IRQ Polarity.
  DEPRECATED Configuration for ITSS IPC[0-3] registers.
**/
  UINT32                      ItssIrqPolarity[4];

/** Offset 0x0A68 - PCH PMC Energy Report Debug mode
  Disable/Enable Energy Reporting Debug Mode.
  $EN_DIS
**/
  UINT8                       PchPmEnergyReportDebugMode;

/** Offset 0x0A69 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 3, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTranEnable[10];

/** Offset 0x0A73 - USB 3.0 TX Output Unique Transition Bit Scale for rate 3
  USB 3.0 TX Output Unique Transition Bit Scale for rate 3, HSIO_TX_DWORD9[6:0], <b>Default
  = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate3UniqTran[10];

/** Offset 0x0A7D - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 2, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTranEnable[10];

/** Offset 0x0A87 - USB 3.0 TX Output Unique Transition Bit Scale for rate 2
  USB 3.0 TX Output Unique Transition Bit Scale for rate 2, HSIO_TX_DWORD9[14:8],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate2UniqTran[10];

/** Offset 0x0A91 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 1, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTranEnable[10];

/** Offset 0x0A9B - USB 3.0 TX Output Unique Transition Bit Scale for rate 1
  USB 3.0 TX Output Unique Transition Bit Scale for rate 1, HSIO_TX_DWORD9[22:16],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate1UniqTran[10];

/** Offset 0x0AA5 - Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0
  Enable the write to USB 3.0 TX Output Unique Transition Bit Mode for rate 0, Each
  value in array can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTranEnable[10];

/** Offset 0x0AAF - USB 3.0 TX Output Unique Transition Bit Scale for rate 0
  USB 3.0 TX Output Unique Transition Bit Scale for rate 0, HSIO_TX_DWORD9[30:24],
  <b>Default = 4Ch</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxRate0UniqTran[10];

/** Offset 0x0AB9 - Hybrid Storage Detection and Configuration Mode
  Enables support for Hybrid storage devices. 0: Disabled; 1: Dynamic Configuration.
  Default is 0: Disabled
  0: Disabled, 1: Dynamic Configuration
**/
  UINT8                       HybridStorageMode;

/** Offset 0x0ABA - Enable HD Audio Link SDI_0, SDI_1
  0:Disabled, 1:Enabled. Enables SDI Native Function for SDI0 and SDI1 if it is Enabled
**/
  UINT8                       PchHdaAudioLinkHdaSdiEnable[2];

/** Offset 0x0ABC - Number of Coefficients to be used
  The number of coefficients to be used for equalization, default value is 3
**/
  UINT8                       PcieNumOfCoefficients;

/** Offset 0x0ABD - PCH PM Test Configuration
  Enable/Disable PCH PM Test Configuration
  $EN_DIS
**/
  UINT8                       PchPmTestConfig;

/** Offset 0x0ABE
**/
  UINT8                       UnusedUpdSpace21[7];

/** Offset 0x0AC5
**/
  UINT8                       ReservedFspsUpd[11];
} FSP_S_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x0AD0
**/
  UINT8                       UnusedUpdSpace22[6];

/** Offset 0x0AD6
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
