/** @file

Copyright (c) 2020, Intel Corporation. All rights reserved.<BR>

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPSUPD_H__
#define __FSPSUPD_H__

#include <FspUpd.h>

#pragma pack(1)


///
/// Azalia Header structure
///
typedef struct {
  UINT16 VendorId;           ///< Codec Vendor ID
  UINT16 DeviceId;           ///< Codec Device ID
  UINT8  RevisionId;         ///< Revision ID of the codec. 0xFF matches any revision.
  UINT8  SdiNum;             ///< SDI number, 0xFF matches any SDI.
  UINT16 DataDwords;         ///< Number of data DWORDs pointed by the codec data buffer.
  UINT32 Reserved;           ///< Reserved for future use. Must be set to 0.
} AZALIA_HEADER;

///
/// Audio Azalia Verb Table structure
///
typedef struct {
  AZALIA_HEADER Header;      ///< AZALIA PCH header
  UINT32        *Data;       ///< Pointer to the data buffer. Its length is specified in the header
} AUDIO_AZALIA_VERB_TABLE;

///
/// Refer to the definition of PCH_INT_PIN
///
typedef enum {
  SiPchNoInt,        ///< No Interrupt Pin
  SiPchIntA,
  SiPchIntB,
  SiPchIntC,
  SiPchIntD
} SI_PCH_INT_PIN;
///
/// The PCH_DEVICE_INTERRUPT_CONFIG block describes interrupt pin, IRQ and interrupt mode for PCH device.
///
typedef struct {
  UINT8        Device;                  ///< Device number
  UINT8        Function;                ///< Device function
  UINT8        IntX;                    ///< Interrupt pin: INTA-INTD (see SI_PCH_INT_PIN)
  UINT8        Irq;                     ///< IRQ to be set for device.
} SI_PCH_DEVICE_INTERRUPT_CONFIG;

#define SI_PCH_MAX_DEVICE_INTERRUPT_CONFIG  64       ///< Number of all PCH devices


/** Fsp S Configuration
**/
typedef struct {

/** Offset 0x0020 - Logo Pointer
  Points to PEI Display Logo Image
**/
  UINT32                      LogoPtr;

/** Offset 0x0024 - Logo Size
  Size of PEI Display Logo Image
**/
  UINT32                      LogoSize;

/** Offset 0x0028 - Graphics Configuration Ptr
  Points to VBT
**/
  UINT32                      GraphicsConfigPtr;

/** Offset 0x002C - Enable Device 4
  Enable/disable Device 4
  $EN_DIS
**/
  UINT8                       Device4Enable;

/** Offset 0x002D
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x0030 - MicrocodeRegionBase
  Memory Base of Microcode Updates
**/
  UINT32                      MicrocodeRegionBase;

/** Offset 0x0034 - MicrocodeRegionSize
  Size of Microcode Updates
**/
  UINT32                      MicrocodeRegionSize;

/** Offset 0x0038 - Turbo Mode
  Enable/Disable Turbo mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       TurboMode;

/** Offset 0x0039 - PchDmiCwbEnable
  Central Write Buffer feature configurable and disabled by default
  $EN_DIS
**/
  UINT8                       PchDmiCwbEnable;

/** Offset 0x003A - HECI3 state
  The HECI3 state from Mbp for reference in S3 path or when MbpHob is not installed.
  0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       Heci3Enabled;

/** Offset 0x003B - HECI1 state
  Determine if HECI1 is hidden prior to boot to OS. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       Heci1Disabled;

/** Offset 0x003C - AMT Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable AMT functionality.
  $EN_DIS
**/
  UINT8                       AmtEnabled;

/** Offset 0x003D - WatchDog Timer Switch
  Enable/Disable. 0: Disable, 1: enable, Enable or disable WatchDog timer. Setting
  is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       WatchDogEnabled;

/** Offset 0x003E - Manageability Mode set by Mebx
  Enable/Disable. 0: Disable, 1: enable, Enable or disable Manageability Mode.
  $EN_DIS
**/
  UINT8                       ManageabilityMode;

/** Offset 0x003F - PET Progress
  Enable/Disable. 0: Disable, 1: enable, Enable/Disable PET Events Progress to receive
  PET Events. Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       FwProgress;

/** Offset 0x0040 - SOL Switch
  Enable/Disable. 0: Disable, 1: enable, Serial Over Lan enable/disable state by Mebx.
  Setting is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       AmtSolEnabled;

/** Offset 0x0041
**/
  UINT8                       UnusedUpdSpace1;

/** Offset 0x0042 - OS Timer
  16 bits Value, Set OS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerOs;

/** Offset 0x0044 - BIOS Timer
  16 bits Value, Set BIOS watchdog timer. Setting is invalid if AmtEnabled is 0.
**/
  UINT16                      WatchDogTimerBios;

/** Offset 0x0046 - Remote Assistance Trigger Availablilty
  Enable/Disable. 0: Disable, 1: enable, Remote Assistance enable/disable state by Mebx.
  $EN_DIS
**/
  UINT8                       RemoteAssistance;

/** Offset 0x0047 - KVM Switch
  Enable/Disable. 0: Disable, 1: enable, KVM enable/disable state by Mebx. Setting
  is invalid if AmtEnabled is 0.
  $EN_DIS
**/
  UINT8                       AmtKvmEnabled;

/** Offset 0x0048 - MEBX execution
  Enable/Disable. 0: Disable, 1: enable, Force MEBX execution.
  $EN_DIS
**/
  UINT8                       ForcMebxSyncUp;

/** Offset 0x0049 - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x004A - DMI ASPM
  0=Disable, 2(Default)=L1
  0:Disable, 2:L1
**/
  UINT8                       DmiAspm;

/** Offset 0x004B - PCIe DeEmphasis control per root port
  0: -6dB, 1(Default): -3.5dB
  0:-6dB, 1:-3.5dB
**/
  UINT8                       PegDeEmphasis[4];

/** Offset 0x004F - PCIe Slot Power Limit value per root port
  Slot power limit value per root port
**/
  UINT8                       PegSlotPowerLimitValue[4];

/** Offset 0x0053 - PCIe Slot Power Limit scale per root port
  Slot power limit scale per root port
  0:1.0x, 1:0.1x, 2:0.01x, 3:0x001x
**/
  UINT8                       PegSlotPowerLimitScale[4];

/** Offset 0x0057
**/
  UINT8                       UnusedUpdSpace2[1];

/** Offset 0x0058 - PCIe Physical Slot Number per root port
  Physical Slot Number per root port
**/
  UINT16                      PegPhysicalSlotNumber[4];

/** Offset 0x0060 - Enable/Disable PavpEnable
  Enable(Default): Enable PavpEnable, Disable: Disable PavpEnable
  $EN_DIS
**/
  UINT8                       PavpEnable;

/** Offset 0x0061 - CdClock Frequency selection
  0=337.5 Mhz, 1=450 Mhz, 2=540 Mhz, 3(Default)=675 Mhz
  0: 337.5 Mhz, 1: 450 Mhz, 2: 540 Mhz, 3: 675 Mhz
**/
  UINT8                       CdClock;

/** Offset 0x0062 - Enable/Disable PeiGraphicsPeimInit
  Enable: Enable PeiGraphicsPeimInit, Disable(Default): Disable PeiGraphicsPeimInit
  $EN_DIS
**/
  UINT8                       PeiGraphicsPeimInit;

/** Offset 0x0063 - Enable or disable GNA device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       GnaEnable;

/** Offset 0x0064 - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOutDeprecated;

/** Offset 0x0065
**/
  UINT8                       UnusedUpdSpace3[3];

/** Offset 0x0068 - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddressDeprecated[3];

/** Offset 0x0074 - Enable or disable eDP device
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortEdp;

/** Offset 0x0075 - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x0076 - Enable or disable HPD of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x0077 - Enable or disable HPD of DDI port D
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortDHpd;

/** Offset 0x0078 - Enable or disable HPD of DDI port F
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortFHpd;

/** Offset 0x0079 - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x007A - Enable or disable DDC of DDI port C
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x007B - Enable or disable DDC of DDI port D
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortDDdc;

/** Offset 0x007C - Enable or disable DDC of DDI port F
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortFDdc;

/** Offset 0x007D - Enable/Disable SkipS3CdClockInit
  Enable: Skip Full CD clock initializaton, Disable(Default): Initialize the full
  CD clock in S3 resume due to GOP absent
  $EN_DIS
**/
  UINT8                       SkipS3CdClockInit;

/** Offset 0x007E - Delta T12 Power Cycle Delay required in ms
  DEPRECATED
  0 : No Delay, 0xFFFF : Auto Calulate T12 Delay
**/
  UINT16                      DeltaT12PowerCycleDelay;

/** Offset 0x0080 - Blt Buffer Address
  Address of Blt buffer
**/
  UINT32                      BltBufferAddress;

/** Offset 0x0084 - Blt Buffer Size
  Size of Blt Buffer, is equal to PixelWidth * PixelHeight * 4 bytes (the size of
  EFI_GRAPHICS_OUTPUT_BLT_PIXEL)
**/
  UINT32                      BltBufferSize;

/** Offset 0x0088 - Program GT Chicken bits
  Progarm the GT chicken bits in GTTMMADR + 0xD00 BITS [3:1]
**/
  UINT8                       ProgramGtChickenBits;

/** Offset 0x0089 - SaPostMemProductionRsvd
  Reserved for SA Post-Mem Production
  $EN_DIS
**/
  UINT8                       SaPostMemProductionRsvd[34];

/** Offset 0x00AB - PCIE RP Disable Gen2PLL Shutdown and L1 Clock Gating Enable
  PCIE RP Disable Gen2PLL Shutdown and L1 Clock Gating Enable Workaround needed for
  Alpine ridge
**/
  UINT8                       PcieRootPortGen2PllL1CgDisable[24];

/** Offset 0x00C3 - Advanced Encryption Standard (AES) feature
  Enable or Disable Advanced Encryption Standard (AES) feature; </b>0: Disable; <b>1: Enable
  $EN_DIS
**/
  UINT8                       AesEnable;

/** Offset 0x00C4 - Power State 3 enable/disable
  PCODE MMIO Mailbox: Power State 3 enable/disable; 0: Disable; <b>1: Enable</b>.
  For all VR Indexes
**/
  UINT8                       Psi3Enable[5];

/** Offset 0x00C9 - Power State 4 enable/disable
  PCODE MMIO Mailbox: Power State 4 enable/disable; 0: Disable; <b>1: Enable</b>.For
  all VR Indexes
**/
  UINT8                       Psi4Enable[5];

/** Offset 0x00CE - Imon slope correction
  PCODE MMIO Mailbox: Imon slope correction. Specified in 1/100 increment values.
  Range is 0-200. 125 = 1.25. <b>0: Auto</b>.For all VR Indexes
**/
  UINT8                       ImonSlope[5];

/** Offset 0x00D3 - Imon offset correction
  DEPRECATED
**/
  UINT8                       ImonOffset[5];

/** Offset 0x00D8 - Enable/Disable BIOS configuration of VR
  Enable/Disable BIOS configuration of VR; <b>0: Disable</b>; 1: Enable.For all VR Indexes
**/
  UINT8                       VrConfigEnable[5];

/** Offset 0x00DD - Thermal Design Current enable/disable
  PCODE MMIO Mailbox: Thermal Design Current enable/disable; <b>0: Disable</b>; 1:
  Enable.For all VR Indexes
**/
  UINT8                       TdcEnable[5];

/** Offset 0x00E2 - HECI3 state
  PCODE MMIO Mailbox: Thermal Design Current time window. Defined in milli seconds.
  Valid Values 1 - 1ms , 2 - 2ms , 3 - 3ms , 4 - 4ms , 5 - 5ms , 6 - 6ms , 7 - 7ms
  , 8 - 8ms , 10 - 10ms.For all VR Indexe
**/
  UINT8                       TdcTimeWindow[5];

/** Offset 0x00E7 - Thermal Design Current Lock
  PCODE MMIO Mailbox: Thermal Design Current Lock; <b>0: Disable</b>; 1: Enable.For
  all VR Indexes
**/
  UINT8                       TdcLock[5];

/** Offset 0x00EC - Platform Psys slope correction
  PCODE MMIO Mailbox: Platform Psys slope correction. <b>0 - Auto</b> Specified in
  1/100 increment values. Range is 0-200. 125 = 1.25
**/
  UINT8                       PsysSlope;

/** Offset 0x00ED - Platform Psys offset correction
  PCODE MMIO Mailbox: Platform Psys offset correction. <b>0 - Auto</b> Units 1/4,
  Range 0-255. Value of 100 = 100/4 = 25 offset
**/
  UINT8                       PsysOffset;

/** Offset 0x00EE - Acoustic Noise Mitigation feature
  Enable or Disable Acoustic Noise Mitigation feature. This has to be enabled to program
  slew rate configuration for all VR domains, Pre Wake, Ramp Up and, Ramp Down times.<b>0:
  Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       AcousticNoiseMitigation;

/** Offset 0x00EF - Disable Fast Slew Rate for Deep Package C States for VR IA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableIa;

/** Offset 0x00F0 - Slew Rate configuration for Deep Package C States for VR IA domain
  Slew Rate configuration for Deep Package C States for VR IA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForIa;

/** Offset 0x00F1 - Slew Rate configuration for Deep Package C States for VR GT domain
  Slew Rate configuration for Deep Package C States for VR GT domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForGt;

/** Offset 0x00F2 - Slew Rate configuration for Deep Package C States for VR SA domain
  Slew Rate configuration for Deep Package C States for VR SA domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForSa;

/** Offset 0x00F3
**/
  UINT8                       UnusedUpdSpace4[1];

/** Offset 0x00F4 - Thermal Design Current current limit
  PCODE MMIO Mailbox: Thermal Design Current current limit. Specified in 1/8A units.
  Range is 0-4095. 1000 = 125A. <b>0: Auto</b>. For all VR Indexes
**/
  UINT16                      TdcPowerLimit[5];

/** Offset 0x00FE - AcLoadline
  PCODE MMIO Mailbox: AcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249. <b>Intel Recommended Defaults vary by domain and SKU.
**/
  UINT16                      AcLoadline[5];

/** Offset 0x0108 - DcLoadline
  PCODE MMIO Mailbox: DcLoadline in 1/100 mOhms (ie. 1250 = 12.50 mOhm); Range is
  0-6249.<b>Intel Recommended Defaults vary by domain and SKU.</b>
**/
  UINT16                      DcLoadline[5];

/** Offset 0x0112 - Power State 1 Threshold current
  PCODE MMIO Mailbox: Power State 1 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi1Threshold[5];

/** Offset 0x011C - Power State 2 Threshold current
  PCODE MMIO Mailbox: Power State 2 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi2Threshold[5];

/** Offset 0x0126 - Power State 3 Threshold current
  PCODE MMIO Mailbox: Power State 3 current cuttof in 1/4 Amp increments. Range is 0-128A.
**/
  UINT16                      Psi3Threshold[5];

/** Offset 0x0130 - Icc Max limit
  PCODE MMIO Mailbox: VR Icc Max limit. 0-255A in 1/4 A units. 400 = 100A
**/
  UINT16                      IccMax[5];

/** Offset 0x013A - VR Voltage Limit
  PCODE MMIO Mailbox: VR Voltage Limit. Range is 0-7999mV.
**/
  UINT16                      VrVoltageLimit[5];

/** Offset 0x0144 - Disable Fast Slew Rate for Deep Package C States for VR GT domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableGt;

/** Offset 0x0145 - Disable Fast Slew Rate for Deep Package C States for VR SA domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableSa;

/** Offset 0x0146 - Enable VR specific mailbox command
  VR specific mailbox commands. <b>00b - no VR specific command sent.</b>  01b - A
  VR mailbox command specifically for the MPS IMPV8 VR will be sent. 10b - VR specific
  command sent for PS4 exit issue. 11b - Reserved.
  $EN_DIS
**/
  UINT8                       SendVrMbxCmd;

/** Offset 0x0147 - Reserved
  Reserved
**/
  UINT8                       Reserved2;

/** Offset 0x0148 - Enable or Disable TXT
  Enable or Disable TXT; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       TxtEnable;

/** Offset 0x0149 - Deprecated DO NOT USE Skip Multi-Processor Initialization
  @deprecated SkipMpInit has been moved to FspmUpd
  $EN_DIS
**/
  UINT8                       SkipMpInitDeprecated;

/** Offset 0x014A - McIVR RFI Frequency Prefix
  PCODE MMIO Mailbox: McIVR RFI Frequency Adjustment Prefix. <b>0: Plus (+)</b>; 1:
  Minus (-).
**/
  UINT8                       McivrRfiFrequencyPrefix;

/** Offset 0x014B - McIVR RFI Frequency Adjustment
  PCODE MMIO Mailbox: Adjust the RFI frequency relative to the nominal frequency in
  increments of 100KHz. For subtraction, change McivrRfiFrequencyPrefix. <b>0: Auto</b>.
**/
  UINT8                       McivrRfiFrequencyAdjust;

/** Offset 0x014C - FIVR RFI Frequency
  PCODE MMIO Mailbox: Set the desired RFI frequency, in increments of 100KHz. <b>0:
  Auto</b>. Range varies based on XTAL clock: 0-1918 (Up to 191.8HMz) for 24MHz clock;
  0-1535 (Up to 153.5MHz) for 19MHz clock.
**/
  UINT16                      FivrRfiFrequency;

/** Offset 0x014E - McIVR RFI Spread Spectrum
  PCODE MMIO Mailbox: McIVR RFI Spread Spectrum. <b>0: 0%</b>; 1: +/- 0.5%; 2: +/-
  1%; 3: +/- 1.5%; 4: +/- 2%; 5: +/- 3%; 6: +/- 4%; 7: +/- 5%; 8: +/- 6%.
**/
  UINT8                       McivrSpreadSpectrum;

/** Offset 0x014F - FIVR RFI Spread Spectrum
  PCODE MMIO Mailbox: FIVR RFI Spread Spectrum, in 0.1% increments. <b>0: 0%</b>;
  Range: 0.0% to 10.0% (0-100).
**/
  UINT8                       FivrSpreadSpectrum;

/** Offset 0x0150 - Disable Fast Slew Rate for Deep Package C States for VR FIVR domain
  Disable Fast Slew Rate for Deep Package C States based on Acoustic Noise Mitigation
  feature enabled. <b>0: False</b>; 1: True
  $EN_DIS
**/
  UINT8                       FastPkgCRampDisableFivr;

/** Offset 0x0151 - Slew Rate configuration for Deep Package C States for VR FIVR domain
  Slew Rate configuration for Deep Package C States for VR FIVR domain based on Acoustic
  Noise Mitigation feature enabled. <b>0: Fast/2</b>; 1: Fast/4; 2: Fast/8; 3: Fast/16
  0: Fast/2, 1: Fast/4, 2: Fast/8, 3: Fast/16
**/
  UINT8                       SlowSlewRateForFivr;

/** Offset 0x0152
**/
  UINT8                       UnusedUpdSpace5[2];

/** Offset 0x0154 - CpuBistData
  Pointer CPU BIST Data
**/
  UINT32                      CpuBistData;

/** Offset 0x0158 - Activates VR mailbox command for Intersil VR C-state issues.
  Intersil VR mailbox command. <b>0 - no mailbox command sent.</b>  1 - VR mailbox
  command sent for IA/GT rails only. 2 - VR mailbox command sent for IA/GT/SA rails.
**/
  UINT8                       IslVrCmd;

/** Offset 0x0159
**/
  UINT8                       UnusedUpdSpace6[1];

/** Offset 0x015A - Imon slope1 correction
  PCODE MMIO Mailbox: Imon slope correction. Specified in 1/100 increment values.
  Range is 0-200. 125 = 1.25. <b>0: Auto</b>.For all VR Indexes
**/
  UINT16                      ImonSlope1[5];

/** Offset 0x0164 - CPU VR Power Delivery Design
  Used to communicate the power delivery design capability of the board. This value
  is an enum of the available power delivery segments that are defined in the Platform
  Design Guide.
**/
  UINT32                      VrPowerDeliveryDesign;

/** Offset 0x0168 - Pre Wake Randomization time
  PCODE MMIO Mailbox: Acoustic Migitation Range.Defines the maximum pre-wake randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMigitation is enabled.
  Range 0-255 <b>0</b>.
**/
  UINT8                       PreWake;

/** Offset 0x0169 - Ramp Up Randomization time
  PCODE MMIO Mailbox: Acoustic Migitation Range.Defines the maximum Ramp Up randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMigitation is enabled.Range
  0-255 <b>0</b>.
**/
  UINT8                       RampUp;

/** Offset 0x016A - Ramp Down Randomization time
  PCODE MMIO Mailbox: Acoustic Migitation Range.Defines the maximum Ramp Down randomization
  time in micro ticks.This can be programmed only if AcousticNoiseMigitation is enabled.Range
  0-255 <b>0</b>.
**/
  UINT8                       RampDown;

/** Offset 0x016B
**/
  UINT8                       UnusedUpdSpace7;

/** Offset 0x016C - CpuMpPpi
  Pointer for CpuMpPpi
**/
  UINT32                      CpuMpPpi;

/** Offset 0x0170 - CpuMpHob
  Pointer for CpuMpHob. This is optional data buffer for CpuMpPpi usage.
**/
  UINT32                      CpuMpHob;

/** Offset 0x0174 - CPU Run Control
  Enable, Disable or Do not configure CPU Run Control; 0: Disable; 1: Enable ; <b>2:
  No Change</b>
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x0175
**/
  UINT8                       UnusedUpdSpace8[1];

/** Offset 0x0176 - Imon offset 1 correction
  PCODE MMIO Mailbox: Imon offset correction. Value is a 2's complement signed integer.
  Units 1/1000, Range 0-63999. For an offset = 12.580, use 12580. <b>0: Auto</b>
**/
  UINT16                      ImonOffset1[5];

/** Offset 0x0180 - ReservedCpuPostMemProduction
  Reserved for CPU Post-Mem Production
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemProduction[8];

/** Offset 0x0188 - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x0189 - Select HDAudio IoBuffer Ownership
  Indicates the ownership of the I/O buffer between Intel HD Audio link vs I2S0 /
  I2S port. 0: Intel HD-Audio link owns all the I/O buffers. 1: Intel HD-Audio link
  owns 4 of the I/O buffers for 1 HD-Audio codec connection, and I2S1 port owns 4
  of the I/O buffers for 1 I2S codec connection. 2: Reserved. 3: I2S0 and I2S1 ports
  own all the I/O buffers.
  0:HD-A Link, 1:Shared HD-A Link and I2S Port, 3:I2S Ports
**/
  UINT8                       PchHdaIoBufferOwnership;

/** Offset 0x018A - Configure CLKSRC Number
  Configure Root Port CLKSRC Number. Each value in arrary can be between 0-6 for valid
  clock numbers or 0x1F for an invalid number. One byte for each port, byte0 for
  port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkSrcNumber[24];

/** Offset 0x01A2 - Force Disable clock
  Disables clock even if link is inactive default value is 0
**/
  UINT8                       PcieRpForceClkDisableWhenRpDisable[24];

/** Offset 0x01BA - Enable CIO2 Controller
  Enable/disable SKYCAM CIO2 Controller.
  $EN_DIS
**/
  UINT8                       PchCio2Enable;

/** Offset 0x01BB - SPI0 Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:PchSerialIoCsActiveLow,
  1:PchSerialIoCsActiveHigh
**/
  UINT8                       SerialIoSpi0CsPolarity[2];

/** Offset 0x01BD - SPI1 Chip Select Polarity
  Sets polarity for each chip Select. Available options: 0:PchSerialIoCsActiveLow,
  1:PchSerialIoCsActiveHigh
**/
  UINT8                       SerialIoSpi1CsPolarity[2];

/** Offset 0x01BF - SPI0 Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpi0CsEnable[2];

/** Offset 0x01C1 - SPI1 Chip Select Enable
  0:Disabled, 1:Enabled. Enables GPIO for CS0 or CS1 if it is Enabled
**/
  UINT8                       SerialIoSpi1CsEnable[2];

/** Offset 0x01C3 - SPIn Device Mode
  Selects SPI operation mode. N represents controller index: SPI0, SPI1, ... Available
  modes: 0:SerialIoSpiDisabled, 1:SerialIoSpiPci, 2:SerialIoSpiHidden
**/
  UINT8                       SerialIoSpiMode[2];

/** Offset 0x01C5 - SPIn Default Chip Select Output
  Sets Default CS as Output. N represents controller index: SPI0, SPI1, ... Available
  options: 0:CS0, 1:CS1
**/
  UINT8                       SerialIoSpiDefaultCsOutput[2];

/** Offset 0x01C7 - I2Cn Device Mode
  Selects I2c operation mode. N represents controller index: I2c0, I2c1, ... Available
  modes: 0:SerialIoI2cDisabled, 1:SerialIoI2cPci, 2:SerialIoI2cHidden
**/
  UINT8                       SerialIoI2cMode[6];

/** Offset 0x01CD - UART Number For Debug Purpose
  UART number for debug purpose. 0:UART0, 1: UART1, 2:UART2. Note: If UART0 is selected
  as CNVi BT Core interface, it cannot be used for debug purpose.
   0:UART0, 1:UART1, 2:UART2
**/
  UINT8                       SerialIoDebugUartNumber;

/** Offset 0x01CE - UARTn Device Mode
  Selects Uart operation mode. N represents controller index: Uart0, Uart1, ... Available
  modes: 0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartMode[3];

/** Offset 0x01D1
**/
  UINT8                       UnusedUpdSpace9[3];

/** Offset 0x01D4 - Default BaudRate for each Serial IO UART
  Set default BaudRate Supported from 0 - default to 6000000
**/
  UINT32                      SerialIoUartBaudRate[3];

/** Offset 0x01E0 - Default ParityType for each Serial IO UART
  Set default Parity. 0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartParity[3];

/** Offset 0x01E3 - Default DataBits for each Serial IO UART
  Set default word length. 0: Default, 5,6,7,8
**/
  UINT8                       SerialIoUartDataBits[3];

/** Offset 0x01E6 - Default StopBits for each Serial IO UART
  Set default stop bits. 0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3:
  TwoStopBits
**/
  UINT8                       SerialIoUartStopBits[3];

/** Offset 0x01E9 - Power Gating mode for each Serial IO UART that works in COM mode
  Set Power Gating. 0: Disabled, 1: Enabled, 2: Auto
**/
  UINT8                       SerialIoUartPowerGating[3];

/** Offset 0x01EC - Enable Dma for each Serial IO UART that supports it
  Set DMA/PIO mode. 0: Disabled, 1: Enabled
**/
  UINT8                       SerialIoUartDmaEnable[3];

/** Offset 0x01EF - Enables UART hardware flow control, CTS and RTS lines
  Enables UART hardware flow control, CTS and RTS lines.
**/
  UINT8                       SerialIoUartAutoFlow[3];

/** Offset 0x01F2 - Serial IO UART DBG2 table
  Enable or disable Serial Io UART DBG2 table, default is Disable; <b>0: Disable;</b>
  1: Enable.
**/
  UINT8                       SerialIoUartDbg2[3];

/** Offset 0x01F5 - Enable PCH ISH Controller
  Enable/disable ISH Controller.
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x01F6 - Show SPI controller
  Enable/disable to show SPI controller.
  $EN_DIS
**/
  UINT8                       ShowSpiController;

/** Offset 0x01F7 - Flash Configuration Lock Down
  Enable/disable flash lock down. If platform decides to skip this programming, it
  must lock SPI flash register DLOCK, FLOCKDN, and WRSDIS before end of post.
  $EN_DIS
**/
  UINT8                       SpiFlashCfgLockDown;

/** Offset 0x01F8 - Enable SATA SALP Support
  Enable/disable SATA Aggressive Link Power Management.
  $EN_DIS
**/
  UINT8                       SataSalpSupport;

/** Offset 0x01F9 - Enable SATA ports
  Enable/disable SATA ports. One byte for each port, byte0 for port0, byte1 for port1,
  and so on.
**/
  UINT8                       SataPortsEnable[8];

/** Offset 0x0201 - Enable SATA DEVSLP Feature
  Enable/disable SATA DEVSLP per port. 0 is disable, 1 is enable. One byte for each
  port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlp[8];

/** Offset 0x0209 - Enable USB2 ports
  Enable/disable per USB2 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb20Enable[16];

/** Offset 0x0219 - Enable USB3 ports
  Enable/disable per USB3 ports. One byte for each port, byte0 for port0, byte1 for
  port1, and so on.
**/
  UINT8                       PortUsb30Enable[10];

/** Offset 0x0223 - Enable xDCI controller
  Enable/disable to xDCI controller.
  $EN_DIS
**/
  UINT8                       XdciEnable;

/** Offset 0x0224 - Enable XHCI SSIC Enable
  Enable/disable XHCI SSIC port.
  $EN_DIS
**/
  UINT8                       SsicPortEnable;

/** Offset 0x0225 - Number of DevIntConfig Entry
  Number of Device Interrupt Configuration Entry. If this is not zero, the DevIntConfigPtr
  must not be NULL.
**/
  UINT8                       NumOfDevIntConfig;

/** Offset 0x0226
**/
  UINT8                       UnusedUpdSpace10[2];

/** Offset 0x0228 - Address of PCH_DEVICE_INTERRUPT_CONFIG table.
  The address of the table of PCH_DEVICE_INTERRUPT_CONFIG.
**/
  UINT32                      DevIntConfigPtr;

/** Offset 0x022C - PIRQx to IRQx Map Config
  PIRQx to IRQx mapping. The valid value is 0x00 to 0x0F for each. First byte is for
  PIRQA, second byte is for PIRQB, and so on. The setting is only available in Legacy
  8259 PCI mode.
**/
  UINT8                       PxRcConfig[8];

/** Offset 0x0234 - Select GPIO IRQ Route
  GPIO IRQ Select. The valid value is 14 or 15.
**/
  UINT8                       GpioIrqRoute;

/** Offset 0x0235 - Select SciIrqSelect
  SCI IRQ Select. The valid value is 9, 10, 11, and 20, 21, 22, 23 for APIC only.
**/
  UINT8                       SciIrqSelect;

/** Offset 0x0236 - Select TcoIrqSelect
  TCO IRQ Select. The valid value is 9, 10, 11, 20, 21, 22, 23.
**/
  UINT8                       TcoIrqSelect;

/** Offset 0x0237 - Enable/Disable Tco IRQ
  Enable/disable TCO IRQ
  $EN_DIS
**/
  UINT8                       TcoIrqEnable;

/** Offset 0x0238 - PCH HDA Verb Table Entry Number
  Number of Entries in Verb Table.
**/
  UINT8                       PchHdaVerbTableEntryNum;

/** Offset 0x0239
**/
  UINT8                       UnusedUpdSpace11[3];

/** Offset 0x023C - PCH HDA Verb Table Pointer
  Pointer to Array of pointers to Verb Table.
**/
  UINT32                      PchHdaVerbTablePtr;

/** Offset 0x0240 - Enable SATA
  Enable/disable SATA controller.
  $EN_DIS
**/
  UINT8                       SataEnable;

/** Offset 0x0241 - SATA Mode
  Select SATA controller working mode.
  0:AHCI, 1:RAID
**/
  UINT8                       SataMode;

/** Offset 0x0242 - USB Per Port HS Preemphasis Bias
  USB Per Port HS Preemphasis Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV. One byte for each port.
**/
  UINT8                       Usb2AfePetxiset[16];

/** Offset 0x0252 - USB Per Port HS Transmitter Bias
  USB Per Port HS Transmitter Bias. 000b-0mV, 001b-11.25mV, 010b-16.9mV, 011b-28.15mV,
  100b-28.15mV, 101b-39.35mV, 110b-45mV, 111b-56.3mV, One byte for each port.
**/
  UINT8                       Usb2AfeTxiset[16];

/** Offset 0x0262 - USB Per Port HS Transmitter Emphasis
  USB Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT8                       Usb2AfePredeemp[16];

/** Offset 0x0272 - USB Per Port Half Bit Pre-emphasis
  USB Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT8                       Usb2AfePehalfbit[16];

/** Offset 0x0282 - Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment
  Enable the write to USB 3.0 TX Output -3.5dB De-Emphasis Adjustment. Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmphEnable[10];

/** Offset 0x028C - USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting
  USB 3.0 TX Output -3.5dB De-Emphasis Adjustment Setting, HSIO_TX_DWORD5[21:16],
  <b>Default = 29h</b> (approximately -3.5dB De-Emphasis). One byte for each port.
**/
  UINT8                       Usb3HsioTxDeEmph[10];

/** Offset 0x0296 - Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment
  Enable the write to USB 3.0 TX Output Downscale Amplitude Adjustment, Each value
  in arrary can be between 0-1. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmpEnable[10];

/** Offset 0x02A0 - USB 3.0 TX Output Downscale Amplitude Adjustment
  USB 3.0 TX Output Downscale Amplitude Adjustment, HSIO_TX_DWORD8[21:16], <b>Default
  = 00h</b>. One byte for each port.
**/
  UINT8                       Usb3HsioTxDownscaleAmp[10];

/** Offset 0x02AA - Enable xHCI LTR override
  Enables override of recommended LTR values for xHCI
  $EN_DIS
**/
  UINT8                       PchUsbLtrOverrideEnable;

/** Offset 0x02AB
**/
  UINT8                       UnusedUpdSpace12;

/** Offset 0x02AC - xHCI High Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI High Idle Time LTR setting
**/
  UINT32                      PchUsbLtrHighIdleTimeOverride;

/** Offset 0x02B0 - xHCI Medium Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Medium Idle Time LTR setting
**/
  UINT32                      PchUsbLtrMediumIdleTimeOverride;

/** Offset 0x02B4 - xHCI Low Idle Time LTR override
  Value used for overriding LTR recommendation for xHCI Low Idle Time LTR setting
**/
  UINT32                      PchUsbLtrLowIdleTimeOverride;

/** Offset 0x02B8 - Enable LAN
  Enable/disable LAN controller.
  $EN_DIS
**/
  UINT8                       PchLanEnable;

/** Offset 0x02B9 - Delay USB PDO Programming
  Enable/disable delay of PDO programming for USB from PEI phase to DXE phase. 0:
  disable, 1: enable
  $EN_DIS
**/
  UINT8                       DelayUsbPdoProgramming;

/** Offset 0x02BA
**/
  UINT8                       UnusedUpdSpace13[2];

/** Offset 0x02BC - Trace Hub Memory Base
  If Trace Hub is enabled and trace to memory is desired, BootLoader needs to allocate
  trace hub memory as reserved and uncacheable, set the base to ensure Trace Hub
  memory is configured properly.
**/
  UINT32                      TraceHubMemBase;

/** Offset 0x02C0 - Enable PCIE RP CLKREQ Support
  Enable/disable PCIE Root Port CLKREQ support. 0: disable, 1: enable. One byte for
  each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqSupport[24];

/** Offset 0x02D8 - Configure CLKREQ Number
  Configure Root Port CLKREQ Number if CLKREQ is supported. Each value in arrary can
  be between 0-6. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       PcieRpClkReqNumber[24];

/** Offset 0x02F0 - Enable CPU PCIE RP CLKREQ Support
  Enable/disable CPU PCIE Root Port CLKREQ support. 0: disable, 1: enable. One byte
  for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       CpuPcieRpClkReqSupport[4];

/** Offset 0x02F4 - Configure CPU PCIE CLKREQ Number
  Configure CPU Root Port CLKREQ Number if CLKREQ is supported. Each value in arrary
  can be between 0-3. One byte for each port, byte0 for port1, byte1 for port2, and so on.
**/
  UINT8                       CpuPcieRpClkReqNumber[4];

/** Offset 0x02F8 - Enable SkyCam PortA Termination override
  Enable/disable PortA Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortATermOvrEnable;

/** Offset 0x02F9 - Enable SkyCam PortB Termination override
  Enable/disable PortB Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBTermOvrEnable;

/** Offset 0x02FA - Enable SkyCam PortC Termination override
  Enable/disable PortC Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCTermOvrEnable;

/** Offset 0x02FB - Enable SkyCam PortD Termination override
  Enable/disable PortD Termination override.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortDTermOvrEnable;

/** Offset 0x02FC - Enable SkyCam PortA Clk Trim
  Enable/disable PortA Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortATrimEnable;

/** Offset 0x02FD - Enable SkyCam PortB Clk Trim
  Enable/disable PortB Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBTrimEnable;

/** Offset 0x02FE - Enable SkyCam PortC Clk Trim
  Enable/disable PortC Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCTrimEnable;

/** Offset 0x02FF - Enable SkyCam PortD Clk Trim
  Enable/disable PortD Clk Trim.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortDTrimEnable;

/** Offset 0x0300 - Enable SkyCam PortA Ctle
  Enable/disable PortA Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortACtleEnable;

/** Offset 0x0301 - Enable SkyCam PortB Ctle
  Enable/disable PortB Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortBCtleEnable;

/** Offset 0x0302 - Enable SkyCam PortCD Ctle
  Enable/disable PortCD Ctle.
  $EN_DIS
**/
  UINT8                       PchSkyCamPortCDCtleEnable;

/** Offset 0x0303 - Enable SkyCam PortA Ctle Cap Value
  Enable/disable PortA Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortACtleCapValue;

/** Offset 0x0304 - Enable SkyCam PortB Ctle Cap Value
  Enable/disable PortB Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortBCtleCapValue;

/** Offset 0x0305 - Enable SkyCam PortCD Ctle Cap Value
  Enable/disable PortCD Ctle Cap Value.
**/
  UINT8                       PchSkyCamPortCDCtleCapValue;

/** Offset 0x0306 - Enable SkyCam PortA Ctle Res Value
  Enable/disable PortA Ctle Res Value.
**/
  UINT8                       PchSkyCamPortACtleResValue;

/** Offset 0x0307 - Enable SkyCam PortB Ctle Res Value
  Enable/disable PortB Ctle Res Value.
**/
  UINT8                       PchSkyCamPortBCtleResValue;

/** Offset 0x0308 - Enable SkyCam PortCD Ctle Res Value
  Enable/disable PortCD Ctle Res Value.
**/
  UINT8                       PchSkyCamPortCDCtleResValue;

/** Offset 0x0309 - Enable SkyCam PortA Clk Trim Value
  Enable/disable PortA Clk Trim Value.
**/
  UINT8                       PchSkyCamPortAClkTrimValue;

/** Offset 0x030A - Enable SkyCam PortB Clk Trim Value
  Enable/disable PortB Clk Trim Value.
**/
  UINT8                       PchSkyCamPortBClkTrimValue;

/** Offset 0x030B - Enable SkyCam PortC Clk Trim Value
  Enable/disable PortC Clk Trim Value.
**/
  UINT8                       PchSkyCamPortCClkTrimValue;

/** Offset 0x030C - Enable SkyCam PortD Clk Trim Value
  Enable/disable PortD Clk Trim Value.
**/
  UINT8                       PchSkyCamPortDClkTrimValue;

/** Offset 0x030D
**/
  UINT8                       UnusedUpdSpace14;

/** Offset 0x030E - Enable SkyCam Port A Data Trim Value
  Enable/disable Port A Data Trim Value.
**/
  UINT16                      PchSkyCamPortADataTrimValue;

/** Offset 0x0310 - Enable SkyCam Port B Data Trim Value
  Enable/disable Port B Data Trim Value.
**/
  UINT16                      PchSkyCamPortBDataTrimValue;

/** Offset 0x0312 - Enable SkyCam C/D Data Trim Value
  Enable/disable C/D Data Trim Value.
**/
  UINT16                      PchSkyCamPortCDDataTrimValue;

/** Offset 0x0314 - Pch Dmi Aspm Ctrl
  ASPM configuration on the PCH side of the DMI/OPI Link. Default is <b>PchPcieAspmAutoConfig</b>
  0:Disabled, 1:L0s, 2:L1, 3:L0sL1, 4:Auto
**/
  UINT8                       PchDmiAspmCtrl;

/** Offset 0x0315 - SlpS0WithGbeSupport
  Enable/Disable SLP_S0 with GBE Support
  0: Disable, 1: Enable
**/
  UINT8                       SlpS0WithGbeSupport;

/** Offset 0x0316 - Enable Power Optimizer
  Enable DMI Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       PchPwrOptEnable;

/** Offset 0x0317 - PCH Flash Protection Ranges Write Enble
  Write or erase is blocked by hardware.
**/
  UINT8                       PchWriteProtectionEnable[5];

/** Offset 0x031C - PCH Flash Protection Ranges Read Enble
  Read is blocked by hardware.
**/
  UINT8                       PchReadProtectionEnable[5];

/** Offset 0x0321
**/
  UINT8                       UnusedUpdSpace15[1];

/** Offset 0x0322 - PCH Protect Range Limit
  Left shifted address by 12 bits with address bits 11:0 are assumed to be FFFh for
  limit comparison.
**/
  UINT16                      PchProtectedRangeLimit[5];

/** Offset 0x032C - PCH Protect Range Base
  Left shifted address by 12 bits with address bits 11:0 are assumed to be 0.
**/
  UINT16                      PchProtectedRangeBase[5];

/** Offset 0x0336 - Enable Pme
  Enable Azalia wake-on-ring.
  $EN_DIS
**/
  UINT8                       PchHdaPme;

/** Offset 0x0337 - IO Buffer Voltage
  I/O Buffer Voltage Mode Select: 0: 3.3V, 1: 1.8V.
**/
  UINT8                       PchHdaIoBufferVoltage;

/** Offset 0x0338 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0339 - HD Audio Link Frequency
  HDA Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 0: 6MHz, , 1: 12MHz, 2: 24MHz.
**/
  UINT8                       PchHdaLinkFrequency;

/** Offset 0x033A - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x033B - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 1: 1T.
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x033C - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x033D - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x033E - Enable PCH Io Apic
  Set to 1 if BDF value is valid.
  $EN_DIS
**/
  UINT8                       PchIoApicBdfValid;

/** Offset 0x033F - PCH Io Apic Bus Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0xF0.
**/
  UINT8                       PchIoApicBusNumber;

/** Offset 0x0340 - PCH Io Apic Device Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0x1F.
**/
  UINT8                       PchIoApicDeviceNumber;

/** Offset 0x0341 - PCH Io Apic Function Number
  Bus/Device/Function used as Requestor / Completer ID. Default is 0x00.
**/
  UINT8                       PchIoApicFunctionNumber;

/** Offset 0x0342 - Enable PCH Io Apic Entry 24-119
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIoApicEntry24_119;

/** Offset 0x0343 - PCH Io Apic ID
  This member determines IOAPIC ID. Default is 0x02.
**/
  UINT8                       PchIoApicId;

/** Offset 0x0344 - Enable PCH ISH SPI GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshSpiGpioAssign;

/** Offset 0x0345 - Enable PCH ISH UART0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart0GpioAssign;

/** Offset 0x0346 - Enable PCH ISH UART1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshUart1GpioAssign;

/** Offset 0x0347 - Enable PCH ISH I2C0 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c0GpioAssign;

/** Offset 0x0348 - Enable PCH ISH I2C1 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c1GpioAssign;

/** Offset 0x0349 - Enable PCH ISH I2C2 GPIO pins assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshI2c2GpioAssign;

/** Offset 0x034A - Enable PCH ISH GP_0 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp0GpioAssign;

/** Offset 0x034B - Enable PCH ISH GP_1 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp1GpioAssign;

/** Offset 0x034C - Enable PCH ISH GP_2 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp2GpioAssign;

/** Offset 0x034D - Enable PCH ISH GP_3 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp3GpioAssign;

/** Offset 0x034E - Enable PCH ISH GP_4 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp4GpioAssign;

/** Offset 0x034F - Enable PCH ISH GP_5 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp5GpioAssign;

/** Offset 0x0350 - Enable PCH ISH GP_6 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp6GpioAssign;

/** Offset 0x0351 - Enable PCH ISH GP_7 GPIO pin assigned
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchIshGp7GpioAssign;

/** Offset 0x0352 - PCH ISH PDT Unlock Msg
  0: False; 1: True.
  $EN_DIS
**/
  UINT8                       PchIshPdtUnlock;

/** Offset 0x0353 - Enable PCH Lan LTR capabilty of PCH internal LAN
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanLtrEnable;

/** Offset 0x0354 - Enable PCH Lan use CLKREQ for GbE power management
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanK1OffEnable;

/** Offset 0x0355 - Indicate whether dedicated CLKREQ# is supported
  0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchLanClkReqSupported;

/** Offset 0x0356 - CLKREQ# used by GbE
  Valid if ClkReqSupported is TRUE.
**/
  UINT8                       PchLanClkReqNumber;

/** Offset 0x0357 - Enable LOCKDOWN BIOS LOCK
  Enable the BIOS Lock feature and set EISS bit (D31:F5:RegDCh[5]) for the BIOS region
  protection.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosLock;

/** Offset 0x0358 - Enable LOCKDOWN SPI Eiss
  Enable InSMM.STS (EISS) in SPI.
  $EN_DIS
**/
  UINT8                       PchLockDownSpiEiss;

/** Offset 0x0359 - PCH Compatibility Revision ID
  This member describes whether or not the CRID feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchCrid;

/** Offset 0x035A - PCH Legacy IO Low Latency Enable
  todo
  $EN_DIS
**/
  UINT8                       PchLegacyIoLowLatency;

/** Offset 0x035B - Enable PCIE RP HotPlug
  Indicate whether the root port is hot plug available.
**/
  UINT8                       PcieRpHotPlug[24];

/** Offset 0x0373 - Enable PCIE RP Pm Sci
  Indicate whether the root port power manager SCI is enabled.
**/
  UINT8                       PcieRpPmSci[24];

/** Offset 0x038B - Enable PCIE RP Ext Sync
  Indicate whether the extended synch is enabled.
**/
  UINT8                       PcieRpExtSync[24];

/** Offset 0x03A3 - Enable PCIE RP Transmitter Half Swing
  Indicate whether the Transmitter Half Swing is enabled.
**/
  UINT8                       PcieRpTransmitterHalfSwing[24];

/** Offset 0x03BB - Enable PCIE RP Clk Req Detect
  Probe CLKREQ# signal before enabling CLKREQ# based power management.
**/
  UINT8                       PcieRpClkReqDetect[24];

/** Offset 0x03D3 - PCIE RP Advanced Error Report
  Indicate whether the Advanced Error Reporting is enabled.
**/
  UINT8                       PcieRpAdvancedErrorReporting[24];

/** Offset 0x03EB - PCIE RP Unsupported Request Report
  Indicate whether the Unsupported Request Report is enabled.
**/
  UINT8                       PcieRpUnsupportedRequestReport[24];

/** Offset 0x0403 - PCIE RP Fatal Error Report
  Indicate whether the Fatal Error Report is enabled.
**/
  UINT8                       PcieRpFatalErrorReport[24];

/** Offset 0x041B - PCIE RP No Fatal Error Report
  Indicate whether the No Fatal Error Report is enabled.
**/
  UINT8                       PcieRpNoFatalErrorReport[24];

/** Offset 0x0433 - PCIE RP Correctable Error Report
  Indicate whether the Correctable Error Report is enabled.
**/
  UINT8                       PcieRpCorrectableErrorReport[24];

/** Offset 0x044B - PCIE RP System Error On Fatal Error
  Indicate whether the System Error on Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnFatalError[24];

/** Offset 0x0463 - PCIE RP System Error On Non Fatal Error
  Indicate whether the System Error on Non Fatal Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnNonFatalError[24];

/** Offset 0x047B - PCIE RP System Error On Correctable Error
  Indicate whether the System Error on Correctable Error is enabled.
**/
  UINT8                       PcieRpSystemErrorOnCorrectableError[24];

/** Offset 0x0493 - PCIE RP Max Payload
  Max Payload Size supported, Default 128B, see enum PCH_PCIE_MAX_PAYLOAD.
**/
  UINT8                       PcieRpMaxPayload[24];

/** Offset 0x04AB - PCIE RP Device Reset Pad Active High
  Indicated whether PERST# is active 0: Low; 1: High, See: DeviceResetPad.
**/
  UINT8                       PcieRpDeviceResetPadActiveHigh[24];

/** Offset 0x04C3 - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3 (see:
  PCH_PCIE_SPEED).
**/
  UINT8                       PcieRpPcieSpeed[24];

/** Offset 0x04DB - PCIE RP Gen3 Equalization Phase Method
  PCIe Gen3 Eq Ph3 Method (see PCH_PCIE_EQ_METHOD). 0: Default; 2: Software Search;
  4: Fixed Coeficients.
**/
  UINT8                       PcieRpGen3EqPh3Method[24];

/** Offset 0x04F3 - PCIE RP Physical Slot Number
  Indicates the slot number for the root port. Default is the value as root port index.
**/
  UINT8                       PcieRpPhysicalSlotNumber[24];

/** Offset 0x050B - PCIE RP Completion Timeout
  The root port completion timeout(see: PCH_PCIE_COMPLETION_TIMEOUT). Default is PchPcieCompletionTO_Default.
**/
  UINT8                       PcieRpCompletionTimeout[24];

/** Offset 0x0523
**/
  UINT8                       UnusedUpdSpace16[1];

/** Offset 0x0524 - PCIE RP Device Reset Pad
  The PCH pin assigned to device PERST# signal if available, zero otherwise.  See
  also DeviceResetPadActiveHigh.
**/
  UINT32                      PcieRpDeviceResetPad[24];

/** Offset 0x0584 - PCIE RP Aspm
  The ASPM configuration of the root port (see: PCH_PCIE_ASPM_CONTROL). Default is
  PchPcieAspmAutoConfig.
**/
  UINT8                       PcieRpAspm[24];

/** Offset 0x059C - PCIE RP L1 Substates
  The L1 Substates configuration of the root port (see: PCH_PCIE_L1SUBSTATES_CONTROL).
  Default is PchPcieL1SubstatesL1_1_2.
**/
  UINT8                       PcieRpL1Substates[24];

/** Offset 0x05B4 - PCIE RP Ltr Enable
  Latency Tolerance Reporting Mechanism.
**/
  UINT8                       PcieRpLtrEnable[24];

/** Offset 0x05CC - PCIE RP Ltr Config Lock
  0: Disable; 1: Enable.
**/
  UINT8                       PcieRpLtrConfigLock[24];

/** Offset 0x05E4 - PCIE Eq Ph3 Lane Param Cm
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C-1.
**/
  UINT8                       PcieEqPh3LaneParamCm[24];

/** Offset 0x05FC - PCIE Eq Ph3 Lane Param Cp
  PCH_PCIE_EQ_LANE_PARAM. Coefficient C+1.
**/
  UINT8                       PcieEqPh3LaneParamCp[24];

/** Offset 0x0614 - PCIE RP Clock Power Management
  Enable/Disable PCIE RP Clock Power Management, even if disabled, CLKREQ# signal
  can still be controlled by L1 PM substates mechanism
**/
  UINT8                       PcieRpEnableCpm[24];

/** Offset 0x062C - PCIE RP Detect Timeout Ms
  The number of milliseconds within 0~65535 in reference code will wait for link to
  exit Detect state for enabled ports before assuming there is no device and potentially
  disabling the port.
**/
  UINT16                      PcieRpDetectTimeoutMs[24];

/** Offset 0x065C - PCIE Sw Eq CoeffList Cm
  PCH_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       PcieSwEqCoeffListCm[5];

/** Offset 0x0661 - PCIE Sw Eq CoeffList Cp
  PCH_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       PcieSwEqCoeffListCp[5];

/** Offset 0x0666 - PCIE Disable RootPort Clock Gating
  Describes whether the PCI Express Clock Gating for each root port is enabled by
  platform modules. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PcieDisableRootPortClockGating;

/** Offset 0x0667 - PCIE Enable Peer Memory Write
  This member describes whether Peer Memory Writes are enabled on the platform.
  $EN_DIS
**/
  UINT8                       PcieEnablePeerMemoryWrite;

/** Offset 0x0668 - PCIE Allow No Ltr Icc PLL Shutdown
  Allows BIOS to control ICC PLL Shutdown by determining PCIe devices are LTR capable
  or leaving untouched.
  $EN_DIS
**/
  UINT8                       PcieAllowNoLtrIccPllShutdown;

/** Offset 0x0669 - PCIE Compliance Test Mode
  Compliance Test Mode shall be enabled when using Compliance Load Board.
  $EN_DIS
**/
  UINT8                       PcieComplianceTestMode;

/** Offset 0x066A - PCIE Rp Function Swap
  Allows BIOS to use root port function number swapping when root port of function
  0 is disabled.
  $EN_DIS
**/
  UINT8                       PcieRpFunctionSwap;

/** Offset 0x066B - PCH Pm PME_B0_S5_DIS
  When cleared (default), wake events from PME_B0_STS are allowed in S5 if PME_B0_EN = 1.
  $EN_DIS
**/
  UINT8                       PchPmPmeB0S5Dis;

/** Offset 0x066C - PCH Pm Slp S0 Voltage Margining Enable
  Indicates platform has support for VCCPrim_Core Voltage Margining in SLP_S0# asserted state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0VmEnable;

/** Offset 0x066D - PCH Pm Wol Enable Override
  Corresponds to the WOL Enable Override bit in the General PM Configuration B (GEN_PMCON_B) register.
  $EN_DIS
**/
  UINT8                       PchPmWolEnableOverride;

/** Offset 0x066E - PCH Pm Pcie Wake From DeepSx
  Determine if enable PCIe to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmPcieWakeFromDeepSx;

/** Offset 0x066F - PCH Pm WoW lan Enable
  Determine if WLAN wake from Sx, corresponds to the HOST_WLAN_PP_EN bit in the PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanEnable;

/** Offset 0x0670 - PCH Pm WoW lan DeepSx Enable
  Determine if WLAN wake from DeepSx, corresponds to the DSX_WLAN_PP_EN bit in the
  PWRM_CFG3 register.
  $EN_DIS
**/
  UINT8                       PchPmWoWlanDeepSxEnable;

/** Offset 0x0671 - PCH Pm Lan Wake From DeepSx
  Determine if enable LAN to wake from deep Sx.
  $EN_DIS
**/
  UINT8                       PchPmLanWakeFromDeepSx;

/** Offset 0x0672 - PCH Pm Deep Sx Pol
  Deep Sx Policy.
  $EN_DIS
**/
  UINT8                       PchPmDeepSxPol;

/** Offset 0x0673 - PCH Pm Slp S3 Min Assert
  SLP_S3 Minimum Assertion Width Policy. Default is PchSlpS350ms.
**/
  UINT8                       PchPmSlpS3MinAssert;

/** Offset 0x0674 - PCH Pm Slp S4 Min Assert
  SLP_S4 Minimum Assertion Width Policy. Default is PchSlpS44s.
**/
  UINT8                       PchPmSlpS4MinAssert;

/** Offset 0x0675 - PCH Pm Slp Sus Min Assert
  SLP_SUS Minimum Assertion Width Policy. Default is PchSlpSus4s.
**/
  UINT8                       PchPmSlpSusMinAssert;

/** Offset 0x0676 - PCH Pm Slp A Min Assert
  SLP_A Minimum Assertion Width Policy. Default is PchSlpA2s.
**/
  UINT8                       PchPmSlpAMinAssert;

/** Offset 0x0677 - PCH Pm Lpc Clock Run
  This member describes whether or not the LPC ClockRun feature of PCH should be enabled.
  $EN_DIS
**/
  UINT8                       PchPmLpcClockRun;

/** Offset 0x0678 - PCH Pm Slp Strch Sus Up
  Enable SLP_X Stretching After SUS Well Power Up.
  $EN_DIS
**/
  UINT8                       PchPmSlpStrchSusUp;

/** Offset 0x0679 - PCH Pm Slp Lan Low Dc
  Enable/Disable SLP_LAN# Low on DC Power.
  $EN_DIS
**/
  UINT8                       PchPmSlpLanLowDc;

/** Offset 0x067A - PCH Pm Pwr Btn Override Period
  PCH power button override period. 000b-4s, 001b-6s, 010b-8s, 011b-10s, 100b-12s, 101b-14s.
**/
  UINT8                       PchPmPwrBtnOverridePeriod;

/** Offset 0x067B - PCH Pm Disable Dsx Ac Present Pulldown
  When Disable, PCH will internal pull down AC_PRESENT in deep SX and during G3 exit.
  $EN_DIS
**/
  UINT8                       PchPmDisableDsxAcPresentPulldown;

/** Offset 0x067C - PCH Pm Disable Native Power Button
  Power button native mode disable.
  $EN_DIS
**/
  UINT8                       PchPmDisableNativePowerButton;

/** Offset 0x067D - PCH Pm Slp S0 Enable
  Indicates whether SLP_S0# is to be asserted when PCH reaches idle state.
  $EN_DIS
**/
  UINT8                       PchPmSlpS0Enable;

/** Offset 0x067E - PCH Pm ME_WAKE_STS
  Clear the ME_WAKE_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmMeWakeSts;

/** Offset 0x067F - PCH Pm WOL_OVR_WK_STS
  Clear the WOL_OVR_WK_STS bit in the Power and Reset Status (PRSTS) register.
  $EN_DIS
**/
  UINT8                       PchPmWolOvrWkSts;

/** Offset 0x0680 - PCH Pm Reset Power Cycle Duration
  Could be customized in the unit of second. Please refer to EDS for all support settings.
  0 is default, 1 is 1 second, 2 is 2 seconds, ...
**/
  UINT8                       PchPmPwrCycDur;

/** Offset 0x0681 - PCH Port 61h Config Enable/Disable
  Used for the emulation feature for Port61h read. The port is trapped and the SMI
  handler will toggle bit4 according to the handler's internal state.
  $EN_DIS
**/
  UINT8                       PchPort61hEnable;

/** Offset 0x0682 - PCH Sata Pwr Opt Enable
  SATA Power Optimizer on PCH side.
  $EN_DIS
**/
  UINT8                       SataPwrOptEnable;

/** Offset 0x0683 - PCH Sata eSATA Speed Limit
  When enabled, BIOS will configure the PxSCTL.SPD to 2 to limit the eSATA port speed.
  $EN_DIS
**/
  UINT8                       EsataSpeedLimit;

/** Offset 0x0684 - PCH Sata Speed Limit
  Indicates the maximum speed the SATA controller can support 0h: PchSataSpeedDefault.
**/
  UINT8                       SataSpeedLimit;

/** Offset 0x0685 - Enable SATA Port HotPlug
  Enable SATA Port HotPlug.
**/
  UINT8                       SataPortsHotPlug[8];

/** Offset 0x068D - Enable SATA Port Interlock Sw
  Enable SATA Port Interlock Sw.
**/
  UINT8                       SataPortsInterlockSw[8];

/** Offset 0x0695 - Enable SATA Port External
  Enable SATA Port External.
**/
  UINT8                       SataPortsExternal[8];

/** Offset 0x069D - Enable SATA Port SpinUp
  Enable the COMRESET initialization Sequence to the device.
**/
  UINT8                       SataPortsSpinUp[8];

/** Offset 0x06A5 - Enable SATA Port Solid State Drive
  0: HDD; 1: SSD.
**/
  UINT8                       SataPortsSolidStateDrive[8];

/** Offset 0x06AD - Enable SATA Port Enable Dito Config
  Enable DEVSLP Idle Timeout settings (DmVal, DitoVal).
**/
  UINT8                       SataPortsEnableDitoConfig[8];

/** Offset 0x06B5 - Enable SATA Port DmVal
  DITO multiplier. Default is 15.
**/
  UINT8                       SataPortsDmVal[8];

/** Offset 0x06BD
**/
  UINT8                       UnusedUpdSpace17[1];

/** Offset 0x06BE - Enable SATA Port DmVal
  DEVSLP Idle Timeout (DITO), Default is 625.
**/
  UINT16                      SataPortsDitoVal[8];

/** Offset 0x06CE - Enable SATA Port ZpOdd
  Support zero power ODD.
**/
  UINT8                       SataPortsZpOdd[8];

/** Offset 0x06D6 - PCH Sata Rst Raid Alternate Id
  Enable RAID Alternate ID.
  0:Client, 1:Alternate, 2:Server
**/
  UINT8                       SataRstRaidAlternateId;

/** Offset 0x06D7 - PCH Sata Rst Raid0
  RAID0.
  $EN_DIS
**/
  UINT8                       SataRstRaid0;

/** Offset 0x06D8 - PCH Sata Rst Raid1
  RAID1.
  $EN_DIS
**/
  UINT8                       SataRstRaid1;

/** Offset 0x06D9 - PCH Sata Rst Raid10
  RAID10.
  $EN_DIS
**/
  UINT8                       SataRstRaid10;

/** Offset 0x06DA - PCH Sata Rst Raid5
  RAID5.
  $EN_DIS
**/
  UINT8                       SataRstRaid5;

/** Offset 0x06DB - PCH Sata Rst Irrt
  Intel Rapid Recovery Technology.
  $EN_DIS
**/
  UINT8                       SataRstIrrt;

/** Offset 0x06DC - PCH Sata Rst Orom Ui Banner
  OROM UI and BANNER.
  $EN_DIS
**/
  UINT8                       SataRstOromUiBanner;

/** Offset 0x06DD - PCH Sata Rst Orom Ui Delay
  00b: 2 secs; 01b: 4 secs; 10b: 6 secs; 11: 8 secs (see: PCH_SATA_OROM_DELAY).
**/
  UINT8                       SataRstOromUiDelay;

/** Offset 0x06DE - PCH Sata Rst Hdd Unlock
  Indicates that the HDD password unlock in the OS is enabled.
  $EN_DIS
**/
  UINT8                       SataRstHddUnlock;

/** Offset 0x06DF - PCH Sata Rst Led Locate
  Indicates that the LED/SGPIO hardware is attached and ping to locate feature is
  enabled on the OS.
  $EN_DIS
**/
  UINT8                       SataRstLedLocate;

/** Offset 0x06E0 - PCH Sata Rst Irrt Only
  Allow only IRRT drives to span internal and external ports.
  $EN_DIS
**/
  UINT8                       SataRstIrrtOnly;

/** Offset 0x06E1 - PCH Sata Rst Smart Storage
  RST Smart Storage caching Bit.
  $EN_DIS
**/
  UINT8                       SataRstSmartStorage;

/** Offset 0x06E2 - PCH Sata Rst Pcie Storage Remap enable
  Enable Intel RST for PCIe Storage remapping.
**/
  UINT8                       SataRstPcieEnable[3];

/** Offset 0x06E5 - PCH Sata Rst Pcie Storage Port
  Intel RST for PCIe Storage remapping - PCIe Port Selection (1-based, 0 = autodetect).
**/
  UINT8                       SataRstPcieStoragePort[3];

/** Offset 0x06E8 - PCH Sata Rst Pcie Device Reset Delay
  PCIe Storage Device Reset Delay in milliseconds. Default value is 100ms
**/
  UINT8                       SataRstPcieDeviceResetDelay[3];

/** Offset 0x06EB - Enable Pch Serial IO GPIO
  Determines if enable Serial IO GPIO.
  $EN_DIS
**/
  UINT8                       SerialIoGpio;

/** Offset 0x06EC - IO voltage for I2C controllers
  Selects the IO voltage for I2C controllers, 0: PchSerialIoIs33V, 1: PchSerialIoIs18V.
**/
  UINT8                       SerialIoI2cVoltage[6];

/** Offset 0x06F2 - Enable Serial IRQ
  Determines if enable Serial IRQ.
  $EN_DIS
**/
  UINT8                       PchSirqEnable;

/** Offset 0x06F3 - Serial IRQ Mode Select
  Serial IRQ Mode Select, 0: quiet mode, 1: continuous mode.
  $EN_DIS
**/
  UINT8                       PchSirqMode;

/** Offset 0x06F4 - Start Frame Pulse Width
  Start Frame Pulse Width, 0: PchSfpw4Clk, 1: PchSfpw6Clk, 2: PchSfpw8Clk.
**/
  UINT8                       PchStartFramePulse;

/** Offset 0x06F5 - Enable Thermal Device
  Enable Thermal Device, 0: Disabled, 1: Enabled in PCI mode, 2: Enabled in ACPI mode.
**/
  UINT8                       PchThermalDeviceEnable;

/** Offset 0x06F6 - Thermal Throttling Custimized T0Level Value
  Custimized T0Level value.
**/
  UINT16                      PchT0Level;

/** Offset 0x06F8 - Thermal Throttling Custimized T1Level Value
  Custimized T1Level value.
**/
  UINT16                      PchT1Level;

/** Offset 0x06FA - Thermal Throttling Custimized T2Level Value
  Custimized T2Level value.
**/
  UINT16                      PchT2Level;

/** Offset 0x06FC - Thermal Device SMI Enable
  This locks down SMI Enable on Alert Thermal Sensor Trip.
  $EN_DIS
**/
  UINT8                       PchTsmicLock;

/** Offset 0x06FD - Enable The Thermal Throttle
  Enable the thermal throttle function.
  $EN_DIS
**/
  UINT8                       PchTTEnable;

/** Offset 0x06FE - PMSync State 13
  When set to 1 and the programmed GPIO pin is a 1, then PMSync state 13 will force
  at least T2 state.
  $EN_DIS
**/
  UINT8                       PchTTState13Enable;

/** Offset 0x06FF - Thermal Throttle Lock
  Thermal Throttle Lock.
  $EN_DIS
**/
  UINT8                       PchTTLock;

/** Offset 0x0700 - Thermal Throttling Suggested Setting
  Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       TTSuggestedSetting;

/** Offset 0x0701 - Enable PCH Cross Throttling
  Enable/Disable PCH Cross Throttling
  $EN_DIS
**/
  UINT8                       TTCrossThrottling;

/** Offset 0x0702 - DMI Thermal Sensor Autonomous Width Enable
  DMI Thermal Sensor Autonomous Width Enable.
  $EN_DIS
**/
  UINT8                       PchDmiTsawEn;

/** Offset 0x0703 - DMI Thermal Sensor Suggested Setting
  DMT thermal sensor suggested representative values.
  $EN_DIS
**/
  UINT8                       DmiSuggestedSetting;

/** Offset 0x0704 - Thermal Sensor 0 Target Width
  Thermal Sensor 0 Target Width.
**/
  UINT8                       DmiTS0TW;

/** Offset 0x0705 - Thermal Sensor 1 Target Width
  Thermal Sensor 1 Target Width.
**/
  UINT8                       DmiTS1TW;

/** Offset 0x0706 - Thermal Sensor 2 Target Width
  Thermal Sensor 2 Target Width.
**/
  UINT8                       DmiTS2TW;

/** Offset 0x0707 - Thermal Sensor 3 Target Width
  Thermal Sensor 3 Target Width.
**/
  UINT8                       DmiTS3TW;

/** Offset 0x0708 - Port 0 T1 Multipler
  Port 0 T1 Multipler.
**/
  UINT8                       SataP0T1M;

/** Offset 0x0709 - Port 0 T2 Multipler
  Port 0 T2 Multipler.
**/
  UINT8                       SataP0T2M;

/** Offset 0x070A - Port 0 T3 Multipler
  Port 0 T3 Multipler.
**/
  UINT8                       SataP0T3M;

/** Offset 0x070B - Port 0 Tdispatch
  Port 0 Tdispatch.
**/
  UINT8                       SataP0TDisp;

/** Offset 0x070C - Port 1 T1 Multipler
  Port 1 T1 Multipler.
**/
  UINT8                       SataP1T1M;

/** Offset 0x070D - Port 1 T2 Multipler
  Port 1 T2 Multipler.
**/
  UINT8                       SataP1T2M;

/** Offset 0x070E - Port 1 T3 Multipler
  Port 1 T3 Multipler.
**/
  UINT8                       SataP1T3M;

/** Offset 0x070F - Port 1 Tdispatch
  Port 1 Tdispatch.
**/
  UINT8                       SataP1TDisp;

/** Offset 0x0710 - Port 0 Tinactive
  Port 0 Tinactive.
**/
  UINT8                       SataP0Tinact;

/** Offset 0x0711 - Port 0 Alternate Fast Init Tdispatch
  Port 0 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP0TDispFinit;

/** Offset 0x0712 - Port 1 Tinactive
  Port 1 Tinactive.
**/
  UINT8                       SataP1Tinact;

/** Offset 0x0713 - Port 1 Alternate Fast Init Tdispatch
  Port 1 Alternate Fast Init Tdispatch.
  $EN_DIS
**/
  UINT8                       SataP1TDispFinit;

/** Offset 0x0714 - Sata Thermal Throttling Suggested Setting
  Sata Thermal Throttling Suggested Setting.
  $EN_DIS
**/
  UINT8                       SataThermalSuggestedSetting;

/** Offset 0x0715 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
  $EN_DIS
**/
  UINT8                       PchMemoryThrottlingEnable;

/** Offset 0x0716 - Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPmsyncEnable[2];

/** Offset 0x0718 - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryC0TransmitEnable[2];

/** Offset 0x071A - Enable Memory Thermal Throttling
  Enable Memory Thermal Throttling.
**/
  UINT8                       PchMemoryPinSelection[2];

/** Offset 0x071C - Thermal Device Temperature
  Decides the temperature.
**/
  UINT16                      PchTemperatureHotLevel;

/** Offset 0x071E - Disable XHCI Compliance Mode
  This policy will disable XHCI compliance mode on all ports. Complicance Mode should
  be default enabled.
  $EN_DIS
**/
  UINT8                       PchDisableComplianceMode;

/** Offset 0x071F - USB2 Port Over Current Pin
  Describe the specific over current pin number of USB 2.0 Port N.
**/
  UINT8                       Usb2OverCurrentPin[16];

/** Offset 0x072F - USB3 Port Over Current Pin
  Describe the specific over current pin number of USB 3.0 Port N.
**/
  UINT8                       Usb3OverCurrentPin[10];

/** Offset 0x0739 - Enable 8254 Static Clock Gating in early POST time
  Set 8254CGE=1 is required for C11 support. However, set 8254CGE=1 in POST time might
  fail to boot legacy OS which using 8254 timer. Make sure it won't break legacy
  OS boot before enabling this.
  $EN_DIS
**/
  UINT8                       Early8254ClockGatingEnable;

/** Offset 0x073A - PCH Sata Rst Optane Memory
  Optane Memory
  $EN_DIS
**/
  UINT8                       SataRstOptaneMemory;

/** Offset 0x073B - PCH SATA RST CPU attached storage
  RST CPU attached storage
  $EN_DIS
**/
  UINT8                       SataRstCpuAttachedStorage;

/** Offset 0x073C - Pch PCIE device override table pointer
  The PCIe device table is being used to override PCIe device ASPM settings. This
  is a pointer points to a 32bit address. And it's only used in PostMem phase. Please
  refer to PCH_PCIE_DEVICE_OVERRIDE structure for the table. Last entry VendorId
  must be 0.
**/
  UINT32                      PchPcieDeviceOverrideTablePtr;

/** Offset 0x0740 - Enable TCO timer.
  When FALSE, it disables PCH ACPI timer, and stops TCO timer. NOTE: This will have
  huge power impact when it's enabled. If TCO timer is disabled, uCode ACPI timer
  emulation must be enabled, and WDAT table must not be exposed to the OS.
  $EN_DIS
**/
  UINT8                       EnableTcoTimer;

/** Offset 0x0741 - Enable PS_ON.
  PS_ON is a new C10 state from the CPU on desktop SKUs that enables a lower power
  target that will be required by the California Energy Commission (CEC). When FALSE,
  PS_ON is to be disabled.
  $EN_DIS
**/
  UINT8                       PsOnEnable;

/** Offset 0x0742 - GPIO RCOMP Community Clock Gating
  0 = Disable dynamic RCOMP clock local clock gating, 1 = Enable dynamic RCOMP clock
  local clock gating, default value is 1
  $EN_DIS
**/
  UINT8                       GpioPmRcompCommunityLocalClockGating;

/** Offset 0x0743 - Hybrid Storage Mode
  Enables support for Hybrid storage devices. 0: Disabled; 1: Dynamic Configuration.
  Default is 0: Disabled
  0: Disabled, 1: Dynamic Configuration
**/
  UINT8                       HybridStorageMode;

/** Offset 0x0744 - Set SATA DEVSLP GPIO Reset Config
  Set SATA DEVSLP GPIO Reset Config per port. 0x00 - GpioResetDefault, 0x01 - GpioResumeReset,
  0x03 - GpioHostDeepReset, 0x05 - GpioPlatformReset, 0x07 - GpioDswReset. One byte
  for each port, byte0 for port0, byte1 for port1, and so on.
**/
  UINT8                       SataPortsDevSlpResetConfig[8];

/** Offset 0x074C - ReservedPchPostMem
  Reserved for Pch Post-Mem
  $EN_DIS
**/
  UINT8                       ReservedPchPostMem[8];

/** Offset 0x0754
**/
  UINT8                       UnusedUpdSpace18[4];

/** Offset 0x0758 - BgpdtHash[4]
  BgpdtHash values
**/
  UINT64                      BgpdtHash[4];

/** Offset 0x0778 - BiosGuardAttr
  BiosGuardAttr default values
**/
  UINT32                      BiosGuardAttr;

/** Offset 0x077C
**/
  UINT8                       UnusedUpdSpace19[4];

/** Offset 0x0780 - BiosGuardModulePtr
  BiosGuardModulePtr default values
**/
  UINT64                      BiosGuardModulePtr;

/** Offset 0x0788 - SendEcCmd
  SendEcCmd function pointer. \n
  @code typedef EFI_STATUS (EFIAPI *PLATFORM_SEND_EC_COMMAND) (IN EC_COMMAND_TYPE
  EcCmdType, IN UINT8  EcCmd, IN UINT8  SendData, IN OUT UINT8  *ReceiveData); @endcode
**/
  UINT64                      SendEcCmd;

/** Offset 0x0790 - EcCmdProvisionEav
  Ephemeral Authorization Value default values. Provisions an ephemeral shared secret to the EC
**/
  UINT8                       EcCmdProvisionEav;

/** Offset 0x0791 - EcCmdLock
  EcCmdLock default values. Locks Ephemeral Authorization Value sent previously
**/
  UINT8                       EcCmdLock;

/** Offset 0x0792
**/
  UINT8                       UnusedUpdSpace20[6];

/** Offset 0x0798 - SgxEpoch0
  SgxEpoch0 default values
**/
  UINT64                      SgxEpoch0;

/** Offset 0x07A0 - SgxEpoch1
  SgxEpoch1 default values
**/
  UINT64                      SgxEpoch1;

/** Offset 0x07A8 - SgxSinitNvsData
  SgxSinitNvsData default values
**/
  UINT8                       SgxSinitNvsData;

/** Offset 0x07A9 - Si Config CSM Flag.
  Platform specific common policies that used by several silicon components. CSM status flag.
  $EN_DIS
**/
  UINT8                       SiCsmFlag;

/** Offset 0x07AA
**/
  UINT8                       UnusedUpdSpace21[2];

/** Offset 0x07AC - SVID SDID table Poniter.
  The address of the table of SVID SDID to customize each SVID SDID entry.
**/
  UINT32                      SiSsidTablePtr;

/** Offset 0x07B0 - Number of ssid table.
  SiNumberOfSsidTableEntry should match the table entries created in SiSsidTablePtr.
**/
  UINT16                      SiNumberOfSsidTableEntry;

/** Offset 0x07B2 - SATA RST Interrupt Mode
  Allowes to choose which interrupts will be implemented by SATA controller in RAID mode.
  0:Msix, 1:Msi, 2:Legacy
**/
  UINT8                       SataRstInterrupt;

/** Offset 0x07B3 - ME Unconfig on RTC clear
  0: Disable ME Unconfig On Rtc Clear. <b>1: Enable ME Unconfig On Rtc Clear</b>.
  2: Cmos is clear, status unkonwn. 3: Reserved
  0: Disable ME Unconfig On Rtc Clear, 1: Enable ME Unconfig On Rtc Clear, 2: Cmos
  is clear, 3: Reserved
**/
  UINT8                       MeUnconfigOnRtcClear;

/** Offset 0x07B4
**/
  UINT8                       UnusedUpdSpace22[3];

/** Offset 0x07B7
**/
  UINT8                       ReservedFspsUpd[1];
} FSP_S_CONFIG;

/** Fsp S Test Configuration
**/
typedef struct {

/** Offset 0x07B8
**/
  UINT32                      Signature;

/** Offset 0x07BC - Enable/Disable Device 7
  Enable: Device  7 enabled, Disable (Default): Device 7 disabled
  $EN_DIS
**/
  UINT8                       ChapDeviceEnable;

/** Offset 0x07BD - Skip PAM register lock
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  $EN_DIS
**/
  UINT8                       SkipPamLock;

/** Offset 0x07BE - EDRAM Test Mode
  Enable: PAM register will not be locked by RC, platform code should lock it, Disable(Default):
  PAM registers will be locked by RC
  0: EDRAM SW disable, 1: EDRAM SW Enable, 2: EDRAM HW mode
**/
  UINT8                       EdramTestMode;

/** Offset 0x07BF - DMI Extended Sync Control
  Enable: Enable DMI Extended Sync Control, Disable(Default): Disable DMI Extended
  Sync Control
  $EN_DIS
**/
  UINT8                       DmiExtSync;

/** Offset 0x07C0 - DMI IOT Control
  Enable: Enable DMI IOT Control, Disable(Default): Disable DMI IOT Control
  $EN_DIS
**/
  UINT8                       DmiIot;

/** Offset 0x07C1 - PEG Max Payload size per root port
  0xFF(Default):Auto, 0x1: Force 128B, 0x2: Force 256B
  0xFF: Auto, 0x1: Force 128B, 0x2: Force 256B
**/
  UINT8                       PegMaxPayload[4];

/** Offset 0x07C5 - Enable/Disable IGFX RenderStandby
  Enable(Default): Enable IGFX RenderStandby, Disable: Disable IGFX RenderStandby
  $EN_DIS
**/
  UINT8                       RenderStandby;

/** Offset 0x07C6 - Enable/Disable IGFX PmSupport
  Enable(Default): Enable IGFX PmSupport, Disable: Disable IGFX PmSupport
  $EN_DIS
**/
  UINT8                       PmSupport;

/** Offset 0x07C7 - Enable/Disable CdynmaxClamp
  Enable(Default): Enable CdynmaxClamp, Disable: Disable CdynmaxClamp
  $EN_DIS
**/
  UINT8                       CdynmaxClampEnable;

/** Offset 0x07C8 - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisableDeprecated;

/** Offset 0x07C9 - GT Frequency Limit
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
  0xFF: Auto(Default), 2: 100 Mhz, 3: 150 Mhz, 4: 200 Mhz, 5: 250 Mhz, 6: 300 Mhz,
  7: 350 Mhz, 8: 400 Mhz, 9: 450 Mhz, 0xA: 500 Mhz, 0xB: 550 Mhz, 0xC: 600 Mhz, 0xD:
  650 Mhz, 0xE: 700 Mhz, 0xF: 750 Mhz, 0x10: 800 Mhz, 0x11: 850 Mhz, 0x12:900 Mhz,
  0x13: 950 Mhz, 0x14: 1000 Mhz, 0x15: 1050 Mhz, 0x16: 1100 Mhz, 0x17: 1150 Mhz,
  0x18: 1200 Mhz
**/
  UINT8                       GtFreqMax;

/** Offset 0x07CA - Disable Turbo GT
   0=Disable: GT frequency is not limited, 1=Enable: Disables Turbo GT frequency
  $EN_DIS
**/
  UINT8                       DisableTurboGt;

/** Offset 0x07CB - SaPostMemTestRsvd
  Reserved for SA Post-Mem Test
  $EN_DIS
**/
  UINT8                       SaPostMemTestRsvd[11];

/** Offset 0x07D6 - 1-Core Ratio Limit
  1-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 1-Core
  Ratio Limit Must be greater than or equal to 2-Core Ratio Limit, 3-Core Ratio Limit,
  4-Core Ratio Limit, 5-Core Ratio Limit, 6-Core Ratio Limit, 7-Core Ratio Limit,
  8-Core Ratio Limit. Range is 0 to 255
**/
  UINT8                       OneCoreRatioLimit;

/** Offset 0x07D7 - 2-Core Ratio Limit
  2-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 2-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
**/
  UINT8                       TwoCoreRatioLimit;

/** Offset 0x07D8 - 3-Core Ratio Limit
  3-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 3-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
**/
  UINT8                       ThreeCoreRatioLimit;

/** Offset 0x07D9 - 4-Core Ratio Limit
  4-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 4-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
**/
  UINT8                       FourCoreRatioLimit;

/** Offset 0x07DA - Enable or Disable HWP
  Enable or Disable HWP(Hardware P states) Support. 0: Disable; <b>1: Enable;</b>
  2-3:Reserved
  $EN_DIS
**/
  UINT8                       Hwp;

/** Offset 0x07DB - Hardware Duty Cycle Control
  Hardware Duty Cycle Control configuration. 0: Disabled; <b>1: Enabled</b> 2-3:Reserved
  $EN_DIS
**/
  UINT8                       HdcControl;

/** Offset 0x07DC - Package Long duration turbo mode time
  Package Long duration turbo mode time window in seconds. 0 = AUTO, uses 28 seconds.
  Valid values(Unit in seconds) 1 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40
  , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PowerLimit1Time;

/** Offset 0x07DD - Short Duration Turbo Mode
  Enable or Disable short duration Turbo Mode. </b>0 : Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PowerLimit2;

/** Offset 0x07DE - Turbo settings Lock
  Lock all Turbo settings Enable/Disable; <b>0: Disable , </b> 1: Enable
  $EN_DIS
**/
  UINT8                       TurboPowerLimitLock;

/** Offset 0x07DF - Package PL3 time window
  Package PL3 time window range for this policy from 0 to 64ms
**/
  UINT8                       PowerLimit3Time;

/** Offset 0x07E0 - Package PL3 Duty Cycle
  Package PL3 Duty Cycle; Valid Range is 0 to 100
**/
  UINT8                       PowerLimit3DutyCycle;

/** Offset 0x07E1 - Package PL3 Lock
  Package PL3 Lock Enable/Disable; <b>0: Disable ; <b> 1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit3Lock;

/** Offset 0x07E2 - Package PL4 Lock
  Package PL4 Lock Enable/Disable; <b>0: Disable ; <b>1: Enable
  $EN_DIS
**/
  UINT8                       PowerLimit4Lock;

/** Offset 0x07E3 - TCC Activation Offset
  TCC Activation Offset. Offset from factory set TCC activation temperature at which
  the Thermal Control Circuit must be activated. TCC will be activated at TCC Activation
  Temperature, in volts.For Y SKU, the recommended default for this policy is  <b>15</b>,
  For all other SKUs the recommended default are <b>0</b>
**/
  UINT8                       TccActivationOffset;

/** Offset 0x07E4 - Tcc Offset Clamp Enable/Disable
  Tcc Offset Clamp for Runtime Average Temperature Limit (RATL) allows CPU to throttle
  below P1.For Y SKU, the recommended default for this policy is <b>1: Enabled</b>,
  For all other SKUs the recommended default are  <b>0: Disabled</b>.
  $EN_DIS
**/
  UINT8                       TccOffsetClamp;

/** Offset 0x07E5 - Tcc Offset Lock
  Tcc Offset Lock for Runtime Average Temperature Limit (RATL) to lock temperature
  target; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       TccOffsetLock;

/** Offset 0x07E6 - Custom Ratio State Entries
  The number of custom ratio state entries, ranges from 0 to 40 for a valid custom
  ratio table.Sets the number of custom P-states. At least 2 states must be present
**/
  UINT8                       NumberOfEntries;

/** Offset 0x07E7 - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 1. Valid Range 0
  to 128, 0 = AUTO
**/
  UINT8                       Custom1PowerLimit1Time;

/** Offset 0x07E8 - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 1. Valid Range 0 to 255
**/
  UINT8                       Custom1TurboActivationRatio;

/** Offset 0x07E9 - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom1ConfigTdpControl;

/** Offset 0x07EA - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 2. Valid Range 0
  to 128, 0 = AUTO
**/
  UINT8                       Custom2PowerLimit1Time;

/** Offset 0x07EB - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 2. Valid Range 0 to 255
**/
  UINT8                       Custom2TurboActivationRatio;

/** Offset 0x07EC - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom2ConfigTdpControl;

/** Offset 0x07ED - Custom Short term Power Limit time window
  Short term Power Limit time window value for custom CTDP level 3. Valid Range 0
  to 128, 0 = AUTO
**/
  UINT8                       Custom3PowerLimit1Time;

/** Offset 0x07EE - Custom Turbo Activation Ratio
  Turbo Activation Ratio for custom cTDP level 3. Valid Range 0 to 255
**/
  UINT8                       Custom3TurboActivationRatio;

/** Offset 0x07EF - Custom Config Tdp Control
  Config Tdp Control (0/1/2) value for custom cTDP level 1. Valid Range is 0 to 2
**/
  UINT8                       Custom3ConfigTdpControl;

/** Offset 0x07F0 - ConfigTdp mode settings Lock
  Lock the ConfigTdp mode settings from runtime changes; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ConfigTdpLock;

/** Offset 0x07F1 - Load Configurable TDP SSDT
  Configure whether to load Configurable TDP SSDT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ConfigTdpBios;

/** Offset 0x07F2 - PL1 Enable value
  PL1 Enable value to limit average platform power. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit1;

/** Offset 0x07F3 - PL1 timewindow
  PL1 timewindow in seconds. 0 = AUTO, uses 28 seconds. Valid values(Unit in seconds)
  1 to 8 , 10 , 12 ,14 , 16 , 20 , 24 , 28 , 32 , 40 , 48 , 56 , 64 , 80 , 96 , 112 , 128
**/
  UINT8                       PsysPowerLimit1Time;

/** Offset 0x07F4 - PL2 Enable Value
  PL2 Enable activates the PL2 value to limit average platform power.<b>0: Disable</b>;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PsysPowerLimit2;

/** Offset 0x07F5 - Enable or Disable MLC Streamer Prefetcher
  Enable or Disable MLC Streamer Prefetcher; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MlcStreamerPrefetcher;

/** Offset 0x07F6 - Enable or Disable MLC Spatial Prefetcher
  Enable or Disable MLC Spatial Prefetcher; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       MlcSpatialPrefetcher;

/** Offset 0x07F7 - Enable or Disable Monitor /MWAIT instructions
  Enable or Disable Monitor /MWAIT instructions; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MonitorMwaitEnable;

/** Offset 0x07F8 - Enable or Disable initialization of machine check registers
  Enable or Disable initialization of machine check registers; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       MachineCheckEnable;

/** Offset 0x07F9 - Deprecated DO NOT USE Enable or Disable processor debug features
  @deprecated Enable or Disable processor debug features; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x07FA - Lock or Unlock debug interface features
  Lock or Unlock debug interface features; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x07FB - AP Idle Manner of waiting for SIPI
  AP Idle Manner of waiting for SIPI; 1: HALT loop; <b>2: MWAIT loop</b>; 3: RUN loop.
  1: HALT loop, 2: MWAIT loop, 3: RUN loop
**/
  UINT8                       ApIdleManner;

/** Offset 0x07FC - Control on Processor Trace output scheme
  Control on Processor Trace output scheme; <b>0: Single Range Output</b>; 1: ToPA Output.
  0: Single Range Output, 1: ToPA Output
**/
  UINT8                       ProcessorTraceOutputScheme;

/** Offset 0x07FD - Enable or Disable Processor Trace feature
  Enable or Disable Processor Trace feature; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcessorTraceEnable;

/** Offset 0x07FE
**/
  UINT8                       UnusedUpdSpace23[2];

/** Offset 0x0800 - Base of memory region allocated for Processor Trace
  Base address of memory region allocated for Processor Trace. Processor Trace requires
  2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT64                      ProcessorTraceMemBase;

/** Offset 0x0808 - Memory region allocation for Processor Trace
  Length in bytes of memory region allocated for Processor Trace. Processor Trace
  requires 2^N alignment and size in bytes per thread, from 4KB to 128MB. <b>0: Disable</b>
**/
  UINT32                      ProcessorTraceMemLength;

/** Offset 0x080C - Enable or Disable Voltage Optimization feature
  Enable or Disable Voltage Optimization feature 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       VoltageOptimization;

/** Offset 0x080D - Enable or Disable Intel SpeedStep Technology
  Enable or Disable Intel SpeedStep Technology. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Eist;

/** Offset 0x080E - Enable or Disable Energy Efficient P-state
  Enable or Disable Energy Efficient P-state will be applied in Turbo mode. Disable;
  <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       EnergyEfficientPState;

/** Offset 0x080F - Enable or Disable Energy Efficient Turbo
  Enable or Disable Energy Efficient Turbo, will be applied in Turbo mode. Disable;
  1: Enable, <b>2: Auto / Silicon default</b>
  0: Disable, 1: Enable, 2: Auto
**/
  UINT8                       EnergyEfficientTurbo;

/** Offset 0x0810 - Enable or Disable T states
  Enable or Disable T states; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TStates;

/** Offset 0x0811 - Enable or Disable Bi-Directional PROCHOT#
  Enable or Disable Bi-Directional PROCHOT#; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       BiProcHot;

/** Offset 0x0812 - Enable or Disable PROCHOT# signal being driven externally
  Enable or Disable PROCHOT# signal being driven externally; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DisableProcHotOut;

/** Offset 0x0813 - Enable or Disable PROCHOT# Response
  Enable or Disable PROCHOT# Response; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       ProcHotResponse;

/** Offset 0x0814 - Enable or Disable VR Thermal Alert
  Enable or Disable VR Thermal Alert; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       DisableVrThermalAlert;

/** Offset 0x0815 - Enable or Disable Thermal Reporting
  Enable or Disable Thermal Reporting through ACPI tables; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       AutoThermalReporting;

/** Offset 0x0816 - Enable or Disable Thermal Monitor
  Enable or Disable Thermal Monitor; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       ThermalMonitor;

/** Offset 0x0817 - Enable or Disable CPU power states (C-states)
  Enable or Disable CPU power states (C-states). 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       Cx;

/** Offset 0x0818 - Configure C-State Configuration Lock
  Configure C-State Configuration Lock; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       PmgCstCfgCtrlLock;

/** Offset 0x0819 - Enable or Disable Enhanced C-states
  Enable or Disable Enhanced C-states. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1e;

/** Offset 0x081A - Enable or Disable Package Cstate Demotion
  Enable or Disable Package Cstate Demotion. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       PkgCStateDemotion;

/** Offset 0x081B - Enable or Disable Package Cstate UnDemotion
  Enable or Disable Package Cstate UnDemotion. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       PkgCStateUnDemotion;

/** Offset 0x081C - Enable or Disable CState-Pre wake
  Enable or Disable CState-Pre wake. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CStatePreWake;

/** Offset 0x081D - Enable or Disable TimedMwait Support.
  Enable or Disable TimedMwait Support. <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       TimedMwait;

/** Offset 0x081E - Enable or Disable IO to MWAIT redirection
  Enable or Disable IO to MWAIT redirection; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CstCfgCtrIoMwaitRedirection;

/** Offset 0x081F - Set the Max Pkg Cstate
  Set the Max Pkg Cstate. Default set to Auto which limits the Max Pkg Cstate to deep
  C-state. Valid values 0 - C0/C1 , 1 - C2 , 2 - C3 , 3 - C6 , 4 - C7 , 5 - C7S ,
  6 - C8 , 7 - C9 , 8 - C10 , 254 - CPU Default , 255 - Auto
**/
  UINT8                       PkgCStateLimit;

/** Offset 0x0820 - TimeUnit for C-State Latency Control0
  TimeUnit for C-State Latency Control0; Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl0TimeUnit;

/** Offset 0x0821 - TimeUnit for C-State Latency Control1
  TimeUnit for C-State Latency Control1;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl1TimeUnit;

/** Offset 0x0822 - TimeUnit for C-State Latency Control2
  TimeUnit for C-State Latency Control2;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl2TimeUnit;

/** Offset 0x0823 - TimeUnit for C-State Latency Control3
  TimeUnit for C-State Latency Control3;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl3TimeUnit;

/** Offset 0x0824 - TimeUnit for C-State Latency Control4
  Time - 1ns , 1 - 32ns , 2 - 1024ns , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl4TimeUnit;

/** Offset 0x0825 - TimeUnit for C-State Latency Control5
  TimeUnit for C-State Latency Control5;Valid values 0 - 1ns , 1 - 32ns , 2 - 1024ns
  , 3 - 32768ns , 4 - 1048576ns , 5 - 33554432ns
**/
  UINT8                       CstateLatencyControl5TimeUnit;

/** Offset 0x0826 - Interrupt Redirection Mode Select
  Interrupt Redirection Mode Select.0: Fixed priority; 1: Round robin;2: Hash vector;4:
  PAIR with fixed priority;5: PAIR with round robin;6: PAIR with hash vector;7: No change.
**/
  UINT8                       PpmIrmSetting;

/** Offset 0x0827 - Lock prochot configuration
  Lock prochot configuration Enable/Disable; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       ProcHotLock;

/** Offset 0x0828 - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x0829 - Race To Halt
  Enable/Disable Race To Halt feature. RTH will dynamically increase CPU frequency
  in order to enter pkg C-State faster to reduce overall power. (RTH is controlled
  through MSR 1FC bit 20)Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       RaceToHalt;

/** Offset 0x082A - Max P-State Ratio
  Max P-State Ratio, Valid Range 0 to 0x7F
**/
  UINT8                       MaxRatio;

/** Offset 0x082B - P-state ratios for custom P-state table
  P-state ratios for custom P-state table. NumberOfEntries has valid range between
  0 to 40. For no. of P-States supported(NumberOfEntries) , StateRatio[NumberOfEntries]
  are configurable. Valid Range of each entry is 0 to 0x7F
**/
  UINT8                       StateRatio[40];

/** Offset 0x0853 - P-state ratios for max 16 version of custom P-state table
  P-state ratios for max 16 version of custom P-state table. This table is used for
  OS versions limited to a max of 16 P-States. If the first entry of this table is
  0, or if Number of Entries is 16 or less, then this table will be ignored, and
  up to the top 16 values of the StateRatio table will be used instead. Valid Range
  of each entry is 0 to 0x7F
**/
  UINT8                       StateRatioMax16[16];

/** Offset 0x0863
**/
  UINT8                       UnusedUpdSpace24;

/** Offset 0x0864 - Platform Power Pmax
  PCODE MMIO Mailbox: Platform Power Pmax. <b>0 - Auto</b> Specified in 1/8 Watt increments.
  Range 0-1024 Watts. Value of 800 = 100W
**/
  UINT16                      PsysPmax;

/** Offset 0x0866 - Interrupt Response Time Limit of C-State LatencyContol0
  Interrupt Response Time Limit of C-State LatencyContol0.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl0Irtl;

/** Offset 0x0868 - Interrupt Response Time Limit of C-State LatencyContol1
  Interrupt Response Time Limit of C-State LatencyContol1.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl1Irtl;

/** Offset 0x086A - Interrupt Response Time Limit of C-State LatencyContol2
  Interrupt Response Time Limit of C-State LatencyContol2.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl2Irtl;

/** Offset 0x086C - Interrupt Response Time Limit of C-State LatencyContol3
  Interrupt Response Time Limit of C-State LatencyContol3.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl3Irtl;

/** Offset 0x086E - Interrupt Response Time Limit of C-State LatencyContol4
  Interrupt Response Time Limit of C-State LatencyContol4.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl4Irtl;

/** Offset 0x0870 - Interrupt Response Time Limit of C-State LatencyContol5
  Interrupt Response Time Limit of C-State LatencyContol5.Range of value 0 to 0x3FF
**/
  UINT16                      CstateLatencyControl5Irtl;

/** Offset 0x0872
**/
  UINT8                       UnusedUpdSpace25[2];

/** Offset 0x0874 - Package Long duration turbo mode power limit
  Package Long duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.
  Valid Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit1;

/** Offset 0x0878 - Package Short duration turbo mode power limit
  Package Short duration turbo mode power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit2Power;

/** Offset 0x087C - Package PL3 power limit
  Package PL3 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      PowerLimit3;

/** Offset 0x0880 - Package PL4 power limit
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 1023875 in Step size of 125
**/
  UINT32                      PowerLimit4;

/** Offset 0x0884 - Tcc Offset Time Window for RATL
  Package PL4 power limit. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 1023875 in Step size of 125
**/
  UINT32                      TccOffsetTimeWindowForRatl;

/** Offset 0x0888 - Short term Power Limit value for custom cTDP level 1
  Short term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit1;

/** Offset 0x088C - Long term Power Limit value for custom cTDP level 1
  Long term Power Limit value for custom cTDP level 1. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom1PowerLimit2;

/** Offset 0x0890 - Short term Power Limit value for custom cTDP level 2
  Short term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit1;

/** Offset 0x0894 - Long term Power Limit value for custom cTDP level 2
  Long term Power Limit value for custom cTDP level 2. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom2PowerLimit2;

/** Offset 0x0898 - Short term Power Limit value for custom cTDP level 3
  Short term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit1;

/** Offset 0x089C - Long term Power Limit value for custom cTDP level 3
  Long term Power Limit value for custom cTDP level 3. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid
  Range 0 to 4095875 in Step size of 125
**/
  UINT32                      Custom3PowerLimit2;

/** Offset 0x08A0 - Platform PL1 power
  Platform PL1 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit1Power;

/** Offset 0x08A4 - Platform PL2 power
  Platform PL2 power. Units are based on POWER_MGMT_CONFIG.CustomPowerUnit.Valid Range
  0 to 4095875 in Step size of 125
**/
  UINT32                      PsysPowerLimit2Power;

/** Offset 0x08A8 - Set Three Strike Counter Disable
  False (default): Three Strike counter will be incremented and True: Prevents Three
  Strike counter from incrementing; <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       ThreeStrikeCounterDisable;

/** Offset 0x08A9 - Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT
  Set HW P-State Interrupts Enabled for for MISC_PWR_MGMT; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       HwpInterruptControl;

/** Offset 0x08AA - 5-Core Ratio Limit
  5-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 5-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
  0x0:0xFF
**/
  UINT8                       FiveCoreRatioLimit;

/** Offset 0x08AB - 6-Core Ratio Limit
  6-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 6-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
  0x0:0xFF
**/
  UINT8                       SixCoreRatioLimit;

/** Offset 0x08AC - 7-Core Ratio Limit
  7-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 7-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
  0x0:0xFF
**/
  UINT8                       SevenCoreRatioLimit;

/** Offset 0x08AD - 8-Core Ratio Limit
  8-Core Ratio Limit: LFM to Fused, For overclocking part: LFM to 255. This 8-Core
  Ratio Limit Must be Less than or equal to 1-Core Ratio Limit.Range is 0 to 255
  0x0:0xFF
**/
  UINT8                       EightCoreRatioLimit;

/** Offset 0x08AE - Intel Turbo Boost Max Technology 3.0
  Intel Turbo Boost Max Technology 3.0. 0: Disabled; <b>1: Enabled</b>
  $EN_DIS
**/
  UINT8                       EnableItbm;

/** Offset 0x08AF - Intel Turbo Boost Max Technology 3.0 Driver
  @deprecated Intel Turbo Boost Max Technology 3.0 Driver <b>0: Disabled</b>; 1: Enabled
  $EN_DIS
**/
  UINT8                       EnableItbmDriver;

/** Offset 0x08B0 - Enable or Disable C1 Cstate Demotion
  Enable or Disable C1 Cstate Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateAutoDemotion;

/** Offset 0x08B1 - Enable or Disable C1 Cstate UnDemotion
  Enable or Disable C1 Cstate UnDemotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C1StateUnDemotion;

/** Offset 0x08B2 - CpuWakeUpTimer
  Enable long CPU Wakeup Timer. When enabled, the cpu internal wakeup time is increased
  to 180 seconds. 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       CpuWakeUpTimer;

/** Offset 0x08B3 - Minimum Ring ratio limit override
  Minimum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MinRingRatioLimit;

/** Offset 0x08B4 - Minimum Ring ratio limit override
  Maximum Ring ratio limit override. <b>0: Hardware defaults.</b> Range: 0 - Max turbo
  ratio limit
**/
  UINT8                       MaxRingRatioLimit;

/** Offset 0x08B5 - Enable or Disable C3 Cstate Demotion
  Enable or Disable C3 Cstate Demotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C3StateAutoDemotion;

/** Offset 0x08B6 - Enable or Disable C3 Cstate UnDemotion
  Enable or Disable C3 Cstate UnDemotion. Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       C3StateUnDemotion;

/** Offset 0x08B7 - Ratio Limit Num Core 0
  Ratio Limit Num Core0: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore0;

/** Offset 0x08B8 - Ratio Limit Num Core 1
  Ratio Limit Num Core1: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore1;

/** Offset 0x08B9 - Ratio Limit Num Core 2
  Ratio Limit Num Core2: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore2;

/** Offset 0x08BA - Ratio Limit Core 3
  Ratio Limit Num Core3: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore3;

/** Offset 0x08BB - Ratio Limit Num Core 4
  Ratio Limit Num Core4: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore4;

/** Offset 0x08BC - Ratio Limit Num Core 5
  Ratio Limit Num Core5: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore5;

/** Offset 0x08BD - Ratio Limit Num Core 6
  Ratio Limit Num Core6: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore6;

/** Offset 0x08BE - Ratio Limit Num Core 7
  Ratio Limit Num Core7: This register defines the active core ranges for each frequency point
**/
  UINT8                       RatioLimitNumCore7;

/** Offset 0x08BF - Dual Tau Boost
  Enable, Disable Dual Tau Boost feature. This is only applicable for CMLS; <b>0:
  Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       DualTauBoost;

/** Offset 0x08C0 - ITBMT 3.0 Runtime Periodic SMM timer
  Periodic SMM Polling timer for ITBMT 3.0 <b>Default 4 - 8 Sec</b>. 0 = Diable periodic
  SMM, and Valid values 1 - 16ms , 2 - 32ms , 3 - 64ms , 4 - 8 sec , 5 - 16 sec,
  6 - 32 sec, 7 - 64 sec.
**/
  UINT8                       ItbmPeriodicSmmTimer;

/** Offset 0x08C1 - ReservedCpuPostMemTest
  Reserved for CPU Post-Mem Test
  $EN_DIS
**/
  UINT8                       ReservedCpuPostMemTest[9];

/** Offset 0x08CA - SgxSinitDataFromTpm
  SgxSinitDataFromTpm default values
**/
  UINT8                       SgxSinitDataFromTpm;

/** Offset 0x08CB - End of Post message
  Test, Send End of Post message. Disable(0x0): Disable EOP message, Enable(0x1)(Default):
  Enable EOP message
  $EN_DIS
**/
  UINT8                       EndOfPostMessage;

/** Offset 0x08CC - D0I3 Setting for HECI Disable
  Test, 0: disable, 1: enable, Setting this option disables setting D0I3 bit for all
  HECI devices
  $EN_DIS
**/
  UINT8                       DisableD0I3SettingForHeci;

/** Offset 0x08CD - Enable LOCKDOWN SMI
  Enable SMI_LOCK bit to prevent writes to the Global SMI Enable bit.
  $EN_DIS
**/
  UINT8                       PchLockDownGlobalSmi;

/** Offset 0x08CE - HD Audio Reset Wait Timer
  The delay timer after Azalia reset, the value is number of microseconds. Default is 600.
**/
  UINT16                      PchHdaResetWaitTimer;

/** Offset 0x08D0 - Enable LOCKDOWN BIOS Interface
  Enable BIOS Interface Lock Down bit to prevent writes to the Backup Control Register.
  $EN_DIS
**/
  UINT8                       PchLockDownBiosInterface;

/** Offset 0x08D1 - RTC CMOS RAM LOCK
  Enable RTC lower and upper 128 byte Lock bits to lock Bytes 38h-3Fh in the upper
  and and lower 128-byte bank of RTC RAM.
  $EN_DIS
**/
  UINT8                       PchLockDownRtcLock;

/** Offset 0x08D2 - PCH Sbi lock bit
  This unlock the SBI lock bit to allow SBI after post time. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchSbiUnlock;

/** Offset 0x08D3 - PCH Psf lock bit
  The PSF registers will be locked before 3rd party code execution. 0: Disable; 1: Enable.
  $EN_DIS
**/
  UINT8                       PchSbAccessUnlock;

/** Offset 0x08D4 - PCIE RP Ltr Max Snoop Latency
  Latency Tolerance Reporting, Max Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxSnoopLatency[24];

/** Offset 0x0904 - PCIE RP Ltr Max No Snoop Latency
  Latency Tolerance Reporting, Max Non-Snoop Latency.
**/
  UINT16                      PcieRpLtrMaxNoSnoopLatency[24];

/** Offset 0x0934 - PCIE RP Snoop Latency Override Mode
  Latency Tolerance Reporting, Snoop Latency Override Mode.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMode[24];

/** Offset 0x094C - PCIE RP Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpSnoopLatencyOverrideMultiplier[24];

/** Offset 0x0964 - PCIE RP Snoop Latency Override Value
  Latency Tolerance Reporting, Snoop Latency Override Value.
**/
  UINT16                      PcieRpSnoopLatencyOverrideValue[24];

/** Offset 0x0994 - PCIE RP Non Snoop Latency Override Mode
  Latency Tolerance Reporting, Non-Snoop Latency Override Mode.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMode[24];

/** Offset 0x09AC - PCIE RP Non Snoop Latency Override Multiplier
  Latency Tolerance Reporting, Non-Snoop Latency Override Multiplier.
**/
  UINT8                       PcieRpNonSnoopLatencyOverrideMultiplier[24];

/** Offset 0x09C4 - PCIE RP Non Snoop Latency Override Value
  Latency Tolerance Reporting, Non-Snoop Latency Override Value.
**/
  UINT16                      PcieRpNonSnoopLatencyOverrideValue[24];

/** Offset 0x09F4 - PCIE RP Slot Power Limit Scale
  Specifies scale used for slot power limit value. Leave as 0 to set to default.
**/
  UINT8                       PcieRpSlotPowerLimitScale[24];

/** Offset 0x0A0C - PCIE RP Slot Power Limit Value
  Specifies upper limit on power supplie by slot. Leave as 0 to set to default.
**/
  UINT16                      PcieRpSlotPowerLimitValue[24];

/** Offset 0x0A3C - PCIE RP Upstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 5.
**/
  UINT8                       PcieRpUptp[24];

/** Offset 0x0A54 - PCIE RP Downstream Port Transmiter Preset
  Used during Gen3 Link Equalization. Used for all lanes.  Default is 7.
**/
  UINT8                       PcieRpDptp[24];

/** Offset 0x0A6C - PCIE RP Enable Port8xh Decode
  This member describes whether PCIE root port Port 8xh Decode is enabled. 0: Disable;
  1: Enable.
  $EN_DIS
**/
  UINT8                       PcieEnablePort8xhDecode;

/** Offset 0x0A6D - PCIE Port8xh Decode Port Index
  The Index of PCIe Port that is selected for Port8xh Decode (0 Based).
**/
  UINT8                       PchPciePort8xhDecodePortIndex;

/** Offset 0x0A6E - PCH Pm Disable Energy Report
  Disable/Enable PCH to CPU enery report feature.
  $EN_DIS
**/
  UINT8                       PchPmDisableEnergyReport;

/** Offset 0x0A6F - PCH Sata Test Mode
  Allow entrance to the PCH SATA test modes.
  $EN_DIS
**/
  UINT8                       SataTestMode;

/** Offset 0x0A70 - PCH USB OverCurrent mapping lock enable
  If this policy option is enabled then BIOS will program OCCFDONE bit in xHCI meaning
  that OC mapping data will be consumed by xHCI and OC mapping registers will be locked.
  $EN_DIS
**/
  UINT8                       PchXhciOcLock;

/** Offset 0x0A71 - Xhci OverCurrent enable
  Xhci Overcurrent enable.
  $EN_DIS
**/
  UINT8                       PchXhciOcEnable;

/** Offset 0x0A72 - ReservedPchPostMemTest
  Reserved for Pch Post-Mem
  $EN_DIS
**/
  UINT8                       ReservedPchPostMem[16];

/** Offset 0x0A82 - Mctp Broadcast Cycle
  Test, Determine if MCTP Broadcast is enabled <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       MctpBroadcastCycle;

/** Offset 0x0A83 - Enforce Enhanced Debug Mode
  Determine if ME should enter Enhanced Debug Mode. 0: disable, 1: enable
  $EN_DIS
**/
  UINT8                       EnforceEDebugMode;

/** Offset 0x0A84 - LogoPixelHeight Address
  Address of LogoPixelHeight
**/
  UINT32                      LogoPixelHeight;

/** Offset 0x0A88 - LogoPixelWidth Address
  Address of LogoPixelWidth
**/
  UINT32                      LogoPixelWidth;

/** Offset 0x0A8C
**/
  UINT8                       ReservedFspsTestUpd[4];
} FSP_S_TEST_CONFIG;

/** Fsp S UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSP_S_CONFIG                FspsConfig;

/** Offset 0x07B8
**/
  FSP_S_TEST_CONFIG           FspsTestConfig;

/** Offset 0x0A90
**/
  UINT8                       UnusedUpdSpace26[6];

/** Offset 0x0A96
**/
  UINT16                      UpdTerminator;
} FSPS_UPD;

#pragma pack()

#endif
