/** @file

Copyright (c) 2020, Intel Corporation. All rights reserved.<BR>

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;         ///< Chipset Init Info Revision
  UINT8             Rsvd[3];          ///< Reserved
  UINT16            MeChipInitCrc;    ///< 16 bit CRC value of MeChipInit Table
  UINT16            BiosChipInitCrc;  ///< 16 bit CRC value of PchChipInit Table
} CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - Memory SPD Pointer Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr00;

/** Offset 0x004C - Memory SPD Pointer Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr01;

/** Offset 0x0050 - Memory SPD Pointer Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr10;

/** Offset 0x0054 - Memory SPD Pointer Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked as 00
**/
  UINT32                      MemorySpdPtr11;

/** Offset 0x0058 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x005A - Dq Byte Map CH0
  Dq byte mapping between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqByteMapCh0[12];

/** Offset 0x0066 - Dq Byte Map CH1
  Dq byte mapping between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqByteMapCh1[12];

/** Offset 0x0072 - Dqs Map CPU to DRAM CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh0[8];

/** Offset 0x007A - Dqs Map CPU to DRAM CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent
**/
  UINT8                       DqsMapCpu2DramCh1[8];

/** Offset 0x0082 - RcompResistor settings
  Indicates  RcompResistor settings: CML - 0's means MRC auto configured based on
  Design Guidelines, otherwise input an Ohmic value per segment. CFL will need to
  provide the appropriate values.
**/
  UINT16                      RcompResistor[3];

/** Offset 0x0088 - RcompTarget settings
  RcompTarget settings: CML - 0's mean MRC auto configured based on Design Guidelines,
  otherwise input an Ohmic value per segment. CFL will need to provide the appropriate values.
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0092 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0093 - VREF_CA
  CA Vref routing: board-dependent
  0:VREF_CA goes to both CH_A and CH_B, 1: VREF_CA to CH_A and VREF_DQ_A to CH_B,
  2:VREF_CA to CH_A and VREF_DQ_B to CH_B
**/
  UINT8                       CaVrefConfig;

/** Offset 0x0094 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x0095 - Time Measure
  Time Measure: 0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       MrcTimeMeasure;

/** Offset 0x0096 - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0097 - Rank Margin Tool per Task
  This option enables the user to execute Rank Margin Tool per major training step
  in the MRC.
  $EN_DIS
**/
  UINT8                       RmtPerTask;

/** Offset 0x0098 - Training Trace
  This option enables the trained state tracing feature in MRC.  This feature will
  print out the key training parameters state across major training steps.
  $EN_DIS
**/
  UINT8                       TrainTrace;

/** Offset 0x0099
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x009C - Intel Enhanced Debug
  Intel Enhanced Debug (IED): 0=Disabled, 0x400000=Enabled and 4MB SMRAM occupied
  0 : Disable, 0x400000 : Enable
**/
  UINT32                      IedSize;

/** Offset 0x00A0 - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x00A4 - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x00A6 - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x00A7 - GDXC IOT SIZE
  Size of IOT and MOT is in 8 MB chunks
**/
  UINT8                       GdxcIotSize;

/** Offset 0x00A8 - GDXC MOT SIZE
  Size of IOT and MOT is in 8 MB chunks
**/
  UINT8                       GdxcMotSize;

/** Offset 0x00A9 - Spd Address Tabl
  Specify SPD Address table for CH0D0/CH0D1/CH1D0&CH1D1. MemorySpdPtr will be used
  if SPD Address is 00
**/
  UINT8                       SpdAddressTable[4];

/** Offset 0x00AD - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0 MB, 0x01:32 MB, 0x02:64 MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x00AE - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x00AF - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 3:512 MB, 7:1024 MB, 15: 2048 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x00B0 - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile
  Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x00B1 - SA GV
  System Agent dynamic frequency support and when enabled memory will be training
  at two different frequencies. Only effects ULX/ULT CPUs. 0=Disabled, 1=FixedLow,
  2=FixedHigh, and 3=Enabled.
  0:Disabled, 1:FixedLow, 2:FixedHigh, 3:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x00B2 - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Valid values should match the refclk,
  i.e. divide by 133 or 100
  1067:1067, 1333:1333, 1400:1400, 1600:1600, 1800:1800, 1867:1867, 2000:2000, 2133:2133,
  2200:2200, 2400:2400, 2600:2600, 2667:2667, 2800:2800, 2933:2933, 3000:3000, 3200:3200, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x00B4 - Low Frequency
  SAGV Low Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867, 2133,
  2400, 2667, 2933 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933, 0:Auto
**/
  UINT16                      FreqSaGvLow;

/** Offset 0x00B6 - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x00B7 - Channel A DIMM Control
  Channel A DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs
**/
  UINT8                       DisableDimmChannel0;

/** Offset 0x00B8 - Channel B DIMM Control
  Channel B DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs
**/
  UINT8                       DisableDimmChannel1;

/** Offset 0x00B9 - Scrambler Support
  This option enables data scrambling in memory.
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x00BA - Skip Multi-Processor Initialization
  When this is skipped, boot loader must initialize processors before SilicionInit
  API. </b>0: Initialize; <b>1: Skip
  $EN_DIS
**/
  UINT8                       SkipMpInit;

/** Offset 0x00BB - SPD Profile Selected
  Select DIMM timing profile. Options are 0=Default profile, 1=Custom profile, 2=XMP
  Profile 1, 3=XMP Profile 2
  0:Default profile, 1:Custom profile, 2:XMP profile 1, 3:XMP profile 2
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x00BC - Memory Reference Clock
  100MHz, 133MHz.
  0:133MHz, 1:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x00BD
**/
  UINT8                       UnusedUpdSpace1;

/** Offset 0x00BE - Memory Voltage
  Memory Voltage Override (Vddq). Default = no override
  0:Default, 1200:1.20 Volts, 1250:1.25 Volts, 1300:1.30 Volts, 1350:1.35 Volts, 1400:1.40
  Volts, 1450:1.45 Volts, 1500:1.50 Volts, 1550:1.55 Volts, 1600:1.60 Volts, 1650:1.65 Volts
**/
  UINT16                      VddVoltage;

/** Offset 0x00C0 - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT8                       Ratio;

/** Offset 0x00C1 - QCLK Odd Ratio
  Adds 133 or 100 MHz to QCLK frequency, depending on RefClk
  $EN_DIS
**/
  UINT8                       OddRatioMode;

/** Offset 0x00C2 - tCL
  CAS Latency, 0: AUTO, max: 31
**/
  UINT8                       tCL;

/** Offset 0x00C3 - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 34
**/
  UINT8                       tCWL;

/** Offset 0x00C4 - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 63
**/
  UINT8                       tRCDtRP;

/** Offset 0x00C5 - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 15
**/
  UINT8                       tRRD;

/** Offset 0x00C6 - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 63
**/
  UINT16                      tFAW;

/** Offset 0x00C8 - tRAS
  RAS Active Time, 0: AUTO, max: 64
**/
  UINT16                      tRAS;

/** Offset 0x00CA - tREFI
  Refresh Interval, 0: AUTO, max: 65535
**/
  UINT16                      tREFI;

/** Offset 0x00CC - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 1023
**/
  UINT16                      tRFC;

/** Offset 0x00CE - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 15. DDR4 legal
  values: 5, 6, 7, 8, 9, 10, 12
**/
  UINT8                       tRTP;

/** Offset 0x00CF - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18,
  20, 24, 30, 34, 40
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24, 30:30,
  34:34, 40:40
**/
  UINT8                       tWR;

/** Offset 0x00D0 - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 28
**/
  UINT8                       tWTR;

/** Offset 0x00D1 - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x00D2 - DllBwEn[0]
  DllBwEn[0], for 1067 (0..7)
**/
  UINT8                       DllBwEn0;

/** Offset 0x00D3 - DllBwEn[1]
  DllBwEn[1], for 1333 (0..7)
**/
  UINT8                       DllBwEn1;

/** Offset 0x00D4 - DllBwEn[2]
  DllBwEn[2], for 1600 (0..7)
**/
  UINT8                       DllBwEn2;

/** Offset 0x00D5 - DllBwEn[3]
  DllBwEn[3], for 1867 and up (0..7)
**/
  UINT8                       DllBwEn3;

/** Offset 0x00D6 - ISVT IO Port Address
  ISVT IO Port Address. 0=Minimal, 0xFF=Maximum, 0x99=Default
**/
  UINT8                       IsvtIoPort;

/** Offset 0x00D7 - Margin Limit Check
  Margin Limit Check. Choose level of margin check
  0:Disable, 1:L1, 2:L2, 3:Both
**/
  UINT8                       MarginLimitCheck;

/** Offset 0x00D8 - Margin Limit L2
  % of L1 check for margin limit check
**/
  UINT16                      MarginLimitL2;

/** Offset 0x00DA - CPU Trace Hub Mode
  Select 'Target Debugger' if Trace Hub is used by target debugger software or 'Disable'
  trace hub functionality.
  0: Disable, 1:Target Debugger Mode
**/
  UINT8                       CpuTraceHubMode;

/** Offset 0x00DB - CPU Trace Hub Memory Region 0
  CPU Trace Hub Memory Region 0, The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg0Size;

/** Offset 0x00DC - CPU Trace Hub Memory Region 1
  CPU Trace Hub Memory Region 1. The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg1Size;

/** Offset 0x00DD - Enable or Disable Peci C10 Reset command
  Enable or Disable Peci C10 Reset command. If Enabled, BIOS will send the CPU message
  to disable peci reset on C10 exit. The default value is <b>0: Disable</b> for CNL,
  and <b>1: Enable</b> for all other CPU's
  $EN_DIS
**/
  UINT8                       PeciC10Reset;

/** Offset 0x00DE - Enable or Disable Peci Sx Reset command
  Enable or Disable Peci Sx Reset command; <b>0: Disable;</b> 1: Enable.
  $EN_DIS
**/
  UINT8                       PeciSxReset;

/** Offset 0x00DF - HECI Timeouts
  0: Disable, 1: Enable (Default) timeout check for HECI
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x00E0 - HECI1 BAR address
  BAR address of HECI1
**/
  UINT32                      Heci1BarAddress;

/** Offset 0x00E4 - HECI2 BAR address
  BAR address of HECI2
**/
  UINT32                      Heci2BarAddress;

/** Offset 0x00E8 - HECI3 BAR address
  BAR address of HECI3
**/
  UINT32                      Heci3BarAddress;

/** Offset 0x00EC - SG dGPU Power Delay
  SG dGPU delay interval after power enabling: 0=Minimal, 1000=Maximum, default is
  300=300 microseconds
**/
  UINT16                      SgDelayAfterPwrEn;

/** Offset 0x00EE - SG dGPU Reset Delay
  SG dGPU delay interval for Reset complete: 0=Minimal, 1000=Maximum, default is 100=100
  microseconds
**/
  UINT16                      SgDelayAfterHoldReset;

/** Offset 0x00F0 - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x00F2 - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x00F3 - Enable/Disable PEG 0
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg0Enable;

/** Offset 0x00F4 - Enable/Disable PEG 1
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg1Enable;

/** Offset 0x00F5 - Enable/Disable PEG 2
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg2Enable;

/** Offset 0x00F6 - Enable/Disable PEG 3
  Disabled(0x0): Disable PEG Port, Enabled(0x1): Enable PEG Port (If Silicon SKU permits
  it), Auto(0x2)(Default): If an endpoint is present, enable the PEG Port, Disable otherwise
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       Peg3Enable;

/** Offset 0x00F7 - PEG 0 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg0MaxLinkSpeed;

/** Offset 0x00F8 - PEG 1 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg1MaxLinkSpeed;

/** Offset 0x00F9 - PEG 2 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg2MaxLinkSpeed;

/** Offset 0x00FA - PEG 3 Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       Peg3MaxLinkSpeed;

/** Offset 0x00FB - PEG 0 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2, (0x3):Limit Link to x4, (0x4): Limit Link to x8
  0:Auto, 1:x1, 2:x2, 3:x4, 4:x8
**/
  UINT8                       Peg0MaxLinkWidth;

/** Offset 0x00FC - PEG 1 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2, (0x3):Limit Link to x4
  0:Auto, 1:x1, 2:x2, 3:x4
**/
  UINT8                       Peg1MaxLinkWidth;

/** Offset 0x00FD - PEG 2 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2
  0:Auto, 1:x1, 2:x2
**/
  UINT8                       Peg2MaxLinkWidth;

/** Offset 0x00FE - PEG 3 Max Link Width
  Auto (Default)(0x0): Maximum possible link width, (0x1): Limit Link to x1, (0x2):
  Limit Link to x2
  0:Auto, 1:x1, 2:x2
**/
  UINT8                       Peg3MaxLinkWidth;

/** Offset 0x00FF - Power down unused lanes on PEG 0
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg0PowerDownUnusedLanes;

/** Offset 0x0100 - Power down unused lanes on PEG 1
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg1PowerDownUnusedLanes;

/** Offset 0x0101 - Power down unused lanes on PEG 2
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg2PowerDownUnusedLanes;

/** Offset 0x0102 - Power down unused lanes on PEG 3
  (0x0): Do not power down any lane, (0x1): Bios will power down unused lanes based
  on the max possible link width
  0:No power saving, 1:Auto
**/
  UINT8                       Peg3PowerDownUnusedLanes;

/** Offset 0x0103 - PCIe ASPM programming will happen in relation to the Oprom
  Select when PCIe ASPM programming will happen in relation to the Oprom. Before(0x0)(Default):
  Do PCIe ASPM programming before Oprom, After(0x1): Do PCIe ASPM programming after
  Oprom, requires an SMI handler to save/restore ASPM settings during S3 resume
  0:Before, 1:After
**/
  UINT8                       InitPcieAspmAfterOprom;

/** Offset 0x0104 - PCIe Disable Spread Spectrum Clocking
  PCIe Disable Spread Spectrum Clocking. Normal Operation(0x0)(Default) - SSC enabled,
  Disable SSC(0X1) - Disable SSC per platform design or for compliance testing
  0:Normal Operation, 1:Disable SSC
**/
  UINT8                       PegDisableSpreadSpectrumClocking;

/** Offset 0x0105 - DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       DmiGen3RootPortPreset[8];

/** Offset 0x010D - DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       DmiGen3EndPointPreset[8];

/** Offset 0x0115 - DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       DmiGen3EndPointHint[8];

/** Offset 0x011D - DMI Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 0 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       DmiGen3RxCtlePeaking[4];

/** Offset 0x0121 - Thermal Velocity Boost Ratio clipping
  0(Default): Disabled, 1: Enabled. This service controls Core frequency reduction
  caused by high package temperatures for processors that implement the Intel Thermal
  Velocity Boost (TVB) feature
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbRatioClipping;

/** Offset 0x0122 - Thermal Velocity Boost voltage optimization
  0: Disabled, 1: Enabled(Default). This service controls thermal based voltage optimizations
  for processors that implement the Intel Thermal Velocity Boost (TVB) feature.
  0: Disabled, 1: Enabled
**/
  UINT8                       TvbVoltageOptimization;

/** Offset 0x0123 - PEG Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 12 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       PegGen3RxCtlePeaking[10];

/** Offset 0x012D
**/
  UINT8                       UnusedUpdSpace2[3];

/** Offset 0x0130 - Memory data pointer for saved preset search results
  The reference code will store the Gen3 Preset Search results in the SaDataHob's
  PegData structure (SA_PEG_DATA) and platform code can save/restore this data to
  skip preset search in the following boots. Range: 0-0xFFFFFFFF, default is 0
**/
  UINT32                      PegDataPtr;

/** Offset 0x0134 - PEG PERST# GPIO information
  The reference code will use the information in this structure in order to reset
  PCIe Gen3 devices during equalization, if necessary
**/
  UINT8                       PegGpioData[28];

/** Offset 0x0150 - PCIe Hot Plug Enable/Disable per port
  0(Default): Disable, 1: Enable
**/
  UINT8                       PegRootPortHPE[4];

/** Offset 0x0154 - DeEmphasis control for DMI
  DeEmphasis control for DMI. 0=-6dB, 1(Default)=-3.5 dB
  0: -6dB, 1: -3.5dB
**/
  UINT8                       DmiDeEmphasis;

/** Offset 0x0155 - Selection of the primary display device
  0=iGFX, 1=PEG, 2=PCIe Graphics on PCH, 3(Default)=AUTO, 4=Switchable Graphics
  0:iGFX, 1:PEG, 2:PCIe Graphics on PCH, 3:AUTO, 4:Switchable Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x0156 - Selection of iGFX GTT Memory size
  1=2MB, 2=4MB, 3=8MB, Default is 3
  1:2MB, 2:4MB, 3:8MB
**/
  UINT16                      GttSize;

/** Offset 0x0158 - Temporary MMIO address for GMADR
  The reference code will use this as Temporary MMIO address space to access GMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GmAdr to
  (GmAdr + ApertureSize). Default is (PciExpressBaseAddress - ApertureSize) to (PciExpressBaseAddress
  - 0x1) (Where ApertureSize = 256MB)
**/
  UINT32                      GmAdr;

/** Offset 0x015C - Temporary MMIO address for GTTMMADR
  The reference code will use this as Temporary MMIO address space to access GTTMMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GttMmAdr
  to (GttMmAdr + 2MB MMIO + 6MB Reserved + GttSize). Default is (GmAdr - (2MB MMIO
  + 6MB Reserved + GttSize)) to (GmAdr - 0x1) (Where GttSize = 8MB)
**/
  UINT32                      GttMmAdr;

/** Offset 0x0160 - Selection of PSMI Region size
  0=32MB, 1=288MB, 2=544MB, 3=800MB, 4=1024MB Default is 0
  0:32MB, 1:288MB, 2:544MB, 3:800MB, 4:1024MB
**/
  UINT8                       PsmiRegionSize;

/** Offset 0x0161 - Switchable Graphics GPIO information for PEG 0
  Switchable Graphics GPIO information for PEG 0, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie0Gpio[24];

/** Offset 0x0179 - Switchable Graphics GPIO information for PEG 1
  Switchable Graphics GPIO information for PEG 1, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie1Gpio[24];

/** Offset 0x0191 - Switchable Graphics GPIO information for PEG 2
  Switchable Graphics GPIO information for PEG 2, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie2Gpio[24];

/** Offset 0x01A9 - Switchable Graphics GPIO information for PEG 3
  Switchable Graphics GPIO information for PEG 3, for Reset, power and wake GPIOs
**/
  UINT8                       SaRtd3Pcie3Gpio[24];

/** Offset 0x01C1 - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x01C2 - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x01C3 - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtVoltageMode;

/** Offset 0x01C4 - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtMaxOcRatio;

/** Offset 0x01C5
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x01C6 - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtVoltageOffset;

/** Offset 0x01C8 - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtVoltageOverride;

/** Offset 0x01CA - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtExtraTurboVoltage;

/** Offset 0x01CC - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x01CE - PCIe root port Function number for Switchable Graphics dGPU
  Root port Index number to indicate which PCIe root port has dGPU
**/
  UINT8                       RootPortIndex;

/** Offset 0x01CF - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x01D0 - Enable/Disable SA IPU
  Enable(Default): Enable SA IPU, Disable: Disable SA IPU
  $EN_DIS
**/
  UINT8                       SaIpuEnable;

/** Offset 0x01D1 - IPU IMR Configuration
  0:IPU Camera, 1:IPU Gen Default is 0
  0:IPU Camera, 1:IPU Gen
**/
  UINT8                       SaIpuImrConfiguration;

/** Offset 0x01D2 - Selection of PSMI Support On/Off
  0(Default) = FALSE, 1 = TRUE. When TRUE, it will allow the PSMI Support
  $EN_DIS
**/
  UINT8                       GtPsmiSupport;

/** Offset 0x01D3 - GT unslice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtusVoltageMode;

/** Offset 0x01D4 - voltage offset applied to GT unslice
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusVoltageOffset;

/** Offset 0x01D6 - GT unslice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusVoltageOverride;

/** Offset 0x01D8 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtusExtraTurboVoltage;

/** Offset 0x01DA - Maximum GTus turbo ratio override
  0(Default)=Minimal, 60=Maximum
**/
  UINT8                       GtusMaxOcRatio;

/** Offset 0x01DB - SaPreMemProductionRsvd
  Reserved for SA Pre-Mem Production
  $EN_DIS
**/
  UINT8                       SaPreMemProductionRsvd[1];

/** Offset 0x01DC - Per-core HT Disable
  Defines the per-core HT disable mask where: 1 - Disable selected logical core HT,
  0 - is ignored. Input is in HEX and each bit maps to a logical core. Ex. A value
  of '1F' would disable HT for cores 4,3,2,1 and 0. Default is 0, all cores have
  HT enabled. Range is 0 - 0x1FF. You can only disable up to MAX_CORE_COUNT - 1.
**/
  UINT16                      PerCoreHtDisable;

/** Offset 0x01DE - BIST on Reset
  Enable or Disable BIST on Reset; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x01DF - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x01E0 - C6DRAM power gating feature
  This policy indicates whether or not BIOS should allocate PRMRR memory for C6DRAM
  power gating feature.- 0: Don't allocate any PRMRR memory for C6DRAM power gating
  feature.- <b>1: Allocate PRMRR memory for C6DRAM power gating feature</b>.
  $EN_DIS
**/
  UINT8                       EnableC6Dram;

/** Offset 0x01E1 - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x01E2 - Over clocking Lock
  Over clocking Lock Enable/Disable; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x01E3 - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-255
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x01E4 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x01E5 - Program Cache Attributes
  Program Cache Attributes; <b>0: Program</b>; 1: Disable Program.
  $EN_DIS
**/
  UINT8                       DisableMtrrProgram;

/** Offset 0x01E6 - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-255
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x01E7 - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x01E8 - CPU ratio value
  CPU ratio value. Valid Range 0 to 63. CPU Ratio is 0 when disabled.
**/
  UINT8                       CpuRatio;

/** Offset 0x01E9 - Boot frequency
  Sets the boot frequency starting from reset vector.- 0: Maximum battery performance.-
  <b>1: Maximum non-turbo performance</b>.- 2: Turbo performance. @note If Turbo
  is selected BIOS will start in max non-turbo mode and switch to Turbo mode.
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x01EA - Number of active cores
  Number of active cores(Depends on Number of cores). <b>0: All</b>;<b>1: 1 </b>;<b>2:
  2 </b>;<b>3: 3 </b>
  0:All, 1:1, 2:2, 3:3
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x01EB - Processor Early Power On Configuration FCLK setting
  <b>0: 800 MHz (ULT/ULX)</b>. <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.-
  2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x01EC - Set JTAG power in C10 and deeper power states
  False: JTAG is power gated in C10 state. True: keeps the JTAG power up during C10
  and deeper power states for debug purpose. <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       JtagC10PowerGateDisable;

/** Offset 0x01ED - Enable or Disable VMX
  Enable or Disable VMX; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x01EE - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x01EF - AVX3 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x01F0 - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x01F1 - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x01F2 - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x01F4 - Core Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageAdaptive;

/** Offset 0x01F6 - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x01F8 - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio.0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x01F9 - Ring voltage mode
  Ring voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       RingVoltageMode;

/** Offset 0x01FA - Ring voltage override
  The ring voltage override which is applied to the entire range of cpu ring frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageOverride;

/** Offset 0x01FC - Ring Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu ring when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageAdaptive;

/** Offset 0x01FE - Ring Turbo voltage Offset
  The voltage offset applied to the ring while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      RingVoltageOffset;

/** Offset 0x0200 - TjMax Offset
  TjMax offset.Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 10 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x0201 - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x0202
**/
  UINT8                       BiosGuardToolsInterface;

/** Offset 0x0203 - EnableSgx
  Enable/Disable. 0: Disable, Enable/Disable SGX feature, 1: enable, 2: Software Control
  0: Disable, 1: Enable, 2: Software Control
**/
  UINT8                       EnableSgx;

/** Offset 0x0204 - Txt
  Enable/Disable. 0: Disable, Enable/Disable Txt feature, 1: enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x0205
**/
  UINT8                       UnusedUpdSpace4[3];

/** Offset 0x0208 - PrmrrSize
  0=Invalid, 32MB=0x2000000, 64MB=0x4000000, 128MB=0x8000000, 256MB=0x10000000
**/
  UINT32                      PrmrrSize;

/** Offset 0x020C - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x0210 - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x0214 - TxtDprMemorySize
  Enable/Disable. 0: Disable, define default value of TxtDprMemorySize , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x0218 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x0220 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      BiosAcmBase;

/** Offset 0x0224 - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x0228 - ApStartupBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      ApStartupBase;

/** Offset 0x022C - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x0230 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x0238 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x0240 - IsTPMPresence
  IsTPMPresence default values
**/
  UINT8                       IsTPMPresence;

/** Offset 0x0241 - Intel Speed Optimizer Enable
  When enabled this feature automatically overclocks your processor. It changes the
  All Core Frequency along with PL1, PL2, and IccMax. </b>0: Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       AutoEasyOverclock;

/** Offset 0x0242 - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[2];

/** Offset 0x0244 - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[3];

/** Offset 0x0250 - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x0251 - Platform Debug Consent
  To 'opt-in' for debug, please select 'Enabled' with the desired debug probe type.
  Enabling this BIOS option may alter the default value of other debug-related BIOS
  options. Note: DCI OOB (aka BSSB) uses CCA probe; [DCI OOB+DbC] and [USB2 DbC]
  have the same setting
  0:Disabled, 1:Enabled (DCI OOB+[DbC]), 2:Enabled (DCI OOB), 3:Enabled (USB3 DbC),
  4:Enabled (XDP/MIPI60), 5:Enabled (USB2 DbC)
**/
  UINT8                       PlatformDebugConsent;

/** Offset 0x0252 - USB3 Type-C UFP2DFP Kernel/Platform Debug Support
  This BIOS option enables kernel and platform debug for USB3 interface over a UFP
  Type-C receptacle, select 'No Change' will do nothing to UFP2DFP setting.
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DciUsb3TypecUfpDbg;

/** Offset 0x0253 - PCH Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1: Target Debugger Mode, 2: Host Debugger Mode
**/
  UINT8                       PchTraceHubMode;

/** Offset 0x0254 - PCH Trace Hub Memory Region 0 buffer Size
  Specify size of Pch trace memory region 0 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg0Size;

/** Offset 0x0255 - PCH Trace Hub Memory Region 1 buffer Size
  Specify size of Pch trace memory region 1 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg1Size;

/** Offset 0x0256 - Enable Intel HD Audio (Azalia)
  0: Disable, 1: Enable (Default) Azalia controller
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x0257 - Enable PCH ISH Controller
  0: Disable, 1: Enable (Default) ISH Controller
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x0258 - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[24];

/** Offset 0x0270 - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[24];

/** Offset 0x0288 - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[24];

/** Offset 0x02A0 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[24];

/** Offset 0x02B8 - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[24];

/** Offset 0x02D0 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[24];

/** Offset 0x02E8 - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[24];

/** Offset 0x0300 - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[24];

/** Offset 0x0318 - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[24];

/** Offset 0x0330 - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[24];

/** Offset 0x0348 - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[24];

/** Offset 0x0360 - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[24];

/** Offset 0x0378 - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[24];

/** Offset 0x0390 - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[24];

/** Offset 0x03A8 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x03B0 - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x03B8 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x03C0 - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x03C8 - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x03D0 - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x03D8 - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x03E0 - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x03E8 - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x03F0 - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x03F8 - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x0400 - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x0408 - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x0410 - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x0418 - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x0420 - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x0428 - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x0430 - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x0438 - PCH LPC Enhance the port 8xh decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x0439 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  $EN_DIS
**/
  UINT8                       PchPort80Route;

/** Offset 0x043A - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x043B - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x043C - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x043E - Size of PCIe IMR.
  Size of PCIe IMR in megabytes
**/
  UINT16                      PcieImrSize;

/** Offset 0x0440 - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x0444 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpEnableMask;

/** Offset 0x0448 - Enable PCIe IMR
  0:Disable, 1:Enable
  $EN_DIS
**/
  UINT8                       PcieImrEnabled;

/** Offset 0x0449 - Root port number for IMR.
  Root port number for IMR.
**/
  UINT8                       ImrRpSelection;

/** Offset 0x044A - Enable SMBus Alert Pin
  Enable SMBus Alert Pin.
  $EN_DIS
**/
  UINT8                       PchSmbAlertEnable;

/** Offset 0x044B - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x044C - Serial Io Uart Debug Controller Number
  Select SerialIo Uart Controller for debug. Note: If UART0 is selected as CNVi BT
  Core interface, it cannot be used for debug purpose.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       SerialIoUartDebugControllerNumber;

/** Offset 0x044D - Serial Io Uart Debug Auto Flow
  Enables UART hardware flow control, CTS and RTS lines.
  $EN_DIS
**/
  UINT8                       SerialIoUartDebugAutoFlow;

/** Offset 0x044E
**/
  UINT8                       UnusedUpdSpace5[2];

/** Offset 0x0450 - Serial Io Uart Debug BaudRate
  Set default BaudRate Supported from 0 - default to 6000000. Recommended values 9600,
  19200, 57600, 115200, 460800, 921600, 1500000, 1843200, 3000000, 3686400, 6000000
**/
  UINT32                      SerialIoUartDebugBaudRate;

/** Offset 0x0454 - Serial Io Uart Debug Parity
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartDebugParity;

/** Offset 0x0455 - Serial Io Uart Debug Stop Bits
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       SerialIoUartDebugStopBits;

/** Offset 0x0456 - Serial Io Uart Debug Data Bits
  Set default word length. 0: Default, 5,6,7,8
  5:5BITS, 6:6BITS, 7:7BITS, 8:8BITS
**/
  UINT8                       SerialIoUartDebugDataBits;

/** Offset 0x0457 - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x0458 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0459 - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x045A - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHda;

/** Offset 0x045B - Enable HD Audio DMIC0 Link
  Deprecated.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic0;

/** Offset 0x045C - Enable HD Audio DMIC1 Link
  Deprecated.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkDmic1;

/** Offset 0x045D - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP0/I2S link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp0;

/** Offset 0x045E - Enable HD Audio SSP1 Link
  Enable/disable HD Audio SSP1/I2S link. Muxed with HDA/SNDW2.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp1;

/** Offset 0x045F - Enable HD Audio SSP2 Link
  Enable/disable HD Audio SSP2/I2S link.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSsp2;

/** Offset 0x0460 - Enable HD Audio SoundWire#1 Link
  Enable/disable HD Audio SNDW1 link. Muxed with HDA.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw1;

/** Offset 0x0461 - Enable HD Audio SoundWire#2 Link
  Enable/disable HD Audio SNDW2 link. Muxed with SSP1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw2;

/** Offset 0x0462 - Enable HD Audio SoundWire#3 Link
  Enable/disable HD Audio SNDW3 link. Muxed with DMIC1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw3;

/** Offset 0x0463 - Enable HD Audio SoundWire#4 Link
  Enable/disable HD Audio SNDW4 link. Muxed with DMIC0.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkSndw4;

/** Offset 0x0464 - Soundwire Clock Buffer GPIO RCOMP Setting
  0: non-ACT - 50 Ohm driver impedance, 1: ACT - 8 Ohm driver impedance.
  $EN_DIS
**/
  UINT8                       PchHdaSndwBufferRcomp;

/** Offset 0x0465 - ReservedPchPreMem
  Reserved for Pch Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedPchPreMem[2];

/** Offset 0x0467 - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x0468 - GT PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       GtPllVoltageOffset;

/** Offset 0x0469 - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x046A - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x046B - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x046C - MRC Safe Config
  Enables/Disable MRC Safe Config
  $EN_DIS
**/
  UINT8                       MrcSafeConfig;

/** Offset 0x046D - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x046E - HobBufferSize
  Size to set HOB Buffer. 0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value(assuming 63KB
  total HOB size).
  0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value
**/
  UINT8                       HobBufferSize;

/** Offset 0x046F - Early Command Training
  Enables/Disable Early Command Training
  $EN_DIS
**/
  UINT8                       ECT;

/** Offset 0x0470 - SenseAmp Offset Training
  Enables/Disable SenseAmp Offset Training
  $EN_DIS
**/
  UINT8                       SOT;

/** Offset 0x0471 - Early ReadMPR Timing Centering 2D
  Enables/Disable Early ReadMPR Timing Centering 2D
  $EN_DIS
**/
  UINT8                       ERDMPRTC2D;

/** Offset 0x0472 - Read MPR Training
  Enables/Disable Read MPR Training
  $EN_DIS
**/
  UINT8                       RDMPRT;

/** Offset 0x0473 - Receive Enable Training
  Enables/Disable Receive Enable Training
  $EN_DIS
**/
  UINT8                       RCVET;

/** Offset 0x0474 - Jedec Write Leveling
  Enables/Disable Jedec Write Leveling
  $EN_DIS
**/
  UINT8                       JWRL;

/** Offset 0x0475 - Early Write Time Centering 2D
  Enables/Disable Early Write Time Centering 2D
  $EN_DIS
**/
  UINT8                       EWRTC2D;

/** Offset 0x0476 - Early Read Time Centering 2D
  Enables/Disable Early Read Time Centering 2D
  $EN_DIS
**/
  UINT8                       ERDTC2D;

/** Offset 0x0477 - Write Timing Centering 1D
  Enables/Disable Write Timing Centering 1D
  $EN_DIS
**/
  UINT8                       WRTC1D;

/** Offset 0x0478 - Write Voltage Centering 1D
  Enables/Disable Write Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       WRVC1D;

/** Offset 0x0479 - Read Timing Centering 1D
  Enables/Disable Read Timing Centering 1D
  $EN_DIS
**/
  UINT8                       RDTC1D;

/** Offset 0x047A - Dimm ODT Training
  Enables/Disable Dimm ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTT;

/** Offset 0x047B - DIMM RON Training
  Enables/Disable DIMM RON Training
  $EN_DIS
**/
  UINT8                       DIMMRONT;

/** Offset 0x047C - Write Drive Strength/Equalization 2D
  Enables/Disable Write Drive Strength/Equalization 2D
  $EN_DIS
**/
  UINT8                       WRDSEQT;

/** Offset 0x047D - Write Slew Rate Training
  Enables/Disable Write Slew Rate Training
  $EN_DIS
**/
  UINT8                       WRSRT;

/** Offset 0x047E - Read ODT Training
  Enables/Disable Read ODT Training
  $EN_DIS
**/
  UINT8                       RDODTT;

/** Offset 0x047F - Read Equalization Training
  Enables/Disable Read Equalization Training
  $EN_DIS
**/
  UINT8                       RDEQT;

/** Offset 0x0480 - Read Amplifier Training
  Enables/Disable Read Amplifier Training
  $EN_DIS
**/
  UINT8                       RDAPT;

/** Offset 0x0481 - Write Timing Centering 2D
  Enables/Disable Write Timing Centering 2D
  $EN_DIS
**/
  UINT8                       WRTC2D;

/** Offset 0x0482 - Read Timing Centering 2D
  Enables/Disable Read Timing Centering 2D
  $EN_DIS
**/
  UINT8                       RDTC2D;

/** Offset 0x0483 - Write Voltage Centering 2D
  Enables/Disable Write Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       WRVC2D;

/** Offset 0x0484 - Read Voltage Centering 2D
  Enables/Disable Read Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       RDVC2D;

/** Offset 0x0485 - Command Voltage Centering
  Enables/Disable Command Voltage Centering
  $EN_DIS
**/
  UINT8                       CMDVC;

/** Offset 0x0486 - Late Command Training
  Enables/Disable Late Command Training
  $EN_DIS
**/
  UINT8                       LCT;

/** Offset 0x0487 - Round Trip Latency Training
  Enables/Disable Round Trip Latency Training
  $EN_DIS
**/
  UINT8                       RTL;

/** Offset 0x0488 - Turn Around Timing Training
  Enables/Disable Turn Around Timing Training
  $EN_DIS
**/
  UINT8                       TAT;

/** Offset 0x0489 - Memory Test
  Enables/Disable Memory Test
  $EN_DIS
**/
  UINT8                       MEMTST;

/** Offset 0x048A - DIMM SPD Alias Test
  Enables/Disable DIMM SPD Alias Test
  $EN_DIS
**/
  UINT8                       ALIASCHK;

/** Offset 0x048B - Receive Enable Centering 1D
  Enables/Disable Receive Enable Centering 1D
  $EN_DIS
**/
  UINT8                       RCVENC1D;

/** Offset 0x048C - Retrain Margin Check
  Enables/Disable Retrain Margin Check
  $EN_DIS
**/
  UINT8                       RMC;

/** Offset 0x048D - Write Drive Strength Up/Dn independently
  Enables/Disable Write Drive Strength Up/Dn independently
  $EN_DIS
**/
  UINT8                       WRDSUDT;

/** Offset 0x048E - ECC Support
  Enables/Disable ECC Support
  $EN_DIS
**/
  UINT8                       EccSupport;

/** Offset 0x048F - Memory Remap
  Enables/Disable Memory Remap
  $EN_DIS
**/
  UINT8                       RemapEnable;

/** Offset 0x0490 - Rank Interleave support
  Enables/Disable Rank Interleave support. NOTE: RI and HORI can not be enabled at
  the same time.
  $EN_DIS
**/
  UINT8                       RankInterleave;

/** Offset 0x0491 - Enhanced Interleave support
  Enables/Disable Enhanced Interleave support
  $EN_DIS
**/
  UINT8                       EnhancedInterleave;

/** Offset 0x0492 - Memory Trace
  Enable Memory Trace of Ch 0 to Ch 1 using Stacked Mode. Both channels must be of
  equal size. This option may change TOLUD and REMAP values as needed.
  $EN_DIS
**/
  UINT8                       MemoryTrace;

/** Offset 0x0493 - Ch Hash Support
  Enable/Disable Channel Hash Support. NOTE: ONLY if Memory interleaved Mode
  $EN_DIS
**/
  UINT8                       ChHashEnable;

/** Offset 0x0494 - Extern Therm Status
  Enables/Disable Extern Therm Status
  $EN_DIS
**/
  UINT8                       EnableExtts;

/** Offset 0x0495 - Closed Loop Therm Manage
  Enables/Disable Closed Loop Therm Manage
  $EN_DIS
**/
  UINT8                       EnableCltm;

/** Offset 0x0496 - Open Loop Therm Manage
  Enables/Disable Open Loop Therm Manage
  $EN_DIS
**/
  UINT8                       EnableOltm;

/** Offset 0x0497 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter
  $EN_DIS
**/
  UINT8                       EnablePwrDn;

/** Offset 0x0498 - DDR PowerDown and idle counter - LPDDR
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDnLpddr;

/** Offset 0x0499 - Use user provided power weights, scale factor, and channel power floor values
  Enables/Disable Use user provided power weights, scale factor, and channel power
  floor values
  $EN_DIS
**/
  UINT8                       UserPowerWeightsEn;

/** Offset 0x049A - RAPL PL Lock
  Enables/Disable RAPL PL Lock
  $EN_DIS
**/
  UINT8                       RaplLim2Lock;

/** Offset 0x049B - RAPL PL 2 enable
  Enables/Disable RAPL PL 2 enable
  $EN_DIS
**/
  UINT8                       RaplLim2Ena;

/** Offset 0x049C - RAPL PL 1 enable
  Enables/Disable RAPL PL 1 enable
  $EN_DIS
**/
  UINT8                       RaplLim1Ena;

/** Offset 0x049D - SelfRefresh Enable
  Enables/Disable SelfRefresh Enable
  $EN_DIS
**/
  UINT8                       SrefCfgEna;

/** Offset 0x049E - Throttler CKEMin Defeature - LPDDR
  Enables/Disable Throttler CKEMin Defeature(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeatLpddr;

/** Offset 0x049F - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeat;

/** Offset 0x04A0 - Enable RH Prevention
  Enables/Disable RH Prevention
  $EN_DIS
**/
  UINT8                       RhPrevention;

/** Offset 0x04A1 - Exit On Failure (MRC)
  Enables/Disable Exit On Failure (MRC)
  $EN_DIS
**/
  UINT8                       ExitOnFailure;

/** Offset 0x04A2 - LPDDR Thermal Sensor
  Enables/Disable LPDDR Thermal Sensor
  $EN_DIS
**/
  UINT8                       DdrThermalSensor;

/** Offset 0x04A3 - Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedClock;

/** Offset 0x04A4 - Select if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  ESelect if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedZq;

/** Offset 0x04A5
**/
  UINT8                       UnusedUpdSpace6;

/** Offset 0x04A6 - Ch Hash Mask
  Set the BIT(s) to be included in the XOR function. NOTE BIT mask corresponds to
  BITS [19:6
**/
  UINT16                      ChHashMask;

/** Offset 0x04A8 - Base reference clock value
  Base reference clock value, in Hertz(Default is 125Hz)
  100000000:100Hz, 125000000:125Hz, 167000000:167Hz, 250000000:250Hz
**/
  UINT32                      BClkFrequency;

/** Offset 0x04AC - Ch Hash Interleaved Bit
  Select the BIT to be used for Channel Interleaved mode. NOTE: BIT7 will interlave
  the channels at a 2 cacheline granularity, BIT8 at 4 and BIT9 at 8. Default is BIT8
  0:BIT6, 1:BIT7, 2:BIT8, 3:BIT9, 4:BIT10, 5:BIT11, 6:BIT12, 7:BIT13
**/
  UINT8                       ChHashInterleaveBit;

/** Offset 0x04AD - Energy Scale Factor
  Energy Scale Factor, Default is 4
**/
  UINT8                       EnergyScaleFact;

/** Offset 0x04AE - EPG DIMM Idd3N
  Active standby current (Idd3N) in milliamps from datasheet. Must be calculated on
  a per DIMM basis. Default is 26
**/
  UINT16                      Idd3n;

/** Offset 0x04B0 - EPG DIMM Idd3P
  Active power-down current (Idd3P) in milliamps from datasheet. Must be calculated
  on a per DIMM basis. Default is 11
**/
  UINT16                      Idd3p;

/** Offset 0x04B2 - CMD Slew Rate Training
  Enable/Disable CMD Slew Rate Training
  $EN_DIS
**/
  UINT8                       CMDSR;

/** Offset 0x04B3 - CMD Drive Strength and Tx Equalization
  Enable/Disable CMD Drive Strength and Tx Equalization
  $EN_DIS
**/
  UINT8                       CMDDSEQ;

/** Offset 0x04B4 - CMD Normalization
  Enable/Disable CMD Normalization
  $EN_DIS
**/
  UINT8                       CMDNORM;

/** Offset 0x04B5 - Early DQ Write Drive Strength and Equalization Training
  Enable/Disable Early DQ Write Drive Strength and Equalization Training
  $EN_DIS
**/
  UINT8                       EWRDSEQ;

/** Offset 0x04B6 - RH Activation Probability
  RH Activation Probability, Probability value is 1/2^(inputvalue)
**/
  UINT8                       RhActProbability;

/** Offset 0x04B7 - RAPL PL 2 WindowX
  Power PL 2 time window X value, (1/1024)*(1+(x/4))*(2^y) (1=Def)
**/
  UINT8                       RaplLim2WindX;

/** Offset 0x04B8 - RAPL PL 2 WindowY
  Power PL 2 time window Y value, (1/1024)*(1+(x/4))*(2^y) (1=Def)
**/
  UINT8                       RaplLim2WindY;

/** Offset 0x04B9 - RAPL PL 1 WindowX
  Power PL 1 time window X value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim1WindX;

/** Offset 0x04BA - RAPL PL 1 WindowY
  Power PL 1 time window Y value, (1/1024)*(1+(x/4))*(2^y) (0=Def)
**/
  UINT8                       RaplLim1WindY;

/** Offset 0x04BB
**/
  UINT8                       UnusedUpdSpace7;

/** Offset 0x04BC - RAPL PL 2 Power
  range[0;2^14-1]= [2047.875;0]in W, (222= Def)
**/
  UINT16                      RaplLim2Pwr;

/** Offset 0x04BE - RAPL PL 1 Power
  range[0;2^14-1]= [2047.875;0]in W, (0= Def)
**/
  UINT16                      RaplLim1Pwr;

/** Offset 0x04C0 - Warm Threshold Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       WarmThresholdCh0Dimm0;

/** Offset 0x04C1 - Warm Threshold Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       WarmThresholdCh0Dimm1;

/** Offset 0x04C2 - Warm Threshold Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       WarmThresholdCh1Dimm0;

/** Offset 0x04C3 - Warm Threshold Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       WarmThresholdCh1Dimm1;

/** Offset 0x04C4 - Hot Threshold Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       HotThresholdCh0Dimm0;

/** Offset 0x04C5 - Hot Threshold Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       HotThresholdCh0Dimm1;

/** Offset 0x04C6 - Hot Threshold Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       HotThresholdCh1Dimm0;

/** Offset 0x04C7 - Hot Threshold Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM. Default is 255
**/
  UINT8                       HotThresholdCh1Dimm1;

/** Offset 0x04C8 - Warm Budget Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh0Dimm0;

/** Offset 0x04C9 - Warm Budget Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh0Dimm1;

/** Offset 0x04CA - Warm Budget Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh1Dimm0;

/** Offset 0x04CB - Warm Budget Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       WarmBudgetCh1Dimm1;

/** Offset 0x04CC - Hot Budget Ch0 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh0Dimm0;

/** Offset 0x04CD - Hot Budget Ch0 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh0Dimm1;

/** Offset 0x04CE - Hot Budget Ch1 Dimm0
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh1Dimm0;

/** Offset 0x04CF - Hot Budget Ch1 Dimm1
  range[255;0]=[31.875;0] in W for OLTM, [127.5;0] in C for CLTM
**/
  UINT8                       HotBudgetCh1Dimm1;

/** Offset 0x04D0 - Idle Energy Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh0Dimm0;

/** Offset 0x04D1 - Idle Energy Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh0Dimm1;

/** Offset 0x04D2 - Idle Energy Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh1Dimm0;

/** Offset 0x04D3 - Idle Energy Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyCh1Dimm1;

/** Offset 0x04D4 - PowerDown Energy Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh0Dimm0;

/** Offset 0x04D5 - PowerDown Energy Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh0Dimm1;

/** Offset 0x04D6 - PowerDown Energy Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh1Dimm0;

/** Offset 0x04D7 - PowerDown Energy Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(5= Def)
**/
  UINT8                       PdEnergyCh1Dimm1;

/** Offset 0x04D8 - Activate Energy Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh0Dimm0;

/** Offset 0x04D9 - Activate Energy Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh0Dimm1;

/** Offset 0x04DA - Activate Energy Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh1Dimm0;

/** Offset 0x04DB - Activate Energy Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyCh1Dimm1;

/** Offset 0x04DC - Read Energy Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh0Dimm0;

/** Offset 0x04DD - Read Energy Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh0Dimm1;

/** Offset 0x04DE - Read Energy Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh1Dimm0;

/** Offset 0x04DF - Read Energy Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyCh1Dimm1;

/** Offset 0x04E0 - Write Energy Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh0Dimm0;

/** Offset 0x04E1 - Write Energy Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh0Dimm1;

/** Offset 0x04E2 - Write Energy Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh1Dimm0;

/** Offset 0x04E3 - Write Energy Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyCh1Dimm1;

/** Offset 0x04E4 - Throttler CKEMin Timer
  Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH (4).
  Default is 0x30
**/
  UINT8                       ThrtCkeMinTmr;

/** Offset 0x04E5 - Cke Rank Mapping
  Bits [7:4] - Channel 1, bits [3:0] - Channel 0. <b>0xAA=Default</b> Bit [i] specifies
  which rank CKE[i] goes to.
**/
  UINT8                       CkeRankMapping;

/** Offset 0x04E6 - Rapl Power Floor Ch0
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh0;

/** Offset 0x04E7 - Rapl Power Floor Ch1
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh1;

/** Offset 0x04E8 - Command Rate Support
  CMD Rate and Limit Support Option. NOTE: ONLY supported in 1N Mode, Default is 3 CMDs
  0:Disable, 1:1 CMD, 2:2 CMDS, 3:3 CMDS, 4:4 CMDS, 5:5 CMDS, 6:6 CMDS, 7:7 CMDS
**/
  UINT8                       EnCmdRate;

/** Offset 0x04E9 - REFRESH_2X_MODE
  0- (Default)Disabled 1-iMC enables 2xRef when Warm and Hot 2- iMC enables 2xRef when Hot
  0:Disable, 1:Enabled for WARM or HOT, 2:Enabled HOT only
**/
  UINT8                       Refresh2X;

/** Offset 0x04EA - Energy Performance Gain
  Enable/disable(default) Energy Performance Gain.
  $EN_DIS
**/
  UINT8                       EpgEnable;

/** Offset 0x04EB - Row Hammer Solution
  Type of method used to prevent Row Hammer. Default is Hardware RHP
  0:Hardware RHP, 1:2x Refresh
**/
  UINT8                       RhSolution;

/** Offset 0x04EC - User Manual Threshold
  Disabled: Predefined threshold will be used.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserThresholdEnable;

/** Offset 0x04ED - User Manual Budget
  Disabled: Configuration of memories will defined the Budget value.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserBudgetEnable;

/** Offset 0x04EE -   TcritMax
  Maximum Critical Temperature in Centigrade of the On-DIMM Thermal Sensor. TCRITMax
  has to be greater than THIGHMax .\n
  Critical temperature will be  TcritMax
**/
  UINT8                       TsodTcritMax;

/** Offset 0x04EF - Event mode
  Disable:Comparator mode.\n
  Enable:Interrupt mode
  $EN_DIS
**/
  UINT8                       TsodEventMode;

/** Offset 0x04F0 - EVENT polarity
  Disable:Active LOW.\n
  Enable:Active HIGH
  $EN_DIS
**/
  UINT8                       TsodEventPolarity;

/** Offset 0x04F1 - Critical event only
  Disable:Trips on alarm or critical.\n
  Enable:Trips only if criticaal temperature is reached
  $EN_DIS
**/
  UINT8                       TsodCriticalEventOnly;

/** Offset 0x04F2 - Event output control
  Disable:Event output disable.\n
  Enable:Event output enabled
  $EN_DIS
**/
  UINT8                       TsodEventOutputControl;

/** Offset 0x04F3 - Alarm window lock bit
  Disable:Alarm trips are not locked and can be changed.\n
  Enable:Alarm trips are locked and cannot be changed
  $EN_DIS
**/
  UINT8                       TsodAlarmwindowLockBit;

/** Offset 0x04F4 - Critical trip lock bit
  Disable:Critical trip is not locked and can be changed.\n
  Enable:Critical trip is locked and cannot be changed
  $EN_DIS
**/
  UINT8                       TsodCriticaltripLockBit;

/** Offset 0x04F5 - Shutdown mode
  Disable:Temperature sensor enable.\n
  Enable:Temperature sensor disable
  $EN_DIS
**/
  UINT8                       TsodShutdownMode;

/** Offset 0x04F6 - ThighMax
  Thigh = ThighMax (Default is 93)
**/
  UINT8                       TsodThigMax;

/** Offset 0x04F7 - User Manual Thig and Tcrit
  Disabled(Default): Temperature will be given by the configuration of memories and
  1x or 2xrefresh rate.\n
  Enabled: User Input will define for Thigh and Tcrit.
  $EN_DIS
**/
  UINT8                       TsodManualEnable;

/** Offset 0x04F8 - Force OLTM or 2X Refresh when needed
  Disabled(Default): = Force OLTM.\n
  Enabled: = Force 2x Refresh.
  $EN_DIS
**/
  UINT8                       ForceOltmOrRefresh2x;

/** Offset 0x04F9 - Pwr Down Idle Timer
  The minimum value should = to the worst case Roundtrip delay + Burst_Length. 0 means
  AUTO: 64 for ULX/ULT, 128 for DT/Halo
**/
  UINT8                       PwdwnIdleCounter;

/** Offset 0x04FA - Bitmask of ranks that have CA bus terminated
  Offset 225 LPDDR4: Bitmask of ranks that have CA bus terminated. <b>0x01=Default,
  Rank0 is terminating and Rank1 is non-terminating</b>
**/
  UINT8                       CmdRanksTerminated;

/** Offset 0x04FB - GDXC  MOT enable
  GDXC  MOT enable.
  $EN_DIS
**/
  UINT8                       GdxcEnable;

/** Offset 0x04FC - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x04FD - Fivr Faults
  Fivr Faults; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrFaults;

/** Offset 0x04FE - Fivr Efficiency
  Fivr Efficiency Management; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrEfficiency;

/** Offset 0x04FF - Safe Mode Support
  This option configures the varous items in the IO and MC to be more conservative.(def=Disable)
  $EN_DIS
**/
  UINT8                       SafeMode;

/** Offset 0x0500 - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x0501 - LpDdrDqDqsReTraining
  Enables/Disable LpDdrDqDqsReTraining
  $EN_DIS
**/
  UINT8                       LpDdrDqDqsReTraining;

/** Offset 0x0502 - Post Code Output Port
  This option configures Post Code Output Port
**/
  UINT16                      PostCodeOutputPort;

/** Offset 0x0504 - RMTLoopCount
  Specifies the Loop Count to be used during Rank Margin Tool Testing. 0 - AUTO
**/
  UINT8                       RMTLoopCount;

/** Offset 0x0505 - BER Support
  Enable/Disable the Rank Margin Tool interpolation/extrapolation.
  0:Disable, 1:Enable
**/
  UINT8                       EnBER;

/** Offset 0x0506 - Dual Dimm Per-Channel Board Type
  Option to indicate if Board Layout includes One/Two DIMMs per channel. This is used
  to limit maximum frequency for some SKUs.
  0:1DPC, 1:2DPC
**/
  UINT8                       DualDimmPerChannelBoardType;

/** Offset 0x0507 - DDR4 Mixed U-DIMM 2DPC Limitation
  Enable/Disable Frequency Limitation for DDR4 Mixed Dimm 2DPC Memory Configurations.
  Disable=0, Enable(Default)=1
  $EN_DIS
**/
  UINT8                       Ddr4Mixed2DpcLimit;

/** Offset 0x0508 - RMT on Fast flow
  Enable/Disable RMT on Fast flow. Default: Disabled
  $EN_DIS
**/
  UINT8                       FastBootRmt;

/** Offset 0x0509 - CFL Reserved
  Reserved FspmConfig CFL
  $EN_DIS
**/
  UINT8                       ReservedFspmUpdCfl;

/** Offset 0x050A - Memory Test on Warm Boot
  Run Base Memory Test on Warm Boot
  0:Disable, 1:Enable
**/
  UINT8                       MemTestOnWarmBoot;

/** Offset 0x050B - Throttler CKEMin Timer - LPDDR
  Timer value for CKEMin (For LPDDR Only), range[255;0]. Req'd min of SC_ROUND_T +
  BYTE_LENGTH (4). Default is 0x40
**/
  UINT8                       ThrtCkeMinTmrLpddr;

/** Offset 0x050C - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x050D - MRC Force training on Warm
  Enables/Disable the MRC training on warm boot
  $EN_DIS
**/
  UINT8                       MrcTrainOnWarm;

/** Offset 0x050E - Lpddr Dram Odt
  Override Enable/Disable for the ODT logic for LPDDR3 memory. Default is 2 (AUTO)
  0:Disable, 1:Enable, 2:AUTO
**/
  UINT8                       LpddrDramOdt;

/** Offset 0x050F - DDR4 Skip Refresh Enable
  Enable/Disable of DDR4 Temperature Controlled Refresh on DRAM. Default is 1 (Enabled)
  0:Disable, 1:Enable
**/
  UINT8                       Ddr4SkipRefreshEn;

/** Offset 0x0510 - SerialDebugMrcLevel
  MRC Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       SerialDebugMrcLevel;

/** Offset 0x0511 - Enable HD Audio Sndw Link IO Control
  deprecated
**/
  UINT8                       PchHdaSndwLinkIoControlEnabled[4];

/** Offset 0x0515 - Core VF Point Offset Mode
  Selects Core Voltage & Frequency Point Offset between Legacy and Selection modes;
  <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       CoreVfPointOffsetMode;

/** Offset 0x0516 - Core VF Point Offset
  Array used to specifies the Offset Voltage applied to the each selected Core VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      CoreVfPointOffset[15];

/** Offset 0x0534 - Core VF Point Offset Prefix
  Sets the CoreVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
  0:Positive, 1:Negative
**/
  UINT8                       CoreVfPointOffsetPrefix[15];

/** Offset 0x0543 - Core VF Point Ratio
  Array for the each selected Core VF Point to display the ration.
**/
  UINT8                       CoreVfPointRatio[15];

/** Offset 0x0552 - Core VF Point Count
  Number of supported Core Voltage & Frequency Point Offset
**/
  UINT8                       CoreVfPointCount;

/** Offset 0x0553
**/
  UINT8                       UnusedUpdSpace8[4];

/** Offset 0x0557
**/
  UINT8                       ReservedFspmUpd[1];
} FSP_M_CONFIG;

/** Fsp M Test Configuration
**/
typedef struct {

/** Offset 0x0558
**/
  UINT32                      Signature;

/** Offset 0x055C - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x055D - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x055E - Detect External Graphics device for LegacyOpROM
  Detect and report if external graphics device only support LegacyOpROM or not (to
  support CSM auto-enable). Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       ScanExtGfxForLegacyOpRom;

/** Offset 0x055F - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x0560 - DMI Max Link Speed
  Auto (Default)(0x0): Maximum possible link speed, Gen1(0x1): Limit Link to Gen1
  Speed, Gen2(0x2): Limit Link to Gen2 Speed, Gen3(0x3):Limit Link to Gen3 Speed
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x0561 - DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       DmiGen3EqPh2Enable;

/** Offset 0x0562 - DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       DmiGen3EqPh3Method;

/** Offset 0x0563 - Phase2 EQ enable on the PEG 0:1:0.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg0Gen3EqPh2Enable;

/** Offset 0x0564 - Phase2 EQ enable on the PEG 0:1:1.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg1Gen3EqPh2Enable;

/** Offset 0x0565 - Phase2 EQ enable on the PEG 0:1:2.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg2Gen3EqPh2Enable;

/** Offset 0x0566 - Phase2 EQ enable on the PEG 0:1:3.
  Phase2 EQ enable on the PEG 0:1:0. Disabled(0x0): Disable phase 2, Enabled(0x1):
  Enable phase 2, Auto(0x2)(Default): Use the current default method
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Peg3Gen3EqPh2Enable;

/** Offset 0x0567 - Phase3 EQ method on the PEG 0:1:0.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg0Gen3EqPh3Method;

/** Offset 0x0568 - Phase3 EQ method on the PEG 0:1:1.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg1Gen3EqPh3Method;

/** Offset 0x0569 - Phase3 EQ method on the PEG 0:1:2.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg2Gen3EqPh3Method;

/** Offset 0x056A - Phase3 EQ method on the PEG 0:1:3.
  PEG Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       Peg3Gen3EqPh3Method;

/** Offset 0x056B - Enable/Disable PEG GEN3 Static EQ Phase1 programming
  Program PEG Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       PegGen3ProgramStaticEq;

/** Offset 0x056C - PEG Gen3 SwEq Always Attempt
  Gen3 Software Equalization will be executed every boot. Disabled(0x0)(Default):
  Reuse EQ settings saved/restored from NVRAM whenever possible, Enabled(0x1): Re-test
  and generate new EQ values every boot, not recommended
  0:Disable, 1:Enable
**/
  UINT8                       Gen3SwEqAlwaysAttempt;

/** Offset 0x056D - Select number of TxEq presets to test in the PCIe/DMI SwEq
  Select number of TxEq presets to test in the PCIe/DMI SwEq. P7,P3,P5(0x0): Test
  Presets 7, 3, and 5, P0-P9(0x1): Test Presets 0-9, Auto(0x2)(Default): Use the
  current default method (Default)Auto will test Presets 7, 3, and 5.  It is possible
  for this default to change over time;using Auto will ensure Reference Code always
  uses the latest default settings
  0:P7 P3 P5, 1:P0 to P9, 2:Auto
**/
  UINT8                       Gen3SwEqNumberOfPresets;

/** Offset 0x056E - Enable use of the Voltage Offset and Centering Test in the PCIe SwEq
  Enable use of the Voltage Offset and Centering Test in the PCIe Software Equalization
  Algorithm. Disabled(0x0): Disable VOC Test, Enabled(0x1): Enable VOC Test, Auto(0x2)(Default):
  Use the current default
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       Gen3SwEqEnableVocTest;

/** Offset 0x056F - PCIe Rx Compliance Testing Mode
  Disabled(0x0)(Default): Normal Operation - Disable PCIe Rx Compliance testing, Enabled(0x1):
  PCIe Rx Compliance Test Mode - PEG controller is in Rx Compliance Testing Mode;
  it should only be set when doing PCIe compliance testing
  $EN_DIS
**/
  UINT8                       PegRxCemTestingMode;

/** Offset 0x0570 - PCIe Rx Compliance Loopback Lane  When PegRxCemTestingMode is Enabled
  the specificied Lane (0 - 15) will be  used for RxCEMLoopback.  Default is Lane 0
**/
  UINT8                       PegRxCemLoopbackLane;

/** Offset 0x0571 - Generate PCIe BDAT Margin Table
  Set this policy to enable the generation and addition of PCIe margin data to the
  BDAT table. Disabled(0x0)(Default): Normal Operation - Disable PCIe BDAT margin
  data generation, Enable(0x1): Generate PCIe BDAT margin data
  $EN_DIS
**/
  UINT8                       PegGenerateBdatMarginTable;

/** Offset 0x0572 - PCIe Non-Protocol Awareness for Rx Compliance Testing
  Set this policy to enable the generation and addition of PCIe margin data to the
  BDAT table. Disabled(0x0)(Default): Normal Operation - Disable non-protocol awareness,
  Enable(0x1): Non-Protocol Awareness Enabled - Enable non-protocol awareness for
  compliance testing
  $EN_DIS
**/
  UINT8                       PegRxCemNonProtocolAwareness;

/** Offset 0x0573 - PCIe Override RxCTLE
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3RxCtleOverride;

/** Offset 0x0574 - Rsvd
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3Rsvd;

/** Offset 0x0575 - PEG Gen3 Root port preset values per lane
  Used for programming PEG Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       PegGen3RootPortPreset[20];

/** Offset 0x0589 - PEG Gen3 End port preset values per lane
  Used for programming PEG Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       PegGen3EndPointPreset[20];

/** Offset 0x059D - PEG Gen3 End port Hint values per lane
  Used for programming PEG Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       PegGen3EndPointHint[20];

/** Offset 0x05B1
**/
  UINT8                       UnusedUpdSpace9;

/** Offset 0x05B2 - Jitter Dwell Time for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 1000. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqJitterDwellTime;

/** Offset 0x05B4 - Jitter Error Target for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 1. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqJitterErrorTarget;

/** Offset 0x05B6 - VOC Dwell Time for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 10000. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqVocDwellTime;

/** Offset 0x05B8 - VOC Error Target for PCIe Gen3 Software Equalization
  Range: 0-65535, default is 2. @warning Do not change from the default
**/
  UINT16                      Gen3SwEqVocErrorTarget;

/** Offset 0x05BA - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x05BB - BdatTestType
  Indicates the type of Memory Training data to populate into the BDAT ACPI table.
  0:Rank Margin Tool, 1:Margin2D
**/
  UINT8                       BdatTestType;

/** Offset 0x05BC - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x05BD
**/
  UINT8                       UnusedUpdSpace10;

/** Offset 0x05BE - Delta T12 Power Cycle Delay required in ms
  Select the value for delay required. 0(Default)= No delay, 0xFFFF = Auto calculate
  T12 Delay to max 500ms
  0 : No Delay, 0xFFFF : Auto Calulate T12 Delay
**/
  UINT16                      DeltaT12PowerCycleDelayPreMem;

/** Offset 0x05C0 - Oem T12 Dealy Override
  Oem T12 Dealy Override. 0(Default)=Disable  1=Enable
  $EN_DIS
**/
  UINT8                       OemT12DelayOverride;

/** Offset 0x05C1 - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[9];

/** Offset 0x05CA - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x05CC - BiosSize
  Enable/Disable. 0: Disable, define default value of BiosSize , 1: enable
**/
  UINT16                      BiosSize;

/** Offset 0x05CE - TxtAcheckRequest
  Enable/Disable. When Enabled, it will forcing calling TXT Acheck once.
  $EN_DIS
**/
  UINT8                       TxtAcheckRequest;

/** Offset 0x05CF - SecurityTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SecurityTestRsvd[3];

/** Offset 0x05D2 - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x05D3 - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x05D4 - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x05D5 - ReservedPchPreMemTest
  Reserved for Pch Pre-Mem Test
  $EN_DIS
**/
  UINT8                       ReservedPchPreMemTest[16];

/** Offset 0x05E5 - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, Set
  ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x05E6 - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x05E7 - ME DID Message
  Test, 0: disable, 1: enable, Enable/Disable ME DID Message (disable will prevent
  the DID message from being sent)
  $EN_DIS
**/
  UINT8                       SendDidMsg;

/** Offset 0x05E8 - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x05E9 - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable MOB HOB.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x05EA - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x05EB - Enable KT device
  Test, 0: disable, 1: enable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x05EC - tRd2RdSG
  Delay between Read-to-Read commands in the same Bank Group. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2RdSG;

/** Offset 0x05ED - tRd2RdDG
  Delay between Read-to-Read commands in different Bank Group for DDR4. All other
  DDR technologies should set this equal to SG. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2RdDG;

/** Offset 0x05EE - tRd2RdDR
  Delay between Read-to-Read commands in different Ranks. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2RdDR;

/** Offset 0x05EF - tRd2RdDD
  Delay between Read-to-Read commands in different DIMMs. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2RdDD;

/** Offset 0x05F0 - tWr2RdSG
  Delay between Write-to-Read commands in the same Bank Group. 0-Auto, Range 4-86.
**/
  UINT8                       tWr2RdSG;

/** Offset 0x05F1 - tWr2RdDG
  Delay between Write-to-Read commands in different Bank Group for DDR4. All other
  DDR technologies should set this equal to SG. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2RdDG;

/** Offset 0x05F2 - tWr2RdDR
  Delay between Write-to-Read commands in different Ranks. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2RdDR;

/** Offset 0x05F3 - tWr2RdDD
  Delay between Write-to-Read commands in different DIMMs. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2RdDD;

/** Offset 0x05F4 - tWr2WrSG
  Delay between Write-to-Write commands in the same Bank Group. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2WrSG;

/** Offset 0x05F5 - tWr2WrDG
  Delay between Write-to-Write commands in different Bank Group for DDR4. All other
  DDR technologies should set this equal to SG. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2WrDG;

/** Offset 0x05F6 - tWr2WrDR
  Delay between Write-to-Write commands in different Ranks. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2WrDR;

/** Offset 0x05F7 - tWr2WrDD
  Delay between Write-to-Write commands in different DIMMs. 0-Auto, Range 4-54.
**/
  UINT8                       tWr2WrDD;

/** Offset 0x05F8 - tRd2WrSG
  Delay between Read-to-Write commands in the same Bank Group. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2WrSG;

/** Offset 0x05F9 - tRd2WrDG
  Delay between Read-to-Write commands in different Bank Group for DDR4. All other
  DDR technologies should set this equal to SG. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2WrDG;

/** Offset 0x05FA - tRd2WrDR
  Delay between Read-to-Write commands in different Ranks. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2WrDR;

/** Offset 0x05FB - tRd2WrDD
  Delay between Read-to-Write commands in different DIMMs. 0-Auto, Range 4-54.
**/
  UINT8                       tRd2WrDD;

/** Offset 0x05FC - tRRD_L
  Min Row Active to Row Active Delay Time for Same Bank Group, DDR4 Only. 0: AUTO, max: 31
**/
  UINT8                       tRRD_L;

/** Offset 0x05FD - tRRD_S
  Min Row Active to Row Active Delay Time for Different Bank Group, DDR4 Only. 0:
  AUTO, max: 31
**/
  UINT8                       tRRD_S;

/** Offset 0x05FE - tWTR_L
  Min Internal Write to Read Command Delay Time for Same Bank Group, DDR4 Only. 0:
  AUTO, max: 60
**/
  UINT8                       tWTR_L;

/** Offset 0x05FF - tWTR_S
  Min Internal Write to Read Command Delay Time for Different Bank Group, DDR4 Only.
  0: AUTO, max: 28
**/
  UINT8                       tWTR_S;

/** Offset 0x0600 - Skip CPU replacement check
  Test, 0: disable, 1: enable, Setting this option to skip CPU replacement check
  $EN_DIS
**/
  UINT8                       SkipCpuReplacementCheck;

/** Offset 0x0601
**/
  UINT8                       ReservedFspmTestUpd[7];
} FSP_M_TEST_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0558
**/
  FSP_M_TEST_CONFIG           FspmTestConfig;

/** Offset 0x0608
**/
  UINT8                       UnusedUpdSpace11[6];

/** Offset 0x060E
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
