% Політика зменшення бінарних блобів
% Лія Роу
% 4 січня 2022 року (оновлено 15 листопада 2022 року)

Вступ
============

У цій статті описано *принципи*, які керують проектом Libreboot. Щоб отримати
інформацію про те, *як ці принципи застосовуються на практиці*, прочитайте
натомість цю статтю: [Статус свободи програмного та апаратного забезпечення для
кожної материнської плати, що підтримується Libreboot](../freedom-status.uk.md)

Політика Libreboot полягає в тому, щоб надати настільки, наскільки можливо, свободи
кожному користувачу, на кожному підтримуваному апаратному забезпеченні та *підтримувати
стільки апаратного забезпечення з coreboot, наскільки це можливо*; це означає, що ви повинні
мати можливість вивчати, змінювати та *ділитися* всім джерельним кодом, документацією
чи іншими подібними ресурсами, які роблять Libreboot таким, яким він є. Простіше кажучи, ви повинні
мати *контроль* над своїми власними обчисленнями.

*Мета* Libreboot полягає в тому, щоб
зробити саме це та допомогти якомога більшій кількості людей, автоматизувавши
конфігурацію, компіляцію та встановлення *coreboot* для *нетехнічних*
користувачів, ще більше спростивши це для звичайного користувача, надаючи користувачам
дружні інструкції для всього. По суті, Libreboot - це *дистрибутив
coreboot*, приблизно так само, як *Alpine Linux* є дистрибутивом Linux!

Метою цього документа є окреслення того, як це досягається, і як
проект працює на цій основі. *Цей* документ здебільшого стосується
ідеології, тому він (переважно) нетехнічний; для отримання технічної інформації
ви можете звернутися до [документації системи збірки Libreboot](../docs/maintain/).

Поточний обсяг проекту
=====================

Проект libreboot стосується того, що входить до основної мікросхеми завантажувальної флеш-пам'яті,
але є й інші компоненти мікропрограми, які слід взяти до уваги, про що йдеться
в [поширених запитаннях щодо libreboot](../faq.uk.md#яке-ще-мікропрограмне-забезпечення-існує-за-межами-libreboot).

Найбільш критичні з них це:

* Прошивка вбудованого контролера (EC)
* Прошивка жорстких дисків/твердотілих накопичувачів
* Прошивка Intel Management Engine / AMD PSP

Що таке двійковий блоб?
----------------------

Двійковий блоб у цьому контексті - це будь-який виконуваний файл, для якого не існує вихідного коду,
який ви не можете досліджувати та змінювати розумним чином. За визначенням,
усі такі блоби є *пропрієтарними* за своєю природою, і їх слід уникати, якщо це можливо.

Конкретні двійкові блоби також є проблематичними в більшості систем coreboot, але вони
відрізняються для кожної машини. Дізнайтесь більше в розділі поширених запитань і на цій сторінці про те,
як ми працюємо з двійковими блобами в проекті Libreboot.

Для інформації про Intel Management Engine та AMD PSP зверніться до поширених запитань.

Політика *зменшення* блобів
=======================

Конфігурації за замовчуванням
----------------------

Coreboot, на якому Libreboot базується, є здебільшого вільним програмним забезпеченням, але
на деяких платформах вимагає двійкових блобів. Найпоширенішим прикладом може бути raminit
(ініціалізація контролера пам'яті) або ініціалізація кадрового буфера відео. Прошивка
coreboot використовує двійкові блоби для деяких з цих завдань, на деяких материнських платах,
але деякі материнські плати з coreboot можна ініціалізувати з 100% вільним джерельним
кодом, який ви можете перевірити та скомпілювати для свого використання.

Libreboot вирішує цю ситуацію *суворо* та *принципово*. Природа
цього - це те, що ви збираєтесь прочитати.

Проект libreboot має наступну політику:

* Якщо блоб *можна* уникнути, його слід уникати. Наприклад, якщо ініціалізація VGA ROM
  в іншому випадку працює краще, але coreboot має *вільний* код ініціалізації
  для певного графічного пристрою, цей код слід використовувати в libreboot під
  час створення образу ROM. Подібним чином, якщо *ініціалізація контролера пам'яті* можлива
  за допомогою бінарного блобу *або* вільного коду в coreboot, *вільний* код
  слід використовувати в ROM, створених системою збірки Libreboot, а *блоб*
  для raminit не слід використовувати; однак, якщо вільний код ініціалізації недоступний
  для зазначеного raminit, це дозволено, і система збірки Libreboot використовуватиме
  *блоб*.
* Необхідно звернути увагу на деякі нюанси: у деяких конфігураціях ноутбуків або настільних комп'ютерів
  зазвичай буде *два* графічних пристрої (наприклад, чіп nvidia та
  чіп intel, використовуючи технологію nvidia optimus technology, на ноутбуці). Можливо,
  один із них має вільний код ініціалізації в coreboot, а інший - ні. Абсолютно
  прийнятно і бажано, щоб libreboot підтримував обидва пристрої та
  розміщував необхідний двійковий блоб на тому, якому бракує власної
  ініціалізації.
* Виняток зроблено для оновлень мікрокоду ЦП: вони дозволені та фактично
  *обов'язкові* відповідно до політики libreboot. Ці оновлення виправляють помилки ЦП, у тому
  числі помилки безпеки, і оскільки ЦП уже має невільний мікрокод, записаний в
  ROM в будь-якому випадку, єдиний вибір - *x86* або *зламаний x86*. Таким чином, libreboot
  дозволить лише конфігурації материнської плати coreboot, де
  *ввімкнено* оновлення мікрокоду, якщо доступно для ЦП на цій системній платі.
  [Releases after 20230423 will provide separate ROM images with microcode
  excluded, alongside the default ones that include microcode.](microcode.md)
* Intel Management Engine: у документації libreboot *повинні* бути написані
  слова, щоб розповісти людям, як *нейтралізувати* ME, якщо це можливо на даній дошці.
  Програма `me_cleaner` є дуже корисною та забезпечує набагато безпечнішу конфігурацію
  ME.
* Бінарні блоби *ніколи* не слід видаляти, навіть якщо вони не використовуються. 
  У проекті coreboot доступний набір субмодулів `3rdparty` з бінарними блобами
  для завдань ініціалізації на багатьох платах. *Усі* вони повинні бути включені до випусків
  libreboot, навіть якщо вони не використовуються. Таким чином, навіть якщо система збірки Libreboot
  ще не підтримує певну плату, хтось, хто завантажує libreboot, все одно
  може внести зміни у свою локальну версію системи збірки, якщо
  забажає, щоб надати конфігурацію свого апаратного забезпечення.

Загалом, застосовано здоровий глузд. Наприклад, винятком
із мінімізації може бути те, що *блоб* raminit та *вільний* raminit доступні, але
*вільний* так зламано, що його не можна використовувати. У такій ситуації натомість
слід використовувати той, що з блобом, тому що в іншому випадку користувач може повернутися до
повністю пропрієтарної системи замість використання coreboot (через libreboot).
*Деякі* свободи *краще, ніж жодних*.

Нова прагматична політика Libreboot також може призвести до того, що в майбутньому більше людей стануть
розробниками coreboot, виступаючи в якості важливого *містка* між
*ним* і нетехнічними людьми, яким просто потрібна допомога, щоб розпочати роботу.

Налаштування
-------------

Наведені вище принципи мають застосовуватися до конфігурацій *за замовчуванням*. Однак libreboot
має бути *конфігурованим*, дозволяючи користувачеві робити все, що заманеться.

Цілком природно, що користувач може захотіти створити *менш* вільний параметр, ніж
стандартний у libreboot. Це цілком прийнятно; свобода вище,
і її слід заохочувати, але *свободу вибору* користувача
також слід поважати та пристосовуватись до неї.

Іншими словами, не читайте лекції користувачеві. Просто спробуйте допомогти їм у
їхній проблемі! Метою проекту libreboot є просто зробити coreboot більш
доступним для нетехнічних користувачів.

КАТАЛОГ СВОБОДИ
===============

Також має бути доступна сторінка *[статусу блобів](../freedom-status.uk.md)*,
яка інформуватиме людей про статус бінарних блобів на кожній машині, що
підтримується системою збірки Libreboot. Дивіться:
[Статус свободи програмного та апаратного забезпечення для кожної плати, яка
підтримується Libreboot](../freedom-status.uk.md)

Бажано бачити світ, де все апаратне та програмне забезпечення є вільним, під
тією ж ідеологією, що й проект Libreboot. Обладнання!?

Так, обладнання. RISC-V є чудовим прикладом сучасної спроби вільного апаратного забезпечення, яке
часто називають *Апаратним забезпеченням з відкритим кодом*.
Це ISA для виробництва мікропроцесора. Уже існує багато реальних
реалізацій, які можна використовувати, і їх буде лише
більше.

Таке *апаратне забезпечення* ще знаходиться в зародковому стані. Ми повинні почати проект, який
буде каталогізувати статус різних зусиль, у тому числі на апаратному рівні (навіть на
рівні кремнію). Такі рухи, як OSHW і Право на ремонт (Right To Repair), є надзвичайно
важливими, включно з нашим власним рухом, який інакше зазвичай менше думатиме про свободу апаратного
забезпечення (хоча йому справді, справді
варто!)

Одного дня ми житимемо у світі, де будь-хто зможе виготовити власні чіпи,
включаючи процесори, а також будь-які інші типи мікросхем. Зусилля зробити домашнє виробництво
чіпів реальністю зараз знаходяться в зародковому стані, але такі зусилля існують,
наприклад, робота, виконана Семом Зелофом і проектом Libre Silicon:

* <https://www.youtube.com/channel/UC7E8-0Ou69hwScPW1_fQApA>
* <http://sam.zeloof.xyz/>
* <https://libresilicon.com/>

(Сем буквально виробляє процесори в своєму гаражі)

Проблеми з критеріями RYF
==========================

Раніше Libreboot відповідав критеріям FSF RYF, але тепер він дотримується
набагато більш прагматичної політики, спрямованої на надання більшої свободи більшій кількості людей у
більш прагматичний спосіб. Ви можете прочитати ці вказівки, перейшовши за цією URL-адресою:

* Рекомендації FSF Поважає Вашу Свободу (RYF):
<https://web.archive.org/web/20220604203538/https://ryf.fsf.org/about/criteria/>

Простіше кажучи, інструкції RYF стосуються комерційних продуктів із застереженням,
що вони не повинні містити пропрієтарне програмне забезпечення чи відомі проблеми конфіденційності,
як-от лазівки.

Повне виключення всього пропрієтарного забезпечення наразі неможливе. Наприклад,
пропрієтарне мікропрограмне забезпечення SDR у чіпсетах WiFi, мікропрограмне забезпечення пристроїв AHCI, таких як
жорсткі диски або твердотілі накопичувачі тощо. В інструкціях FSF RYF зазначено наступний виняток, щоб пом'якшити цей факт:

* "Однак є один виняток для вторинних вбудованих процесорів. Виняток стосується програмного забезпечення, що постачаєтья в бічних допоміжних і низькорівневих процесорах та FPGA, у яких встановлення програмного забезпечення не передбачається після того, як користувач отримає продукт. Це може включати, наприклад, мікрокод всередині процесора, мікропрограму, вбудовану в пристрій вводу-виводу, або структуру вентилів FPGA. Програмне забезпечення в таких вторинних процесорах не вважається програмним забезпеченням продукту."

*та має бути відхилено
з ідеологічних міркувань*. Решта політики libreboot і загальна
ідеологія, виражена в цій статті, базуватиметься в основному на цьому неприйнятті.
Визначення *програмного забезпечення продукту* абсолютно довільне; програмне забезпечення
є програмне забезпечення, а програмне забезпечення завжди має бути *вільним*. Замість того, щоб робити такі
винятки, слід заохочувати більше апаратного забезпечення, допомогаючи надавати якомога
більше свободи, одночасно надаючи користувачам інформацію про будь-які підводні
камені, з якими вони можуть зіткнутися, і заохочувати свободу на всіх рівнях. Коли така організація,
як FSF, робить такі сміливі винятки, як вище, вона надсилає неправильне повідомлення,
кажучи людям, по суті, заховати ці інші проблеми лише тому, що вони стосуються програмного забезпечення,
яке працює на "вторинному процесорі".
Якщо користувач може оновити програмне забезпечення, воно має бути вільним,
незалежно від того, *передбачав* виробник оновлення чи ні.
Там де справді *не* можливо оновити таке програмне забезпечення, пропрієтарне чи ні,
слід надати поради щодо цього. Освіта важлива, і критерії FSF
активно перешкоджають такій освіті; це створює помилкову надію, що
все добре і чудово, лише тому, що програмне забезпечення на одному довільному
рівні ідеальне.

Цей погляд FSF, виражений у цитованому абзаці, припускає,
що системою керує переважно *один* головний процесор. На багатьох
сучасних комп'ютерах це *більше не відповідає дійсності*.

Вільне *програмне забезпечення* не існує у вакуумі, але ми мали менше свободи в
минулому, особливо коли справа стосувалася апаратного забезпечення, тому *ПЗ* було нашим основним фокусом.

Здатність вільно вивчати, адаптувати, обмінюватися та використовувати/повторно використовувати ПЗ є важливою,
але є багато нюансів, коли справа доходить до *завантажувального мікропрограмного забезпечення*, нюансів, які
здебільшого не існують поза розробкою мікропрограмного забезпечення чи поза розробкою ядра.
Більшість типового прикладного/системного програмного забезпечення є високорівневим і портативним, але
завантажувальна мікропрограма має бути написана для кожної конкретної машини, і через те, як
апаратне забезпечення працює, існує багато компромісів, зокрема FSF, коли
визначає які стандарти слід застосовувати *на практиці*.

Той факт, що майже ніхто не говорить про прошивку EC, *пов'язаний* із
сертифікацією Поважає Вашу Свободу (Respects Your Freedom). Насправді мікропрограмне забезпечення EC має вирішальне
значення для свободи користувачів і повинно бути вільним, але FSF повністю ігнорує його як
*частину апаратного забезпечення*. Це неправильно, і FSF має активно
заохочувати людей визволяти його на кожному ноутбуці!

Інше мікропрограмне забезпечення, яке наразі не доступне для проекту libreboot, описано на
сторінці поширених питань libreboot. Наприклад, прошивка жорстких дисків/твердотілих накопичувачів описана в розділі поширених запитань.
Знову ж таки, повністю проігноровано та знизано плечима FSF.

Проект libreboot не буде приховувати або пропускати ці проблеми, тому що вони
справді є критичними, але, знову ж таки, наразі виходять за межі того, що робить система збірки Libreboot
На даний момент, система збірки Libreboot займається лише
coreboot (і корисними навантаженнями), але в майбутньому це має змінитися.

Приклади *замітання блобів під килим* FSF
----------------------------------------------

Протягом багатьох років було багато випадків, коли FSF активно не 
заохочував рівень свободи програмного забезпечення, наприклад:

* Робоча станція TALOS II "OpenPOWER" від Raptor Engineering USA. Вона містить
  мережеву плату Broadcom в собі, яка потребує прошивки, і ця прошивка була невільною.
  FSF були готові проігнорувати це та сертифікувати продукт TALOS II відповідно до RYF,
  але Тімоті Пірсон із Raptor Engineering все одно звільнив її, хоча йому навіть
  про це не було сказано. Гуго Ландау розробив специфікацію, а Еван Лоєвскі
  написав вільну прошивку. Дивіться:
  <https://www.devever.net/~hl/ortega> та <https://github.com/meklort/bcm5719-fw>
* FSF свого часу схвалив ThinkPad X200, який продавав [Minifree Ltd](https://minifree.org),
  який містить Intel ME; bootrom все ще там, як і співпроцесор ME,
  але ME переведено в вимкнений стан через Intel Flash
  Descriptor, а мікропрограму ME у флеш-пам'яті видалено. Однак ME - це цілий
  співпроцесор, який з вільною прошивкою можна було би використовувати для багатьох
  речей. У проектах Libreboot та coreboot завжди був інтерес до цього,
  але FSF повністю ігнорує це. Продукт X200, який вони сертифікували,
  постачався з попередньо встановленим Libreboot.
* У Libreboot є утиліта, написана мною, Лією Роу, яка створює флеш-дескриптори ICH9M і образи
  GbE NVM з нуля. Це необхідно для налаштування
  машини, але інакше це двійкові блоб-файли; FSF був би цілком
  задоволений сертифікацією апаратного забезпечення в будь-якому випадку, оскільки це були непрограмні
  блоби у форматі, повністю задокументованому Intel (це лише двійкові конфігураційні
  файли), але я все одно пішла вперед і написала ich9gen. За допомогою ich9gen ви можете
  легше змінювати регіони дескриптора/gbe для вашого образу мікропрограмного забезпечення. Дивіться:
  <https://libreboot.org/docs/install/ich9utils.html> - libreboot також має це
* FSF свого часу схвалив ThinkPad T400 з Libreboot, який продавав Minifree. Ця
  машина доступна в двох версіях: з графічним процесором ATI+Intel або лише Intel. Якщо ATI
  GPU, можна налаштувати машину так, щоб використовувався будь-який GPU. Якщо буде використовуватися
  графічний процесор ATI, для ініціалізації потрібен блоб мікропрограми, хоча драйвер для нього
  повністю вільний. *FSF* проігнорувала цей факт і схвалила апаратне забезпечення,
  доки Libreboot не вмикає графічний процесор ATI і не повідомляє людям, як його
  увімкнути. Графічний процесор *Intel* на цій машині має вільний код ініціалізації
  від проекту coreboot і повністю вільний драйвер в обох ядрах Linux та BSD.
  У конфігурації, наданій Libreboot, ATI GPU повністю вимкнено
  та виключено.
* Усі ноутбуки ThinkPad, сумісні з Libreboot, містять невільне мікропрограмне забезпечення вбудованого контролера,
  яке можна прошивати користувачем (*і призначене для оновлення
  виробником*). FSF вирішила ігнорувати прошивку EC, відповідно до
  свого винятку *вторинного процесора*. Дивіться:
  <http://libreboot.org/faq.uk.html#прошивка-ec-вбудований-контролер>

У всіх вищезазначених випадках FSF міг бути суворішим і сміливішим, наполягаючи
на тому, що ці *додаткові* проблеми свободи були вирішені. Вони цього не
зробили. Є багато інших прикладів цього, але мета цієї статті
не перелічити їх усі (інакше на цю тему можна були б написати книгу).

Проблеми з FSDG
------------------

<img tabindex=1 src="https://av.libreboot.org/firmware.uk.png" /><span class="f"><img src="https://av.libreboot.org/firmware.uk.png" /></span>

FSF підтримує ще один набір критеріїв, які називаються Правилами вільного
розповсюдження системи (GNU FSDG)]

Критерії FSDG відрізняються від RYF, але мають подібні проблеми. FSDG - це
те, чому відповідають схвалені FSF дистрибутиви GNU+Linux. По суті, він забороняє
все пропрієтарне програмне забезпечення, включаючи мікропрограму пристрою. Це може здатися благородним, але
вкрай проблематично в контексті прошивки. Їжа для роздумів:

* Виключення мікропрограмним блобів із ядра linux - це *погано*. Пропрієтарна прошивка
  є *також поганою*. Включення їх є мудрішим вибором, якщо також забезпечується сильна освіта
  про те, *чому вони погані* (менше свободи). Якщо ви відкриєте їх для
  користувача та повідомите йому про це, з'явиться більше стимулів (через просте
  нагадування про їх існування) провести зворотне проектування та замінити їх.
* Прошивка *в ядрі вашої ОС* *хороша*. FSF одночасно дає дозвіл на
  апаратне забезпечення *з тими самими блобами прошивки*, якщо прошивка вбудована в
  ROM/флеш-пам'ять на пристрої або вбудована в якийсь процесор. Якщо
  вбудоване програмне забезпечення знаходиться на окремому ROM/флеш-пам'яті, його все одно можна замінити
  користувачем за допомогою зворотного проектування, але тоді вам, ймовірно, доведеться провести деяку пайку
  (замінити чіп на картці/пристрої). *Якщо мікропрограма завантажується ядром
  ОС, тоді вона відкрита для користувача, і її можна легше замінити.
  Критерії FSF у цьому відношенні заохочують розробників апаратного забезпечення
  приховувати вбудоване програмне забезпечення, що робить фактичну (програмну) свободу менш імовірною!*

Окрім цього, FSDG здається нормальним. Будь-яка вільна операційна система має в ідеалі не містити
пропрієтарних *драйверів* або *застосунків*.

Виробники обладнання полюбляють заштовхувать все в мікропрограмне забезпечення, оскільки їх
продукт часто має поганий дизайн, тому вони пізніше хочуть надати вирішення в
прошивці для налагодження проблемних питань. В багатьох випадках, пристрій вже матиме прошивку в собі,
але вимагає оновлення, надане йому вашим ядром ОС.

Найбільш поширений приклад пропрієтарної прошивки в Linux для пристроїв wifi.
Це цікавий сценарій використання, з джерельним кодом, тому що його може бути
використано для контрольованого власником *software defined radio*.

Шлях *Debian* є ідеальним. Дистрибутив Debian GNU+Linux повністю вільний
за замовчуванням, і вони включають додаткову прошивку за необхідності, яку вони мають в
окремому репозиторії, що містить її. Якщо ви хочете тільки прошивку, тривіально
взяти образи встановлювача з нею доданою, або додати її до вашої встановленої
системи. Вони розповідають вам, як зробити це, що означає, що вони допомогають людям
отримати *деяку* свободу, *замість ніякої*. Це невід'ємно прагматичний
спосіб робити справи, і це те, як це робить Libreboot.

Більше контексту, стосовно Debian, доступно в публікації цього блога:
<https://blog.einval.com/2022/04/19#firmware-what-do-we-do> - в ньому, автор,
відомий розробник Debian, робить чудовий акцент про прошивку
пристроїв, подібну до статті (Libreboot), яку ви зараз читаєте. Її
варто прочитати! Станом на жовтень 2022 року, Debian проголосував за включення прошивки пристроїв
за *замовчуванням*, в наступних випусках Debian. Раніше Debian виключав таке
мікропрограмне забезпечення, але дозволяв вам його додавати.

OpenBSD майже така сама, але вони розумні в цьому: під час початкового
завантаження, після інсталяції, він повідомляє вам, яке мікропрограмне забезпечення потрібно,
і оновляє його для вас. Це дуже прозоро обробляється їхньою
програмою `fw_update`, про яку ви можете прочитати тут:

<https://man.openbsd.org/fw_update>

*Заборона* прошивки linux конкретно є загрозою свободі в довгостроковій перспективі,
тому що нові користувачі GNU+Linux можуть бути відбиті від використання ОС, якщо їх
апаратне забезпечення не працює. Ви можете сказати: просто купіть нове обладнання! Це часто неможливо
для користувачів, і користувач також може не мати навичок для
зворотного проектування.

Більш детальна інформація про мікрокод
=====================================

[Releases after 20230423 will provide separate ROM images with microcode
excluded, alongside the default ones that include microcode.](microcode.md)

Щоб було зрозуміло: бажано, щоб мікрокод був вільним. Мікрокод систем Intel
та AMD *є* пропрієтарним. Факти і почуття рідко збігаються; метою цього
розділу є поширення *фактів*.

Система збірки libreboot тепер дозволяє оновлення мікрокоду *за замовчуванням.*

Відсутність оновлень мікрокоду ЦП є абсолютною катастрофою для стабільності
та безпеки системи.

Що ще гірше, той самий текст, цитований із критеріїв FSF RYF,
насправді конкретно згадує мікрокод. Знову процитую для нащадків:

*"Однак є один виняток для вторинних вбудованих процесорів. Виняток
стосується програмного забезпечення, що постачається всередині допоміжних і низкорівневих
процесорів та FPGA, у яких інсталяція програмного забезпечення не передбачається після того,
як користувач отримає продукт. Це може включати, наприклад, мікрокод всередині
процесора, мікропрограму, вбудовану в пристрій вводу-виводу, або структуру вентилів FPGA.
Програмне забезпечення в таких вторинних процесорах не вважається програмним забезпеченням продукту."*

Тут обговорюється мікрокод, який записується в *mask ROM* на самому
ЦП. Одночасно він не дає ОК для *оновлень* мікрокоду, які надаються
coreboot або ядром Linux; згідно з FSF, це напад на
вашу свободу, але старіший мікрокод із більшими помилками, записаний на ROM, є нормальним.

ЦП вже має мікрокод, записаний в mask ROM. Мікрокод налаштовує
логічні вентилі в ЦП, для реалізації набору інструкцій через спеціальні *декодери*,
які мають фіксовану функцію; неможливо, наприклад, реалізувати набір інструкцій RISCV
на процесорі x86. Для мікрокода можливо тільки
реалізувати x86, або *зламаний* x86, і мікрокод за замовчуваням майже завжди є
*зламаним x86* на ЦП Intel/AMD; це неминуче через складність цих
процесорів.

FSF вважає,
що ці оновлення мікрокоду x86 (для Intel/AMD) дозволяють повністю створити новий
ЦП, який принципово відрізняється від x86. Це не правда. Також неправда,
що *всі* інструкції в наборі інструкцій x86 реалізовано за допомогою мікрокоду. У
деяких випадках використовується жорстко закодована схема! Оновлення мікрокоду більше нагадують
крихітні одиничні патчі тут і там у сховищі git, за аналогією.
Щоб знову потрапити у головний простір FSF: ці оновлення не можуть зробити ЦП
еквівалентом рефакторингу всієї кодової бази. Це *гарячі виправлення*, нічого
більше!

Невиключення цих оновлень призведе до нестабільного/невизначеного стану. Intel
сама визначає, які помилки впливають на які ЦП, і вони визначають обхідні шляхи або надають
виправлення в мікрокоді. Виходячи з цього, таке програмне забезпечення, як ядро Linux
може обійти ці помилки/примхи. Крім того, апстрім версії ядра Linux
можуть оновити мікрокод під час завантаження (однак все одно рекомендується робити це
з coreboot для більш стабільної ініціалізації контролера пам'яті або “raminit”).
Подібне можна сказати і про ЦП AMD.

Ось кілька прикладів того, як відсутність оновлень мікрокоду вплинула на *Libreboot*,
змусивши Libreboot обійти зміни, внесені в апстрім coreboot, зміни,
які були *хорошими* і зробили coreboot більш сумісним зі стандартами відповідно до
специфікацій Intel. Libreboot довелося *поламати* coreboot, щоб зберегти деякі
інші функції на деяких Thinkpad GM45/ICH9M:

<https://browse.libreboot.org/lbmk.git/plain/resources/coreboot/default/patches/0012-fix-speedstep-on-x200-t400-Revert-cpu-intel-model_10.patch?id=9938fa14b1bf54db37c0c18bdfec051cae41448e>

<https://browse.libreboot.org/lbmk.git/plain/resources/coreboot/default/patches/0018-Revert-cpu-intel-Configure-IA32_FEATURE_CONTROL-for-.patch?id=4b7be665968b67463ec36b9afc7e8736be0c9b51>

Ці патчі повертають *виправлення помилок* у coreboot, виправлення, які порушують
інші функції, але лише якщо оновлення мікрокоду виключено. Найбільш
правильним з технічної точки зору рішенням є *не* застосування наведених вище патчів, а натомість
оновлення мікрокоду!

Виберіть свою отруту. Недодавання оновлень є *безвідповідальним* і, зрештою,
марним, оскільки ви все одно отримуєте пропрієтарний мікрокод, ви просто отримуєте
старішу, з більшими помилками, версію натомість!

Ця зміна в політиці проекту зовсім не впливає на вашу свободу,
тому що в іншому випадку ви все одно маєте старіший мікрокод із більшими помилками. Однак він покращує
надійність системи, включаючи оновлення!

Така прагматична політика *перевершує* *догму*, яку колись
доводилося терпіти користувачам Libreboot. Простіше кажучи, проект Libreboot має на меті надати користувачам
якомога більше свободи для їх апаратного забезпечення; так було завжди,
але цей менталітет тепер застосовується до [набагато] більшої кількості обладнання.

Інші міркування
====================

Також Libreboot не покриває суворо: OSHW і Право на ремонт (Right To Repair). Однак свобода
на рівні кремнію була б дивовижною, і зусилля вже є; наприклад, подивіться на RISCV ISA (на
практиці фактичне виготовлення все ще є пропрієтарним і не під вашим контролем, але RISCV є повністю вільним
дизайном ЦП, який компанії можуть використовувати замість того, щоб використовувати пропрієтарний ARM/x86 і
так далі). Подібним чином, Право на ремонт (можливість відремонтувати свій власний пристрій, що
передбачає вільний доступ до схем і діаграм) є критично важливим з тієї ж причини, що
критично важливо вільне програмне забезпечення (Право на хакерство)!

OSHW і Право на ремонт взагалі не охоплюються RYF (критерії FSF Поважає Вашу
Свободу), критеріями, яких Libreboot дотримувався раніше..
RYF також робить кілька поступок, які зрештою завдають шкоди, наприклад,
політика *програмне забезпечення як схема*, яка, чесно кажучи, є безглуздою. ROM все ще
програмне забезпечення. Був час, коли FSF не вважав програмне забезпечення BIOS проблемою
свободи, лише тому, що воно записане на mask ROM, а не *прошито*; ця
політика FSF ігнорує той факт, що, маючи відповідні навички паяння, легко замінити
автономні мікросхеми mask ROM на сумісну флеш-пам'ять.

Висновки
==========

RYF сам по собі не є *неправильним*, просто має недоліки. Певним чином це правильно, і
якщо його дотримуватися, результат *надає* багато свобод користувачеві, але RYF
повністю ігнорує багато речей, які зараз можливі, включаючи свободи на
апаратному рівні (критерії RYF охоплюють лише *програмне забезпечення*). Ці вказівки
написані з припущеннями, які все ще були вірними в 1990-х роках, але відтоді
світ змінився. Проект libreboot повністю відкидає цю політику та натомість
використовує прагматичний підхід.

Висновок, який слід зробити з усього цього, такий:

*Дотримання* критеріїв FSF нічого не шкодить, але ці критерії є дуже
консервативними. Його винятки слід *ігнорувати* та повністю ігнорувати. RYF
більше не відповідає меті, і його слід переписати, щоб створити *більш суворий*
набір інструкцій без усіх лазівок чи винятків.
Як завжди було, Libreboot намагається завжди виходити за межі, але
проект Libreboot не розглядає RYF як *золотий стандарт*. Зараз є
можливі рівні свободи, які вказівки RYF взагалі не охоплюють, а
в деяких випадках навіть активно не заохочують/перешкоджають, оскільки це робить компроміси
на основі припущень, які більше не відповідають дійсності. 

Сумна правда: RYF активно заохочує *менше* свободи, не будучи достатньо сміливим.
Він встановлює прапор перемоги та говорить *місію виконано*, незважаючи на те, що
робота *далека* від завершення!

Якщо дотримуватись *з незаперечними винятками*, RYF може в деяких випадках заохочувати
компанії *приховувати* будь-які проблеми зі свободою, які існуюють,
коли це стосується пропрієтарного мікропрограмного забезпечення, яке не працює на центральному процесорі хоста (наприклад, мікропрограмне забезпечення
вбудованого контролера).

Я пропоную написати нові рекомендації, щоб замінити RYF. Ці нові правила
ліквідують усі винятки/лазівки та вимагають, щоб *все* програмне забезпечення
було вільним на машині або якомога більше. Замість того, щоб лише рекламувати продукти,
які відповідають певним стандартам, просто каталогізуйте всі системи у великій
*базі даних* свого роду (наприклад, h-node.org, але краще), яка точно визначатиме, які
*апаратні* **і** програмні проблеми існують на кожному пристрої. Включіть Право
на ремонт і OSHW (включно з такими речами, як RISCV) до найбільш "ідеальної"
стандартної машини; золотим стандартом є вільний *кремній*, як те, над чим
Сем Зелоф та інші працюють зараз.

Цей новий набір критеріїв не повинен намагатися приховати або проігнорувати *щось*. Це
має заохочувати людей розширювати рамки та впроваджувати інновації, щоб ми могли мати
набагато *більше* свободи, ніж зараз можливо. Необхідність є матір'ю всіх
винаходів, а свобода є важливою метою в кожному аспекті життя, не лише в
обчисленні.

Не називайте це "Поважає вашу свободу" чи щось подібне. Натомість назвіть це
приблизно так: каталог свободи. І насправді зосередьтеся на апаратному забезпеченні, а не
лише на програмному забезпеченні!

Інші ресурси
===============

Повідомлення в блозі RYF Аріадни Конілл
------------------------------

Аріадна Конілл, голова групи безпеки *Alpine Linux*, опублікувала дуже серйозну
статтю про RYF, у якій висловлено схожі моменти в порівнянні з *цією* статтею.
Однак Аріадна докладно розглядає кілька інших прикладів проблем із
критеріями FSF RYF; наприклад, йдеться про продукт *Novena* від
Bunnie.

Варто прочитати! Посилання:

<https://ariadne.space/2022/01/22/the-fsfs-relationship-with-firmware-is-harmful-to-free-software-users/>
