---
title: HP EliteBook Folio 9470m
x-toc-enable: true
...

**[PLEASE READ THESE INSTRUCTIONS BEFORE INSTALLING](../../news/safety.md),
OR YOU MIGHT BRICK YOUR MACHINE: [SAFETY PRECAUTIONS](../../news/safety.md)**

<div class="specs">
<center>
<img tabindex=1 alt="HP EliteBook Folio 9470m" class="p" src="https://av.libreboot.org/hp9470m/grub.jpg" /><span class="f"><img src="https://av.libreboot.org/hp9470m/grub.jpg" /></span>
</center>

| ***Specifications***      |                                   |
|---------------------------|-----------------------------------|
| **Manufacturer**          | HP                                |
| **Name**                  | EliteBook Folio 9470m             |
| **Released**              | 2012                              |
| **Chipset**               | Intel QM77                        |
| **CPU**                   | Intel Ivy Bridge ULV              |
| **Graphics**              | Intel HD Graphics 4000            |
| **Display**               | 14" 1366x768 or 1600x900          |
| **Memory**                | Up to 16GB                        |
| **Architecture**          | x86_64                            |
| **EC**                    | KBC1126, proprietary              |
| **Intel ME/AMD PSP**      | Present, neutered                 |
| **Flash chip**            | SOIC-8 16MiB                      |


| ***Payloads supported***  |       |
|---------------------------|-------|
| **GRUB**                  | Works |
| **SeaBIOS**               | Works |
| **SeaBIOS with GRUB**     | Works |
</div>

Introduction
============

HP EliteBook Folio 9470m is a 14" ultrabook with a backlit keyboard.

Libreboot has support for this, in the Git repository and release versions
from Libreboot 20230423 onwards.

Installation of Libreboot
=========================

You must first compile the Libreboot ROM

    ./build roms hp9470m_16mb

More information about building ROM images can be found in
the [build guide](../build).

This is an *Ivybridge* board which means that a neutered ME image is required
if you wish to flash the ME region. Libreboot's build system automatically
downloads, neuters (using `me_cleaner`) and inserts this if compiling from
source.

If you're using *Libreboot release* ROM images, the ME image has been scrubbed
and you must re-insert it. Use the information on this guide to know how
to do that:
[Insert vendor files on Intel Sandybridge/Ivybridge/Haswell
platforms](../install/ivy_has_common.md)

You may also wish to change the *default MAC address* if you're planning to
use the onboard Intel Gigabit Ethernet. You can do this using the information
in the same guide linked above, or read the nvmutil manual:

[Modify MAC addresses with nvmutil](../install/nvmutil.md).

Disassembly
-----------

Remove the battery.

![](https://av.libreboot.org/hp9470m/00_battery.jpg)

Open the two screws marked with the three-disc icons.
Slide the HDD panel out and remove it.

![](https://av.libreboot.org/hp9470m/01_panel.jpg)

The flash chip is now comfortably accessible. Now refer to the
[external programming guide](../install/spi.html) for guidance on how
to program Libreboot on it.

![](https://av.libreboot.org/hp9470m/02_flash.jpg)

Some part of the board might turn on when programming. If programming fails,
you might have to attach the laptop to a charger. Make sure the laptop
powers off before running flashrom. No LEDs should be lit.

