/* gpgzip.h
 *        Copyright (C) 2002 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef GNUPG_ZIP_H
#define GNUPG_ZIP_H

enum {
    PKERR_SUCCESS  =  0,
    PKERR_INV_FILE = -1,
    PKERR_FILE     = -2,
    PKERR_GENERAL  = -3,
};


struct PK_file_list;
typedef struct PK_file_list *PK_FILE_LIST;


#ifdef __cplusplus
extern "C" {
#endif

int pk_archiv_parse( FILE * in );
int pk_archiv_create( PK_FILE_LIST list, const char * output );
void pk_list_add( PK_FILE_LIST *list, const char * name );
void pk_list_free( PK_FILE_LIST ist );

#ifdef __cplusplus
}
#endif
    
#endif /*GNUPG_ZIP_H*/
