/* wptSignEncDlg.cpp - Sign & encrypt dialog
 *	Copyright (C) 2000-2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include <windows.h>
#include <commctrl.h>

#include "../resource.h"
#include "wptErrors.h"
#include "wptAgent.h"
#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptKeylist.h"
#include "wptTypes.h"
#include "wptNLS.h"
#include "wptContext.h" /* for passphrase_s */
#include "wptDlgs.h"
#include "wptW32API.h"
#include "wptKeylist.h"
#include "wptVersion.h"
#include "wptGPG.h"
#include "wptRegistry.h"
#include "wptUTF8.h"


BOOL CALLBACK 
clip_signenc_dlg_proc( HWND dlg, UINT msg, WPARAM wparam, LPARAM lparam )
{
    static listview_ctrl_t lv = NULL;
    static keylist_t list = NULL;
    static int enable = 0;
    gpgme_ctx_t ctx;
    gpgme_keycache_t kc;
    gpgme_recipients_t rset;
    gpgme_error_t err;
    passphrase_cb_s pwd;
    char * signer = NULL;
    int force_trust = 0, opt = 0;
    int kmode = reg_prefs.keylist_mode? KEYLIST_ENCRYPT_MIN : KEYLIST_ENCRYPT;
    
    switch( msg ) {
    case WM_INITDIALOG:
#ifndef LANG_DE
        SetWindowText( dlg, _("Sign & Encrypt") );
#endif
        kc = keycache_get_ctx( KEYCACHE_PUB );
	if( !kc )
	    BUG( NULL );
        lv = keylist_load( GetDlgItem( dlg, IDC_SIGNENC_KEYLIST ), 
			   kc, NULL, kmode, GPGME_ATTR_USERID );
	seclist_init( dlg, IDC_SIGNENC_SECLIST, KEYLIST_FLAG_SHORT, &list );
	center_window( dlg );
	set_active_window( dlg );
	EnableWindow( GetDlgItem( dlg, IDC_SIGNENC_SECLIST ), FALSE );
	SetDlgItemText (dlg, IDC_SIGNENC_SELKEY, _("Select key for signing"));
	SetDlgItemText (dlg, IDC_SIGNENC_SECLISTINF, _("Signing key:"));
        SetForegroundWindow( dlg );
        return TRUE;
        
    case WM_DESTROY:
	seclist_destroy( &list );
        reset_active_window( );
        if( lv ) {
            keylist_delete( lv );
            lv = NULL;
        }
        memset( pwd.pwd, 0, sizeof pwd.pwd );
        return FALSE;
        
    case WM_NOTIFY:
        NMHDR * notify;
        notify = (NMHDR *)lparam;
        if( notify && notify->code == NM_DBLCLK
            && notify->idFrom == IDC_SIGNENC_KEYLIST )
            PostMessage( dlg, WM_COMMAND, MAKEWPARAM(IDOK, 0), NULL );
        return TRUE;
        
    case WM_SYSCOMMAND:
        if( LOWORD (wparam) == SC_CLOSE )
            EndDialog( dlg, TRUE );
        return FALSE;
        
    case WM_COMMAND:
	/* fixme: the enable seems to have a sync problem */
	if( HIWORD( wparam ) == BN_CLICKED 
	    && LOWORD( wparam ) == IDC_SIGNENC_SELKEY ) {
	    enable ^= 1;
	    EnableWindow( GetDlgItem( dlg, IDC_SIGNENC_SECLIST ), enable? TRUE : FALSE );
	}
        switch( LOWORD( wparam ) ) {
        case IDOK:
            rset = keylist_get_recipients( lv, &force_trust, NULL );
            if( !gpgme_recipients_count( rset ) ) {
                msg_box( dlg, _("You must select at least one key."), _("Sign & Encrypt"), MB_ERR );
                gpgme_recipients_release( rset );
                return FALSE;
            }
            if( IsDlgButtonChecked( dlg, IDC_SIGNENC_SELKEY ) ) {
		gpgme_key_t key;
		const char * s;

		if( seclist_select_key( dlg, IDC_SIGNENC_SECLIST, &key ) ) {
		    msg_box( dlg, _("No key was selected."), _("Signing"), MB_ERR );
                    return FALSE;
		}
		s = gpgme_key_get_string_attr( key, GPGME_ATTR_KEYID, NULL, 0 );
		if( s )
		    signer = m_strdup( s+8 );
            }
            else {
		signer = get_gnupg_default_key( );
		if( !signer ) {
                    msg_box( dlg, _("Could not get default key."), _("Signing"), MB_ERR );
                    return FALSE;
                }
            }
            memset( &pwd, 0, sizeof pwd );
            err = gpgme_new( &ctx );
	    if( err )
		BUG( dlg );
	    gpgme_enable_logging( ctx );
	    set_gpg_passphrase_cb( ctx, &pwd, GPG_CMD_SIGN, dlg, _("Sign & Encrypt") );
	    if( force_trust )
                opt |= GPGME_CTRL_FORCETRUST;
            err = gpgme_op_clip_sign_encrypt( ctx, rset, signer, opt );
            memset( pwd.pwd, 0, sizeof pwd.pwd );
            gpgme_recipients_release( rset );
	    free_if_alloc( signer );
	    if( err == GPGME_Bad_Passphrase )    
		agent_del_cache( pwd.keyid );
	    if( err ) {
		gpgme_show_error( dlg, err, ctx, _("Sign & Encrypt"), MB_ERR );
		gpgme_release( ctx );
		return FALSE;
	    }
	    gpgme_release( ctx );
	    show_msg( dlg, 1500, _("GnuPG Status: Finished") );
            EndDialog( dlg, TRUE );
            return TRUE;
            
        case IDCANCEL:
            EndDialog( dlg, FALSE );
            return FALSE;
        }
        break;
    }
    
    return FALSE;
} /* clip_signenc_dlg_proc */
