/* version.c
 *	Copyright (C) 2001, 2002, 2003 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include "util.h"
#include "context.h"
#include "ops.h"

static gpgme_error_t
version_start (gpgme_ctx_t ctx, gpgme_data_t info)
{
    gpgme_error_t rc = 0;
    
    _gpgme_gpg_release( &ctx->gpg );
    rc = _gpgme_gpg_new( &ctx->gpg );
    if( rc )
        goto leave;    
    _gpgme_gpg_add_arg( ctx->gpg, "--version" );
    _gpgme_data_set_mode( info, GPGME_DATA_MODE_IN );
    _gpgme_gpg_add_arg( ctx->gpg, "--output" );
    _gpgme_gpg_add_arg( ctx->gpg, "-" );
    _gpgme_gpg_add_data( ctx->gpg, info, 1 );
    
    rc = _gpgme_gpg_spawn( ctx->gpg, ctx );
leave:
    if( rc ) {
        ctx->pending = 0;
        _gpgme_gpg_release( &ctx->gpg );
    }
    return rc;
} /* gpgme_op_version_start */


gpgme_error_t
gpgme_op_version( char **r_info )
{
    gpgme_error_t rc;
    gpgme_ctx_t ctx = NULL;
    gpgme_data_t dh = NULL;
    
    if( !r_info )
	return mk_error( Invalid_Value );

    rc = gpgme_new( &ctx );
    if( !rc )
	rc = gpgme_data_new( &dh );
    if( !rc )
	rc = version_start( ctx, dh );
    if( !rc ) {
        gpgme_wait( ctx, 1 );
        ctx->pending = 0;
    }    
    *r_info = _gpgme_data_release_and_return_string( dh );
    gpgme_release( ctx );
    return rc;
} /* gpgme_op_version */

