//------------------------------ $Keywords ----------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeConfigure.cpp - Configuration dialog
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// VCS: $Version: 1 $ $Revision: 5 $
/*
$History: **** V 1.0 by kfitzner ****
$History: * gpgeeconfigure.ddp - 2005-05-13 5:44:54 PM - 51 Bytes
$History: * gpgeeconfigure.cpp - 2005-05-13 11:14:15 PM - 15016 Bytes
$History: * gpgeeconfigure.dfm - 2005-05-10 4:34:22 PM - 5619 Bytes
$History: * gpgeeconfigure.h - 2005-05-03 9:05:22 AM - 3358 Bytes
$History: * Initial check-in
$History: **** V 1.1 by kfitzner ****
$History: * gpgeeconfigure.cpp - 2005-05-14 2:07:58 PM - 15553 Bytes
$History: * gpgeeconfigure.dfm - 2005-05-14 1:43:20 PM - 5789 Bytes
$History: * gpgeeconfigure.h - 2005-05-14 1:43:20 PM - 3392 Bytes
$History: * Add configuration entry for persistent key caching
$History: **** V 1.2 by kfitzner ****
$History: * gpgeeconfigure.cpp - 2005-07-17 1:27:44 PM - 16044 Bytes
$History: * gpgeeconfigure.dfm - 2005-07-17 1:12:54 PM - 5973 Bytes
$History: * gpgeeconfigure.h - 2005-07-16 2:12:56 AM - 3420 Bytes
$History: * gpgeeconfigure.ddp - 2005-07-17 1:16:56 PM - 51 Bytes
$History: * Add option to always show parent key id
$History: **** V 1.3 by kfitzner ****
$History: * gpgeeconfigure.cpp - 2005-08-08 6:47:33 AM - 16362 Bytes
$History: * gpgeeconfigure.dfm - 2005-07-17 1:12:54 PM - 5973 Bytes
$History: * gpgeeconfigure.h - 2005-08-08 6:36:52 AM - 3356 Bytes
$History: * gpgeeconfigure.ddp - 2005-08-08 6:36:54 AM - 51 Bytes
$History: * License change - remove option for later versions of GPL
$History: **** V 1.4 by kfitzner ****
$History: * gpgeeconfigure.cpp - 2005-08-31 8:37:13 PM - 16854 Bytes
$History: * gpgeeconfigure.dfm - 2005-08-31 7:07:38 PM - 6162 Bytes
$History: * gpgeeconfigure.h - 2005-08-31 7:06:46 PM - 3381 Bytes
$History: * gpgeeconfigure.ddp - 2005-08-31 7:10:08 PM - 51 Bytes
$History: * Add option to notify on new versions
$History: **** Latest ** V 1.5 by kfitzner ** 2005-10-06 8:28:32 PM ****
$History: * Add language support - now all forms' visual elements 
$History: * are stored in the string table (strings.rc)
*/
//----------------------------  $NoKeywords ---------------------------------


//---------------------------------------------------------------------------
// File Notes:
//---------------------------------------------------------------------------
// 1 Apr 2005 - Kurt Fitzner <kfitzner@excelcia.org>
//
// The code for GPGee's configuration form.  This is pretty much just a UI
// wrapper around the TConfiguration class.  Yes, I know what I said about
// seperating the UI from functional code in notes for GPGeeSignEncrypt.cpp.
// In this case I wanted to create a "drag-n-drop" configuration class that
// could be reused anywhere.  The functionality in GPGeeSignEncrypt isn't
// likely to be reused, so it'd done quick and dirty like. Test.
//---------------------------------------------------------------------------
#include <vcl.h>
#include <FileCtrl.hpp>
#pragma hdrstop

#include "TConfiguration.h"
#include "GPGeeUtility.h"
#include "TProgramLog.h"
#include "GPGeeConfigure.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TformGPGeeConfigure *formGPGeeConfigure;
extern TConfiguration *GPGeeConfig;             // All our configuration data
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
// Constructor for the form
//
__fastcall TformGPGeeConfigure::TformGPGeeConfigure(TComponent* Owner): TForm(Owner)
{
  __ENTERFUNCTION__;
  sGPGProgram = sOptfile = sKeyring = sSecretKeyring = "";
  __RETURNFUNCTION__;
}  // __fastcall TformGPGeeConfigure::TformGPGeeConfigure(TComponent* Owner): TForm(Owner)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Form OnShow event handler - form configuration that can't be done until
// the form's components are streamed in first (ie: can't be done in the
// constructor)
//
void __fastcall TformGPGeeConfigure::FormShow(TObject *Sender)
{
  AnsiString OverwriteSetting;

  __ENTERFUNCTION__;

  // Read in the language strings for the form's visual text labels and change them on the form.  Borland's language
  // editor is capable of doing this, but it's much easier for translators if we can give them a single resource
  // string table to translate instead of forcing them to use Borland's translation tool.
  this->Caption             = GetMessage(FORM_CONFIG_CAPTION);
  btnOk->Caption            = GetMessage(FORM_BTN_OK);
  btnCancel->Caption        = GetMessage(FORM_BTN_CANCEL);
  btnHelp->Caption          = GetMessage(FORM_BTN_HELP);
  gbGnuPG->Caption          = GetMessage(FORM_CONFIG_LABEL_GPGOPTIONS);
  gbGeneralOptions->Caption = GetMessage(FORM_CONFIG_LABEL_GENERALOPTIONS);
  rgOverwrite->Caption      = GetMessage(FORM_CONFIG_LABEL_OVERWRITE);
  chbGPGProgram->Caption    = GetMessage(FORM_CONFIG_CHECK_PROGRAMPATH);
  chbOptfile->Caption       = GetMessage(FORM_CONFIG_CHECK_OPTIONSFILE);
  chbKeyring->Caption       = GetMessage(FORM_CONFIG_CHECK_PUBKEYRING);
  chbSecretKeyring->Caption = GetMessage(FORM_CONFIG_CHECK_SECKEYRING);
  chbForceTrust->Caption    = GetMessage(FORM_CONFIG_CHECK_FORCETRUST);
  chbEncryptToSelf->Caption = GetMessage(FORM_CONFIG_CHECK_ENCRYPTSELF);
  chbCacheKeys->Caption     = GetMessage(FORM_CONFIG_CHECK_CACHE);
  chbParentIds->Caption     = GetMessage(FORM_CONFIG_CHECK_PARENTID);
  chbNotify->Caption        = GetMessage(FORM_CONFIG_CHECK_RELEASE);
  rgOverwrite->Items->Strings[0] = GetMessage(FORM_CONFIG_RADIO_ASK);
  rgOverwrite->Items->Strings[1] = GetMessage(FORM_CONFIG_RADIO_ALWAYS);
  rgOverwrite->Items->Strings[2] = GetMessage(FORM_CONFIG_RADIO_NEVER);

  sGPGProgram = GPGeeConfig->Values["GPG Program"];
  if (!sGPGProgram.IsEmpty())
    MinimizeName(sGPGProgram, edtGPGProgram);
  chbGPGProgram->Checked = !sGPGProgram.IsEmpty() && FileExists(sGPGProgram);

  sOptfile = GPGeeConfig->Values["Options File"];
  if (!sOptfile.IsEmpty())
    MinimizeName(sOptfile, edtOptfile);
  chbOptfile->Checked = !sOptfile.IsEmpty() && FileExists(sOptfile);

  sKeyring = GPGeeConfig->Values["Keyring"];
  if (!sKeyring.IsEmpty())
    MinimizeName(sKeyring, edtKeyring);
  chbKeyring->Checked = !sKeyring.IsEmpty() && FileExists(sKeyring);

  sSecretKeyring = GPGeeConfig->Values["Secret Keyring"];
  if (!sSecretKeyring.IsEmpty())
    MinimizeName(sSecretKeyring, edtSecretKeyring);
  chbSecretKeyring->Checked = !sSecretKeyring.IsEmpty() && FileExists(sSecretKeyring);

  chbForceTrust->Checked = GPGeeConfig->Values["Force Trust"];
  chbEncryptToSelf->Checked = GPGeeConfig->Values["Encrypt to Self"];
  chbNotify->Checked = GPGeeConfig->Values["Update Notify"];

  OverwriteSetting = GPGeeConfig->Values["File Overwrite"];
  if (OverwriteSetting.AnsiCompareIC("ask") == 0)
    rgOverwrite->ItemIndex = 0;
  else if (OverwriteSetting.AnsiCompareIC("always") == 0)
    rgOverwrite->ItemIndex = 1;
  else
    rgOverwrite->ItemIndex = 2;

  chbCacheKeys->Checked = GPGeeConfig->Values["Cache Keys"];

  chbParentIds->Checked = GPGeeConfig->Values["Parent IDs"];

  SanityCheck();

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::FormFirstActivation(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// btnGPGProgram OnClick handler - get the location of the GPG binary
//
void __fastcall TformGPGeeConfigure::btnGPGProgramClick(TObject *Sender)
{
  __ENTERFUNCTION__;

  OpenDialog->Title = "Select location of gpg executable...";
  OpenDialog->DefaultExt = "exe";
  OpenDialog->Filter = "GnuPG executable (gpg.exe)|gpg.exe|All files (*.*)|*.*";
  OpenDialog->InitialDir = "";

  if (!sGPGProgram.IsEmpty() && FileExists(sGPGProgram))
    OpenDialog->FileName = sGPGProgram;
  else
    OpenDialog->FileName = GPGeeConfig->Values["GPGProgram"];

  if (OpenDialog->FileName.IsEmpty())
    OpenDialog->InitialDir = GPGeeConfig->Values["ProgramFilesDir"];
  if (OpenDialog->Execute()) {
    sGPGProgram = OpenDialog->FileName;
    MinimizeName(sGPGProgram, edtGPGProgram);
  }  // if (OpenDialog->Execute())
  SanityCheck();

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnGPGProgramClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// chbGPGProgram OnClick event handler.  If the user clicks to enable setting
// the program path then do the right thing
//
void __fastcall TformGPGeeConfigure::chbGPGProgramClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  if (chbGPGProgram->Checked && (sGPGProgram.IsEmpty() || !FileExists(sGPGProgram)))
    btnGPGProgramClick(Sender);
  else
    SanityCheck();
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::chbGPGProgramClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// btnOptfile OnClick handler - get the location of the GPG options file
//
void __fastcall TformGPGeeConfigure::btnOptfileClick(TObject *Sender)
{
  __ENTERFUNCTION__;

  OpenDialog->Title = "Select location of gpg options file...";
  OpenDialog->DefaultExt = "conf";
  OpenDialog->Filter = "GnuPG configuration file (gpg.conf)|gpg.conf|Conf files (*.conf)|*.conf|All files (*.*)|*.*";
  OpenDialog->InitialDir = "";
  OpenDialog->FileName = "";

  if (!sOptfile.IsEmpty() && FileExists(sOptfile))
    OpenDialog->FileName = sOptfile;
  else if (chbGPGProgram->Checked)
    OpenDialog->InitialDir = ExtractFileDir(sGPGProgram);
  else
    OpenDialog->FileName = GPGeeConfig->Values["OptFile"];
  if (OpenDialog->FileName.IsEmpty() && OpenDialog->InitialDir.IsEmpty())
    OpenDialog->InitialDir = GPGeeConfig->Values["HomeDir"];
  if (OpenDialog->InitialDir.IsEmpty())
    OpenDialog->InitialDir = ExtractFileDir(GPGeeConfig->Values["gpgProgram"]);

  if (OpenDialog->Execute()) {
    sOptfile = OpenDialog->FileName;
    MinimizeName(sOptfile, edtOptfile);
  }  // if (OpenDialog->Execute())
  SanityCheck();

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnOptfileClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// chbOptfile OnClick event handler
//
void __fastcall TformGPGeeConfigure::chbOptfileClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  if (chbOptfile->Checked && (sOptfile.IsEmpty() || !FileExists(sOptfile)))
    btnOptfileClick(Sender);
  else
    SanityCheck();
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::chbOptfileClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// btnKeyring OnClick handler - get the location of the public key keyring
//
void __fastcall TformGPGeeConfigure::btnKeyringClick(TObject *Sender)
{
  __ENTERFUNCTION__;

  OpenDialog->Title = "Select location of gpg public-key keyring...";
  OpenDialog->DefaultExt = "gpg";
  OpenDialog->Filter = "GnuPG public keyring (pubring.gpg)|pubring.gpg|GnuPG files (*.gpg)|*.gpg|All files (*.*)|*.*";
  OpenDialog->FileName = "";
  OpenDialog->InitialDir = "";

  if (!sKeyring.IsEmpty() && FileExists(sKeyring))
    OpenDialog->FileName = sKeyring;
  else
    OpenDialog->InitialDir = GPGeeConfig->Values["HomeDir"];

  if (OpenDialog->Execute()) {
    sKeyring = OpenDialog->FileName;
    MinimizeName(sKeyring, edtKeyring);
  }  // if (OpenDialog->Execute())
  SanityCheck();

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnKeyringClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// chbKeyring OnClick event handler
//
void __fastcall TformGPGeeConfigure::chbKeyringClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  if (chbKeyring->Checked && (sKeyring.IsEmpty() || !FileExists(sKeyring)))
    btnKeyringClick(Sender);
  else
    SanityCheck();
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::chbKeyringClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// btnSecretKeyring OnClick handler - get the location of the secret key
// keyring
//
void __fastcall TformGPGeeConfigure::btnSecretKeyringClick(TObject *Sender)
{
  __ENTERFUNCTION__;

  OpenDialog->Title = "Select location of gpg secret-key keyring...";
  OpenDialog->DefaultExt = "gpg";
  OpenDialog->Filter = "GnuPG secret keyring (secring.gpg)|secring.gpg|GnuPG files (*.gpg)|*.gpg|All files (*.*)|*.*";
  OpenDialog->FileName = "";
  OpenDialog->InitialDir = "";

  if (!sSecretKeyring.IsEmpty() && FileExists(sSecretKeyring))
    OpenDialog->FileName = sSecretKeyring;
  else
    OpenDialog->InitialDir = GPGeeConfig->Values["HomeDir"];

  if (OpenDialog->Execute()) {
    sSecretKeyring = OpenDialog->FileName;
    MinimizeName(sSecretKeyring, edtSecretKeyring);
  }  // if (OpenDialog->Execute())
  SanityCheck();

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnSecretKeyringClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// chbSecretKeyring OnClick event handler
//
void __fastcall TformGPGeeConfigure::chbSecretKeyringClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  if (chbSecretKeyring->Checked && (sSecretKeyring.IsEmpty() || !FileExists(sSecretKeyring)))
    btnSecretKeyringClick(Sender);
  else
    SanityCheck();
  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnSecretKeyringClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// Check to see if the settings on the form make sense and attempt to
// intelligently adjust any that don't
//
void __fastcall TformGPGeeConfigure::SanityCheck(void)
{
  __ENTERFUNCTION__;

  chbGPGProgram->Checked = chbGPGProgram->Checked && !sGPGProgram.IsEmpty() && FileExists(sGPGProgram);
  chbOptfile->Checked = chbOptfile->Checked && !sOptfile.IsEmpty() && FileExists(sOptfile);
  chbKeyring->Checked = chbKeyring->Checked && !sKeyring.IsEmpty() && FileExists(sKeyring);
  chbSecretKeyring->Checked = chbSecretKeyring->Checked && !sSecretKeyring.IsEmpty() && FileExists(sSecretKeyring);
  edtGPGProgram->Enabled = chbGPGProgram->Checked;
  btnGPGProgram->Enabled = chbGPGProgram->Checked;
  edtOptfile->Enabled = chbOptfile->Checked;
  btnOptfile->Enabled = chbOptfile->Checked;
  edtKeyring->Enabled = chbKeyring->Checked;
  btnKeyring->Enabled = chbKeyring->Checked;
  edtSecretKeyring->Enabled = chbSecretKeyring->Checked;
  btnSecretKeyring->Enabled = chbSecretKeyring->Checked;
  chbCacheKeys->Enabled = chbKeyring->Checked && chbSecretKeyring->Checked;

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::SanityCheck(void)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// The user has done the deed and clicked ok...
//
void __fastcall TformGPGeeConfigure::btnOkClick(TObject *Sender)
{
  __ENTERFUNCTION__;

  if (chbGPGProgram->Checked)
    GPGeeConfig->Values["GPG Program"] = sGPGProgram;
  else
    GPGeeConfig->Values["GPG Program"] = "";
  if (chbOptfile->Checked)
    GPGeeConfig->Values["Options File"] = sOptfile;
  else
    GPGeeConfig->Values["Options File"] = "";
  if (chbKeyring->Checked)
    GPGeeConfig->Values["Keyring"] = sKeyring;
  else
    GPGeeConfig->Values["Keyring"] = "";
  if (chbSecretKeyring->Checked)
    GPGeeConfig->Values["Secret Keyring"] = sSecretKeyring;
  else
    GPGeeConfig->Values["Secret Keyring"] = "";
  GPGeeConfig->Values["Force Trust"] = chbForceTrust->Checked;
  GPGeeConfig->Values["Encrypt to Self"] = chbEncryptToSelf->Checked;
  switch (rgOverwrite->ItemIndex) {
    case 0: GPGeeConfig->Values["File Overwrite"] = "Ask"; break;
    case 1: GPGeeConfig->Values["File Overwrite"] = "Always"; break;
    case 2: GPGeeConfig->Values["File Overwrite"] = "Never"; break;
  }  // switch (rgOverwrite->ItemIndex)
  GPGeeConfig->Values["Cache Keys"]    = chbCacheKeys->Enabled && chbCacheKeys->Checked;
  GPGeeConfig->Values["Parent IDs"]    = chbParentIds->Checked;
  GPGeeConfig->Values["Update Notify"] = chbNotify->Checked;
  ModalResult = mrOk;

  __RETURNFUNCTION__;
}  // void __fastcall TformGPGeeConfigure::btnOkClick(TObject *Sender)
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// User clicked on the "Help" button
//
void __fastcall TformGPGeeConfigure::btnHelpClick(TObject *Sender)
{
  __ENTERFUNCTION__;
  Application->HelpContext(4);
  __RETURNFUNCTION__;
}
//---------------------------------------------------------------------------

