/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.cipher;

import gnu.crypto.cipher.Khazad;
import gnu.testlet.TestHarness;
import gnu.testlet.gnu.crypto.cipher.BaseCipherTestCase;
import java.util.HashMap;

public class TestOfKhazad
extends BaseCipherTestCase {
    private static final String[] vk_128 = new String[]{"49A4CE32AC190E3F", "BD2226C1128B4AD1", "A3C8D3CAB9D196BC", "2C8146E405C2EA36", "9EC02CFC7065D8F8"};
    private static final String[] vt_128 = new String[]{"9E399864F78ECA02", "3EABB25778098FF7", "A359C027CB02BC47", "36E62B8D8DDF2929", "CB4204ACEDDFE80E"};
    private static final String[] mct_ecb_e_128 = new String[]{"1C8ABEB5F5D8337C", "D29DDD7B07AA2E2E", "2DCA0196F9AF94DA", "100AFC93082BC492", "7C4EB4E12D5310BA"};
    private static final String[] mct_ecb_d_128 = new String[]{"0EF3A83A8A874A5A", "BB83871935B33F01", "ED25D06041BB09CF", "A4091D256FFAC8B6", "DAC274A3D13600F8"};
    private static final String[] mct_cbc_e_128 = new String[]{"AB983C213749B3CA", "9B0C44EF8B2EA836", "748AFB0A891F1556", "C7012DE469A78E5D", "DB95DB1BD214C348"};
    private static final String[] mct_cbc_d_128 = new String[]{"DE93205588933B11", "8651C2BC76A096F6", "4C9494F2BA8C55CF", "44EE0CB0AA12B9EC", "6D759B4000216139"};

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfKhazad");
        this.cipher = new Khazad();
        HashMap<String, Object> attrib = new HashMap<String, Object>();
        attrib.put("gnu.crypto.cipher.block.size", new Integer(8));
        attrib.put("gnu.crypto.cipher.key.material", new byte[16]);
        try {
            this.cipher.init(attrib);
            String algorithm = this.cipher.name();
            harness.check(this.validityTest(), "validityTest(" + algorithm + ")");
            harness.check(this.cloneabilityTest(), "cloneabilityTest(" + algorithm + ")");
            harness.check(this.katVK(vk_128, this.cipher, 16), "KAT VK " + algorithm + "-128");
            harness.check(this.katVT(vt_128, this.cipher, 16), "KAT VT " + algorithm + "-128");
            harness.check(this.mctEncryptECB(mct_ecb_e_128, this.cipher, 16), "MCT ECB Encryption " + algorithm + "-128");
            harness.check(this.mctDecryptECB(mct_ecb_d_128, this.cipher, 16), "MCT ECB Decryption " + algorithm + "-128");
            harness.check(this.mctEncryptCBC(mct_cbc_e_128, this.cipher, 16), "MCT CBC Encryption " + algorithm + "-128");
            harness.check(this.mctDecryptCBC(mct_cbc_d_128, this.cipher, 16), "MCT CBC Decryption " + algorithm + "-128");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfKhazad");
        }
    }
}

