/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig;

import gnu.crypto.Registry;
import gnu.crypto.sig.BaseSignature;
import gnu.crypto.sig.ISignature;
import gnu.crypto.sig.dss.DSSSignature;
import gnu.crypto.sig.rsa.RSAPSSSignature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SignatureFactory
implements Registry {
    private SignatureFactory() {
    }

    public static ISignature getInstance(String scheme) {
        if (scheme == null) {
            return null;
        }
        scheme = scheme.trim();
        BaseSignature result = null;
        if (scheme.equalsIgnoreCase("dsa") || scheme.equals("dss")) {
            result = new DSSSignature();
        } else if (scheme.equalsIgnoreCase("rsa-pss")) {
            result = new RSAPSSSignature();
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("dss");
        hs.add("rsa-pss");
        return Collections.unmodifiableSet(hs);
    }
}

