/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.mac;

import gnu.crypto.mac.IMac;
import gnu.crypto.mac.TMMH16;
import gnu.crypto.prng.BasePRNG;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import gnu.crypto.util.Util;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.HashMap;
import java.util.Map;

public class TestOfTMMH16
implements Testlet {
    private IRandom keystream;
    private byte[] output;
    private byte[] message;
    private byte[] result;
    private IMac mac;
    private HashMap attributes = new HashMap();

    public void test(TestHarness harness) {
        harness.checkPoint("TestOfTMMH16");
        try {
            this.attributes.clear();
            this.keystream = new DummyKeystream();
            this.keystream.init(null);
            this.output = new byte[]{-99, 106};
            this.mac = new TMMH16();
            this.attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
            this.attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(2));
            this.mac.init((Map)this.attributes);
            this.message = new byte[]{-54, -2, -70, -66, -70, -34};
            int i = 0;
            while (i < this.message.length) {
                this.mac.update(this.message[i]);
                ++i;
            }
            this.result = this.mac.digest();
            harness.check(Util.areEqual((byte[])this.result, (byte[])this.output), "testVector1");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfTMMH16.testVector1");
        }
        try {
            this.attributes.clear();
            this.keystream = new DummyKeystream();
            this.keystream.init(null);
            this.output = new byte[]{-56, -114};
            this.mac = new TMMH16();
            this.attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
            this.attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(2));
            this.mac.init((Map)this.attributes);
            this.message = new byte[]{-54, -2, -70};
            int i = 0;
            while (i < this.message.length) {
                this.mac.update(this.message[i]);
                ++i;
            }
            this.result = this.mac.digest();
            harness.check(Util.areEqual((byte[])this.result, (byte[])this.output), "testVector2");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfTMMH16.testVector2");
        }
        try {
            this.attributes.clear();
            this.keystream = new DummyKeystream();
            this.keystream.init(null);
            this.output = new byte[]{-99, 106, -64, -45};
            this.mac = new TMMH16();
            this.attributes.put("gnu.crypto.mac.tmmh.keystream", this.keystream);
            this.attributes.put("gnu.crypto.mac.tmmh.tag.length", new Integer(4));
            this.mac.init((Map)this.attributes);
            this.message = new byte[]{-54, -2, -70, -66, -70, -34};
            int i = 0;
            while (i < this.message.length) {
                this.mac.update(this.message[i]);
                ++i;
            }
            this.result = this.mac.digest();
            harness.check(Util.areEqual((byte[])this.result, (byte[])this.output), "testVector3");
        }
        catch (Exception x) {
            harness.debug(x);
            harness.fail("TestOfTMMH16.testVector3");
        }
    }

    class DummyKeystream
    extends BasePRNG {
        DummyKeystream() {
            super("???");
        }

        public Object clone() {
            return null;
        }

        public void setup(Map attributes) {
        }

        public void fillBlock() throws LimitReachedException {
            this.buffer = new byte[]{1, 35, 69, 103, -119, -85, -51, -17, -2, -36};
        }
    }
}

