/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.cipher;

import gnu.crypto.cipher.IBlockCipher;
import gnu.crypto.cipher.IBlockCipherSpi;
import gnu.crypto.util.Util;
import java.security.InvalidKeyException;
import java.util.Iterator;
import java.util.Map;

public abstract class BaseCipher
implements IBlockCipher,
IBlockCipherSpi {
    protected String name;
    protected int defaultBlockSize;
    protected int defaultKeySize;
    protected int currentBlockSize;
    protected transient Object currentKey;
    protected Object lock = new Object();

    protected BaseCipher(String name, int defaultBlockSize, int defaultKeySize) {
        this.name = name;
        this.defaultBlockSize = defaultBlockSize;
        this.defaultKeySize = defaultKeySize;
    }

    public abstract Object clone();

    public String name() {
        StringBuffer sb = new StringBuffer(this.name).append('-');
        if (this.currentKey == null) {
            sb.append(String.valueOf(8 * this.defaultBlockSize));
        } else {
            sb.append(String.valueOf(8 * this.currentBlockSize));
        }
        return sb.toString();
    }

    public int defaultBlockSize() {
        return this.defaultBlockSize;
    }

    public int defaultKeySize() {
        return this.defaultKeySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Map attributes) throws InvalidKeyException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey != null) {
                throw new IllegalStateException();
            }
            Integer bs = (Integer)attributes.get("gnu.crypto.cipher.block.size");
            if (bs == null) {
                if (this.currentBlockSize == 0) {
                    this.currentBlockSize = this.defaultBlockSize;
                }
            } else {
                this.currentBlockSize = bs;
                boolean ok = false;
                Iterator it = this.blockSizes();
                while (it.hasNext()) {
                    boolean bl = ok = this.currentBlockSize == (Integer)it.next();
                    if (ok) break;
                }
                if (!ok) {
                    throw new IllegalArgumentException("gnu.crypto.cipher.block.size");
                }
            }
            byte[] k = (byte[])attributes.get("gnu.crypto.cipher.key.material");
            this.currentKey = this.makeKey(k, this.currentBlockSize);
        }
    }

    public int currentBlockSize() {
        if (this.currentKey == null) {
            throw new IllegalStateException();
        }
        return this.currentBlockSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            this.currentKey = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encryptBlock(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            this.encrypt(in, inOffset, out, outOffset, this.currentKey, this.currentBlockSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decryptBlock(byte[] in, int inOffset, byte[] out, int outOffset) throws IllegalStateException {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentKey == null) {
                throw new IllegalStateException();
            }
            this.decrypt(in, inOffset, out, outOffset, this.currentKey, this.currentBlockSize);
        }
    }

    public boolean selfTest() {
        Iterator kit = this.keySizes();
        while (kit.hasNext()) {
            int ks = (Integer)kit.next();
            Iterator bit = this.blockSizes();
            while (bit.hasNext()) {
                if (this.testSymmetry(ks, (Integer)bit.next())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean testSymmetry(int ks, int bs) {
        try {
            byte[] kb = new byte[ks];
            byte[] pt = new byte[bs];
            byte[] ct = new byte[bs];
            byte[] cpt = new byte[bs];
            int i = 0;
            while (i < ks) {
                kb[i] = (byte)i;
                ++i;
            }
            i = 0;
            while (i < bs) {
                pt[i] = (byte)i;
                ++i;
            }
            Object k = this.makeKey(kb, bs);
            this.encrypt(pt, 0, ct, 0, k, bs);
            this.decrypt(ct, 0, cpt, 0, k, bs);
            return Util.areEqual(pt, cpt);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }

    protected boolean testKat(byte[] kb, byte[] ct) {
        try {
            int bs = ct.length;
            byte[] pt = new byte[bs];
            byte[] t = new byte[bs];
            Object k = this.makeKey(kb, bs);
            this.encrypt(pt, 0, t, 0, k, bs);
            if (!Util.areEqual(t, ct)) {
                return false;
            }
            this.decrypt(t, 0, t, 0, k, bs);
            return Util.areEqual(t, pt);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }
}

