<?php
/********************************************************************
Product		: GNU Taler Gateway for Payage
Date		: 26 Feburary 2023
Copyright	: Tim Leibacher
Contact		: https://www.tim-leibacher.ch/contact
Licence		: GNU General Public License
*********************************************************************/
defined('_JEXEC') or die('Restricted Access');

class Payage_Taler_LeibacherInstallerScript
{
public function preflight($type, $parent)
{
	$app = JFactory::getApplication();
    $payage_xml_file = JPATH_ADMINISTRATOR.'/components/com_payage/payage.xml';
    if (!file_exists($payage_xml_file))
		{
        $app->enqueueMessage("Please install Payage before installing gateway addons", 'error');
		return false;
		}

	$xml_array = JInstaller::parseXMLInstallFile($payage_xml_file);
	$payage_version = $xml_array['version'];
	if (version_compare($payage_version,"2.28","<"))
		{
        $app->enqueueMessage("This Payage addon requires at least Payage 2.28. Please install the latest version of Payage first.", 'error');
		return false;
		}

// get the previously installed version, if any

	if (file_exists(JPATH_ADMINISTRATOR.'/components/com_payage/payage_taler_leibacher.xml'))
		{
		$xml_array = JInstaller::parseXMLInstallFile(JPATH_ADMINISTRATOR.'/components/com_payage/payage_taler_leibacher.xml');
		$this->previous_version = $xml_array['version'];
		}

    return true;
}

//-------------------------------------------------------------------------------
// Called at uninstall time
//
public function uninstall($parent)
{
    $app = JFactory::getApplication();
    $app->enqueueMessage("Taler gateway for Payage has been uninstalled.");
}

//-------------------------------------------------------------------------------
// The main install function
//
public function postflight($type, $parent)
{
    $this->app = JFactory::getApplication();
	  $this_version = $parent->getManifest()->version;
    $this->app->enqueueMessage("Payage Taler version $this_version installed.", 'message');
	return true;
}

}
