/*
 * Decompiled with CFR 0.152.
 */
package gnu.math;

import gnu.math.Complex;
import gnu.math.DFloNum;
import gnu.math.Dimensions;
import gnu.math.Numeric;
import gnu.math.RealNum;
import gnu.math.Unit;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DComplex
extends Complex
implements Externalizable {
    double real;
    double imag;

    public DComplex() {
    }

    public DComplex(double d, double d2) {
        this.real = d;
        this.imag = d2;
    }

    public RealNum re() {
        return new DFloNum(this.real);
    }

    public double doubleValue() {
        return this.real;
    }

    public RealNum im() {
        return new DFloNum(this.imag);
    }

    public double doubleImagValue() {
        return this.imag;
    }

    public boolean equals(Object object2) {
        if (object2 == null || !(object2 instanceof Complex)) {
            return false;
        }
        Complex complex = (Complex)object2;
        return complex.unit() == Unit.Empty && Double.doubleToLongBits(this.real) == Double.doubleToLongBits(complex.reValue()) && Double.doubleToLongBits(this.imag) == Double.doubleToLongBits(complex.imValue());
    }

    public String toString() {
        String string;
        String string2;
        String string3 = "";
        if (this.real == Double.POSITIVE_INFINITY) {
            string3 = "#i";
            string2 = "1/0";
        } else if (this.real == Double.NEGATIVE_INFINITY) {
            string3 = "#i";
            string2 = "-1/0";
        } else if (Double.isNaN(this.real)) {
            string3 = "#i";
            string2 = "0/0";
        } else {
            string2 = Double.toString(this.real);
        }
        if (Double.doubleToLongBits(this.imag) == 0L) {
            return string3 + string2;
        }
        if (this.imag == Double.POSITIVE_INFINITY) {
            string3 = "#i";
            string = "+1/0i";
        } else if (this.imag == Double.NEGATIVE_INFINITY) {
            string3 = "#i";
            string = "-1/0i";
        } else if (Double.isNaN(this.imag)) {
            string3 = "#i";
            string = "+0/0i";
        } else {
            string = Double.toString(this.imag) + "i";
            if (string.charAt(0) != '-') {
                string = "+" + string;
            }
        }
        return (Double.doubleToLongBits(this.real) == 0L ? string3 : string3 + string2) + string;
    }

    public String toString(int n) {
        if (n == 10) {
            return this.toString();
        }
        return "#d" + this.toString();
    }

    public final Numeric neg() {
        return new DComplex(-this.real, -this.imag);
    }

    public Numeric add(Object object2, int n) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            if (complex.dimensions() != Dimensions.Empty) {
                throw new ArithmeticException("units mis-match");
            }
            return new DComplex(this.real + (double)n * complex.reValue(), this.imag + (double)n * complex.imValue());
        }
        return ((Numeric)object2).addReversed(this, n);
    }

    public Numeric mul(Object object2) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            if (complex.unit() == Unit.Empty) {
                double d = complex.reValue();
                double d2 = complex.imValue();
                return new DComplex(this.real * d - this.imag * d2, this.real * d2 + this.imag * d);
            }
            return Complex.times(this, complex);
        }
        return ((Numeric)object2).mulReversed(this);
    }

    public Numeric div(Object object2) {
        if (object2 instanceof Complex) {
            Complex complex = (Complex)object2;
            return DComplex.div(this.real, this.imag, complex.doubleValue(), complex.doubleImagValue());
        }
        return ((Numeric)object2).divReversed(this);
    }

    public static DComplex power(double d, double d2, double d3, double d4) {
        double d5 = Math.hypot(d, d2);
        double d6 = Math.log(d5);
        double d7 = Math.atan2(d2, d);
        double d8 = Math.exp(d6 * d3 - d4 * d7);
        d7 = d4 * d6 + d3 * d7;
        return Complex.polar(d8, d7);
    }

    public static Complex log(double d, double d2) {
        double d3 = Math.hypot(d, d2);
        return DComplex.make(Math.log(d3), Math.atan2(d2, d));
    }

    public static DComplex div(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9 = Math.abs(d3);
        if (d9 <= (d8 = Math.abs(d4))) {
            double d10 = d3 / d4;
            d7 = d4 * (1.0 + d10 * d10);
            d6 = d * d10 + d2;
            d5 = d2 * d10 - d;
        } else {
            double d11 = d4 / d3;
            d7 = d3 * (1.0 + d11 * d11);
            d6 = d + d2 * d11;
            d5 = d2 - d * d11;
        }
        return new DComplex(d6 / d7, d5 / d7);
    }

    public static Complex sqrt(double d, double d2) {
        double d3;
        double d4;
        double d5 = Math.hypot(d, d2);
        if (d5 == 0.0) {
            d3 = d4 = d5;
        } else if (d > 0.0) {
            d3 = Math.sqrt(0.5 * (d5 + d));
            d4 = d2 / d3 / 2.0;
        } else {
            d4 = Math.sqrt(0.5 * (d5 - d));
            if (d2 < 0.0) {
                d4 = -d4;
            }
            d3 = d2 / d4 / 2.0;
        }
        return new DComplex(d3, d4);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.real);
        objectOutput.writeDouble(this.imag);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.real = objectInput.readDouble();
        this.imag = objectInput.readDouble();
    }
}

