/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.KAttr;
import gnu.kawa.xml.KCDATASection;
import gnu.kawa.xml.KComment;
import gnu.kawa.xml.KDocument;
import gnu.kawa.xml.KElement;
import gnu.kawa.xml.KProcessingInstruction;
import gnu.kawa.xml.KText;
import gnu.kawa.xml.Nodes;
import gnu.kawa.xml.SortedNodes;
import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.TreePosition;
import gnu.mapping.CharArrayOutPort;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import gnu.text.Path;
import gnu.xml.NodeTree;
import gnu.xml.XMLPrinter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class KNode
extends SeqPosition
implements Node,
Consumable {
    public KNode(NodeTree nodeTree, int n) {
        super(nodeTree, n);
    }

    public static Object atomicValue(Object object2) {
        if (object2 instanceof KNode) {
            KNode kNode = (KNode)object2;
            return ((NodeTree)kNode.sequence).typedValue(kNode.ipos);
        }
        return object2;
    }

    public static KNode coerce(Object object2) {
        if (object2 instanceof KNode) {
            return (KNode)object2;
        }
        if (object2 instanceof NodeTree) {
            NodeTree nodeTree = (NodeTree)object2;
            return KNode.make(nodeTree, nodeTree.startPos());
        }
        if (object2 instanceof SeqPosition && !(object2 instanceof TreePosition)) {
            SeqPosition seqPosition = (SeqPosition)object2;
            if (seqPosition.sequence instanceof NodeTree) {
                return KNode.make((NodeTree)seqPosition.sequence, seqPosition.ipos);
            }
        }
        return null;
    }

    public static KNode make(NodeTree nodeTree, int n) {
        int n2 = nodeTree.posToDataIndex(n);
        while (n2 < nodeTree.data.length && nodeTree.data[n2] == '\uf112') {
            if ((n2 += 5) == nodeTree.gapStart) {
                n2 = nodeTree.gapEnd;
            }
            n = n2 << 1;
        }
        int n3 = nodeTree.getNextKindI(nodeTree.posToDataIndex(n));
        switch (n3) {
            case 33: {
                return new KElement(nodeTree, n);
            }
            case 35: {
                return new KAttr(nodeTree, n);
            }
            case 34: {
                return new KDocument(nodeTree, n);
            }
            case 31: {
                return new KCDATASection(nodeTree, n);
            }
            case 36: {
                return new KComment(nodeTree, n);
            }
            case 37: {
                return new KProcessingInstruction(nodeTree, n);
            }
            case 0: {
                if (nodeTree.isEmpty()) break;
                return null;
            }
        }
        return new KText(nodeTree, n);
    }

    public KNode copy() {
        return KNode.make((NodeTree)this.sequence, this.sequence.copyPos(this.getPos()));
    }

    public static KNode make(NodeTree nodeTree) {
        return KNode.make(nodeTree, 0);
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public abstract short getNodeType();

    public String getNodeName() {
        return this.sequence.getNextTypeName(this.ipos);
    }

    public Symbol getNodeSymbol() {
        Object object2 = ((NodeTree)this.sequence).getNextTypeObject(this.ipos);
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof Symbol) {
            return (Symbol)object2;
        }
        return Namespace.EmptyNamespace.getSymbol(object2.toString().intern());
    }

    public Object getNodeNameObject() {
        return ((NodeTree)this.sequence).getNextTypeObject(this.ipos);
    }

    public String getNamespaceURI() {
        return ((NodeTree)this.sequence).posNamespaceURI(this.ipos);
    }

    public String getPrefix() {
        return ((NodeTree)this.sequence).posPrefix(this.ipos);
    }

    public String getLocalName() {
        return ((NodeTree)this.sequence).posLocalName(this.ipos);
    }

    public static String getNodeValue(NodeTree nodeTree, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        KNode.getNodeValue(nodeTree, n, stringBuffer);
        return stringBuffer.toString();
    }

    public static void getNodeValue(NodeTree nodeTree, int n, StringBuffer stringBuffer) {
        nodeTree.stringValue(nodeTree.posToDataIndex(n), stringBuffer);
    }

    public String getNodeValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getNodeValue(stringBuffer);
        return stringBuffer.toString();
    }

    public void getNodeValue(StringBuffer stringBuffer) {
        KNode.getNodeValue((NodeTree)this.sequence, this.ipos, stringBuffer);
    }

    public boolean hasChildNodes() {
        return ((NodeTree)this.sequence).posFirstChild(this.ipos) >= 0;
    }

    public String getTextContent() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getTextContent(stringBuffer);
        return stringBuffer.toString();
    }

    protected void getTextContent(StringBuffer stringBuffer) {
        this.getNodeValue(stringBuffer);
    }

    public Node getParentNode() {
        int n = this.sequence.parentPos(this.ipos);
        if (n == -1) {
            return null;
        }
        return KNode.make((NodeTree)this.sequence, n);
    }

    public Node getPreviousSibling() {
        int n = this.sequence.parentPos(this.ipos);
        if (n == -1) {
            n = 0;
        }
        int n2 = ((NodeTree)this.sequence).posToDataIndex(this.ipos);
        int n3 = this.sequence.firstChildPos(n);
        int n4 = 0;
        do {
            n4 = n3;
        } while ((n3 = this.sequence.nextPos(n3)) != 0 && ((NodeTree)this.sequence).posToDataIndex(n3) != n2);
        return n4 == 0 ? null : KNode.make((NodeTree)this.sequence, n4);
    }

    public Node getNextSibling() {
        int n = ((NodeTree)this.sequence).nextPos(this.ipos);
        return n == 0 ? null : KNode.make((NodeTree)this.sequence, n);
    }

    public Node getFirstChild() {
        int n = ((NodeTree)this.sequence).posFirstChild(this.ipos);
        return KNode.make((NodeTree)this.sequence, n);
    }

    public Node getLastChild() {
        int n = 0;
        int n2 = this.sequence.firstChildPos(this.ipos);
        while (n2 != 0) {
            n = n2;
            n2 = this.sequence.nextPos(n2);
        }
        return n == 0 ? null : KNode.make((NodeTree)this.sequence, n);
    }

    public NodeList getChildNodes() {
        SortedNodes sortedNodes = new SortedNodes();
        int n = this.sequence.firstChildPos(this.ipos);
        while (n != 0) {
            ((Nodes)sortedNodes).writePosition(this.sequence, n);
            n = this.sequence.nextPos(n);
        }
        return sortedNodes;
    }

    public NodeList getElementsByTagName(String string) {
        throw new UnsupportedOperationException("getElementsByTagName not implemented yet");
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(7, "setNodeValue not supported");
    }

    public void setPrefix(String string) throws DOMException {
        throw new DOMException(7, "setPrefix not supported");
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DOMException(7, "insertBefore not supported");
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DOMException(7, "replaceChild not supported");
    }

    public Node removeChild(Node node) throws DOMException {
        throw new DOMException(7, "removeChild not supported");
    }

    public Node appendChild(Node node) throws DOMException {
        throw new DOMException(7, "appendChild not supported");
    }

    public void setTextContent(String string) throws DOMException {
        throw new DOMException(7, "setTextContent not supported");
    }

    public Node cloneNode(boolean bl) {
        if (!bl) {
            throw new UnsupportedOperationException("shallow cloneNode not implemented");
        }
        NodeTree nodeTree = new NodeTree();
        ((NodeTree)this.sequence).consumeNext(this.ipos, nodeTree);
        return KNode.make(nodeTree);
    }

    public Document getOwnerDocument() {
        int n = this.sequence.getNextKind(this.ipos);
        if (n == 34) {
            return new KDocument((NodeTree)this.sequence, 0);
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        throw new UnsupportedOperationException("getAttributes not implemented yet");
    }

    public void normalize() {
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean isDefaultNamespace(String string) {
        return ((NodeTree)this.sequence).posIsDefaultNamespace(this.ipos, string);
    }

    public String lookupNamespaceURI(String string) {
        return ((NodeTree)this.sequence).posLookupNamespaceURI(this.ipos, string);
    }

    public String lookupPrefix(String string) {
        return ((NodeTree)this.sequence).posLookupPrefix(this.ipos, string);
    }

    public String getBaseURI() {
        Path path = ((NodeTree)this.sequence).baseUriOfPos(this.ipos, true);
        return path == null ? null : path.toString();
    }

    public Path baseURI() {
        return ((NodeTree)this.sequence).baseUriOfPos(this.ipos, true);
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        if (!(node instanceof KNode)) {
            throw new DOMException(9, "other Node is a " + node.getClass().getName());
        }
        KNode kNode = (KNode)node;
        AbstractSequence abstractSequence = kNode.sequence;
        return (short)(this.sequence == abstractSequence ? abstractSequence.compare(this.ipos, kNode.ipos) : this.sequence.stableCompare(abstractSequence));
    }

    public boolean isSameNode(Node node) {
        if (!(node instanceof KNode)) {
            return false;
        }
        KNode kNode = (KNode)node;
        if (this.sequence != kNode.sequence) {
            return false;
        }
        return this.sequence.equals(this.ipos, kNode.ipos);
    }

    public boolean isEqualNode(Node node) {
        throw new UnsupportedOperationException("getAttributesisEqualNode not implemented yet");
    }

    public String toString() {
        CharArrayOutPort charArrayOutPort = new CharArrayOutPort();
        XMLPrinter xMLPrinter = new XMLPrinter(charArrayOutPort);
        ((NodeTree)this.sequence).consumeNext(this.ipos, xMLPrinter);
        xMLPrinter.close();
        charArrayOutPort.close();
        return charArrayOutPort.toString();
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public void consume(Consumer consumer) {
        if (consumer instanceof PositionConsumer) {
            ((PositionConsumer)((Object)consumer)).consume(this);
        } else {
            ((NodeTree)this.sequence).consumeNext(this.ipos, consumer);
        }
    }

    public Object setUserData(String string, Object object2, UserDataHandler userDataHandler) {
        throw new UnsupportedOperationException("setUserData not implemented yet");
    }

    public Object getUserData(String string) {
        return null;
    }
}

