/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.kawa.xml.BinaryObject;

public class HexBinary
extends BinaryObject {
    public HexBinary(byte[] byArray) {
        this.data = byArray;
    }

    static HexBinary valueOf(String string) {
        return new HexBinary(HexBinary.parseHexBinary(string));
    }

    static byte[] parseHexBinary(String string) {
        int n = (string = string.trim()).length();
        if ((n & 1) != 0) {
            throw new IllegalArgumentException("hexBinary string length not a multiple of 2");
        }
        byte[] byArray = new byte[n >>= 1];
        for (int i = 0; i < n; ++i) {
            int n2 = Character.digit(string.charAt(2 * i), 16);
            int n3 = Character.digit(string.charAt(2 * i + 1), 16);
            int n4 = -1;
            if (n2 < 0) {
                n4 = 2 * i;
            } else if (n3 < 0) {
                n4 = 2 * i + 1;
            }
            if (n4 >= 0) {
                throw new IllegalArgumentException("invalid hexBinary character at position " + n4);
            }
            byArray[i] = (byte)(16 * n2 + n3);
        }
        return byArray;
    }

    static char forHexDigit(int n) {
        return n < 10 ? (char)(n + 48) : (char)(n - 10 + 65);
    }

    public StringBuffer toString(StringBuffer stringBuffer) {
        for (byte by : this.data) {
            stringBuffer.append(HexBinary.forHexDigit(by >> 4 & 0xF));
            stringBuffer.append(HexBinary.forHexDigit(by & 0xF));
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toString(new StringBuffer()).toString();
    }
}

