/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.expr.Language;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.WrongType;

public class GenericProc
extends MethodProc {
    protected MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;

    public GenericProc(String string) {
        this.setName(string);
    }

    public GenericProc() {
    }

    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    protected synchronized void add(MethodProc[] methodProcArray) {
        int n = methodProcArray.length;
        if (this.methods == null) {
            this.methods = new MethodProc[n];
        }
        for (int i = 0; i < n; ++i) {
            this.add(methodProcArray[i]);
        }
    }

    public synchronized void add(MethodProc methodProc) {
        MethodProc methodProc2;
        int n;
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (this.count >= this.methods.length) {
            MethodProc[] methodProcArray = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, methodProcArray, 0, this.count);
            this.methods = methodProcArray;
        }
        for (n = 0; n < this.count && (methodProc2 = MethodProc.mostSpecific(methodProc, this.methods[n])) != methodProc; ++n) {
        }
        if (n < this.count) {
            System.arraycopy(this.methods, n, this.methods, n + 1, this.count - n);
        }
        this.methods[n] = methodProc;
        int n2 = methodProc.minArgs();
        if (n2 < this.minArgs || this.count == 0) {
            this.minArgs = n2;
        }
        if ((n2 = methodProc.maxArgs()) == -1 || n2 > this.maxArgs) {
            this.maxArgs = n2;
        }
        ++this.count;
    }

    public Object applyN(Object[] objectArray) throws Throwable {
        if (this.count == 1) {
            return this.methods[0].applyN(objectArray);
        }
        GenericProc.checkArgCount(this, objectArray.length);
        CallContext callContext = CallContext.getInstance();
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.matchN(objectArray, callContext);
            if (n != 0) continue;
            return callContext.runUntilValue();
        }
        throw new WrongType((Procedure)this, -1, null);
    }

    public int isApplicable(Type[] typeArray) {
        int n = -1;
        int n2 = this.count;
        while (--n2 >= 0) {
            MethodProc methodProc = this.methods[n2];
            int n3 = methodProc.isApplicable(typeArray);
            if (n3 == 1) {
                return 1;
            }
            if (n3 != 0) continue;
            n = 0;
        }
        return n;
    }

    public int match0(CallContext callContext) {
        if (this.count == 1) {
            return this.methods[0].match0(callContext);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match0(callContext);
            if (n != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public int match1(Object object2, CallContext callContext) {
        if (this.count == 1) {
            return this.methods[0].match1(object2, callContext);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match1(object2, callContext);
            if (n != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public int match2(Object object2, Object object3, CallContext callContext) {
        if (this.count == 1) {
            return this.methods[0].match2(object2, object3, callContext);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match2(object2, object3, callContext);
            if (n != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public int match3(Object object2, Object object3, Object object4, CallContext callContext) {
        if (this.count == 1) {
            return this.methods[0].match3(object2, object3, object4, callContext);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match3(object2, object3, object4, callContext);
            if (n != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public int match4(Object object2, Object object3, Object object4, Object object5, CallContext callContext) {
        if (this.count == 1) {
            return this.methods[0].match4(object2, object3, object4, object5, callContext);
        }
        for (int i = 0; i < this.count; ++i) {
            MethodProc methodProc = this.methods[i];
            int n = methodProc.match4(object2, object3, object4, object5, callContext);
            if (n != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public int matchN(Object[] objectArray, CallContext callContext) {
        int n;
        int n2;
        if (this.count == 1) {
            return this.methods[0].matchN(objectArray, callContext);
        }
        int n3 = objectArray.length;
        Type[] typeArray = new Type[n3];
        Language language = Language.getDefaultLanguage();
        for (int i = 0; i < n3; ++i) {
            Type type;
            Object object2 = objectArray[i];
            if (object2 == null) {
                type = Type.nullType;
            } else {
                Class<?> clazz = object2.getClass();
                type = language != null ? language.getTypeFor(clazz) : Type.make(clazz);
            }
            typeArray[i] = type;
        }
        int[] nArray = new int[this.count];
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        for (n2 = 0; n2 < this.count; ++n2) {
            n = this.methods[n2].isApplicable(typeArray);
            if (n4 == 0 && n >= 0) {
                n6 = n2;
            }
            if (n > 0) {
                ++n4;
            } else if (n == 0) {
                ++n5;
            }
            nArray[n2] = n;
        }
        if (n4 == 1 || n4 == 0 && n5 == 1) {
            return this.methods[n6].matchN(objectArray, callContext);
        }
        for (n2 = 0; n2 < this.count; ++n2) {
            MethodProc methodProc;
            n = nArray[n2];
            if (n < 0 || n == 0 && n4 > 0 || (n = (methodProc = this.methods[n2]).matchN(objectArray, callContext)) != 0) continue;
            return 0;
        }
        callContext.proc = null;
        return -1;
    }

    public final void setProperties(Object[] objectArray) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object object2 = objectArray[i];
            if (object2 instanceof Keyword) {
                Keyword keyword = (Keyword)object2;
                String string = keyword.getName();
                Object object3 = objectArray[++i];
                if (string == "name") {
                    this.setName(object3.toString());
                    continue;
                }
                if (string == "method") {
                    this.add((MethodProc)object3);
                    continue;
                }
                this.setProperty(keyword.asSymbol(), object3);
                continue;
            }
            this.add((MethodProc)object2);
        }
    }

    public static GenericProc make(Object[] objectArray) {
        GenericProc genericProc = new GenericProc();
        genericProc.setProperties(objectArray);
        return genericProc;
    }
}

