/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.lists.PrintConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.UnescapedData;
import gnu.lists.XConsumer;
import gnu.mapping.OutPort;
import gnu.mapping.ThreadLocation;
import gnu.text.Char;
import gnu.xml.NamespaceBinding;
import gnu.xml.NodeTree;
import gnu.xml.XName;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class XMLPrinter
extends PrintConsumer
implements PositionConsumer,
XConsumer {
    int printIndent = -1;
    boolean printXMLdecl = false;
    boolean inAttribute = false;
    boolean inStartTag = false;
    boolean needXMLdecl = false;
    boolean canonicalize = true;
    boolean htmlCompat = true;
    public boolean escapeText = true;
    boolean isHtml = false;
    boolean undeclareNamespaces = false;
    Object style;
    public static final ThreadLocation doctypeSystem = new ThreadLocation("doctype-system");
    public static final ThreadLocation doctypePublic = new ThreadLocation("doctype-public");
    public static final ThreadLocation indentLoc = new ThreadLocation("xml-indent");
    NamespaceBinding namespaceBindings = NamespaceBinding.predefinedXML;
    NamespaceBinding[] namespaceSaveStack = new NamespaceBinding[20];
    int groupNesting;
    private static final int WORD = -2;
    private static final int ELEMENT_START = -3;
    private static final int ELEMENT_END = -4;
    int prev = 32;
    static final String HtmlEmptyTags = "/area/base/basefont/br/col/frame/hr/img/input/isindex/link/meta/para/";

    public XMLPrinter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XMLPrinter(Consumer consumer, boolean bl) {
        super(consumer, bl);
    }

    public XMLPrinter(PrintConsumer printConsumer, boolean bl) {
        super(printConsumer, bl);
    }

    public XMLPrinter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public XMLPrinter(Consumer consumer) {
        super(consumer, false);
    }

    public XMLPrinter(Writer writer) {
        super(writer);
    }

    public XMLPrinter(PrintConsumer printConsumer) {
        super(printConsumer, false);
    }

    public XMLPrinter(OutputStream outputStream) {
        super(outputStream, false);
    }

    public static XMLPrinter make(Consumer consumer, Object object2) {
        XMLPrinter xMLPrinter = new XMLPrinter(consumer);
        xMLPrinter.setStyle(object2);
        return xMLPrinter;
    }

    public static String toString(Object object2) {
        StringWriter stringWriter = new StringWriter();
        new XMLPrinter(stringWriter).writeObject(object2);
        return stringWriter.toString();
    }

    public void setStyle(Object object2) {
        this.style = object2;
        this.htmlCompat = false;
        if ("html".equals(object2)) {
            this.isHtml = true;
            this.htmlCompat = true;
        }
        if ("xhtml".equals(object2)) {
            this.htmlCompat = true;
        }
        if ("plain".equals(object2)) {
            this.escapeText = false;
        }
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    public void writeChar(int n) {
        this.closeTag();
        if (this.printIndent >= 0 && (n == 32 || n == 9)) {
            ((OutPort)this.out).writeSpaceFill();
            this.prev = 32;
            return;
        }
        if (this.printIndent >= 0 && (n == 13 || n == 10)) {
            if (n != 10 || this.prev != 13) {
                ((OutPort)this.out).writeBreak(82);
            }
            return;
        }
        if (!this.escapeText) {
            super.write((char)n);
            this.prev = n;
        } else {
            this.prev = 59;
            if (!(n != 60 || this.isHtml && this.inAttribute)) {
                super.write("&lt;");
            } else if (n == 62) {
                super.write("&gt;");
            } else if (n == 38) {
                super.write("&amp;");
            } else if (n == 34 && this.inAttribute) {
                super.write("&quot;");
            } else if (n >= 127) {
                super.write("&#" + n + ";");
            } else {
                super.write((char)n);
                this.prev = n;
            }
        }
    }

    private void startWord() {
        this.closeTag();
        if (this.prev == -2) {
            super.write(32);
        }
        this.prev = -2;
    }

    public void writeBoolean(boolean bl) {
        this.startWord();
        super.print(bl);
    }

    private void closeTag() {
        if (this.inStartTag && !this.inAttribute) {
            if (this.printIndent >= 0) {
                ((OutPort)this.out).endLogicalBlock("");
            }
            super.write(62);
            this.inStartTag = false;
            this.prev = -3;
        } else if (this.needXMLdecl) {
            super.write("<?xml version=\"1.0\"?>\n");
            if (this.printIndent >= 0) {
                ((OutPort)this.out).startLogicalBlock("", "", 2);
            }
            this.needXMLdecl = false;
        }
    }

    protected void startNumber() {
        this.startWord();
    }

    public void beginDocument() {
        if (this.printXMLdecl) {
            this.needXMLdecl = true;
        }
        if (this.printIndent >= 0 && !this.needXMLdecl) {
            ((OutPort)this.out).startLogicalBlock("", "", 2);
        }
    }

    public void endDocument() {
        if (this.printIndent >= 0) {
            ((OutPort)this.out).endLogicalBlock("");
        }
    }

    public void beginGroup(String string, Object object2) {
        String string2;
        Object object3;
        NamespaceBinding[] namespaceBindingArray;
        Object object4;
        this.closeTag();
        if (this.groupNesting == 0) {
            if (this.out instanceof OutPort) {
                object4 = indentLoc.get(null);
                NamespaceBinding[] namespaceBindingArray2 = namespaceBindingArray = object4 == null ? null : object4.toString();
                this.printIndent = namespaceBindingArray == null ? -1 : (namespaceBindingArray.equals("pretty") ? 0 : (namespaceBindingArray.equals("always") || namespaceBindingArray.equals("yes") ? 1 : -1));
            } else {
                this.printIndent = -1;
            }
            object4 = doctypeSystem.get(null);
            if (object4 != null && (namespaceBindingArray = object4.toString()).length() > 0) {
                object3 = doctypePublic.get(null);
                super.write("<!DOCTYPE ");
                super.write(string);
                String string3 = string2 = object3 == null ? null : object3.toString();
                if (string2 != null && string2.length() > 0) {
                    super.write(" PUBLIC \"");
                    super.write(string2);
                    super.write("\" \"");
                } else {
                    super.write(" SYSTEM \"");
                }
                super.write((String)namespaceBindingArray);
                super.write("\">");
                if (this.out instanceof OutPort) {
                    ((OutPort)this.out).println();
                }
            }
        }
        if (this.printIndent >= 0) {
            object4 = (OutPort)this.out;
            if (this.prev == -3 || this.prev == -4) {
                ((OutPort)object4).writeBreak(this.printIndent > 0 ? 82 : 78);
            }
            ((OutPort)object4).startLogicalBlock("", "", 2);
        }
        super.write(60);
        super.write(string);
        object4 = null;
        this.namespaceSaveStack[this.groupNesting++] = this.namespaceBindings;
        if (object2 instanceof XName) {
            object4 = ((XName)object2).namespaceNodes;
            namespaceBindingArray = NamespaceBinding.commonAncestor((NamespaceBinding)object4, this.namespaceBindings);
            object3 = object4;
            while (object3 != namespaceBindingArray) {
                String string4 = ((NamespaceBinding)object3).uri;
                string2 = ((NamespaceBinding)object3).prefix;
                if (string4 != this.namespaceBindings.resolve(string2) && string4 != ((NamespaceBinding)object4).resolve(string2, (NamespaceBinding)object3)) {
                    super.write(32);
                    if (string2 == null) {
                        super.write("xmlns");
                    } else {
                        super.write("xmlns:");
                        super.write(string2);
                    }
                    super.write("=\"");
                    this.inAttribute = true;
                    if (string4 != null) {
                        this.writeChars(string4);
                    }
                    this.inAttribute = false;
                    super.write(34);
                }
                object3 = ((NamespaceBinding)object3).next;
            }
            if (this.undeclareNamespaces) {
                object3 = this.namespaceBindings;
                while (object3 != namespaceBindingArray) {
                    string2 = ((NamespaceBinding)object3).prefix;
                    if (((NamespaceBinding)object3).uri != null && ((NamespaceBinding)object4).resolve(string2) == null) {
                        super.write(32);
                        if (string2 == null) {
                            super.write("xmlns");
                        } else {
                            super.write("xmlns:");
                            super.write(string2);
                        }
                        super.write("=\"\"");
                    }
                    object3 = ((NamespaceBinding)object3).next;
                }
            }
            this.namespaceBindings = object4;
        }
        if (this.groupNesting >= this.namespaceSaveStack.length) {
            namespaceBindingArray = new NamespaceBinding[2 * this.groupNesting];
            System.arraycopy(this.namespaceSaveStack, 0, namespaceBindingArray, 0, this.groupNesting);
            this.namespaceSaveStack = namespaceBindingArray;
        }
        this.inStartTag = true;
        if (this.isHtml && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = false;
        }
        if (this.printIndent >= 0) {
            ((OutPort)this.out).startLogicalBlock("", "", 1);
        }
    }

    public static boolean isHtmlEmptyElementTag(String string) {
        int n = HtmlEmptyTags.indexOf(string);
        return n > 0 && HtmlEmptyTags.charAt(n - 1) == '/' && HtmlEmptyTags.charAt(n + string.length()) == '/';
    }

    public void endGroup(String string) {
        OutPort outPort;
        if (this.canonicalize && !this.htmlCompat) {
            this.closeTag();
        }
        if (this.inStartTag) {
            if (this.printIndent >= 0) {
                ((OutPort)this.out).endLogicalBlock("");
            }
            super.write(this.isHtml ? (XMLPrinter.isHtmlEmptyElementTag(string) ? ">" : "></" + string + ">") : (this.htmlCompat ? " />" : "/>"));
            this.inStartTag = false;
        } else {
            if (this.printIndent >= 0) {
                outPort = (OutPort)this.out;
                outPort.setIndentation(0, false);
                if (this.prev == -4) {
                    outPort.writeBreak(this.printIndent > 0 ? 82 : 78);
                }
            }
            super.write("</");
            super.write(string);
            super.write(">");
        }
        if (this.printIndent >= 0) {
            outPort = (OutPort)this.out;
            outPort.endLogicalBlock("");
        }
        this.prev = -4;
        if (this.isHtml && !this.escapeText && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = true;
        }
        this.namespaceBindings = this.namespaceSaveStack[--this.groupNesting];
        this.namespaceSaveStack[this.groupNesting] = null;
    }

    public void beginAttribute(String string, Object object2) {
        if (this.inAttribute) {
            super.write(34);
        }
        this.inAttribute = true;
        super.write(32);
        if (this.printIndent >= 0) {
            ((OutPort)this.out).writeBreakFill();
        }
        super.write(string);
        super.write("=\"");
        this.prev = 32;
    }

    public void endAttribute() {
        super.write(34);
        this.inAttribute = false;
        this.prev = 32;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable && !(object2 instanceof UnescapedData)) {
            ((Consumable)object2).consume(this);
            return;
        }
        if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, this);
            if (seqPosition.sequence instanceof NodeTree) {
                this.prev = 45;
            }
            return;
        }
        this.closeTag();
        if (object2 instanceof UnescapedData) {
            super.write(((UnescapedData)object2).getData());
            this.prev = 45;
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).intValue());
        } else {
            this.startWord();
            this.prev = 32;
            this.writeChars(object2 == null ? "(null)" : object2.toString());
            this.prev = -2;
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        this.closeTag();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
        this.prev = 45;
    }

    public void write(char[] cArray, int n, int n2) {
        this.closeTag();
        if (n2 <= 0) {
            return;
        }
        int n3 = n + n2;
        int n4 = 0;
        while (n < n3) {
            char c;
            if ((c = cArray[n++]) >= '\u007f' || c == '\n' || c == '\r' || c == '<' || c == '>' || c == '&' || c == '\"' && this.inAttribute) {
                if (n4 > 0) {
                    super.write(cArray, n - 1 - n4, n4);
                }
                this.writeChar(c);
                n4 = 0;
                continue;
            }
            ++n4;
        }
        if (n4 > 0) {
            super.write(cArray, n3 - n4, n4);
        }
        this.prev = 45;
    }

    public void writePosition(AbstractSequence abstractSequence, int n) {
        abstractSequence.consumeNext(n, this);
    }

    public void writeBaseUri(Object object2) {
    }

    public void writeComment(char[] cArray, int n, int n2) {
        this.closeTag();
        this.print("<!--");
        super.write(cArray, n, n2);
        this.print("-->");
        this.prev = 62;
    }

    public void writeCDATA(char[] cArray, int n, int n2) {
        this.closeTag();
        this.print("<![CDATA[");
        int n3 = n + n2;
        for (int i = n; i < n3 - 2; ++i) {
            if (cArray[i] != ']' || cArray[i + 1] != ']' || cArray[i + 2] != '>') continue;
            if (i > n) {
                super.write(cArray, n, i - n);
            }
            this.print("]]]><![CDATA[]>");
            n = i + 3;
            n2 = n3 - n;
            i += 2;
        }
        super.write(cArray, n, n2);
        this.print("]]>");
        this.prev = 62;
    }

    public void writeProcessingInstruction(String string, char[] cArray, int n, int n2) {
        if ("xml".equals(string)) {
            this.needXMLdecl = false;
        }
        this.closeTag();
        this.print("<?");
        this.print(string);
        this.print(' ');
        this.write(cArray, n, n2);
        this.print("?>");
        this.prev = 62;
    }

    public void consume(SeqPosition seqPosition) {
        throw new Error("not implemented consume(TreePosition)");
    }
}

