.TH KAWA 1
.\" NAME should be all caps, SECTION should be 1-8, maybe w/ subsection
.\" other parms are allowed: see man(7), man(1)
.SH NAME
kawa \- implementation of Scheme language on JVM
.SH SYNOPSIS
.B kawa
.I "[options]"
.br
.B java kawa.repl
.I "[options]"
.SH "DESCRIPTION"
This manual page documents briefly the
.BR kawa
package, a Scheme dialect written completely in the Java language.
Scheme procedures are compiled into Java bytecodes for efficiency.

Scheme is a high-level non-pure functional language in the Lisp family,
with lexical scoping dynamically-types.
The Kawa dialect of Scheme contains hooks to access and control Java objects.

The release includes a number of useful classes, including
a package that makes it easy to create .class files, and
powerful Number classes.

Using the
.B kawa
script is equivalent to invoking an interpreter of the Java language on the
.B "kawa.repl"
package.

This manual page is just a quick synopsis.
For more information, read the
.B kawa
manual.
In a Debian GNU/Linux distribution, you should find a copy in
.IR /usr/share/doc/kawa/index.html .

.SH OPTIONS
.TP
.BI "-e " expression
Evaluate the
.IR expression .
.TP
.BI "-c " expression
Evaluate the
.IR expression ,
but does not cause the start-up file
.I ~/.kawarc.scm
to be read.
.TP
.BI "-f " filename
Read and evaluate Scheme commands from the
.IR filename .
.TP
.B -s
Enter an interactive read-evaluate-print command loop.
.TP
.B -w
Enter an interactive read-evaluate-print in a new top-level window.
.br
If no options are specified, it is equivalent to
.BR -s .
.SH "SEE ALSO"
.IR "http://ww.gnu.org/software/kawa/" ,
the
.B kawa
home page, with the manual.
.SH FILES
.TP
.B /usr/bin/kawa
The
.B kawa
executable is a shell script that invokes a Java language interpreter,
conventionally named
.BR java .
.TP
.B ~/.kawarc.scm
Commands that are executed when
.B kawa
is started.
.SH AUTHOR
Per Bothner <per@bothner.com>.
