;; Machine Descriptions for R8C/M16C/M32C
;; Copyright (C) 2005
;; Free Software Foundation, Inc.
;; Contributed by Red Hat.
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.
;;
;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the Free
;; Software Foundation, 51 Franklin Street, Fifth Floor, Boston, MA
;; 02110-1301, USA.

(define_constants
  [(R0_REGNO 0)
   (R2_REGNO 1)
   (R1_REGNO 2)
   (R3_REGNO 3)

   (A0_REGNO 4)
   (A1_REGNO 5)
   (SB_REGNO 6)
   (FB_REGNO 7)

   (SP_REGNO 8)
   (PC_REGNO 9)
   (FLG_REGNO 10)
   (MEM0_REGNO 12)
   (MEM7_REGNO 19)
   ])

(define_constants
  [(UNS_PROLOGUE_END 1)
   (UNS_EPILOGUE_START 2)
   (UNS_EH_EPILOGUE 3)
   (UNS_PUSHM 4)
   (UNS_POPM 5)
   ])

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

;; n = no change, x = clobbered.  The first 16 values are chosen such
;; that the enum has one bit set for each flag.
(define_attr "flags" "x,c,z,zc,s,sc,sz,szc,o,oc,oz,ozc,os,osc,osz,oszc,n" (const_string "n"))
(define_asm_attributes [(set_attr "flags" "x")])
