/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.Setting;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.ToolSettings;
import com.sun.electric.tool.user.User;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NetworkTool
extends Tool {
    private static final NetworkTool tool = new NetworkTool();
    static boolean debug = false;
    static boolean showInfo = true;
    public static int totalNumErrors = 0;
    static final int errorSortNetworks = 0;
    static final int errorSortNodes = 1;
    static final int errorSortPorts = 2;
    private static final boolean BUS_ASCENDING_DEFAULT = false;
    private static Pref cacheBusAscending = Pref.makeBooleanServerPref("BusAscending", NetworkTool.tool.prefs, false);

    public static void renumberNetlists() {
        new RenumberJob();
    }

    public NetworkTool() {
        super("network");
    }

    public static NetworkTool getNetworkTool() {
        return tool;
    }

    public static void setInformationOutput(boolean infoOutput) {
        showInfo = infoOutput;
    }

    public static Set<Network> getNetworksOnPort(PortInst pi, Netlist netlist, Set<Network> nets) {
        boolean added = false;
        if (nets == null) {
            nets = new HashSet<Network>();
        }
        if (!pi.isLinked()) {
            return nets;
        }
        Iterator<Connection> aIt = pi.getConnections();
        while (aIt.hasNext()) {
            Connection con = aIt.next();
            ArcInst ai = con.getArc();
            int wid = netlist.getBusWidth(ai);
            for (int i = 0; i < wid; ++i) {
                Network net = netlist.getNetwork(ai, i);
                if (net == null) continue;
                added = true;
                nets.add(net);
            }
        }
        if (!added) {
            NodeInst ni = pi.getNodeInst();
            HashSet<PortInst> ports = new HashSet<PortInst>();
            ports.add(pi);
            Iterator<ElectricObject> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst otherpi = it.next();
                if (otherpi == pi || !netlist.sameNetwork(ni, pi.getPortProto(), ni, otherpi.getPortProto())) continue;
                ports.add(otherpi);
            }
            it = ni.getParent().getExports();
            while (it.hasNext()) {
                Export export = (Export)it.next();
                if (!ports.contains(export.getOriginalPort())) continue;
                Name name = export.getNameKey();
                for (int i = 0; i < name.busWidth(); ++i) {
                    nets.add(netlist.getNetwork(pi.getNodeInst(), pi.getPortProto(), i));
                    added = true;
                }
            }
        }
        if (!added) {
            PortProto pp = pi.getPortProto();
            if (pp instanceof Export) {
                int wid = netlist.getBusWidth((Export)pp);
                for (int i = 0; i < wid; ++i) {
                    Network net = netlist.getNetwork(pi.getNodeInst(), pp, i);
                    if (net == null) continue;
                    nets.add(net);
                }
            } else {
                Network net = netlist.getNetwork(pi);
                if (net != null) {
                    nets.add(net);
                }
            }
        }
        return nets;
    }

    public static Set<Network> getNetworks(Geometric geom, Netlist netlist, Set<Network> nets) {
        if (nets == null) {
            nets = new HashSet<Network>();
        } else {
            nets.clear();
        }
        if (geom instanceof ArcInst) {
            nets.add(netlist.getNetwork((ArcInst)geom, 0));
        } else {
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                nets = NetworkTool.getNetworksOnPort(pi, netlist, nets);
            }
        }
        return nets;
    }

    @Override
    public void init() {
        this.setOn();
        if (!debug) {
            return;
        }
        System.out.println("NetworkTool.init()");
    }

    public static boolean isIgnoreResistors() {
        return NetworkTool.getIgnoreResistorsSetting().getBoolean();
    }

    private static Netlist.ShortResistors isIgnoreResistors_() {
        return Netlist.ShortResistors.NO;
    }

    public static Setting getIgnoreResistorsSetting() {
        return ToolSettings.getIgnoreResistorsSetting();
    }

    public static boolean isBusAscending() {
        return cacheBusAscending.getBoolean();
    }

    public static void setBusAscending(boolean a) {
        cacheBusAscending.setBoolean(a);
    }

    public static boolean isFactoryBusAscending() {
        return cacheBusAscending.getBooleanFactoryValue();
    }

    public static boolean isBusAscendingInNetlistEngine() {
        return false;
    }

    private static class RenumberJob
    extends Job {
        private RenumberJob() {
            super("Renumber All Networks", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            return true;
        }
    }

    public static class NetlistNotReady
    extends RuntimeException {
        public NetlistNotReady() {
            super("User netlist is not ready");
        }

        public NetlistNotReady(String s) {
            super(s);
        }
    }
}

