/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.simulatedAnnealing1.metrics;

import com.sun.electric.tool.placement.PlacementFrame;
import com.sun.electric.tool.placement.simulatedAnnealing1.SimulatedAnnealing;
import com.sun.electric.tool.placement.simulatedAnnealing1.metrics.AbstractMetric;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSTMetric
extends AbstractMetric {
    private SimulatedAnnealing.IncrementalState incState;
    private double currentScore;

    @Override
    public String getMetricName() {
        return "MSTMetric";
    }

    public MSTMetric(List<PlacementFrame.PlacementNode> nodesToPlace, List<PlacementFrame.PlacementNetwork> allNetworks, SimulatedAnnealing.IncrementalState incState) {
        super(nodesToPlace, allNetworks);
        this.incState = incState;
    }

    public double init(List<PlacementFrame.PlacementNetwork> allNetworks) {
        this.currentScore = this.compute();
        return this.currentScore;
    }

    public double getCurrentScore() {
        return this.currentScore;
    }

    public double update(int index2) {
        this.currentScore = this.compute();
        return this.currentScore;
    }

    @Override
    public double compute() {
        double total = 0.0;
        for (PlacementFrame.PlacementNetwork net : this.allNetworks) {
            total += this.compute(net);
        }
        return total;
    }

    private double compute(PlacementFrame.PlacementNetwork net) {
        TreeSet<Edge> edges = new TreeSet<Edge>();
        for (PlacementFrame.PlacementPort port1 : net.getPortsOnNet()) {
            for (PlacementFrame.PlacementPort port2 : net.getPortsOnNet()) {
                edges.add(new Edge(port1.getPlacementNode().getTypeName(), port2.getPlacementNode().getTypeName(), this.getDistance(port1, port2)));
            }
        }
        KruskalEdges vv = new KruskalEdges();
        for (Edge edge : edges) {
            vv.insertEdge(edge);
        }
        double total = 0.0;
        for (Edge edge : vv.getEdges()) {
            total += edge.getWeight();
        }
        return total;
    }

    private double getDistance(PlacementFrame.PlacementPort port1, PlacementFrame.PlacementPort port2) {
        SimulatedAnnealing.PlacementNodePosition n1 = this.incState.getNodeFromState(this.nodesToPlace.indexOf(port1.getPlacementNode()));
        SimulatedAnnealing.PlacementNodePosition n2 = this.incState.getNodeFromState(this.nodesToPlace.indexOf(port2.getPlacementNode()));
        double deltaX = n1.getPlacementX() + port1.getRotatedOffX() - n2.getPlacementX() - port2.getOffX();
        double deltaY = n1.getPlacementY() + port1.getRotatedOffY() - n2.getPlacementY() - port2.getOffY();
        return deltaX * deltaX + deltaY * deltaY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class KruskalEdges {
        Vector<HashSet<String>> vertexGroups = new Vector();
        TreeSet<Edge> kruskalEdges = new TreeSet();

        KruskalEdges() {
        }

        public TreeSet<Edge> getEdges() {
            return this.kruskalEdges;
        }

        HashSet<String> getVertexGroup(String vertex) {
            for (HashSet<String> vertexGroup : this.vertexGroups) {
                if (!vertexGroup.contains(vertex)) continue;
                return vertexGroup;
            }
            return null;
        }

        public void insertEdge(Edge edge) {
            String vertexA = edge.getVertexA();
            String vertexB = edge.getVertexB();
            HashSet<String> vertexGroupA = this.getVertexGroup(vertexA);
            HashSet<String> vertexGroupB = this.getVertexGroup(vertexB);
            if (vertexGroupA == null) {
                this.kruskalEdges.add(edge);
                if (vertexGroupB == null) {
                    HashSet<String> htNewVertexGroup = new HashSet<String>();
                    htNewVertexGroup.add(vertexA);
                    htNewVertexGroup.add(vertexB);
                    this.vertexGroups.add(htNewVertexGroup);
                } else {
                    vertexGroupB.add(vertexA);
                }
            } else if (vertexGroupB == null) {
                vertexGroupA.add(vertexB);
                this.kruskalEdges.add(edge);
            } else if (vertexGroupA != vertexGroupB) {
                vertexGroupA.addAll(vertexGroupB);
                this.vertexGroups.remove(vertexGroupB);
                this.kruskalEdges.add(edge);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Edge
    implements Comparable<Edge> {
        String vertexA;
        String vertexB;
        double weight;

        public Edge(String vertexA, String vertexB, double weight) {
            this.vertexA = vertexA;
            this.vertexB = vertexB;
            this.weight = weight;
        }

        public String getVertexA() {
            return this.vertexA;
        }

        public String getVertexB() {
            return this.vertexB;
        }

        public double getWeight() {
            return this.weight;
        }

        public String toString() {
            return "(" + this.vertexA + ", " + this.vertexB + ") : Weight = " + this.weight;
        }

        @Override
        public int compareTo(Edge edge) {
            return this.weight < edge.weight ? -1 : 1;
        }
    }
}

