/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.io.input.Simulate;
import com.sun.electric.tool.simulation.AnalogSignal;
import com.sun.electric.tool.simulation.Analysis;
import com.sun.electric.tool.simulation.Stimuli;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PSpiceOut
extends Simulate {
    PSpiceOut() {
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        if (this.openTextInput(fileURL)) {
            return null;
        }
        PSpiceOut.startProgressDialog("PSpice output", fileURL.getFile());
        Stimuli sd = this.readPSpiceFile(cell);
        PSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private Stimuli readPSpiceFile(Cell cell) throws IOException {
        int i;
        String line;
        boolean first = true;
        Stimuli sd = new Stimuli();
        Analysis an = new Analysis(sd, Analysis.ANALYSIS_SIGNALS);
        sd.setCell(cell);
        AnalogSignal[] signals = null;
        List[] values = null;
        int numSignals = 0;
        while ((line = this.getLine()) != null) {
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SPICE3/PSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return null;
                }
                int ptr = 0;
                ArrayList<String> signalNames = new ArrayList<String>();
                while (true) {
                    if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                        continue;
                    }
                    if (ptr >= line.length()) break;
                    int start = ptr;
                    while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                    }
                    signalNames.add(line.substring(start, ptr));
                }
                numSignals = signalNames.size();
                signals = new AnalogSignal[numSignals - 1];
                values = new List[numSignals];
                for (i = 0; i < numSignals; ++i) {
                    if (i != 0) {
                        signals[i - 1] = new AnalogSignal(an);
                        signals[i - 1].setSignalName((String)signalNames.get(i));
                    }
                    values[i] = new ArrayList();
                }
                continue;
            }
            int equalPos = line.indexOf("=");
            if (equalPos >= 0) {
                if (line.length() > equalPos + 3) {
                    line = line.substring(equalPos + 3);
                } else {
                    System.out.println("Missing value after '='.  This may not be a PSpice output file.");
                    return null;
                }
            }
            int ptr = 0;
            int position = 0;
            while (true) {
                if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                    continue;
                }
                if (ptr >= line.length() || line.charAt(ptr) == ')') break;
                int start = ptr;
                while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                double value = TextUtils.atof(line.substring(start, ptr));
                values[position++].add(new Double(value));
            }
            if (position == numSignals) continue;
            System.out.println("Line of data has " + position + " values, but expect " + numSignals + ". Unable to recover from error.  This may not be a PSpice output file.");
            return null;
        }
        if (numSignals == 0) {
            System.out.println("No data found in the file.  This may not be a PSpice output file.");
            return null;
        }
        int numEvents = values[0].size();
        an.buildCommonTime(numEvents);
        for (int i2 = 0; i2 < numEvents; ++i2) {
            an.setCommonTime(i2, (Double)values[0].get(i2));
        }
        for (int j = 1; j < numSignals; ++j) {
            void as = signals[j - 1];
            as.buildValues(numEvents);
            for (i = 0; i < numEvents; ++i) {
                as.setValue(i, (Double)values[j].get(i));
            }
        }
        return sd;
    }
}

