/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Geometric
extends ElectricObject {
    protected final Cell parent;

    protected Geometric(Cell parent) {
        this.parent = parent;
    }

    public String describe(boolean withQuotes) {
        return "?";
    }

    public void checkChanging() {
        if (this.parent != null) {
            this.parent.checkChanging();
        }
    }

    public Cell whichCell() {
        return this.parent;
    }

    public int whichMultiPage() {
        int pageNo = 0;
        if (this.parent.isMultiPage()) {
            double cY = this.getBounds().getCenterY();
            pageNo = (int)((cY + 500.0) / 1000.0);
        }
        return pageNo;
    }

    public EDatabase getDatabase() {
        return this.parent != null ? this.parent.getDatabase() : null;
    }

    public void getInfo() {
        Rectangle2D visBounds = this.getBounds();
        System.out.println(" Bounds: (" + visBounds.getCenterX() + "," + visBounds.getCenterY() + "), size: " + visBounds.getWidth() + "x" + visBounds.getHeight());
        System.out.println(" Parent: " + this.parent);
        super.getInfo();
    }

    public Cell getParent() {
        return this.parent;
    }

    public abstract Rectangle2D getBounds();

    public double getTrueCenterX() {
        return this.getBounds().getCenterX();
    }

    public double getTrueCenterY() {
        return this.getBounds().getCenterY();
    }

    public Point2D getTrueCenter() {
        return new Point2D.Double(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public static boolean objectsTouch(Geometric geom1, Geometric geom2) {
        if (geom1 instanceof NodeInst) {
            if (geom2 instanceof NodeInst) {
                return false;
            }
            Geometric temp = geom1;
            geom1 = geom2;
            geom2 = temp;
        }
        if (!(geom2 instanceof NodeInst)) {
            return false;
        }
        NodeInst ni = (NodeInst)geom2;
        ArcInst ai = (ArcInst)geom1;
        for (int i = 0; i < 2; ++i) {
            if (ai.getPortInst(i).getNodeInst() != ni) continue;
            return true;
        }
        return false;
    }
}

