/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.jemNets.NetObject;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.Subcircuit;
import com.sun.electric.tool.ncc.jemNets.Transistor;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class StratCheckSizes
extends Strategy {
    private NccOptions options;
    private double minWidth;
    private double maxWidth;
    private double minLength;
    private double maxLength;
    private Transistor minWidMos;
    private Transistor maxWidMos;
    private Transistor minLenMos;
    private Transistor maxLenMos;
    private List mismatches = new ArrayList();

    private StratCheckSizes(NccGlobals globals) {
        super(globals);
        this.options = globals.getOptions();
    }

    private void checkWidthMismatch() {
        if (!NccUtils.sizesMatch(this.maxWidth, this.minWidth, this.options)) {
            this.mismatches.add(new WidthMismatch(this.minWidth, this.minWidMos, this.maxWidth, this.maxWidMos));
        }
    }

    private void checkLengthMismatch() {
        if (!NccUtils.sizesMatch(this.maxLength, this.minLength, this.options)) {
            this.mismatches.add(new LengthMismatch(this.minLength, this.minLenMos, this.maxLength, this.maxLenMos));
        }
    }

    private void summary() {
        Collections.sort(this.mismatches, new MismatchComparator());
        System.out.println("  There are " + this.mismatches.size() + " size mismatches.");
        Iterator it = this.mismatches.iterator();
        while (it.hasNext()) {
            Mismatch m = (Mismatch)it.next();
            System.out.print(m.toString());
        }
    }

    private boolean matches() {
        return this.mismatches.size() == 0;
    }

    public LeafList doFor(EquivRecord j) {
        if (j.isLeaf()) {
            if (j.isMatched()) {
                this.minLength = Double.MAX_VALUE;
                this.minWidth = Double.MAX_VALUE;
                this.maxLength = Double.MIN_VALUE;
                this.maxWidth = Double.MIN_VALUE;
                super.doFor(j);
                this.checkWidthMismatch();
                this.checkLengthMismatch();
            }
        } else {
            super.doFor(j);
        }
        return new LeafList();
    }

    public Integer doFor(NetObject n) {
        Part p = (Part)n;
        if (p instanceof Subcircuit) {
            this.maxLength = 1.0;
            this.minLength = 1.0;
            this.maxWidth = 1.0;
            this.minWidth = 1.0;
        } else {
            double l;
            this.globals.error(!(p instanceof Transistor), "unimplemented part type");
            Transistor t = (Transistor)p;
            double w = t.getWidth();
            if (w < this.minWidth) {
                this.minWidth = w;
                this.minWidMos = t;
            }
            if (w > this.maxWidth) {
                this.maxWidth = w;
                this.maxWidMos = t;
            }
            if ((l = t.getLength()) < this.minLength) {
                this.minLength = l;
                this.minLenMos = t;
            }
            if (l > this.maxLength) {
                this.maxLength = l;
                this.maxLenMos = t;
            }
        }
        return CODE_NO_CHANGE;
    }

    public static boolean doYourJob(NccGlobals globals) {
        NccOptions options = globals.getOptions();
        if (!options.checkSizes) {
            return true;
        }
        EquivRecord parts = globals.getParts();
        if (parts == null) {
            return true;
        }
        StratCheckSizes jsf = new StratCheckSizes(globals);
        jsf.doFor(parts);
        jsf.summary();
        return jsf.matches();
    }

    private static class MismatchComparator
    implements Comparator {
        private MismatchComparator() {
        }

        public int compare(Object o1, Object o2) {
            Mismatch m1 = (Mismatch)o1;
            Mismatch m2 = (Mismatch)o2;
            double diff = m1.relErr() - m2.relErr();
            if (diff == 0.0) {
                return 0;
            }
            return diff > 0.0 ? 1 : -1;
        }
    }

    private static class WidthMismatch
    extends Mismatch {
        public String widLen() {
            return "width";
        }

        public String wl() {
            return "W";
        }

        public WidthMismatch(double min, Transistor minMos, double max, Transistor maxMos) {
            super(min, minMos, max, maxMos);
        }
    }

    private static class LengthMismatch
    extends Mismatch {
        public String widLen() {
            return "length";
        }

        public String wl() {
            return "L";
        }

        public LengthMismatch(double min, Transistor minMos, double max, Transistor maxMos) {
            super(min, minMos, max, maxMos);
        }
    }

    private static abstract class Mismatch {
        private StringBuffer sb = new StringBuffer();
        public final double min;
        public final double max;
        public final Transistor minMos;
        public final Transistor maxMos;

        private void aln(String s) {
            this.sb.append(s);
            this.sb.append("\n");
        }

        Mismatch(double min, Transistor minMos, double max, Transistor maxMos) {
            this.min = min;
            this.max = max;
            this.minMos = minMos;
            this.maxMos = maxMos;
        }

        public double relErr() {
            return (this.max - this.min) / this.min;
        }

        public double absErr() {
            return this.max - this.min;
        }

        public boolean isCap() {
            return this.minMos.isCapacitor();
        }

        public abstract String widLen();

        public abstract String wl();

        public String toString() {
            this.aln("    MOS" + (this.isCap() ? " capacitor" : "") + " " + this.widLen() + "s don't match. " + " relativeError=" + NccUtils.round(this.relErr() * 100.0, 1) + "%" + " absoluteError=" + NccUtils.round(this.absErr(), 2));
            this.aln("      " + this.wl() + "=" + NccUtils.round(this.min, 2) + " for " + this.minMos.fullDescription());
            this.aln("      " + this.wl() + "=" + NccUtils.round(this.max, 2) + " for " + this.maxMos.fullDescription());
            return this.sb.toString();
        }
    }
}

