/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.output.Output;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class ReadableDump
extends Output {
    private int nodeInstError;
    private int portProtoError;
    private int arcInstError;
    private int typeError;
    private HashMap cellOrdering;
    private HashMap cellGrouping;
    private HashMap nodeMap;
    private HashMap arcMap;
    private HashMap portMap;
    private int cellNumber;
    private Cell[] cells;

    ReadableDump() {
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        GenMath.MutableInteger mi;
        GenMath.MutableInteger mi2;
        Cell cell;
        Cell cell2;
        Iterator it;
        Library oLib;
        this.typeError = 0;
        this.arcInstError = 0;
        this.portProtoError = 0;
        this.nodeInstError = 0;
        this.cellOrdering = new HashMap();
        this.cellGrouping = new HashMap();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            oLib = (Library)lIt.next();
            it = oLib.getCells();
            while (it.hasNext()) {
                cell2 = (Cell)it.next();
                this.cellOrdering.put(cell2, new GenMath.MutableInteger(-1));
            }
        }
        this.cellNumber = 0;
        Iterator it2 = lib.getCells();
        while (it2.hasNext()) {
            cell = (Cell)it2.next();
            if (cell.getNumUsagesIn() != 0) continue;
            this.textRecurse(cell);
        }
        it2 = lib.getCells();
        while (it2.hasNext()) {
            cell = (Cell)it2.next();
            mi2 = (GenMath.MutableInteger)this.cellOrdering.get(cell);
            if (mi2 != null && mi2.intValue() >= 0) continue;
            this.textRecurse(cell);
        }
        if (this.cellNumber > 0) {
            this.cells = new Cell[this.cellNumber];
            lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                oLib = (Library)lIt.next();
                it = oLib.getCells();
                while (it.hasNext()) {
                    cell2 = (Cell)it.next();
                    mi = (GenMath.MutableInteger)this.cellOrdering.get(cell2);
                    if (mi.intValue() < 0) continue;
                    this.cells[mi.intValue()] = cell2;
                }
            }
        }
        it2 = lib.getCells();
        while (it2.hasNext()) {
            cell = (Cell)it2.next();
            this.cellGrouping.put(cell, new GenMath.MutableInteger(0));
        }
        int cellGroup = 0;
        Iterator it3 = lib.getCells();
        while (it3.hasNext()) {
            Cell cell3 = (Cell)it3.next();
            GenMath.MutableInteger mi3 = (GenMath.MutableInteger)this.cellGrouping.get(cell3);
            if (mi3 == null || mi3.intValue() != 0) continue;
            ++cellGroup;
            Iterator gIt = cell3.getCellGroup().getCells();
            while (gIt.hasNext()) {
                Cell oCell = (Cell)gIt.next();
                mi3 = (GenMath.MutableInteger)this.cellGrouping.get(oCell);
                mi3.setValue(cellGroup);
            }
        }
        this.printWriter.print("****library: \"" + lib.getName() + "\"\n");
        this.printWriter.print("version: " + Version.getVersion() + "\n");
        this.printWriter.print("aids: " + Tool.getNumTools() + "\n");
        it3 = Tool.getTools();
        while (it3.hasNext()) {
            Tool tool = (Tool)it3.next();
            this.printWriter.print("aidname: " + tool.getName() + "\n");
            this.writeVars(tool, null);
        }
        this.printWriter.print("userbits: " + lib.lowLevelGetUserBits() + "\n");
        this.printWriter.print("techcount: " + Technology.getNumTechnologies() + "\n");
        it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            Technology tech = (Technology)it3.next();
            this.printWriter.print("techname: " + tech.getTechName() + " lambda: " + (int)(tech.getScale() * 2.0) + "\n");
            this.writeVars(tech, null);
        }
        it3 = View.getViews();
        while (it3.hasNext()) {
            View v = (View)it3.next();
            this.printWriter.print("view: " + v.getFullName() + "{" + v.getAbbreviation() + "}\n");
        }
        this.printWriter.print("cellcount: " + this.cellNumber + "\n");
        Cell curCell = lib.getCurCell();
        if (curCell != null) {
            mi2 = (GenMath.MutableInteger)this.cellOrdering.get(curCell);
            this.printWriter.print("maincell: " + mi2.intValue() + "\n");
        }
        this.writeVars(lib, null);
        for (int i = 0; i < this.cellNumber; ++i) {
            NodeInst ni;
            cell2 = this.cells[i];
            mi = (GenMath.MutableInteger)this.cellOrdering.get(cell2);
            int groupIndex = 0;
            GenMath.MutableInteger mig = (GenMath.MutableInteger)this.cellGrouping.get(cell2);
            if (mig != null) {
                groupIndex = mig.intValue();
            }
            this.printWriter.print("***cell: " + mi.intValue() + "/" + groupIndex + "\n");
            this.printWriter.print("name: " + cell2.getName());
            if (cell2.getView().getAbbreviation().length() > 0) {
                this.printWriter.print("{" + cell2.getView().getAbbreviation() + "}");
            }
            this.printWriter.print("\n");
            this.printWriter.print("version: " + cell2.getVersion() + "\n");
            this.printWriter.print("creationdate: " + ELIBConstants.dateToSeconds(cell2.getCreationDate()) + "\n");
            this.printWriter.print("revisiondate: " + ELIBConstants.dateToSeconds(cell2.getRevisionDate()) + "\n");
            Rectangle2D bounds = cell2.getBounds();
            Technology tech = cell2.getTechnology();
            double scale = tech.getScale() * 2.0;
            int lowX = (int)(bounds.getMinX() * scale);
            int highX = (int)(bounds.getMaxX() * scale);
            int lowY = (int)(bounds.getMinY() * scale);
            int highY = (int)(bounds.getMaxY() * scale);
            this.printWriter.print("lowx: " + lowX + " highx: " + highX + " lowy: " + lowY + " highy: " + highY + "\n");
            if (cell2.getLibrary() != lib) {
                this.printWriter.print("externallibrary: \"" + cell2.getLibrary().getLibFile().getFile() + "\"\n");
                continue;
            }
            this.printWriter.print("aadirty: 0\n");
            this.printWriter.print("userbits: " + cell2.lowLevelGetUserbits() + "\n");
            this.nodeMap = new HashMap();
            this.arcMap = new HashMap();
            this.portMap = new HashMap();
            int nodeCount = 0;
            int arcCount = 0;
            int portCount = 0;
            Iterator it4 = cell2.getNodes();
            while (it4.hasNext()) {
                ni = (NodeInst)it4.next();
                this.nodeMap.put(ni, new Integer(nodeCount++));
            }
            it4 = cell2.getArcs();
            while (it4.hasNext()) {
                ArcInst ai = (ArcInst)it4.next();
                this.arcMap.put(ai, new Integer(arcCount++));
            }
            it4 = cell2.getPorts();
            while (it4.hasNext()) {
                Export pp = (Export)it4.next();
                this.portMap.put(pp, new Integer(portCount++));
            }
            this.printWriter.print("nodes: " + cell2.getNumNodes() + " arcs: " + cell2.getNumArcs() + " porttypes: " + cell2.getNumPorts() + "\n");
            this.writeVars(cell2, cell2);
            it4 = cell2.getNodes();
            while (it4.hasNext()) {
                int transpose;
                ni = (NodeInst)it4.next();
                NodeProto np = ni.getProto();
                Integer nodeIndex = (Integer)this.nodeMap.get(ni);
                this.printWriter.print("**node: " + nodeIndex + "\n");
                if (np instanceof Cell) {
                    GenMath.MutableInteger subMi = (GenMath.MutableInteger)this.cellOrdering.get(np);
                    this.printWriter.print("type: [" + subMi.intValue() + "]\n");
                } else {
                    this.printWriter.print("type: " + np.getTechnology().getTechName() + ":" + np.getName() + "\n");
                }
                if (np instanceof Cell) {
                    lowX = (int)((ni.getTrueCenterX() - ni.getXSize() / 2.0) * scale);
                    highX = (int)((ni.getTrueCenterX() + ni.getXSize() / 2.0) * scale);
                    lowY = (int)((ni.getTrueCenterY() - ni.getYSize() / 2.0) * scale);
                    highY = (int)((ni.getTrueCenterY() + ni.getYSize() / 2.0) * scale);
                } else {
                    lowX = (int)((ni.getAnchorCenterX() - ni.getXSize() / 2.0) * scale);
                    highX = (int)((ni.getAnchorCenterX() + ni.getXSize() / 2.0) * scale);
                    lowY = (int)((ni.getAnchorCenterY() - ni.getYSize() / 2.0) * scale);
                    highY = (int)((ni.getAnchorCenterY() + ni.getYSize() / 2.0) * scale);
                }
                this.printWriter.print("lowx: " + lowX + " highx: " + highX + " lowy: " + lowY + " highy: " + highY + "\n");
                int angle = ni.getAngle();
                int n = transpose = ni.isXMirrored() != ni.isYMirrored() ? 1 : 0;
                if (ni.isXMirrored()) {
                    angle = ni.isYMirrored() ? (angle + 1800) % 3600 : (angle + 900) % 3600;
                } else if (ni.isYMirrored()) {
                    angle = (angle + 2700) % 3600;
                }
                this.printWriter.print("rotation: " + angle + " transpose: " + transpose + "\n");
                if (np instanceof Cell) {
                    this.printWriter.print("descript: " + ni.getProtoTextDescriptor().lowLevelGet0() + "/" + ni.getProtoTextDescriptor().lowLevelGet0() + "\n");
                }
                this.printWriter.print("userbits: " + ni.lowLevelGetUserbits() + "\n");
                this.writeVars(ni, cell2);
                Iterator pIt = np.getPorts();
                while (pIt.hasNext()) {
                    PortProto pp = (PortProto)pIt.next();
                    boolean found = false;
                    Iterator aIt = ni.getConnections();
                    while (aIt.hasNext()) {
                        Integer aIndex;
                        Connection con = (Connection)aIt.next();
                        if (con.getPortInst().getPortProto() != pp) continue;
                        if (!found) {
                            this.printWriter.print("*port: " + pp.getName() + "\n");
                            found = true;
                        }
                        if ((aIndex = (Integer)this.arcMap.get(con.getArc())) == null) {
                            aIndex = new Integer(-1);
                        }
                        this.printWriter.print("arc: " + aIndex + "\n");
                    }
                    Iterator eIt = ni.getExports();
                    while (eIt.hasNext()) {
                        Integer pIndex;
                        Export e = (Export)eIt.next();
                        if (e.getOriginalPort().getPortProto() != pp) continue;
                        if (!found) {
                            this.printWriter.print("*port: " + pp.getName() + "\n");
                            found = true;
                        }
                        if ((pIndex = (Integer)this.portMap.get(e)) == null) {
                            pIndex = new Integer(-1);
                        }
                        this.printWriter.print("exported: " + pIndex + "\n");
                    }
                }
            }
            int poc = 0;
            Iterator it5 = cell2.getPorts();
            while (it5.hasNext()) {
                Export pp = (Export)it5.next();
                this.printWriter.print("**porttype: " + poc + "\n");
                ++poc;
                NodeInst subNi = pp.getOriginalPort().getNodeInst();
                Integer subNodeIndex = (Integer)this.nodeMap.get(subNi);
                PortProto subPp = pp.getOriginalPort().getPortProto();
                this.printWriter.print("subnode: " + subNodeIndex + "\n");
                this.printWriter.print("subport: " + subPp.getName() + "\n");
                this.printWriter.print("name: " + pp.getName() + "\n");
                TextDescriptor td = pp.getTextDescriptor();
                this.printWriter.print("descript: " + td.lowLevelGet0() + "/" + td.lowLevelGet1() + "\n");
                this.printWriter.print("userbits: " + pp.lowLevelGetUserbits() + "\n");
                this.writeVars(pp, cell2);
            }
            it5 = cell2.getArcs();
            while (it5.hasNext()) {
                ArcInst ai = (ArcInst)it5.next();
                Integer arcIndex = (Integer)this.arcMap.get(ai);
                this.printWriter.print("**arc: " + arcIndex + "\n");
                this.printWriter.print("type: " + ai.getProto().getTechnology().getTechName() + ":" + ai.getProto().getName() + "\n");
                int width = (int)(ai.getWidth() * scale);
                int length = (int)(ai.getLength() * scale);
                this.printWriter.print("width: " + width + " length: " + length + "\n");
                int arcAngle = ai.getAngle() / 10;
                ai.lowLevelSetArcAngle(arcAngle);
                int userBits = ai.lowLevelGetUserbits();
                userBits &= 0xFFFAFFFF;
                if (ai.getTail().isNegated()) {
                    userBits = ai.isReverseEnds() ? (userBits |= 0x10000) : (userBits |= 0x40000);
                }
                if (ai.getHead().isNegated()) {
                    userBits = ai.isReverseEnds() ? (userBits |= 0x40000) : (userBits |= 0x10000);
                }
                this.printWriter.print("userbits: " + userBits + "\n");
                for (int e = 0; e < 2; ++e) {
                    Connection con = ai.getConnection(e);
                    NodeInst conNi = con.getPortInst().getNodeInst();
                    Integer conNodeIndex = (Integer)this.nodeMap.get(conNi);
                    this.printWriter.print("*end: " + e + "\n");
                    this.printWriter.print("node: " + conNodeIndex + "\n");
                    this.printWriter.print("nodeport: " + con.getPortInst().getPortProto().getName() + "\n");
                    int endX = (int)(con.getLocation().getX() * scale);
                    int endY = (int)(con.getLocation().getY() * scale);
                    this.printWriter.print("xpos: " + endX + " ypos: " + endY + "\n");
                }
                this.writeVars(ai, cell2);
            }
            this.printWriter.print("celldone: " + cell2.getName() + "\n");
        }
        if (this.nodeInstError != 0) {
            System.out.println("Warning: " + this.nodeInstError + " node pointers point outside cell: not saved");
        }
        if (this.arcInstError != 0) {
            System.out.println("Warning: " + this.arcInstError + " arc pointers point outside cell: not saved");
        }
        if (this.portProtoError != 0) {
            System.out.println("Warning: " + this.portProtoError + " export pointers point outside cell: not saved");
        }
        if (this.typeError != 0) {
            System.out.println("Warning: " + this.typeError + " objects of unknown type could not be saved");
        }
        lib.clearChangedMinor();
        lib.clearChangedMajor();
        System.out.println(this.filePath + " written");
        return false;
    }

    private void textRecurse(Cell cell) {
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            GenMath.MutableInteger mi;
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || (mi = (GenMath.MutableInteger)this.cellOrdering.get(subCell = (Cell)ni.getProto())) != null && mi.intValue() >= 0) continue;
            this.textRecurse(subCell);
        }
        GenMath.MutableInteger mi = (GenMath.MutableInteger)this.cellOrdering.get(cell);
        mi.setValue(this.cellNumber++);
    }

    private void writeVars(ElectricObject eObj, Cell curCell) {
        int type;
        Variable var;
        int i = 0;
        Iterator it = eObj.getVariables();
        while (it.hasNext()) {
            var = (Variable)it.next();
            if (var.isDontSave()) continue;
            ++i;
        }
        if (eObj instanceof Geometric && ((Geometric)eObj).getNameKey() != null) {
            ++i;
        }
        if (i == 0) {
            return;
        }
        this.printWriter.print("variables: " + i + "\n");
        it = eObj.getVariables();
        while (it.hasNext()) {
            String pt;
            var = (Variable)it.next();
            if (var.isDontSave()) continue;
            type = var.lowLevelGetFlags() & 0xE0000160;
            Float[] varObj = var.getObject();
            if (eObj instanceof NodeInst && var.getKey() == NodeInst.TRACE && varObj instanceof Object[]) {
                Object[] objList = varObj;
                Point2D[] points = (Point2D[])objList;
                int len = points.length * 2;
                Float[] newPoints = new Float[len];
                for (int j = 0; j < points.length; ++j) {
                    newPoints[j * 2] = new Float(points[j].getX());
                    newPoints[j * 2 + 1] = new Float(points[j].getY());
                }
                varObj = newPoints;
            }
            if ((pt = this.makeString(varObj, curCell)) == null) {
                pt = "";
            }
            this.printName(var.getKey().getName());
            TextDescriptor td = var.getTextDescriptor();
            if (varObj instanceof Object[]) {
                Object[] objList = varObj;
                int objType = ELIBConstants.getVarType(objList[0]);
                if (objType == 6) {
                    objType = 5;
                }
                int len = objList.length;
                this.printWriter.print("(" + len + ")[0" + Integer.toOctalString(type |= objType | 0x80 | len << 9) + ",0" + Integer.toOctalString(td.lowLevelGet0()) + "/0" + Integer.toOctalString(td.lowLevelGet1()) + "]: ");
            } else {
                int objType = ELIBConstants.getVarType(varObj);
                if (objType == 6) {
                    objType = 5;
                }
                this.printWriter.print("[0" + Integer.toOctalString(type |= objType) + ",0" + Integer.toOctalString(td.lowLevelGet0()) + "/0" + Integer.toOctalString(td.lowLevelGet1()) + "]: ");
            }
            this.printWriter.print(pt + "\n");
        }
        if (eObj instanceof Geometric && ((Geometric)eObj).getNameKey() != null) {
            Geometric geom = (Geometric)eObj;
            Variable.Key key = geom instanceof NodeInst ? NodeInst.NODE_NAME : ArcInst.ARC_NAME;
            type = 4;
            if (geom.isUsernamed()) {
                type |= 0x40;
            }
            TextDescriptor td = geom.getNameTextDescriptor();
            this.printWriter.print("[0" + Integer.toOctalString(type) + ",0" + Integer.toOctalString(td.lowLevelGet0()) + "/0" + Integer.toOctalString(td.lowLevelGet1()) + "]: ");
            this.printWriter.print("\"" + this.convertString(geom.getName()) + "\"\n");
        }
    }

    private String makeString(Object obj, Cell curCell) {
        StringBuffer infstr = new StringBuffer();
        if (obj instanceof Object[]) {
            Object[] objArray = (Object[])obj;
            int len = objArray.length;
            for (int i = 0; i < len; ++i) {
                Object oneObj = objArray[i];
                if (i == 0) {
                    infstr.append("[");
                } else {
                    infstr.append(",");
                }
                this.makeStringVar(infstr, oneObj, curCell);
            }
            infstr.append("]");
        } else {
            this.makeStringVar(infstr, obj, curCell);
        }
        return infstr.toString();
    }

    private void makeStringVar(StringBuffer infstr, Object obj, Cell curCell) {
        if (obj instanceof Integer) {
            infstr.append((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            infstr.append(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Byte) {
            infstr.append(((Byte)obj).byteValue());
            return;
        }
        if (obj instanceof String) {
            infstr.append("\"");
            infstr.append(this.convertString((String)obj));
            infstr.append("\"");
            return;
        }
        if (obj instanceof Float) {
            infstr.append(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            infstr.append((Double)obj);
            return;
        }
        if (obj instanceof Boolean) {
            infstr.append((Boolean)obj != false ? 1 : 0);
            return;
        }
        if (obj instanceof Long) {
            infstr.append((Long)obj);
            return;
        }
        if (obj instanceof Technology) {
            Technology tech = (Technology)obj;
            infstr.append(tech.getTechName());
            return;
        }
        if (obj instanceof Library) {
            Library lib = (Library)obj;
            infstr.append("\"" + lib.getName() + "\"");
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            infstr.append(tool.getName());
            return;
        }
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            Integer nodeIndex = (Integer)this.nodeMap.get(ni);
            int cIndex = -1;
            if (nodeIndex == null) {
                ++this.nodeInstError;
            } else {
                cIndex = nodeIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            Integer arcIndex = (Integer)this.arcMap.get(ai);
            int cIndex = -1;
            if (arcIndex == null) {
                ++this.arcInstError;
            } else {
                cIndex = arcIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof Cell) {
            Cell cell = (Cell)obj;
            GenMath.MutableInteger mi = (GenMath.MutableInteger)this.cellOrdering.get(cell);
            int cIndex = -1;
            if (mi != null) {
                cIndex = mi.intValue();
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        if (obj instanceof PrimitiveNode) {
            PrimitiveNode np = (PrimitiveNode)obj;
            infstr.append(np.getTechnology().getTechName() + ":" + np.getName());
            return;
        }
        if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            infstr.append(ap.getTechnology().getTechName() + ":" + ap.getName());
            return;
        }
        if (obj instanceof Export) {
            Export pp = (Export)obj;
            Integer portIndex = (Integer)this.portMap.get(pp);
            int cIndex = -1;
            if (portIndex == null) {
                ++this.portProtoError;
            } else {
                cIndex = portIndex;
            }
            infstr.append(Integer.toString(cIndex));
            return;
        }
        ++this.typeError;
    }

    private String convertString(String str) {
        StringBuffer infstr = new StringBuffer();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '[' || ch == ']' || ch == '\"' || ch == '^') {
                infstr.append('^');
            }
            infstr.append(ch);
        }
        return infstr.toString();
    }

    private void printName(String name) {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char pt = name.charAt(i);
            if (pt == '^' || pt == '[' || pt == '(') {
                this.printWriter.print("^");
            }
            this.printWriter.print(pt);
        }
    }
}

