/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.NodeUsage;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.CellName;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JOptionPane;

public class Cell
extends NodeProto
implements Comparable {
    public static final Variable.Key CHARACTERISTIC_SPACING = ElectricObject.newKey("FACET_characteristic_spacing");
    public static final Variable.Key CELL_TEXT_KEY = ElectricObject.newKey("FACET_message");
    private static final int ABBREVLEN = 8;
    private static final Rectangle2D CENTERRECT = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    private static int cellNumber = 0;
    private CellGroup cellGroup = null;
    private VersionGroup versionGroup;
    private Library lib;
    private View view;
    private Date creationDate;
    private Date revisionDate;
    private int version;
    private Name basename;
    private List essenBounds = new ArrayList();
    private List nodes;
    private Map usagesIn;
    private Map maxSuffix;
    private List arcs;
    private Map tempNames;
    private Rectangle2D cellBounds;
    private boolean boundsDirty;
    private boolean boundsEmpty;
    private Geometric.RTNode rTree;
    private Undo.Change change;
    private int lock;
    private boolean linked;
    private int cellIndex;
    private boolean boundLock = false;
    private Rectangle2D lastBounds = new Rectangle2D.Double();

    private Cell() {
        this.cellIndex = cellNumber++;
        this.nodes = new ArrayList();
        this.usagesIn = new HashMap();
        this.maxSuffix = new HashMap();
        this.arcs = new ArrayList();
        this.tempNames = new HashMap();
        this.tech = null;
        this.creationDate = new Date();
        this.revisionDate = new Date();
        this.userBits = 0;
        this.cellBounds = new Rectangle2D.Double();
        this.boundsEmpty = true;
        this.boundsDirty = false;
        this.rTree = Geometric.RTNode.makeTopLevel();
        this.linked = false;
    }

    public static Cell makeInstance(Library lib, String name) {
        Job.checkChanging();
        Cell cell = Cell.lowLevelAllocate(lib);
        if (cell.lowLevelPopulate(name)) {
            return null;
        }
        if (cell.lowLevelLink()) {
            return null;
        }
        Undo.newObject(cell);
        if (User.isPlaceCellCenter()) {
            PrimitiveNode cellCenterProto = Generic.tech.cellCenterNode;
            NodeInst cellCenter = NodeInst.newInstance(cellCenterProto, new Point2D.Double(0.0, 0.0), ((NodeProto)cellCenterProto).getDefWidth(), ((NodeProto)cellCenterProto).getDefHeight(), 0, cell, null);
            cellCenter.setVisInside();
            cellCenter.setHardSelect();
        }
        return cell;
    }

    public static Cell newInstance(Library lib, String name) {
        Job.checkChanging();
        Cell cell = Cell.lowLevelAllocate(lib);
        if (cell.lowLevelPopulate(name)) {
            return null;
        }
        if (cell.lowLevelLink()) {
            return null;
        }
        Undo.newObject(cell);
        return cell;
    }

    public void kill() {
        this.checkChanging();
        this.lowLevelUnlink();
        Undo.killObject(this);
    }

    public Cell makeNewVersion() {
        Cell newVersion = Cell.copyNodeProto(this, this.lib, this.noLibDescribe(), false);
        return newVersion;
    }

    public void joinGroup(Cell otherCell) {
        this.setCellGroup(otherCell.getCellGroup());
    }

    public static Cell copyNodeProto(Cell fromCell, Library toLib, String toName, boolean useExisting) {
        Cell newCell;
        PortProto ppt;
        PortProto pp;
        NodeProto lnt;
        NodeInst ni;
        if (fromCell == null) {
            return null;
        }
        if (toLib == null) {
            return null;
        }
        for (int i = 0; i < toName.length(); ++i) {
            char ch = toName.charAt(i);
            if (ch > ' ' && ch != ':' && ch < '\u007f') continue;
            return null;
        }
        Library destLib = toLib;
        if (toLib == fromCell.getLibrary()) {
            destLib = null;
        }
        Iterator it = fromCell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            ni.setTempObj(ni.getProto());
        }
        if (destLib != null) {
            it = fromCell.getNodes();
            while (it.hasNext()) {
                Cell niProto;
                ni = (NodeInst)it.next();
                if (ni.getProto() instanceof PrimitiveNode || (niProto = (Cell)ni.getProto()).getLibrary() != fromCell.getLibrary()) continue;
                boolean maySubstitute = useExisting;
                if (!maySubstitute && niProto.getView() == View.ICON && niProto.isIconOf(fromCell)) {
                    maySubstitute = true;
                }
                if (!maySubstitute) continue;
                lnt = null;
                Iterator cIt = toLib.getCells();
                while (cIt.hasNext() && (!(lnt = (Cell)cIt.next()).getName().equalsIgnoreCase(niProto.getName()) || ((Cell)lnt).getView() != niProto.getView())) {
                    lnt = null;
                }
                if (lnt == null) continue;
                boolean validPorts = true;
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    pp = pi.getPortProto();
                    ppt = lnt.findPortProto(pp.getName());
                    if (ppt != null) {
                        // empty if block
                    }
                    if (ppt != null) continue;
                    System.out.println("Cannot use subcell " + ((Cell)lnt).noLibDescribe() + " in library " + destLib.getName() + ": exports don't match");
                    validPorts = false;
                    break;
                }
                if (!validPorts) continue;
                ni.setTempObj(lnt);
            }
        }
        String cellName = toName;
        if (toName.indexOf(123) < 0 && fromCell.getView() != View.UNKNOWN) {
            cellName = toName + "{" + fromCell.getView().getAbbreviation() + "}";
        }
        if ((newCell = Cell.newInstance(toLib, cellName)) == null) {
            return null;
        }
        newCell.lowLevelSetUserbits(fromCell.lowLevelGetUserbits());
        Iterator it2 = fromCell.getNodes();
        while (it2.hasNext()) {
            NodeInst toNi;
            NodeInst ni2 = (NodeInst)it2.next();
            lnt = (NodeProto)ni2.getTempObj();
            double scaleX = ni2.getXSize();
            if (ni2.isXMirrored()) {
                scaleX = -scaleX;
            }
            double scaleY = ni2.getYSize();
            if (ni2.isYMirrored()) {
                scaleY = -scaleY;
            }
            if ((toNi = NodeInst.newInstance(lnt, new Point2D.Double(ni2.getAnchorCenterX(), ni2.getAnchorCenterY()), scaleX, scaleY, ni2.getAngle(), newCell, ni2.getName())) == null) {
                return null;
            }
            ni2.setTempObj(toNi);
            toNi.setProtoTextDescriptor(ni2.getProtoTextDescriptor());
            toNi.setNameTextDescriptor(ni2.getNameTextDescriptor());
            toNi.lowLevelSetUserbits(ni2.lowLevelGetUserbits());
        }
        it2 = fromCell.getNodes();
        while (it2.hasNext()) {
            NodeInst ni3 = (NodeInst)it2.next();
            NodeInst toNi = (NodeInst)ni3.getTempObj();
            toNi.copyVars(ni3);
        }
        it2 = fromCell.getArcs();
        while (it2.hasNext()) {
            ArcInst ai = (ArcInst)it2.next();
            PortInst[] opi = new PortInst[2];
            for (int i = 0; i < 2; ++i) {
                opi[i] = null;
                Connection con = ai.getConnection(i);
                NodeInst ono = (NodeInst)con.getPortInst().getNodeInst().getTempObj();
                pp = con.getPortInst().getPortProto();
                if (ono.getProto() instanceof PrimitiveNode) {
                    opi[i] = ono.findPortInstFromProto(pp);
                } else {
                    ppt = ono.getProto().findPortProto(pp.getName());
                    if (ppt != null) {
                        opi[i] = ono.findPortInstFromProto(ppt);
                    }
                }
                if (opi[i] != null) continue;
                System.out.println("Error: no port for " + ai.getProto().describe() + " arc on " + ono.getProto().describe() + " node");
            }
            if (opi[0] == null || opi[1] == null) {
                return null;
            }
            ArcInst toAi = ArcInst.newInstance(ai.getProto(), ai.getWidth(), opi[0], ai.getHead().getLocation(), opi[1], ai.getTail().getLocation(), ai.getName());
            if (toAi == null) {
                return null;
            }
            toAi.setNameTextDescriptor(ai.getNameTextDescriptor());
            toAi.copyVars(ai);
            toAi.lowLevelSetUserbits(ai.lowLevelGetUserbits());
        }
        it2 = fromCell.getPorts();
        while (it2.hasNext()) {
            Export pp2 = (Export)it2.next();
            NodeInst ni4 = (NodeInst)pp2.getOriginalPort().getNodeInst().getTempObj();
            PortInst pi = ni4.findPortInst(pp2.getOriginalPort().getPortProto().getName());
            if (pi == null) {
                System.out.println("Error: no port on " + pp2.getOriginalPort().getNodeInst().getProto().describe() + " cell");
                return null;
            }
            Export ppt2 = Export.newInstance(newCell, pi, pp2.getName());
            if (ppt2 == null) {
                return null;
            }
            ppt2.copyVars(pp2);
            ppt2.lowLevelSetUserbits(pp2.lowLevelGetUserbits());
            ppt2.setTextDescriptor(pp2.getTextDescriptor());
        }
        newCell.copyVars(fromCell);
        newCell.lowLevelSetCreationDate(fromCell.getCreationDate());
        newCell.lowLevelSetRevisionDate(fromCell.getRevisionDate());
        return newCell;
    }

    public void rename(String newName) {
        this.checkChanging();
        Name oldName = this.basename;
        this.lowLevelRename(newName);
        Undo.renameObject(this, oldName);
    }

    public void lowLevelRename(String newName) {
        this.setProtoName(newName);
    }

    public static Cell lowLevelAllocate(Library lib) {
        Job.checkChanging();
        Cell c = new Cell();
        c.lib = lib;
        return c;
    }

    public boolean lowLevelPopulate(String name) {
        this.checkChanging();
        Library lib = this.getLibrary();
        CellName n = CellName.parseName(name);
        if (n == null) {
            return true;
        }
        int version = n.getVersion();
        if (version > 0) {
            Iterator it = lib.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || version != c.getVersion()) continue;
                System.out.println("Already have cell " + c.getName() + " with version " + version + ", generating a new version");
                version = 1;
                Iterator vIt = lib.getCells();
                while (vIt.hasNext()) {
                    c = (Cell)vIt.next();
                    if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || c.getVersion() < version) continue;
                    version = c.getVersion() + 1;
                }
            }
        } else {
            version = 1;
            Iterator it = lib.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!n.getName().equalsIgnoreCase(c.getName()) || n.getView() != c.getView() || c.getVersion() < version) continue;
                version = c.getVersion() + 1;
            }
        }
        this.setProtoName(n.getName());
        this.view = n.getView();
        this.version = version;
        return false;
    }

    private void setProtoName(String name) {
        this.protoName = name;
        this.basename = Name.findName(this.protoName.substring(0, Math.min(8, this.protoName.length())) + '@').getBasename();
        if (this.basename == null) {
            this.basename = NodeProto.Function.UNKNOWN.getBasename();
        }
    }

    public boolean lowLevelLink() {
        Cell displacedCell;
        this.checkChanging();
        if (this.linked) {
            System.out.println(this + " already linked");
            return true;
        }
        this.versionGroup = null;
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            Cell c = (Cell)it.next();
            if (c.getView() != this.getView() || !this.getName().equalsIgnoreCase(c.getName())) continue;
            this.versionGroup = c.versionGroup;
            break;
        }
        if (this.versionGroup == null) {
            this.versionGroup = new VersionGroup();
        }
        if ((displacedCell = this.versionGroup.add(this)) != null) {
            displacedCell.getCellGroup().remove(displacedCell);
        }
        if (this.getNewestVersion() != this) {
            this.cellGroup = null;
        } else {
            if (this.cellGroup == null) {
                Iterator it2 = this.lib.getCells();
                while (it2.hasNext()) {
                    Cell c = (Cell)it2.next();
                    if (c.getCellGroup() == null || !this.getName().equalsIgnoreCase(c.getName())) continue;
                    this.cellGroup = c.getCellGroup();
                    break;
                }
                if (this.cellGroup == null) {
                    this.cellGroup = new CellGroup();
                }
            }
            this.cellGroup.add(this);
        }
        Library lib = this.getLibrary();
        lib.addCell(this);
        Iterator it3 = this.getUsagesIn();
        while (it3.hasNext()) {
            NodeUsage nu = (NodeUsage)it3.next();
            nu.getProto().addUsageOf(nu);
        }
        this.linked = true;
        return false;
    }

    public void lowLevelUnlink() {
        this.checkChanging();
        if (!this.linked) {
            System.out.println(this + " already unlinked");
            return;
        }
        Iterator vIt = this.getVersions();
        Cell newest = (Cell)vIt.next();
        Cell nextNewest = null;
        if (vIt.hasNext()) {
            nextNewest = (Cell)vIt.next();
        }
        this.versionGroup.remove(this);
        this.setVersionGroup(null);
        if (this == newest && nextNewest != null) {
            this.cellGroup.add(nextNewest);
        }
        if (this.cellGroup != null) {
            this.cellGroup.remove(this);
        }
        Library lib = this.getLibrary();
        lib.removeCell(this);
        Iterator it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            nu.getProto().removeUsageOf(nu);
        }
        this.linked = false;
    }

    public double getDefWidth() {
        return this.getBounds().getWidth();
    }

    public double getDefHeight() {
        return this.getBounds().getHeight();
    }

    public SizeOffset getProtoSizeOffset() {
        return new SizeOffset(0.0, 0.0, 0.0, 0.0);
    }

    public Dimension2D getCharacteristicSpacing() {
        Variable var = this.getVar(CHARACTERISTIC_SPACING);
        if (var != null) {
            Object obj = var.getObject();
            if (obj instanceof Integer[]) {
                Integer[] iSpac = (Integer[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(iSpac[0].intValue(), iSpac[1].intValue());
                return spacing;
            }
            if (obj instanceof Double[]) {
                Double[] dSpac = (Double[])obj;
                Dimension2D.Double spacing = new Dimension2D.Double(dSpac[0], dSpac[1]);
                return spacing;
            }
        }
        return null;
    }

    public void setCharacteristicSpacing(double x, double y) {
        Double[] newVals = new Double[]{new Double(x), new Double(y)};
        this.newVar(CHARACTERISTIC_SPACING, (Object)newVals);
    }

    public void setDirty() {
        this.boundsDirty = true;
    }

    public Iterator searchIterator(Rectangle2D bounds) {
        return new Geometric.Search(bounds, this);
    }

    public void rememberBounds() {
        if (this.boundsDirty) {
            this.getBounds();
        }
        this.boundLock = true;
    }

    public Rectangle2D getRememberedBounds() {
        Rectangle2D retBounds = this.lastBounds;
        if (this.boundLock) {
            retBounds = this.cellBounds;
        }
        this.boundLock = false;
        return retBounds;
    }

    public Rectangle2D getBounds() {
        if (this.boundsDirty) {
            int i;
            if (this.boundLock) {
                this.boundLock = false;
                this.lastBounds.setRect(this.cellBounds);
            }
            this.boundsEmpty = true;
            double cellHighY = 0.0;
            double cellLowY = 0.0;
            double cellHighX = 0.0;
            double cellLowX = 0.0;
            for (i = 0; i < this.nodes.size(); ++i) {
                NodeInst ni = (NodeInst)this.nodes.get(i);
                NodeProto np = ni.getProto();
                if (np == Generic.tech.cellCenterNode) continue;
                if (np == Generic.tech.invisiblePinNode) {
                    boolean found = false;
                    Iterator it = ni.getVariables();
                    while (it.hasNext()) {
                        TextDescriptor td;
                        Variable var = (Variable)it.next();
                        if (!var.isDisplay() || !(td = var.getTextDescriptor()).isInterior() && !td.isInherit()) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                }
                Rectangle2D bounds = ni.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (this.boundsEmpty) {
                    this.boundsEmpty = false;
                    cellLowX = lowx;
                    cellHighX = highx;
                    cellLowY = lowy;
                    cellHighY = highy;
                    continue;
                }
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            for (i = 0; i < this.arcs.size(); ++i) {
                ArcInst ai = (ArcInst)this.arcs.get(i);
                Rectangle2D bounds = ai.getBounds();
                double lowx = bounds.getMinX();
                double highx = bounds.getMaxX();
                double lowy = bounds.getMinY();
                double highy = bounds.getMaxY();
                if (lowx < cellLowX) {
                    cellLowX = lowx;
                }
                if (highx > cellHighX) {
                    cellHighX = highx;
                }
                if (lowy < cellLowY) {
                    cellLowY = lowy;
                }
                if (!(highy > cellHighY)) continue;
                cellHighY = highy;
            }
            this.cellBounds.setRect(DBMath.smooth(cellLowX), DBMath.smooth(cellLowY), DBMath.smooth(cellHighX - cellLowX), DBMath.smooth(cellHighY - cellLowY));
            this.boundsDirty = false;
        }
        return this.cellBounds;
    }

    public Geometric.RTNode getRTree() {
        return this.rTree;
    }

    public void setRTree(Geometric.RTNode rTree) {
        this.checkChanging();
        this.rTree = rTree;
    }

    public Rectangle2D findEssentialBounds() {
        if (this.essenBounds.size() < 2) {
            return null;
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (int i = 0; i < this.essenBounds.size(); ++i) {
            NodeInst ni = (NodeInst)this.essenBounds.get(i);
            minX = Math.min(minX, ni.getTrueCenterX());
            maxX = Math.max(maxX, ni.getTrueCenterX());
            minY = Math.min(minY, ni.getTrueCenterY());
            maxY = Math.max(maxY, ni.getTrueCenterY());
        }
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    public void adjustReferencePoint(NodeInst referencePointNode) {
        NodeInst ni;
        this.checkChanging();
        double cX = referencePointNode.getAnchorCenterX();
        double cY = referencePointNode.getAnchorCenterY();
        if (cX == 0.0 && cY == 0.0) {
            return;
        }
        referencePointNode.modifyInstance(-cX, -cY, 0.0, 0.0, 0);
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            if (ni == referencePointNode) continue;
            ni.lowLevelModify(-cX, -cY, 0.0, 0.0, 0);
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            ai.lowLevelModify(0.0, -cX, -cY, -cX, -cY);
        }
        it = this.getInstancesOf();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            Undo.redrawObject(ni);
            AffineTransform trans = NodeInst.pureRotate(ni.getAngle(), ni.isMirroredAboutXAxis(), ni.isMirroredAboutYAxis());
            Point2D.Double in = new Point2D.Double(cX, cY);
            trans.transform(in, in);
            ni.modifyInstance(((Point2D)in).getX(), ((Point2D)in).getY(), 0.0, 0.0, 0);
        }
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            Cell cell;
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (!(content instanceof EditWindow) || (cell = content.getCell()) != this) continue;
            EditWindow wnd = (EditWindow)content;
            Point2D off = wnd.getOffset();
            off.setLocation(off.getX() - cX, off.getY() - cY);
            wnd.setOffset(off);
        }
    }

    public boolean alreadyCellCenter() {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() != Generic.tech.cellCenterNode) continue;
            return true;
        }
        return false;
    }

    public synchronized Iterator getNodes() {
        ArrayList nodesCopy = new ArrayList(this.nodes);
        return nodesCopy.iterator();
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public final NodeInst getNode(int nodeIndex) {
        return (NodeInst)this.nodes.get(nodeIndex);
    }

    public synchronized Iterator getUsagesIn() {
        HashMap usagesCopy = new HashMap(this.usagesIn);
        return usagesCopy.values().iterator();
    }

    public int getNumUsagesIn() {
        return this.usagesIn.size();
    }

    public NodeInst findNode(String name) {
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            NodeInst ni = (NodeInst)this.nodes.get(i);
            String nodeNm = ni.getName();
            if (nodeNm == null || !nodeNm.equals(name)) continue;
            return ni;
        }
        return null;
    }

    public NodeUsage addNode(NodeInst ni) {
        this.checkChanging();
        NodeUsage nu = this.addUsage(ni.getProto());
        if (nu.contains(ni)) {
            System.out.println("Cell " + this + " already contains node inst " + ni);
            return null;
        }
        ni.setNodeIndex(this.nodes.size());
        this.nodes.add(ni);
        this.addTempName(ni);
        nu.addInst(ni);
        this.boundsDirty = true;
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode && np == Generic.tech.cellCenterNode) {
            this.adjustReferencePoint(ni);
        }
        if (np instanceof PrimitiveNode && np.getName().equals("Essential-Bounds")) {
            this.essenBounds.add(ni);
        }
        return nu;
    }

    public void removeNode(NodeInst ni) {
        this.checkChanging();
        NodeUsage nu = ni.getNodeUsage();
        if (!nu.contains(ni)) {
            System.out.println("Cell " + this + " doesn't contain node inst " + ni);
            return;
        }
        nu.removeInst(ni);
        if (nu.isEmpty()) {
            this.removeUsage(nu);
        }
        this.removeTempName(ni);
        int nodeIndex = ni.getNodeIndex();
        int lastNode = this.nodes.size() - 1;
        if (nodeIndex == lastNode) {
            this.nodes.remove(nodeIndex);
        } else {
            NodeInst lastNi = (NodeInst)this.nodes.remove(lastNode);
            this.nodes.set(nodeIndex, lastNi);
            lastNi.setNodeIndex(nodeIndex);
        }
        ni.setNodeIndex(-1);
        this.boundsDirty = true;
        this.essenBounds.remove(ni);
    }

    private NodeUsage addUsage(NodeProto protoType) {
        NodeUsage nu;
        if (!this.linked) {
            System.out.println("addUsage of " + protoType + " to unliked " + this);
        }
        if ((nu = (NodeUsage)this.usagesIn.get(protoType)) == null) {
            nu = new NodeUsage(protoType, this);
            this.usagesIn.put(protoType, nu);
            protoType.addUsageOf(nu);
        }
        return nu;
    }

    private void removeUsage(NodeUsage nu) {
        if (!this.linked) {
            System.out.println("removeUsage of " + nu.getProto() + " to unliked " + this);
        }
        NodeProto protoType = nu.getProto();
        protoType.removeUsageOf(nu);
        this.usagesIn.remove(protoType);
    }

    public synchronized Iterator getArcs() {
        ArrayList arcsCopy = new ArrayList(this.arcs);
        return arcsCopy.iterator();
    }

    public int getNumArcs() {
        return this.arcs.size();
    }

    public final ArcInst getArc(int arcIndex) {
        return (ArcInst)this.arcs.get(arcIndex);
    }

    public void addArc(ArcInst ai) {
        this.checkChanging();
        if (this.arcs.contains(ai)) {
            System.out.println("Cell " + this + " already contains arc " + ai);
            return;
        }
        ai.setArcIndex(this.arcs.size());
        this.arcs.add(ai);
        this.addTempName(ai);
        this.boundsDirty = true;
    }

    public void removeArc(ArcInst ai) {
        this.checkChanging();
        if (!this.arcs.contains(ai)) {
            System.out.println("Cell " + this + " doesn't contain arc " + ai);
            return;
        }
        this.removeTempName(ai);
        int arcIndex = ai.getArcIndex();
        int lastArc = this.arcs.size() - 1;
        if (arcIndex == lastArc) {
            this.arcs.remove(arcIndex);
        } else {
            ArcInst lastAi = (ArcInst)this.arcs.remove(lastArc);
            this.arcs.set(arcIndex, lastAi);
            lastAi.setArcIndex(arcIndex);
        }
        ai.setArcIndex(-1);
        this.boundsDirty = true;
    }

    public Export findExport(String name) {
        return (Export)this.findPortProto(name);
    }

    public Export findExport(Name name) {
        return (Export)this.findPortProto(name);
    }

    public String describe() {
        String name = "";
        if (this.lib != Library.getCurrent()) {
            name = name + this.lib.getName() + ":";
        }
        name = name + this.noLibDescribe();
        return name;
    }

    public String noLibDescribe() {
        String name = this.protoName;
        if (this.getNewestVersion() != this) {
            name = name + ";" + this.version;
        }
        if (this.view != null) {
            name = name + "{" + this.view.getAbbreviation() + "}";
        }
        return name;
    }

    public String[] getTextViewContents() {
        String[] strings = TextWindow.getEditedText(this);
        if (strings != null) {
            return strings;
        }
        Variable var = this.getVar(CELL_TEXT_KEY);
        if (var == null) {
            return null;
        }
        Object obj = var.getObject();
        if (!(obj instanceof String[])) {
            return null;
        }
        return (String[])obj;
    }

    public void setTextViewContents(String[] strings) {
        Job.checkChanging();
        TextWindow.updateText(this, strings);
        this.newVar(CELL_TEXT_KEY, (Object)strings);
    }

    public Poly[] getAllText(boolean hardToSelect, EditWindow wnd) {
        int dispVars = this.numDisplayableVariables(false);
        if (dispVars == 0) {
            return null;
        }
        Poly[] polys = new Poly[dispVars];
        this.addDisplayableVariables(CENTERRECT, polys, 0, wnd, false);
        return polys;
    }

    public Rectangle2D getRelativeTextBounds(EditWindow wnd) {
        Rectangle2D bounds = null;
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ni, bounds, wnd);
            Iterator pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = (PortInst)pIt.next();
                bounds = this.accumulateTextBoundsOnObject(pi, bounds, wnd);
            }
        }
        it = this.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            bounds = this.accumulateTextBoundsOnObject(ai, bounds, wnd);
        }
        it = this.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            bounds = this.accumulateTextBoundsOnObject(pp, bounds, wnd);
        }
        bounds = this.accumulateTextBoundsOnObject(this, bounds, wnd);
        return bounds;
    }

    private Rectangle2D accumulateTextBoundsOnObject(ElectricObject eObj, Rectangle2D bounds, EditWindow wnd) {
        Poly poly;
        Geometric geom;
        Name name;
        Rectangle2D polyBound;
        Poly poly2;
        Iterator vIt = eObj.getVariables();
        while (vIt.hasNext()) {
            TextDescriptor td;
            Variable var = (Variable)vIt.next();
            if (!var.isDisplay() || (td = var.getTextDescriptor()).getSize().isAbsolute() || (poly2 = eObj.computeTextPoly(wnd, var, null)) == null) continue;
            polyBound = poly2.getBounds2D();
            if (bounds == null) {
                bounds = polyBound;
                continue;
            }
            Rectangle2D.union(bounds, polyBound, bounds);
        }
        if (eObj instanceof Geometric && !(name = (geom = (Geometric)eObj).getNameKey()).isTempname() && (poly = eObj.computeTextPoly(wnd, null, name)) != null) {
            Rectangle2D polyBound2 = poly.getBounds2D();
            if (bounds == null) {
                bounds = polyBound2;
            } else {
                Rectangle2D.union(bounds, polyBound2, bounds);
            }
        }
        if (eObj instanceof NodeInst) {
            NodeInst ni = (NodeInst)eObj;
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                poly2 = pp.computeTextPoly(wnd, null, null);
                if (poly2 == null) continue;
                polyBound = poly2.getBounds2D();
                if (bounds == null) {
                    bounds = polyBound;
                    continue;
                }
                Rectangle2D.union(bounds, polyBound, bounds);
            }
        }
        return bounds;
    }

    public Name getBasename() {
        return this.basename;
    }

    public Name getAutoname(Name basename) {
        MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename);
        if (ms == null) {
            ms = new MaxSuffix();
            this.maxSuffix.put(basename.lowerCase(), ms);
            return basename.findSuffixed(0);
        }
        ++ms.v;
        return basename.findSuffixed(ms.v);
    }

    public void addTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.put(name.lowerCase(), geom);
        Name basename = name.getBasename();
        if (basename != null && basename != name) {
            int numSuffix;
            MaxSuffix ms = (MaxSuffix)this.maxSuffix.get(basename = basename.lowerCase());
            if (ms == null) {
                ms = new MaxSuffix();
                this.maxSuffix.put(basename, ms);
            }
            if ((numSuffix = name.getNumSuffix()) > ms.v) {
                ms.v = numSuffix;
            }
        }
    }

    public void removeTempName(Geometric geom) {
        Name name = geom.getNameKey();
        if (!name.isTempname()) {
            return;
        }
        this.tempNames.remove(name.lowerCase());
    }

    public boolean hasTempName(Name name) {
        return this.tempNames.get(name) != null;
    }

    public boolean isUniqueName(String name, Class cls, ElectricObject exclude) {
        return this.isUniqueName(Name.findName(name), cls, exclude);
    }

    public boolean isUniqueName(Name name, Class cls, ElectricObject exclude) {
        name = name.lowerCase();
        if (cls == PortProto.class) {
            Export pp = this.findExport(name);
            return pp == null || exclude == pp;
        }
        if (cls == NodeInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                Name nodeName;
                NodeInst ni = (NodeInst)it.next();
                if (exclude == ni || name != (nodeName = ni.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        if (cls == ArcInst.class) {
            if (name.isTempname()) {
                Geometric geom = (Geometric)this.tempNames.get(name);
                return geom == null || exclude == geom;
            }
            Iterator it = this.getArcs();
            while (it.hasNext()) {
                Name arcName;
                ArcInst ai = (ArcInst)it.next();
                if (exclude == ai || name != (arcName = ai.getNameKey()).lowerCase()) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public String toString() {
        return "Cell " + this.describe();
    }

    public boolean isLinked() {
        return this.linked;
    }

    public static boolean isInstantiationRecursive(Cell toInstantiate, Cell parent) {
        if (toInstantiate == parent) {
            return true;
        }
        if (toInstantiate.isIconOf(parent) && toInstantiate.getView() == View.ICON && parent.getView() != View.ICON) {
            return false;
        }
        return parent.isAChildOf(toInstantiate);
    }

    public boolean isAChildOf(Cell parent) {
        return this.getIsAChildOf(parent, new HashMap());
    }

    private boolean getIsAChildOf(Cell parent, Map checkedParents) {
        Cell c;
        if (parent.getView() == View.ICON && (c = parent.contentsView()) != null && c != parent && this.getIsAChildOf(c, checkedParents)) {
            return true;
        }
        if (checkedParents.get(parent) != null) {
            return false;
        }
        checkedParents.put(parent, parent);
        Cell contentView = this.contentsView();
        Cell iconView = this.iconView();
        Iterator it = parent.getNodes();
        while (it.hasNext()) {
            Cell c2;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (c2 = (Cell)np).isIconOf(parent)) continue;
            if (c2 == contentView) {
                return true;
            }
            if (c2 == iconView) {
                return true;
            }
            if (!this.getIsAChildOf(c2, checkedParents)) continue;
            return true;
        }
        return false;
    }

    private boolean getIsAParentOf(Cell child) {
        if (this == child) {
            return true;
        }
        Cell lastParent = null;
        Iterator it = child.getInstancesOf();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getParent() == lastParent) continue;
            lastParent = ni.getParent();
            if (!this.getIsAParentOf(ni.getParent())) continue;
            return true;
        }
        Cell np = child.iconView();
        if (np != null) {
            lastParent = null;
            Iterator it2 = np.getInstancesOf();
            while (it2.hasNext()) {
                NodeInst ni = (NodeInst)it2.next();
                if (ni.getParent() == lastParent) continue;
                lastParent = ni.getParent();
                NodeProto niProto = ni.getProto();
                if (niProto instanceof Cell && ((Cell)niProto).isIconOf(child) && child.getView() != View.ICON || !this.getIsAParentOf(ni.getParent())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isInUse(String action) {
        String parents = null;
        Iterator it = this.getUsagesOf();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            Cell parent = nu.getParent();
            if (parents == null) {
                parents = parent.describe();
                continue;
            }
            parents = parents + ", " + parent.describe();
        }
        if (parents != null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot " + action + " cell " + this.describe() + " because it is used in " + parents, action + " failed", 0);
            return true;
        }
        return false;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View newView) {
        if (newView == this.view) {
            return;
        }
        this.lowLevelUnlink();
        int newVersion = this.version;
        Iterator it = this.lib.getCells();
        while (it.hasNext()) {
            Cell other = (Cell)it.next();
            if (other.view != newView || !other.protoName.equalsIgnoreCase(this.protoName) || other.version < newVersion) continue;
            newVersion = other.version + 1;
        }
        this.view = newView;
        this.version = newVersion;
        this.lowLevelLink();
    }

    public boolean isIcon() {
        return this.view == View.ICON;
    }

    public boolean isIconOf(Cell cell) {
        return this.view == View.ICON && this.cellGroup == cell.cellGroup;
    }

    public Cell contentsView() {
        Cell cellInGroup;
        if (this.getView() != View.ICON && this.getView() != View.LAYOUTSKEL) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() == View.SCHEMATIC) {
                return cellInGroup;
            }
            if (!cellInGroup.getView().isMultiPageView()) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell iconView() {
        if (!this.isSchematicView()) {
            return null;
        }
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.ICON) continue;
            return cellInGroup;
        }
        return null;
    }

    public Cell otherView(View view) {
        Iterator it = this.getCellGroup().getCells();
        while (it.hasNext()) {
            Cell cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != view) continue;
            return cellInGroup;
        }
        return null;
    }

    public boolean isSchematicView() {
        return this.getView() == View.SCHEMATIC || this.getView().isMultiPageView();
    }

    public Netlist getNetlist(boolean shortResistors) {
        return Network.getNetlist(this, shortResistors);
    }

    public Netlist getUserNetlist() {
        return Network.getUserNetlist(this);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void lowLevelSetCreationDate(Date creationDate) {
        this.checkChanging();
        this.creationDate = creationDate;
    }

    public Date getRevisionDate() {
        return this.revisionDate;
    }

    public void lowLevelSetRevisionDate(Date revisionDate) {
        this.checkChanging();
        this.revisionDate = revisionDate;
    }

    public void madeRevision() {
        this.checkChanging();
        this.revisionDate = new Date();
    }

    public void checkCellDates() {
        FlagSet cellDateFlagSet = NodeProto.getFlagSet(1);
        cellDateFlagSet.clearOnAllCells();
        this.checkCellDate(this.getRevisionDate(), cellDateFlagSet);
        cellDateFlagSet.freeFlagSet();
    }

    private void checkCellDate(Date rev_time, FlagSet cellDateFlagSet) {
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            Cell contentsCell;
            Cell subCell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (subCell = (Cell)np).isIconOf(this)) continue;
            if (!subCell.isBit(cellDateFlagSet)) {
                subCell.checkCellDate(rev_time, cellDateFlagSet);
            }
            if ((contentsCell = subCell.contentsView()) == null || contentsCell.isBit(cellDateFlagSet)) continue;
            contentsCell.checkCellDate(rev_time, cellDateFlagSet);
        }
        this.setBit(cellDateFlagSet);
        if (!this.getRevisionDate().after(rev_time)) {
            return;
        }
        System.out.println("WARNING: sub-cell " + this.describe() + " has been edited since the last revision to the current cell");
    }

    public int checkAndRepair() {
        ArcInst ai;
        int errorCount = super.checkAndRepair();
        HashMap<Connection, ArcInst> connections = new HashMap<Connection, ArcInst>();
        Iterator it = this.getArcs();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            errorCount += ai.checkAndRepair();
            ArcInst otherAi = (ArcInst)connections.get(ai.getHead());
            if (otherAi != null) {
                System.out.println("Cell " + this.describe() + ", Arc " + ai.describe() + ": head connection already on other arc " + otherAi.describe());
                ++errorCount;
            } else {
                connections.put(ai.getHead(), ai);
            }
            otherAi = (ArcInst)connections.get(ai.getTail());
            if (otherAi != null) {
                System.out.println("Cell " + this.describe() + ", Arc " + ai.describe() + ": tail connection already on other arc " + otherAi.describe());
                ++errorCount;
                continue;
            }
            connections.put(ai.getTail(), ai);
        }
        it = this.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            errorCount += ni.checkAndRepair();
            Iterator pIt = ni.getConnections();
            while (pIt.hasNext()) {
                Connection con = (Connection)pIt.next();
                ArcInst ai2 = (ArcInst)connections.get(con);
                if (ai2 == null) {
                    System.out.println("Cell " + this.describe() + ", Node " + ni.describe() + ": has connection to unknown arc: " + con.getArc().describe() + " (node has " + ni.getNumConnections() + " connections)");
                    ++errorCount;
                    continue;
                }
                connections.put(con, null);
            }
        }
        it = connections.values().iterator();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            if (ai == null) continue;
            System.out.println("Cell " + this.describe() + ", Arc " + ai.describe() + ": connection is not on any node");
            ++errorCount;
        }
        it = this.getUsagesIn();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            errorCount += nu.checkAndRepair();
        }
        if (this.versionGroup == null) {
            System.out.println("Cell " + this.describe() + ", Version group is null");
            ++errorCount;
        }
        if (this.cellGroup == null) {
            System.out.println("Cell " + this.describe() + ", Cell group is null");
            ++errorCount;
        }
        return errorCount;
    }

    public boolean objInCell(ElectricObject eObj) {
        block4: {
            block5: {
                block3: {
                    if (!(eObj instanceof NodeInst)) break block3;
                    Iterator it = this.getNodes();
                    while (it.hasNext()) {
                        if ((ElectricObject)it.next() != eObj) continue;
                        return true;
                    }
                    break block4;
                }
                if (!(eObj instanceof ArcInst)) break block5;
                Iterator it = this.getArcs();
                while (it.hasNext()) {
                    if ((ElectricObject)it.next() != eObj) continue;
                    return true;
                }
                break block4;
            }
            if (!(eObj instanceof PortInst)) break block4;
            NodeInst ni = ((PortInst)eObj).getNodeInst();
            Iterator it = this.getNodes();
            while (it.hasNext()) {
                if ((ElectricObject)it.next() != ni) continue;
                return true;
            }
        }
        return false;
    }

    public void setChangeLock() {
        if (this.lock < 0) {
            return;
        }
        if (this.lock > 0) {
            System.out.println("An attemt to set change lock of cell " + this.describe() + " being examined");
            return;
        }
        this.lock = -1;
        Iterator it = this.getUsagesOf();
        while (it.hasNext()) {
            NodeUsage nu = (NodeUsage)it.next();
            nu.getParent().setChangeLock();
        }
        if (!this.isSchematicView()) {
            return;
        }
        it = this.cellGroup.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (cell.view != View.ICON) continue;
            cell.setChangeLock();
        }
    }

    public final int getCellIndex() {
        return this.cellIndex;
    }

    public static int getCellNumber() {
        return cellNumber;
    }

    public void clearChangeLock() {
        if (this.lock >= 0) {
            return;
        }
        this.lock = 0;
    }

    public void checkChanging() {
        if (Job.getChangingThread() != Thread.currentThread()) {
            if (Job.getChangingThread() == null) {
                System.out.println(this + " is changing without Undo.startChanges() lock");
            } else {
                System.out.println(this + " is changing by another thread " + Job.getChangingThread());
            }
        }
        Cell rootCell = Job.getChangingCell();
        if (this.lock != -1 && rootCell != null) {
            System.out.println("Change to cell " + rootCell.describe() + " affects cell " + this.describe() + " which is not above it in the hierarchy");
        }
    }

    public void setChange(Undo.Change change) {
        this.checkChanging();
        this.change = change;
    }

    public Undo.Change getChange() {
        return this.change;
    }

    public Cell whichCell() {
        return this;
    }

    public CellGroup getCellGroup() {
        return this.cellGroup;
    }

    public void setCellGroup(CellGroup cellGroup) {
        if (cellGroup == null) {
            Exception e = new Exception("Cannot set CellGroup to NULL!");
            e.printStackTrace(System.out);
        }
        if (this.cellGroup == cellGroup) {
            return;
        }
        if (this.cellGroup != null) {
            this.cellGroup.remove(this);
        }
        this.cellGroup = cellGroup;
        if (cellGroup != null) {
            cellGroup.add(this);
        }
    }

    public int getVersion() {
        return this.version;
    }

    public int getNumVersions() {
        return this.versionGroup.size();
    }

    public Iterator getVersions() {
        return this.versionGroup.iterator();
    }

    public Cell getNewestVersion() {
        return (Cell)this.getVersions().next();
    }

    public void setVersionGroup(VersionGroup versionGroup) {
        this.versionGroup = versionGroup;
    }

    public Library getLibrary() {
        return this.lib;
    }

    public Technology getTechnology() {
        if (this.tech == null) {
            this.tech = Technology.whatTechnology(this, null, 0, 0, null, 0, 0);
        }
        return this.tech;
    }

    public Cell getEquivalent() {
        return this.view == View.ICON ? this.cellGroup.getMainSchematics() : this;
    }

    public boolean containsInstance(Geometric thing) {
        if (thing instanceof ArcInst) {
            return this.arcs.contains(thing);
        }
        if (thing instanceof NodeInst) {
            NodeInst ni = (NodeInst)thing;
            NodeUsage nu = (NodeUsage)this.usagesIn.get(ni.getProto());
            return nu != null && nu.contains(ni);
        }
        return false;
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Iterator i;
        boolean found;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cell toCompare = (Cell)obj;
        if (this.getNumNodes() != toCompare.getNumNodes() || this.getNumArcs() != toCompare.getNumArcs() || this.getNumPorts() != toCompare.getNumPorts()) {
            if (buffer != null) {
                buffer.append("Different numbers of nodes/arcs/ports in " + this.getName() + " and " + toCompare.getName() + "\n");
            }
            return false;
        }
        ArrayList<ElectricObject> noCheckAgain = new ArrayList<ElectricObject>();
        Iterator it = this.getNodes();
        while (it.hasNext()) {
            found = false;
            NodeInst node = (NodeInst)it.next();
            i = toCompare.getNodes();
            while (i.hasNext()) {
                NodeInst n = (NodeInst)i.next();
                if (noCheckAgain.contains(n) || !node.compare(n, buffer)) continue;
                found = true;
                noCheckAgain.add(n);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding node " + node.getName() + " found in " + toCompare.getName() + "\n");
            }
            return false;
        }
        it = this.getArcs();
        while (it.hasNext()) {
            found = false;
            ArcInst arc = (ArcInst)it.next();
            i = toCompare.getArcs();
            while (i.hasNext()) {
                ArcInst a = (ArcInst)i.next();
                if (noCheckAgain.contains(a) || !arc.compare(a, buffer)) continue;
                found = true;
                noCheckAgain.add(a);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding arc " + arc.getName() + " found in other cell" + "\n");
            }
            return false;
        }
        it = this.getPorts();
        while (it.hasNext()) {
            found = false;
            PortInst port = (PortInst)it.next();
            i = toCompare.getPorts();
            while (i.hasNext()) {
                PortInst p = (PortInst)i.next();
                if (noCheckAgain.contains(p) || !port.compare(p, buffer)) continue;
                found = true;
                noCheckAgain.add(p);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port " + port.getPortProto().getName() + " found in other cell" + "\n");
            }
            return false;
        }
        return true;
    }

    public int compareTo(Object obj) {
        if (this.equals(obj)) {
            return 0;
        }
        if (!(obj instanceof Cell)) {
            return -1;
        }
        Cell toCompare = (Cell)obj;
        Date toCompareDate = toCompare.getRevisionDate();
        return toCompareDate.compareTo(this.getRevisionDate());
    }

    private class MaxSuffix {
        int v = 0;

        private MaxSuffix() {
        }
    }

    private static class VersionGroup {
        private List versions = new ArrayList();

        public Cell add(Cell cell) {
            Cell formerNewestCell = null;
            if (this.versions.size() > 0) {
                formerNewestCell = (Cell)this.versions.iterator().next();
            }
            this.versions.add(cell);
            cell.setVersionGroup(this);
            Collections.sort(this.versions, new CellsByVersion());
            Cell newestCell = (Cell)this.versions.iterator().next();
            if (newestCell == formerNewestCell) {
                formerNewestCell = null;
            }
            return formerNewestCell;
        }

        public void remove(Cell cell) {
            this.versions.remove(cell);
        }

        public int size() {
            return this.versions.size();
        }

        public Iterator iterator() {
            return this.versions.iterator();
        }

        private static class CellsByVersion
        implements Comparator {
            private CellsByVersion() {
            }

            public int compare(Object o1, Object o2) {
                Cell c1 = (Cell)o1;
                Cell c2 = (Cell)o2;
                return c2.getVersion() - c1.getVersion();
            }
        }
    }

    public static class CellGroup {
        private ArrayList cells = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Cell cell) {
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                if (!this.cells.contains(cell)) {
                    this.cells.add(cell);
                }
            }
            cell.cellGroup = this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(Cell f) {
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                this.cells.remove(f);
            }
        }

        public Iterator getCells() {
            return this.cells.iterator();
        }

        public int getNumCells() {
            return this.cells.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getCellsSortedByView() {
            ArrayList sortedList = new ArrayList();
            ArrayList arrayList = this.cells;
            synchronized (arrayList) {
                Iterator it = this.cells.iterator();
                while (it.hasNext()) {
                    sortedList.add(it.next());
                }
            }
            Collections.sort(sortedList, new CellsByView());
            return sortedList;
        }

        public Cell getMainSchematics() {
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (!c.isSchematicView()) continue;
                return c;
            }
            return null;
        }

        public boolean containsCell(Cell cell) {
            return this.cells.contains(cell);
        }

        public String toString() {
            return "CELLGROUP";
        }

        public String getName() {
            TreeSet<String> groupNames = new TreeSet<String>();
            Iterator it = this.getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                groupNames.add(cell.getName());
            }
            String groupName = null;
            Iterator it2 = groupNames.iterator();
            while (it2.hasNext()) {
                String oneName = (String)it2.next();
                if (groupName == null) {
                    groupName = oneName;
                    continue;
                }
                groupName = groupName + "," + oneName;
            }
            return groupName;
        }

        private static class CellsByView
        implements Comparator {
            private CellsByView() {
            }

            public int compare(Object o1, Object o2) {
                Cell c1 = (Cell)o1;
                Cell c2 = (Cell)o2;
                View v1 = c1.getView();
                View v2 = c2.getView();
                return v1.getOrder() - v2.getOrder();
            }
        }
    }
}

