;;; amssymb.el --- AUCTeX style for `amssymb.sty'

;; Copyright (C) 2012 Free Software Foundation, Inc.

;; Author: Mads Jensen <mje@inducks.org>
;; Maintainer: auctex-devel@gnu.org
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.

;; AUCTeX is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with AUCTeX; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
;; 02110-1301, USA.

;;; Commentary:

;; This file adds support for `amssymb.sty'.

;; The commands were just taken out of the \DeclareMathSymbol from
;; amssymb.sty in the order specified there, i.e., \mathord, \mathbin,
;; \mathrel

;;; Code:

(TeX-add-style-hook
 "amssymb"
 (lambda ()
   (TeX-add-symbols
    "boxdot"
    "boxplus"
    "boxtimes"
    "square"
    "blacksquare"
    "centerdot"
    "lozenge"
    "blacklozenge"
    "circlearrowright"
    "circlearrowleft"
    "leftrightharpoons"
    "boxminus"
    "Vdash"
    "Vvdash"
    "vDash"
    "twoheadrightarrow"
    "twoheadleftarrow"
    "leftleftarrows"
    "rightrightarrows"
    "upuparrows"
    "downdownarrows"
    "upharpoonright"
    "downharpoonright"
    "upharpoonleft"
    "downharpoonleft"
    "rightarrowtail"
    "leftarrowtail"
    "leftrightarrows"
    "rightleftarrows"
    "Lsh"
    "Rsh"
    "rightsquigarrow"
    "leftrightsquigarrow"
    "looparrowleft"
    "looparrowright"
    "circeq"
    "succsim"
    "gtrsim"
    "gtrapprox"
    "multimap"
    "therefore"
    "because"
    "doteqdot"
    "triangleq"
    "precsim"
    "lesssim"
    "lessapprox"
    "eqslantless"
    "eqslantgtr"
    "curlyeqprec"
    "curlyeqsucc"
    "preccurlyeq"
    "leqq"
    "leqslant"
    "lessgtr"
    "backprime"
    "risingdotseq"
    "fallingdotseq"
    "succcurlyeq"
    "geqq"
    "geqslant"
    "gtrless"
    "vartriangleright"
    "vartriangleleft"
    "trianglerighteq"
    "trianglelefteq"
    "bigstar"
    "between"
    "blacktriangledown"
    "blacktriangleright"
    "blacktriangleleft"
    "vartriangle"
    "blacktriangle"
    "triangledown"
    "eqcirc"
    "lesseqgtr"
    "gtreqless"
    "lesseqqgtr"
    "gtreqqless"
    "Rrightarrow"
    "Lleftarrow"
    "veebar"
    "barwedge"
    "doublebarwedge"
    "measuredangle"
    "sphericalangle"
    "varpropto"
    "smallsmile"
    "smallfrown"
    "Subset"
    "Supset"
    "Cup"
    "Cap"
    "curlywedge"
    "curlyvee"
    "leftthreetimes"
    "rightthreetimes"
    "subseteqq"
    "supseteqq"
    "bumpeq"
    "Bumpeq"
    "lll"
    "ggg"
    "circledS"
    "pitchfork"
    "dotplus"
    "backsim"
    "backsimeq"
    "complement"
    "intercal"
    "circledcirc"
    "circledast"
    "circleddash"
    "lvertneqq"
    "gvertneqq"
    "nleq"
    "ngeq"
    "nless"
    "ngtr"
    "nprec"
    "nsucc"
    "lneqq"
    "gneqq"
    "nleqslant"
    "ngeqslant"
    "lneq"
    "gneq"
    "npreceq"
    "nsucceq"
    "precnsim"
    "succnsim"
    "lnsim"
    "gnsim"
    "nleqq"
    "ngeqq"
    "precneqq"
    "succneqq"
    "precnapprox"
    "succnapprox"
    "lnapprox"
    "gnapprox"
    "nsim"
    "ncong"
    "diagup"
    "diagdown"
    "varsubsetneq"
    "varsupsetneq"
    "nsubseteqq"
    "nsupseteqq"
    "subsetneqq"
    "supsetneqq"
    "varsubsetneqq"
    "varsupsetneqq"
    "subsetneq"
    "supsetneq"
    "nsubseteq"
    "nsupseteq"
    "nparallel"
    "nmid"
    "nshortmid"
    "nshortparallel"
    "nvdash"
    "nVdash"
    "nvDash"
    "nVDash"
    "ntrianglerighteq"
    "ntrianglelefteq"
    "ntriangleleft"
    "ntriangleright"
    "nleftarrow"
    "nrightarrow"
    "nLeftarrow"
    "nRightarrow"
    "nLeftrightarrow"
    "nleftrightarrow"
    "divideontimes"
    "varnothing"
    "nexists"
    "Finv"
    "Game"
    "eth"
    "eqsim"
    "beth"
    "gimel"
    "daleth"
    "lessdot"
    "gtrdot"
    "ltimes"
    "rtimes"
    "shortmid"
    "shortparallel"
    "smallsetminus"
    "thicksim"
    "thickapprox"
    "approxeq"
    "succapprox"
    "precapprox"
    "curvearrowleft"
    "curvearrowright"
    "digamma"
    "varkappa"
    "Bbbk"
    "hslash"
    "backepsilon"))
 LaTeX-dialect)

(defvar LaTeX-amssymb-package-options '("psamsfonts")
  "Package options for the amssymb package.")

;;; amssymb.el ends here.
