#! /bin/sh
# This file is part of GNU tar testsuite.
# Copyright (C) 2004 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

# Check if listed-incremental backups work for files moved from one directory
# to another. 
# Based on a script by Martin Simmons <ZYHYLCRMZPRP@spammotel.com>
# References: 
#  <20040626230315.163AA1D148@cpc5-cmbg1-6-0-cust208.cmbg.cable.ntl.com>
#  http://lists.gnu.org/archive/html/bug-tar/2004-06/msg00028.html

. ./preset
TAR_ARCHIVE_FORMATS="gnu oldgnu" 
. $srcdir/before

mkdir directory

echo Create directories
mkdir tart
sleep 1
mkdir tart/c0
sleep 1
mkdir tart/c1
sleep 1

for file in tart/a1 tart/b1 tart/c0/cq1 tart/c0/cq2 tart/c1/ca1 tart/c1/ca2
do
  echo File $file > $file
  sleep 1
done

sleep 1
echo Creating main archive
tar -c -v --listed-incremental=tart.incr1 -f archive.1 tart

sleep 1
echo Modifying filesystem
rm tart/a1
mv tart/b1 tart/b2
mv tart/c1 tart/c2
touch tart/c2/ca3

echo Directory contents
find tart|sort

sleep 1
echo Creating incremental archive
cp -p tart.incr1 tart.incr2
tar -c -v --listed-incremental=tart.incr2 -f archive.2 tart

sleep 1

rm -rf tart/*
echo Extracting main archive
tar -x -v --listed-incremental=tart.incr1 -f archive.1
echo Extracting incremental archive
tar -x -v --listed-incremental=tart.incr2 -f archive.2

echo Final files:
find tart|sort

err="tar: tart/c0: Directory is new
tar: tart/c1: Directory is new
tar: tart/c2: Directory is new
"

out="Create directories
Creating main archive
tart/
tart/c0/
tart/c1/
tart/a1
tart/b1
tart/c0/cq1
tart/c0/cq2
tart/c1/ca1
tart/c1/ca2
Modifying filesystem
Directory contents
tart
tart/b2
tart/c0
tart/c0/cq1
tart/c0/cq2
tart/c2
tart/c2/ca1
tart/c2/ca2
tart/c2/ca3
Creating incremental archive
tart/
tart/c0/
tart/c2/
tart/b2
tart/c2/ca1
tart/c2/ca2
tart/c2/ca3
Extracting main archive
tart/
tart/c0/
tart/c1/
tart/a1
tart/b1
tart/c0/cq1
tart/c0/cq2
tart/c1/ca1
tart/c1/ca2
Extracting incremental archive
tart/
tar: Deleting \`tart/c1'
tar: Deleting \`tart/a1'
tar: Deleting \`tart/b1'
tart/c0/
tart/c2/
tart/b2
tart/c2/ca1
tart/c2/ca2
tart/c2/ca3
Final files:
tart
tart/b2
tart/c0
tart/c0/cq1
tart/c0/cq2
tart/c2
tart/c2/ca1
tart/c2/ca2
tart/c2/ca3
"

. $srcdir/after
