;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015, 2016 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url

            %storedir
            %localstatedir
            %sysconfdir
            %sbindir

            %store-directory
            %state-directory
            %config-directory
            %guix-register-program

            %system
            %libgcrypt
            %libz
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.  When adding a substitution variable
;;; here, make sure to equip (guix scripts pull) to substitute it.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "https://www.gnu.org/software/guix/")

(define %storedir
  "/gnu/store")

(define %localstatedir
  "/var")

(define %sysconfdir
  "/etc")

(define %sbindir
  "/gnu/store/vir3lrwqy50pr8fkaf3m091dgbrja2n6-guix-0.13.0/sbin")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      %storedir))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `nix/local.mk'.
  (or (getenv "NIX_STATE_DIR")
      (string-append %localstatedir "/guix")))

(define %config-directory
  ;; This must match `GUIX_CONFIGURATION_DIRECTORY' as defined in `nix/local.mk'.
  (or (getenv "GUIX_CONFIGURATION_DIRECTORY")
      (string-append %sysconfdir "/guix")))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER")
      (string-append %sbindir "/guix-register")))

(define %system
  "x86_64-linux")

(define %libgcrypt
  "/gnu/store/hag795ji8p9vqikwp8cibfibpsa39s3n-libgcrypt-1.7.6/lib/libgcrypt")

(define %libz
  "/gnu/store/jwkcd7siv6fcyl0qsg607bg9c8ap0gqr-zlib-1.2.11/lib/libz")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/8wmanahsh0mk1n5xw6i7wpwih95yqzaq-gzip-1.8/bin/gzip")

(define %bzip2
  "/gnu/store/8nkj1w5whm5gwrhsmqvm1w6im27vz02g-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/c140q16b1n4x0j2i7wv1awc1c39ipzrr-xz-5.2.2/bin/xz")

;;; config.scm ends here
