;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url
            %store-directory
            %state-directory
            %config-directory
            %guix-register-program
            %system
            %libgcrypt
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.10.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "http://www.gnu.org/software/guix/")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      "/gnu/store"))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `daemon.am'.
  (or (getenv "NIX_STATE_DIR") "/var/guix"))

(define %config-directory
  ;; This must match `NIX_CONF_DIR' as defined in `daemon.am'.
  (or (getenv "NIX_CONF_DIR") "/etc/guix"))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER") "/gnu/store/3g6zn8y5sfwywr4pqiwqrab735a0x4zl-guix-0.10.0/sbin/guix-register"))

(define %system
  "x86_64-linux")

(define %libgcrypt
  "/gnu/store/7wfbprp1b9b25crlidg6h7b6hpib2b99-libgcrypt-1.6.5/lib/libgcrypt")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/304ljrrivn98ds6zsv3lcrp5c8qyl8d5-gzip-1.6/bin/gzip")

(define %bzip2
  "/gnu/store/b3bmn7z2f68v76331k1vk47wv5d4g5xd-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/z8vgpay1q450ndgil902xxxz5mq0b1qr-xz-5.2.2/bin/xz")

;;; config.scm ends here
