#! /bin/sh
# Copyright (C) 2009-2012 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Check parallel-tests features:
# - recheck

am_parallel_tests=yes
. ./defs || Exit 1

cat >> configure.ac << 'END'
AC_OUTPUT
END

cat > Makefile.am << 'END'
TEST_SUITE_LOG = mylog.log
TESTS = foo.test bar.test baz.test
check_SCRIPTS = bla
CLEANFILES = bla
bla:
	echo bla > $@
END

cat > foo.test <<'END'
#! /bin/sh
echo "this is $0"
test -f bla || exit 1
exit 0
END
cat > bar.test <<'END'
#! /bin/sh
echo "this is $0"
exit 99
END
cat > baz.test <<'END'
#! /bin/sh
echo "this is $0"
exit 1
END
chmod a+x foo.test bar.test baz.test

$ACLOCAL
$AUTOCONF
$AUTOMAKE -a

./configure
$MAKE check >stdout && { cat stdout; Exit 1; }
cat stdout
count_test_results total=3 pass=1 fail=1 skip=0 xfail=0 xpass=0 error=1

$MAKE recheck >stdout && { cat stdout; Exit 1; }
cat stdout
count_test_results total=2 pass=0 fail=1 skip=0 xfail=0 xpass=0 error=1
grep 'foo\.test' stdout && Exit 1
grep '^ERROR: bar\.test$' stdout
grep '^FAIL: baz\.test$' stdout

# Ensure that recheck builds check_SCRIPTS, and that
# recheck reruns nothing if check has not been run.
$MAKE clean
$MAKE recheck
test -f bla
test ! -f foo.log
test ! -f bar.log
test ! -f baz.log
test -f mylog.log

:
