/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilderBase;

public abstract class CacheStatsBase
implements PlainJsonSerializable {
    @Nullable
    private final Long evictions;
    @Nullable
    private final Long hitCount;
    @Nullable
    private final Long itemCount;
    @Nullable
    private final Long missCount;
    @Nullable
    private final String size;
    @Nullable
    private final Long sizeInBytes;

    protected CacheStatsBase(AbstractBuilder<?> builder) {
        this.evictions = ((AbstractBuilder)builder).evictions;
        this.hitCount = ((AbstractBuilder)builder).hitCount;
        this.itemCount = ((AbstractBuilder)builder).itemCount;
        this.missCount = ((AbstractBuilder)builder).missCount;
        this.size = ((AbstractBuilder)builder).size;
        this.sizeInBytes = ((AbstractBuilder)builder).sizeInBytes;
    }

    @Nullable
    public final Long evictions() {
        return this.evictions;
    }

    @Nullable
    public final Long hitCount() {
        return this.hitCount;
    }

    @Nullable
    public final Long itemCount() {
        return this.itemCount;
    }

    @Nullable
    public final Long missCount() {
        return this.missCount;
    }

    @Nullable
    public final String size() {
        return this.size;
    }

    @Nullable
    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.evictions != null) {
            generator.writeKey("evictions");
            generator.write(this.evictions.longValue());
        }
        if (this.hitCount != null) {
            generator.writeKey("hit_count");
            generator.write(this.hitCount.longValue());
        }
        if (this.itemCount != null) {
            generator.writeKey("item_count");
            generator.write(this.itemCount.longValue());
        }
        if (this.missCount != null) {
            generator.writeKey("miss_count");
            generator.write(this.missCount.longValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.sizeInBytes != null) {
            generator.writeKey("size_in_bytes");
            generator.write(this.sizeInBytes.longValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCacheStatsBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::evictions, JsonpDeserializer.longDeserializer(), "evictions");
        op.add(AbstractBuilder::hitCount, JsonpDeserializer.longDeserializer(), "hit_count");
        op.add(AbstractBuilder::itemCount, JsonpDeserializer.longDeserializer(), "item_count");
        op.add(AbstractBuilder::missCount, JsonpDeserializer.longDeserializer(), "miss_count");
        op.add(AbstractBuilder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(AbstractBuilder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.evictions);
        result = 31 * result + Objects.hashCode(this.hitCount);
        result = 31 * result + Objects.hashCode(this.itemCount);
        result = 31 * result + Objects.hashCode(this.missCount);
        result = 31 * result + Objects.hashCode(this.size);
        result = 31 * result + Objects.hashCode(this.sizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheStatsBase other = (CacheStatsBase)o;
        return Objects.equals(this.evictions, other.evictions) && Objects.equals(this.hitCount, other.hitCount) && Objects.equals(this.itemCount, other.itemCount) && Objects.equals(this.missCount, other.missCount) && Objects.equals(this.size, other.size) && Objects.equals(this.sizeInBytes, other.sizeInBytes);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        @Nullable
        private Long evictions;
        @Nullable
        private Long hitCount;
        @Nullable
        private Long itemCount;
        @Nullable
        private Long missCount;
        @Nullable
        private String size;
        @Nullable
        private Long sizeInBytes;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(CacheStatsBase o) {
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.itemCount = o.itemCount;
            this.missCount = o.missCount;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            this.evictions = o.evictions;
            this.hitCount = o.hitCount;
            this.itemCount = o.itemCount;
            this.missCount = o.missCount;
            this.size = o.size;
            this.sizeInBytes = o.sizeInBytes;
        }

        @Nonnull
        protected abstract BuilderT self();

        @Nonnull
        public final BuilderT evictions(@Nullable Long value) {
            this.evictions = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT hitCount(@Nullable Long value) {
            this.hitCount = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT itemCount(@Nullable Long value) {
            this.itemCount = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT missCount(@Nullable Long value) {
            this.missCount = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT size(@Nullable String value) {
            this.size = value;
            return this.self();
        }

        @Nonnull
        public final BuilderT sizeInBytes(@Nullable Long value) {
            this.sizeInBytes = value;
            return this.self();
        }
    }
}

