/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import net.infonode.util.Direction;

public class LayoutUtil {
    private LayoutUtil() {
    }

    public static Component[] getVisibleChildren(Container parent) {
        return LayoutUtil.getVisibleChildren(parent.getComponents());
    }

    public static Component[] getVisibleChildren(Component[] components) {
        int count = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i].isVisible()) {
                ++count;
            }
            ++i;
        }
        Component[] c = new Component[count];
        int index = 0;
        int i2 = 0;
        while (i2 < components.length) {
            if (components[i2].isVisible()) {
                c[index++] = components[i2];
            }
            ++i2;
        }
        return c;
    }

    public static Rectangle getInteriorArea(Container container) {
        Insets insets = container.getInsets();
        return new Rectangle(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
    }

    public static Dimension getInteriorSize(Container container) {
        Insets insets = container.getInsets();
        return new Dimension(container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
    }

    public static Dimension rotate(Dimension dim, Direction dir) {
        return LayoutUtil.rotate(dim, dir.isHorizontal());
    }

    public static Dimension rotate(Dimension dim, boolean horizontal) {
        return dim == null ? null : (horizontal ? dim : new Dimension(dim.height, dim.width));
    }

    public static boolean isDescendingFrom(Component component, Component parent) {
        return component == parent || component != null && LayoutUtil.isDescendingFrom(component.getParent(), parent);
    }

    public static Dimension getMaxMinimumSize(Component[] components) {
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i] != null) {
                Dimension min = components[i].getMinimumSize();
                int w = min.width;
                int h = min.height;
                if (maxHeight < h) {
                    maxHeight = h;
                }
                if (maxWidth < w) {
                    maxWidth = w;
                }
            }
            ++i;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    public static Dimension getMaxPreferredSize(Component[] components) {
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < components.length) {
            if (components[i] != null) {
                Dimension min = components[i].getPreferredSize();
                int w = min.width;
                int h = min.height;
                if (maxHeight < h) {
                    maxHeight = h;
                }
                if (maxWidth < w) {
                    maxWidth = w;
                }
            }
            ++i;
        }
        return new Dimension(maxWidth, maxHeight);
    }

    public static Dimension getMinMaximumSize(Component[] components) {
        int minWidth = Integer.MAX_VALUE;
        int minHeight = Integer.MAX_VALUE;
        int i = 0;
        while (i < components.length) {
            if (components[i] != null) {
                Dimension min = components[i].getMaximumSize();
                int w = min.width;
                int h = min.height;
                if (minWidth > w) {
                    minWidth = w;
                }
                if (minHeight > h) {
                    minHeight = h;
                }
            }
            ++i;
        }
        return new Dimension(minWidth, minHeight);
    }

    public static Insets rotate(Direction dir, Insets insets) {
        return dir == Direction.RIGHT ? insets : (dir == Direction.DOWN ? new Insets(insets.right, insets.top, insets.left, insets.bottom) : (dir == Direction.LEFT ? new Insets(insets.bottom, insets.right, insets.top, insets.left) : new Insets(insets.left, insets.bottom, insets.right, insets.top)));
    }

    public static Insets unrotate(Direction dir, Insets insets) {
        return dir == Direction.RIGHT ? insets : (dir == Direction.DOWN ? new Insets(insets.left, insets.bottom, insets.right, insets.top) : (dir == Direction.LEFT ? new Insets(insets.bottom, insets.right, insets.top, insets.left) : new Insets(insets.right, insets.top, insets.left, insets.bottom)));
    }

    public static Dimension add(Dimension dim, Insets insets) {
        return new Dimension(dim.width + insets.left + insets.right, dim.height + insets.top + insets.bottom);
    }

    public static Dimension getValidSize(Dimension dim, Component component) {
        Dimension minSize = component.getMinimumSize();
        Dimension maxSize = component.getMaximumSize();
        return new Dimension(Math.max(minSize.width, Math.min(dim.width, maxSize.width)), Math.max(minSize.height, Math.min(dim.height, maxSize.height)));
    }

    public static Component getChildContaining(Component parent, Component component) {
        return component == null ? null : (component.getParent() == parent ? component : LayoutUtil.getChildContaining(parent, component.getParent()));
    }

    public static String getBorderLayoutOrientation(Direction direction) {
        return direction == Direction.UP ? "North" : (direction == Direction.DOWN ? "South" : (direction == Direction.LEFT ? "West" : "East"));
    }
}

